/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.glassfish.bootstrap.cfg.AsenvConf;
import com.sun.enterprise.glassfish.bootstrap.cp.GlassfishBootstrapClassLoader;
import com.sun.enterprise.glassfish.bootstrap.osgi.EmbeddedOSGiGlassFishImpl;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.FelixPrettyPrinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class EmbeddedOSGiGlassFishRuntime
extends GlassFishRuntime {
    private static final int TIMEOUT_FOR_HK2 = 10000;
    private static final Logger LOG = Logger.getLogger(EmbeddedOSGiGlassFishRuntime.class.getName());
    private final List<GlassFish> glassFishes = new ArrayList<GlassFish>();
    private final BundleContext context;

    public EmbeddedOSGiGlassFishRuntime(BundleContext context) {
        this.context = context;
    }

    public synchronized GlassFish newGlassFish(GlassFishProperties gfProps) throws GlassFishException {
        try {
            this.setEnv(gfProps.getProperties());
            StartupContext startupContext = new StartupContext(gfProps.getProperties());
            ServiceTracker hk2Tracker = new ServiceTracker(this.context, Main.class, null);
            hk2Tracker.open();
            Main hk2Main = (Main)hk2Tracker.waitForService(10000L);
            hk2Tracker.close();
            if (hk2Main == null) {
                throw new IllegalStateException("HK2 Main not found, check GlassFish dependencies!");
            }
            ServiceReference mrServiceRef = this.context.getServiceReference(ModulesRegistry.class);
            ModulesRegistry mr = (ModulesRegistry)this.context.getService(mrServiceRef);
            this.logClassLoaders(mr);
            ServiceLocator serviceLocator = hk2Main.createServiceLocator(mr, startupContext, null, null);
            ModuleStartup gfKernel = hk2Main.findStartupService(mr, serviceLocator, null, startupContext);
            GlassFish glassFish = this.createGlassFish(gfKernel, serviceLocator, gfProps.getProperties());
            this.glassFishes.add(glassFish);
            return glassFish;
        }
        catch (BootException | InterruptedException ex) {
            throw new GlassFishException((Throwable)ex);
        }
        catch (Throwable t) {
            MultiException multiException = this.findMultiException(t);
            if (multiException == null) {
                throw new GlassFishException("GlassFish failed to start.", t);
            }
            String bundleMessage = this.findBundleMessage(multiException);
            if (bundleMessage == null) {
                throw new GlassFishException("GlassFish failed to start.", t);
            }
            try {
                String prettyMessage = FelixPrettyPrinter.prettyPrintExceptionMessage((String)bundleMessage);
                List bundleIDs = FelixPrettyPrinter.findBundleIds((String)prettyMessage);
                if (bundleIDs.isEmpty()) {
                    throw new GlassFishException(prettyMessage, t);
                }
                StringBuilder bundleBuilder = new StringBuilder(1024);
                bundleBuilder.append(prettyMessage);
                for (Integer bundleId : bundleIDs) {
                    Bundle bundle = this.context.getBundle((long)bundleId.intValue());
                    if (bundle == null) continue;
                    bundleBuilder.append('[').append(bundleId).append("] \n");
                    bundleBuilder.append("jar = ").append(bundle.getLocation());
                    this.tryAddPomProperties(bundle, bundleBuilder);
                    bundleBuilder.append('\n');
                }
                throw new GlassFishException(bundleBuilder.toString(), t);
            }
            catch (GlassFishException ee) {
                throw ee;
            }
            catch (Throwable ee) {
                GlassFishException e = new GlassFishException(bundleMessage, t);
                e.addSuppressed(ee);
                throw e;
            }
        }
    }

    public synchronized void shutdown() throws GlassFishException {
        for (GlassFish glassFish : new ArrayList<GlassFish>(this.glassFishes)) {
            if (glassFish.getStatus() == GlassFish.Status.DISPOSED) continue;
            try {
                glassFish.dispose();
            }
            catch (GlassFishException e) {
                e.printStackTrace();
            }
        }
        this.glassFishes.clear();
        EmbeddedOSGiGlassFishRuntime.shutdownInternal();
    }

    private MultiException findMultiException(Throwable t) {
        for (Throwable currentThrowable = t; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            if (currentThrowable instanceof MultiException) {
                return (MultiException)currentThrowable;
            }
            for (Throwable suppressed : currentThrowable.getSuppressed()) {
                MultiException multiException = this.findMultiException(suppressed);
                if (multiException == null) continue;
                return multiException;
            }
        }
        return null;
    }

    private String findBundleMessage(MultiException ex) {
        for (Throwable error : ex.getErrors()) {
            String message;
            if (error instanceof MultiException && (message = this.findBundleMessage((MultiException)error)) != null) {
                return message;
            }
            for (Throwable currentThrowable = error; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
                if (!(currentThrowable instanceof BundleException)) continue;
                return currentThrowable.getMessage();
            }
        }
        return null;
    }

    private void tryAddPomProperties(Bundle bundle, StringBuilder bundleBuilder) throws IOException {
        Enumeration entries = bundle.findEntries("META-INF/maven/", "pom.properties", true);
        while (entries.hasMoreElements()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((URL)entries.nextElement()).openStream(), StandardCharsets.UTF_8));){
                reader.lines().filter(e -> !e.startsWith("#")).forEach(e -> bundleBuilder.append('\n').append(e.replace("=", " = ")));
            }
            bundleBuilder.append('\n');
        }
    }

    private void setEnv(Properties bootstrapProperties) {
        String instanceRootValue;
        String installRootValue = bootstrapProperties.getProperty("com.sun.aas.installRoot");
        if (installRootValue != null && !installRootValue.isEmpty()) {
            File installRoot = new File(installRootValue);
            System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
            AsenvConf asenv = AsenvConf.parseAsEnv(installRoot);
            asenv.mirrorToSystemProperties();
            System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        }
        if ((instanceRootValue = bootstrapProperties.getProperty("com.sun.aas.instanceRoot")) != null && !instanceRootValue.isEmpty()) {
            File instanceRoot = new File(instanceRootValue);
            System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
            System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        }
    }

    private GlassFish createGlassFish(ModuleStartup gfKernel, ServiceLocator locator, Properties gfProps) throws GlassFishException {
        GlassFishImpl gf = new GlassFishImpl(gfKernel, locator, gfProps);
        return new EmbeddedOSGiGlassFishImpl(gf, this.context);
    }

    private void logClassLoaders(ModulesRegistry moduleRegistry) {
        if (!LOG.isLoggable(Level.FINEST)) {
            return;
        }
        this.logCL(LOG, "currentThread.contextClassLoader:       ", Thread.currentThread().getContextClassLoader());
        this.logCL(LOG, "this.class.classLoader:                 ", ((Object)((Object)this)).getClass().getClassLoader());
        this.logCL(LOG, "this.class.classLoader.parent:          ", ((Object)((Object)this)).getClass().getClassLoader().getParent());
        this.logCL(LOG, "moduleRegistry.parentClassLoader:       ", moduleRegistry.getParentClassLoader());
        this.logCL(LOG, "moduleRegistry.parentClassLoader.parent ", moduleRegistry.getParentClassLoader().getParent());
    }

    private void logCL(Logger logger, String label, ClassLoader classLoader) {
        logger.finest(label + this.toString(classLoader));
    }

    private String toString(ClassLoader classLoader) {
        if (classLoader instanceof GlassfishBootstrapClassLoader || classLoader instanceof GlassfishUrlClassLoader) {
            return classLoader.toString();
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)URLClassLoader.class.cast(classLoader);
            return String.valueOf(ucl) + ": " + String.valueOf(Arrays.stream(ucl.getURLs()).collect(Collectors.toList()));
        }
        return classLoader.toString();
    }
}

