/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.InvalidJvmOptionException;
import com.sun.enterprise.admin.util.QuotedStringTokenizer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class JvmOptionsElement {
    private static final StringManager strMgr = StringManager.getManager(JvmOptionsElement.class);
    private static final JvmOptionsElement DEFAULT = new JvmOptionsElement(){

        @Override
        boolean hasOption(String option) {
            return false;
        }

        @Override
        boolean deleteJvmOption(String option) {
            return false;
        }

        @Override
        String getJvmOptionsAsStoredInXml() {
            return "";
        }

        @Override
        ArrayList getJvmOptions() {
            return new ArrayList();
        }

        @Override
        boolean hasNext() {
            return false;
        }

        @Override
        void setNext(JvmOptionsElement element) {
            throw new UnsupportedOperationException();
        }
    };
    private final Set jvmOptions = new LinkedHashSet();
    private JvmOptionsElement next;
    static final char SEP = ' ';

    static boolean isLast(JvmOptionsElement e) {
        return e == DEFAULT;
    }

    private JvmOptionsElement() {
    }

    JvmOptionsElement(String options) throws InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        String gogoArgs = "-Dgosh.args=--noshutdown -c noop=true";
        if (!options.equals(gogoArgs)) {
            QuotedStringTokenizer strTok = new QuotedStringTokenizer(options, " \t");
            while (strTok.hasMoreTokens()) {
                String option = strTok.nextToken();
                this.checkValidOption(option);
                this.jvmOptions.add(option);
            }
        } else {
            this.jvmOptions.add(gogoArgs);
        }
        this.next = DEFAULT;
    }

    void setNext(JvmOptionsElement element) {
        if (null == element) {
            throw new IllegalArgumentException();
        }
        this.next = element;
    }

    boolean hasNext() {
        return DEFAULT != this.next;
    }

    JvmOptionsElement next() {
        return this.next;
    }

    boolean hasOption(String option) {
        boolean exists = this.jvmOptions.contains(option);
        if (!exists) {
            exists = this.next.hasOption(option);
        }
        return exists;
    }

    boolean deleteJvmOption(String option) {
        boolean b1 = this.jvmOptions.remove(option);
        boolean b2 = this.next().deleteJvmOption(option);
        return b1 || b2;
    }

    String getJvmOptionsAsStoredInXml() {
        if (this.jvmOptions.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = this.jvmOptions.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    ArrayList getJvmOptions() {
        ArrayList<String> arr = new ArrayList<String>();
        if (!this.jvmOptions.isEmpty()) {
            for (String nextOption : this.jvmOptions) {
                if (nextOption.length() > 2 && nextOption.startsWith("\"") && nextOption.endsWith("\"")) {
                    nextOption = nextOption.substring(1, nextOption.length() - 1);
                }
                arr.add(nextOption);
            }
        }
        return arr;
    }

    public String toString() {
        return this.getJvmOptionsAsStoredInXml();
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + (this.jvmOptions != null ? this.jvmOptions.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean isEqual = false;
        if (o instanceof JvmOptionsElement) {
            JvmOptionsElement that = (JvmOptionsElement)o;
            return this.jvmOptions.containsAll(that.jvmOptions);
        }
        return isEqual;
    }

    private void checkValidOption(String option) throws InvalidJvmOptionException {
        if (null == option || option.equals("")) {
            throw new InvalidJvmOptionException(strMgr.getString("jvmOptions.invalid_option", (Object)option));
        }
        if (!(option.startsWith("-") || option.startsWith("\"-") && option.endsWith("\""))) {
            throw new InvalidJvmOptionException(strMgr.getString("jvmOptions.no_dash", (Object)option));
        }
        this.checkQuotes(option);
    }

    void checkQuotes(String option) throws InvalidJvmOptionException {
        int length = option.length();
        int numQuotes = 0;
        for (int index = 0; index < length && (index = option.indexOf(34, index)) != -1; ++index) {
            ++numQuotes;
        }
        if (numQuotes % 2 != 0) {
            throw new InvalidJvmOptionException(strMgr.getString("jvmOptions.incorrect_quotes", (Object)option));
        }
    }
}

