/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.security;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.mvc.Controller;
import jakarta.mvc.security.Csrf;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import org.eclipse.krazo.KrazoConfig;
import org.eclipse.krazo.security.CsrfToken;
import org.eclipse.krazo.security.CsrfTokenManager;

@Controller
@Priority(value=3000)
public class CsrfProtectFilter
implements ContainerResponseFilter {
    @Inject
    private CsrfTokenManager csrfTokenManager;
    @Inject
    private KrazoConfig krazoConfig;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.isCsrfEnabled()) {
            CsrfToken token = this.csrfTokenManager.getOrCreateToken();
            MultivaluedMap headers = responseContext.getHeaders();
            if (!headers.containsKey((Object)token.getHeaderName())) {
                headers.putSingle((Object)token.getHeaderName(), (Object)token.getValue());
            }
        }
    }

    private boolean isCsrfEnabled() {
        return this.krazoConfig.getCsrfOptions() != Csrf.CsrfOptions.OFF;
    }
}

