/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.common.DoNothingActionReporter;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.SystemTasks;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InstanceLifecycleEvent;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.ChangeableRunLevelFuture;
import org.glassfish.hk2.runlevel.ErrorInformation;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelController;
import org.glassfish.hk2.runlevel.RunLevelFuture;
import org.glassfish.hk2.runlevel.RunLevelListener;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Rank(value=50)
public class AppServerStartup
implements PostConstruct,
ModuleStartup {
    StartupContext context;
    static final Logger logger = KernelLoggerInfo.getLogger();
    static final Level level = Level.FINE;
    @Inject
    ServerEnvironmentImpl serverEnvironment;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    ModulesRegistry systemRegistry;
    @Inject
    ExecutorService executor;
    @Inject
    Events events;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    @Inject
    SystemTasks pidWriter;
    @Inject
    RunLevelController runLevelController;
    @Inject
    Provider<CommandRunner> commandRunnerProvider;
    @Inject
    private AppInstanceListener appInstanceListener;
    private MasterRunLevelListener masterListener;
    private long platformInitTime;
    private String platform = System.getProperty("GlassFish_Platform");
    private Thread serverThread;
    private boolean shutdownSignal = false;
    private static final String THREAD_POLICY_PROPERTY = "org.glassfish.startupThreadPolicy";
    private static final String MAX_STARTUP_THREAD_PROPERTY = "org.glassfish.maxStartupThreads";
    private static final String POLICY_FULLY_THREADED = "FULLY_THREADED";
    private static final String POLICY_USE_NO_THREADS = "USE_NO_THREADS";
    private static final int DEFAULT_STARTUP_THREADS = 4;
    private static final String FELIX_PLATFORM = "Felix";
    private static final String STATIC_PLATFORM = "Static";

    @Inject
    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    public void postConstruct() {
        this.masterListener = new MasterRunLevelListener(this.runLevelController);
        String threadPolicy = System.getProperty(THREAD_POLICY_PROPERTY);
        if (threadPolicy != null) {
            if (POLICY_FULLY_THREADED.equals(threadPolicy)) {
                logger.fine("Using startup thread policy FULLY_THREADED at behest of system property");
                this.runLevelController.setThreadingPolicy(RunLevelController.ThreadingPolicy.FULLY_THREADED);
            } else if (POLICY_USE_NO_THREADS.equals(threadPolicy)) {
                logger.fine("Using startup thread policy USE_NO_THREADS at behest of system property");
                this.runLevelController.setThreadingPolicy(RunLevelController.ThreadingPolicy.USE_NO_THREADS);
            } else {
                logger.warning("Unknown threading policy " + threadPolicy + ".  Will use the current policy of " + String.valueOf(this.runLevelController.getThreadingPolicy()));
            }
        } else if (this.platform == null || !this.platform.equals(FELIX_PLATFORM) && !this.platform.equals(STATIC_PLATFORM)) {
            this.runLevelController.setThreadingPolicy(RunLevelController.ThreadingPolicy.USE_NO_THREADS);
        }
        int numThreads = Integer.getInteger(MAX_STARTUP_THREAD_PROPERTY, 4);
        if (numThreads > 0) {
            logger.fine("Startup controller will use " + numThreads + " + threads");
            this.runLevelController.setMaximumUseableThreads(numThreads);
        } else {
            logger.fine("Startup controller will use infinite threads");
        }
    }

    public synchronized void start() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.commonCLS.getCommonClassLoader());
            this.doStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private void doStart() {
        this.run();
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverThread = new Thread("GlassFish Kernel Main Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.logp(level, "AppServerStartup", "run", "[{0}] started", new Object[]{this});
                latch.countDown();
                1 var1_1 = this;
                synchronized (var1_1) {
                    while (!AppServerStartup.this.shutdownSignal) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                logger.logp(level, "AppServerStartup", "run", "[{0}] exiting", new Object[]{this});
            }
        };
        this.serverThread.setDaemon(false);
        this.serverThread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void run() {
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
            return;
        }
        if (this.platform == null) {
            this.platform = "Embedded";
        }
        this.platformInitTime = System.currentTimeMillis();
        if (logger.isLoggable(level)) {
            logger.log(level, "Startup class : {0}", this.getClass().getName());
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)logger));
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)this.masterListener));
        config.addUnbindFilter((Filter)BuilderHelper.createContractFilter((String)ProcessEnvironment.class.getName()));
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)(this.serverEnvironment.isEmbedded() ? new ProcessEnvironment(ProcessEnvironment.ProcessType.Embedded) : new ProcessEnvironment(ProcessEnvironment.ProcessType.Server))));
        config.commit();
        this.masterListener.reset();
        long initFinishTime = 0L;
        long startupFinishTime = 0L;
        if (!this.proceedTo(1)) {
            this.appInstanceListener.stopRecordingTimes();
            return;
        }
        if (!logger.isLoggable(level)) {
            this.appInstanceListener.stopRecordingTimes();
        } else {
            initFinishTime = System.currentTimeMillis();
            logger.log(level, "Init level done in " + (initFinishTime - this.context.getCreationTime()) + " ms");
        }
        this.appInstanceListener.startRecordingFutures();
        if (!this.proceedTo(10) || !this.postStartupJob()) {
            this.appInstanceListener.stopRecordingTimes();
            return;
        }
        if (logger.isLoggable(level)) {
            startupFinishTime = System.currentTimeMillis();
            logger.log(level, "Startup level done in " + (startupFinishTime - initFinishTime) + " ms");
        }
        if (!this.proceedTo(20)) {
            this.appInstanceListener.stopRecordingTimes();
            return;
        }
        if (logger.isLoggable(level)) {
            long postStartupFinishTime = System.currentTimeMillis();
            logger.log(level, "PostStartup level done in " + (postStartupFinishTime - startupFinishTime) + " ms");
        }
    }

    private boolean postStartupJob() {
        LinkedList<Future<Result<Thread>>> futures = this.appInstanceListener.getFutures();
        this.serverEnvironment.setStatus(ServerEnvironment.Status.starting);
        this.events.send(new EventListener.Event(EventTypes.SERVER_STARTUP), false);
        long nowTime = System.currentTimeMillis();
        logger.log(Level.INFO, "NCLS-CORE-00017", new Object[]{Version.getProductIdInfo(), this.platform, this.platformInitTime - this.context.getCreationTime(), nowTime - this.platformInitTime, nowTime - this.context.getCreationTime()});
        AppServerStartup.printModuleStatus(this.systemRegistry, level);
        String wallClockStart = System.getProperty("WALL_CLOCK_START");
        if (wallClockStart != null) {
            try {
                Instant realstart = Instant.parse(wallClockStart);
                long l = Duration.between(realstart, Instant.now()).toMillis();
                logger.log(Level.INFO, "NCLS-CORE-00018", l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Future future : futures) {
            try {
                try {
                    if (!((Result)future.get(3L, TimeUnit.SECONDS)).isFailure()) continue;
                    Throwable t = ((Result)future.get()).exception();
                    logger.log(Level.SEVERE, "NCLS-CORE-00019", t);
                    this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
                    this.shutdown();
                    return false;
                }
                catch (TimeoutException e) {
                    logger.log(Level.WARNING, "NCLS-CORE-00020", e);
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "NCLS-CORE-00021", t);
            }
        }
        this.serverEnvironment.setStatus(ServerEnvironment.Status.started);
        this.events.send(new EventListener.Event(EventTypes.SERVER_READY), false);
        this.pidWriter.writePidFile();
        return true;
    }

    public static void printModuleStatus(ModulesRegistry registry, Level level) {
        if (!logger.isLoggable(level) || registry == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("HK2Module Status Report Begins\n");
        for (HK2Module m : registry.getModules()) {
            if (m.getState() != ModuleState.READY) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (HK2Module m : registry.getModules()) {
            if (m.getState() != ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (HK2Module m : registry.getModules()) {
            if (m.getState() == ModuleState.READY || m.getState() == ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("HK2Module Status Report Ends");
        logger.log(level, sb.toString());
    }

    private void shutdown() {
        CommandRunner runner = (CommandRunner)this.commandRunnerProvider.get();
        if (runner != null) {
            ParameterMap params = new ParameterMap();
            boolean noForcedShutdown = Boolean.parseBoolean(this.context.getArguments().getProperty("--noforcedshutdown", "true"));
            if (noForcedShutdown) {
                params.set((Object)"force", (Object)"false");
            }
            InternalSystemAdministrator kernelIdentity = (InternalSystemAdministrator)this.serviceLocator.getService(InternalSystemAdministrator.class, new Annotation[0]);
            if (this.serverEnvironment.isDas()) {
                runner.getCommandInvocation("stop-domain", (ActionReport)new DoNothingActionReporter(), kernelIdentity.getSubject()).parameters(params).execute();
            } else {
                runner.getCommandInvocation("_stop-instance", (ActionReport)new DoNothingActionReporter(), kernelIdentity.getSubject()).parameters(params).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.serverEnvironment.getStatus() == ServerEnvironment.Status.stopped) {
            logger.fine("Already stopped, so just returning");
            return;
        }
        this.serverEnvironment.setStatus(ServerEnvironment.Status.stopping);
        try {
            this.events.send(new EventListener.Event(EventTypes.PREPARE_SHUTDOWN), false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00070", e);
        }
        try {
            this.proceedTo(1);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00070", e);
        }
        this.serverEnvironment.setStatus(ServerEnvironment.Status.stopped);
        try {
            this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00070", e);
        }
        try {
            this.runLevelController.proceedTo(0);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00070", e);
        }
        logger.info("NCLS-CORE-00013");
        if (this.serverThread != null) {
            Thread e = this.serverThread;
            synchronized (e) {
                this.shutdownSignal = true;
                this.serverThread.notify();
            }
            try {
                this.serverThread.join(0L);
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private boolean proceedTo(int runLevel) {
        try {
            this.runLevelController.proceedTo(runLevel);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00014", e);
            this.shutdown();
            return false;
        }
        return !this.masterListener.isForcedShutdown();
    }

    @Singleton
    private class MasterRunLevelListener
    implements RunLevelListener {
        private final RunLevelController controller;
        private boolean forcedShutdown = false;

        private MasterRunLevelListener(RunLevelController controller) {
            this.controller = controller;
        }

        private void reset() {
            this.forcedShutdown = false;
        }

        private boolean isForcedShutdown() {
            return this.forcedShutdown;
        }

        public void onCancelled(RunLevelFuture future, int previousProceedTo) {
            logger.log(Level.INFO, "NCLS-CORE-00015");
            if (future.isDown()) {
                return;
            }
            this.forcedShutdown = true;
            AppServerStartup.this.shutdown();
        }

        public void onError(RunLevelFuture future, ErrorInformation info) {
            if (future.isDown()) {
                logger.log(Level.WARNING, "An error occured when the system was coming down", info.getError());
                return;
            }
            logger.log(Level.INFO, "NCLS-CORE-00015", info.getError());
            if (this.controller.getCurrentRunLevel() >= 1) {
                logger.log(Level.SEVERE, "NCLS-CORE-00016", info.getError());
                AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
            }
            this.forcedShutdown = true;
            AppServerStartup.this.shutdown();
        }

        public void onProgress(ChangeableRunLevelFuture future, int achievedLevel) {
            if (achievedLevel == 20 && logger.isLoggable(level)) {
                AppServerStartup.printModuleStatus(AppServerStartup.this.systemRegistry, level);
                LinkedHashMap<String, Long> recordedTimes = AppServerStartup.this.appInstanceListener.getAllRecordedTimes();
                int lcv = 0;
                if (recordedTimes != null) {
                    for (Map.Entry<String, Long> service : recordedTimes.entrySet()) {
                        logger.log(level, "Service(" + lcv++ + ") : " + service.getKey() + " took " + String.valueOf(service.getValue()) + " ms");
                    }
                }
            }
        }
    }

    @Service
    public static class AppInstanceListener
    implements InstanceLifecycleListener {
        private static final Filter FILTER = new Filter(){

            public boolean matches(Descriptor d) {
                return d.getScope() != null && d.getScope().equals(RunLevel.class.getName());
            }
        };
        @Inject
        private Provider<RunLevelController> controllerProvider;
        private volatile RunLevelController controller;
        private Map<String, Long> startTimes = new HashMap<String, Long>();
        private LinkedHashMap<String, Long> recordedTimes = new LinkedHashMap();
        private LinkedList<Future<Result<Thread>>> futures = null;

        public Filter getFilter() {
            return FILTER;
        }

        public void lifecycleEvent(InstanceLifecycleEvent lifecycleEvent) {
            if (InstanceLifecycleEventType.PRE_PRODUCTION.equals((Object)lifecycleEvent.getEventType())) {
                this.doPreProduction(lifecycleEvent.getActiveDescriptor());
                return;
            }
            if (InstanceLifecycleEventType.POST_PRODUCTION.equals((Object)lifecycleEvent.getEventType())) {
                this.doPostProduction(lifecycleEvent);
                return;
            }
            if (InstanceLifecycleEventType.PRE_DESTRUCTION.equals((Object)lifecycleEvent.getEventType())) {
                this.doPreDestruction(lifecycleEvent.getActiveDescriptor());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RunLevelController getController() {
            if (this.controller != null) {
                return this.controller;
            }
            AppInstanceListener appInstanceListener = this;
            synchronized (appInstanceListener) {
                if (this.controller != null) {
                    return this.controller;
                }
                this.controller = (RunLevelController)this.controllerProvider.get();
                return this.controller;
            }
        }

        private void stopRecordingTimes() {
            this.startTimes = null;
            this.recordedTimes = null;
        }

        private void startRecordingFutures() {
            this.futures = new LinkedList();
        }

        private LinkedList<Future<Result<Thread>>> getFutures() {
            LinkedList<Future<Result<Thread>>> retVal = this.futures;
            this.futures = null;
            return retVal;
        }

        private void doPreProduction(ActiveDescriptor<?> descriptor) {
            if (this.startTimes != null) {
                this.startTimes.put(descriptor.getImplementation(), System.currentTimeMillis());
            }
            if (this.getController().getCurrentRunLevel() > 1 && logger.isLoggable(level)) {
                logger.log(level, "Running service " + descriptor.getImplementation());
            }
        }

        private void doPostProduction(InstanceLifecycleEvent event) {
            Object startup;
            ActiveDescriptor descriptor = event.getActiveDescriptor();
            if (this.startTimes != null && this.recordedTimes != null) {
                Long startupTime = this.startTimes.remove(descriptor.getImplementation());
                if (startupTime == null) {
                    return;
                }
                this.recordedTimes.put(descriptor.getImplementation(), System.currentTimeMillis() - startupTime);
            }
            if (this.getController().getCurrentRunLevel() > 1 && logger.isLoggable(level)) {
                logger.log(level, "Service " + descriptor.getImplementation() + " finished " + String.valueOf(event.getLifecycleObject()));
            }
            if (this.futures != null && (startup = event.getLifecycleObject()) instanceof FutureProvider) {
                FutureProvider futureProvider = (FutureProvider)startup;
                this.futures.addAll(futureProvider.getFutures());
            }
        }

        private void doPreDestruction(ActiveDescriptor<?> descriptor) {
            if (logger.isLoggable(level)) {
                logger.log(level, "Releasing service {0}", descriptor.getImplementation());
            }
        }

        private LinkedHashMap<String, Long> getAllRecordedTimes() {
            LinkedHashMap<String, Long> retVal = this.recordedTimes;
            this.stopRecordingTimes();
            return retVal;
        }
    }
}

