/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableModel;

public class UIFactory {
    public static final String CANCEL = "cancel";
    private static Font baseFont = new JLabel().getFont();
    private static final ActionListener closeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Component src = (Component)e.getSource();
            for (Container p = src.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof JInternalFrame) && !(p instanceof Window)) continue;
                p.setVisible(false);
                return;
            }
        }
    };
    private Class clientClass;
    private Component parent;
    private I18NResourceBundle i18n;
    private HelpBroker helpBroker;
    private static I18NResourceBundle local_i18n = I18NResourceBundle.getBundleForClass(UIFactory.class);
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();

    public static Font getBaseFont() {
        return baseFont;
    }

    public static Color getInvalidInputColor() {
        return Colors.INPUT_INVALID.getValue();
    }

    public static void setInvalidInputColor(Color newColor) {
        Colors.INPUT_INVALID.setValue(newColor);
    }

    public static Color getValidInputColor() {
        return Colors.INPUT_VALID.getValue();
    }

    public static void setValidInputColor(Color newColor) {
        Colors.INPUT_VALID.setValue(newColor);
    }

    public static Color getDefaultInputColor() {
        return Colors.INPUT_DEFAULT.getValue();
    }

    public static void setDefaultInputColor(Color newColor) {
        Colors.INPUT_DEFAULT.setValue(newColor);
    }

    public static void setColorByName(String name, Color c) {
        Colors.valueOfByPreferencesName(name).setValue(c);
    }

    public static void setDefaultColors() {
        Colors[] colors;
        Preferences pref = Preferences.access();
        for (Colors c : colors = Colors.values()) {
            pref.setPreference(c.getPreferencesName(), c.getDefaultValue());
        }
    }

    public static void addColorChangeObserver(Preferences.Observer observer) {
        Preferences.access().addObserver(Colors.getColorsNames(), observer);
    }

    public JButton createColorChooseButton(String cs, JLabel label, ActionListener l) {
        JButton b = new JButton(" ");
        Color c = Colors.getColorByPreferencesName(cs);
        b.setBackground(c);
        b.setSize(14, 14);
        b.setText(" ");
        b.setName(cs);
        if (l != null) {
            b.addActionListener(l);
        }
        if (label != null) {
            label.setLabelFor(b);
        }
        return b;
    }

    public UIFactory(Class c, HelpBroker helpBroker) {
        this(c, null, helpBroker);
    }

    public UIFactory(Component c, HelpBroker helpBroker) {
        this(c.getClass(), c, helpBroker);
    }

    public UIFactory(Class c, Component p, HelpBroker helpBroker) {
        this.helpBroker = helpBroker;
        this.clientClass = c;
        this.parent = p;
        this.i18n = I18NResourceBundle.getBundleForClass(c);
    }

    public void setDialogParent(Component p) {
        if (this.parent != null && this.parent != p) {
            throw new IllegalStateException();
        }
        this.parent = p;
    }

    public int getDotsPerInch() {
        return DOTS_PER_INCH;
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public I18NResourceBundle getI18NResourceBundle() {
        return this.i18n;
    }

    public int getI18NMnemonic(String key) {
        String keyString = this.getI18NString(key);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyString);
        if (keyStroke != null) {
            return keyStroke.getKeyCode();
        }
        return 0;
    }

    public Color getI18NColor(String key) {
        String value = this.i18n.getString(key + ".clr");
        try {
            if (value != null) {
                return Color.decode(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Color.BLACK;
    }

    public String getI18NString(String key) {
        return this.i18n.getString(key);
    }

    public String getI18NString(String key, Object arg) {
        return this.i18n.getString(key, arg);
    }

    public String getI18NString(String key, Object[] args) {
        return this.i18n.getString(key, args);
    }

    public void setHelp(final Component comp, String helpID) {
        if (helpID == null) {
            throw new NullPointerException();
        }
        ContextHelpManager.setHelpIDString(comp, helpID);
        if (comp instanceof JDialog) {
            JDialog d = (JDialog)comp;
            ContextHelpManager.setHelpIDString(d.getRootPane(), helpID);
            Desktop.addHelpDebugListener(d);
            final JRootPane rootPane = d.getRootPane();
            KeyStroke keystroke = KeyStroke.getKeyStroke(112, 0, false);
            rootPane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UIFactory.this.helpBroker != null) {
                        UIFactory.this.helpBroker.displayCurrentID(ContextHelpManager.getHelpIDString(rootPane));
                    }
                }
            }, keystroke, 1);
        } else if (comp instanceof JComponent) {
            KeyStroke keystroke = KeyStroke.getKeyStroke(112, 0, false);
            ((JComponent)comp).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UIFactory.this.helpBroker != null) {
                        UIFactory.this.helpBroker.displayCurrentID(ContextHelpManager.getHelpIDString(comp));
                    }
                }
            }, keystroke, 1);
        }
    }

    public void setToolTip(JComponent c, String uiKey) {
        String text = this.getI18NString(uiKey + ".tip");
        c.setToolTipText(text);
        c.getAccessibleContext().setAccessibleDescription(text);
    }

    public void setAccessibleDescription(Component c, String uiKey) {
        this.setAccessibleDescription(c.getAccessibleContext(), uiKey);
    }

    public void setAccessibleDescription(AccessibleContext c, String uiKey) {
        String text = this.getI18NString(uiKey + ".desc");
        c.setAccessibleDescription(text);
    }

    public void setAccessibleName(Component c, String uiKey) {
        this.setAccessibleName(c.getAccessibleContext(), uiKey);
    }

    public void setAccessibleName(AccessibleContext c, String uiKey) {
        String text = this.getI18NString(uiKey + ".name");
        c.setAccessibleName(text);
    }

    public void setAccessibleInfo(Component c, String uiKey) {
        this.setAccessibleInfo(c.getAccessibleContext(), uiKey);
    }

    public void setAccessibleInfo(AccessibleContext c, String uiKey) {
        this.setAccessibleDescription(c, uiKey);
        this.setAccessibleName(c, uiKey);
    }

    public Border createTitledBorder(String uiKey) {
        return BorderFactory.createTitledBorder(null, this.getI18NString(uiKey + ".bdr"), 4, 0, UIFactory.getBaseFont(), Colors.TEXT_COLOR.getValue());
    }

    public Component createHorizontalGlue(String uiKey) {
        Component c = Box.createHorizontalGlue();
        c.setName(uiKey);
        c.setFocusable(false);
        return c;
    }

    public Component createGlue(String uiKey) {
        Component c = Box.createGlue();
        c.setName(uiKey);
        c.setFocusable(false);
        return c;
    }

    public Component createHorizontalStrut(int width) {
        Component c = Box.createHorizontalStrut(width);
        c.setFocusable(false);
        return c;
    }

    public JButton createButton(String uiKey) {
        JButton b = new JButton(this.getI18NString(uiKey + ".btn"));
        b.setActionCommand(uiKey);
        b.setName(uiKey);
        this.setMnemonic(b, uiKey);
        this.setToolTip(b, uiKey);
        return b;
    }

    public JButton createButton(Action a) {
        JButton b = new JButton(a);
        b.setName((String)a.getValue("Name"));
        return b;
    }

    public JButton createButton(String uiKey, Icon icon) {
        JButton b = new JButton(icon);
        b.setName(uiKey);
        this.setMnemonic(b, uiKey);
        this.setToolTip(b, uiKey);
        return b;
    }

    public JButton createButton(String uiKey, ActionListener l) {
        JButton b = this.createButton(uiKey);
        b.addActionListener(l);
        return b;
    }

    public JButton createButton(String uiKey, ActionListener l, String cmd) {
        JButton b = this.createButton(uiKey);
        b.setActionCommand(cmd);
        b.addActionListener(l);
        return b;
    }

    public JButton createCancelButton(String uiKey) {
        return this.createCancelButton(uiKey, closeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JButton createCancelButton(String uiKey, ActionListener l) {
        JButton b;
        I18NResourceBundle save_i18n = this.i18n;
        try {
            this.i18n = local_i18n;
            b = new JButton(this.getI18NString("uif.cancel.btn"));
        }
        finally {
            this.i18n = save_i18n;
        }
        b.setActionCommand(CANCEL);
        b.addActionListener(l);
        b.setName(uiKey);
        this.setToolTip(b, uiKey);
        return b;
    }

    public JButton createCloseButton(String uiKey) {
        return this.createCloseButton(uiKey, true);
    }

    public JButton createCloseButton(String uiKey, boolean needMnemonic) {
        JButton b = new JButton(this.getI18NString(uiKey + ".btn"));
        b.setName(uiKey);
        if (needMnemonic) {
            this.setMnemonic(b, uiKey);
        }
        this.setToolTip(b, uiKey);
        b.addActionListener(closeListener);
        return b;
    }

    public JButton createHelpButton(String uiKey, final String helpID) {
        JButton hb = this.createButton(uiKey);
        hb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UIFactory.this.helpBroker != null) {
                    UIFactory.this.helpBroker.displayCurrentID(helpID);
                }
            }
        });
        return hb;
    }

    public JButton createIconButton(String uiKey) {
        JButton b = this.createButton(uiKey, this.createIcon(uiKey));
        b.setBorder(BorderFactory.createEmptyBorder());
        return b;
    }

    public JButton createIconButton(String uiKey, ActionListener l) {
        JButton b = this.createButton(uiKey, this.createIcon(uiKey));
        b.addActionListener(l);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JButton createOptionButton(String uiKey) {
        I18NResourceBundle save_i18n = this.i18n;
        try {
            JButton b;
            this.i18n = local_i18n;
            JButton jButton = b = this.createButton(uiKey, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component c = (Component)e.getSource();
                    JOptionPane op = (JOptionPane)SwingUtilities.getAncestorOfClass(JOptionPane.class, c);
                    op.setValue(c);
                    op.setVisible(false);
                }
            });
            return jButton;
        }
        finally {
            this.i18n = save_i18n;
        }
    }

    public JRadioButton createRadioButton(String uiKey, ButtonGroup group) {
        String text = this.getI18NString(uiKey + ".rb");
        JRadioButton btn = new JRadioButton(text, true);
        btn.setName(uiKey);
        btn.setSelected(false);
        this.setMnemonic(btn, uiKey);
        this.setToolTip(btn, uiKey);
        group.add(btn);
        return btn;
    }

    public void setMnemonic(AbstractButton b, String uiKey) {
        int mne = this.getI18NMnemonic(uiKey + ".mne");
        if (mne != 0) {
            b.setMnemonic(mne);
        }
    }

    public JCheckBox createCheckBox(String uiKey) {
        return this.createCheckBox(uiKey, false, null);
    }

    public JCheckBox createCheckBox(String uiKey, boolean state) {
        return this.createCheckBox(uiKey, state, null);
    }

    public JCheckBox createCheckBox(String uiKey, boolean state, ButtonGroup group) {
        String ckbKey = uiKey + ".ckb";
        JCheckBox b = new JCheckBox(this.getI18NString(ckbKey), state);
        b.setName(uiKey);
        if (group != null) {
            group.add(b);
        }
        this.setMnemonic(b, uiKey);
        this.setToolTip(b, uiKey);
        return b;
    }

    public JComboBox createChoice(String uiKey, String[] choiceKeys) {
        return this.createChoice(uiKey, choiceKeys, false);
    }

    public JComboBox createChoice(String uiKey, final String[] choiceKeys, boolean editable) {
        Component editComp;
        final String[] choices = new String[choiceKeys.length];
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = this.getI18NString(uiKey + "." + choiceKeys[i] + ".chc");
        }
        JComboBox<String> choice = new JComboBox<String>(choiceKeys);
        choice.setName(uiKey);
        this.setToolTip(choice, uiKey);
        this.setAccessibleName(choice, uiKey);
        choice.setEditable(editable);
        if (editable && (editComp = choice.getEditor().getEditorComponent()) instanceof Accessible) {
            if (editComp.getName() == null) {
                editComp.setName(uiKey + ".ed");
            }
            AccessibleContext ac = choice.getAccessibleContext();
            AccessibleContext ed_ac = editComp.getAccessibleContext();
            ed_ac.setAccessibleName(ac.getAccessibleName());
            ed_ac.setAccessibleDescription(ac.getAccessibleDescription());
        }
        choice.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
                Object c = o;
                for (int i = 0; i < choiceKeys.length; ++i) {
                    if (choiceKeys[i] != o) continue;
                    c = choices[i];
                    break;
                }
                return super.getListCellRendererComponent((JList<?>)list, c, index, isSelected, cellHasFocus);
            }
        });
        return choice;
    }

    public JComboBox createChoice(String uiKey) {
        return this.createChoice(uiKey, false);
    }

    public JComboBox createChoice(String uiKey, boolean editable) {
        return this.createChoice(uiKey, editable, null);
    }

    public JComboBox createChoice(String uiKey, JLabel label) {
        return this.createChoice(uiKey, false, label);
    }

    public JComboBox createChoice(String uiKey, boolean editable, JLabel label) {
        Component editComp;
        JComboBox choice = new JComboBox();
        choice.setName(uiKey);
        this.setToolTip(choice, uiKey);
        if (label != null) {
            label.setLabelFor(choice);
        } else {
            this.setAccessibleName(choice, uiKey);
        }
        choice.setEditable(editable);
        if (editable && (editComp = choice.getEditor().getEditorComponent()) instanceof Accessible) {
            if (editComp.getName() == null) {
                editComp.setName(uiKey + ".ed");
            }
            AccessibleContext ac = choice.getAccessibleContext();
            AccessibleContext ed_ac = editComp.getAccessibleContext();
            ed_ac.setAccessibleName(ac.getAccessibleName());
            ed_ac.setAccessibleDescription(ac.getAccessibleDescription());
        }
        return choice;
    }

    public JComboBox createLiteralChoice(String uiKey, Object[] choices) {
        JComboBox<Object> choice = new JComboBox<Object>(choices);
        choice.setName(uiKey);
        this.setToolTip(choice, uiKey);
        return choice;
    }

    public Icon createIcon(String uiKey) {
        return new ImageIcon(this.getIconURL(uiKey));
    }

    public URL getIconURL(String uiKey) {
        String r = this.getI18NString(uiKey + ".icon");
        URL url = this.clientClass.getResource(r);
        if (url == null) {
            throw new MissingResourceException(r, this.clientClass.getName(), r);
        }
        return url;
    }

    public JLabel createIconLabel(String uiKey) {
        return new JLabel(this.createIcon(uiKey));
    }

    public Image createImage(String r) {
        URL url = this.getClass().getResource(r);
        if (url == null) {
            throw new MissingResourceException(r, this.clientClass.getName(), r);
        }
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public JLabel createLabel(String uiKey) {
        return this.createLabel(uiKey, false);
    }

    public JLabel createLabel(String uiKey, boolean need508) {
        JLabel l = new JLabel(this.getI18NString(uiKey + ".lbl"));
        l.setName(uiKey);
        if (need508) {
            this.setToolTip(l, uiKey);
            l.setDisplayedMnemonic(this.getI18NMnemonic(uiKey + ".mne"));
        }
        return l;
    }

    public JList createList(String uiKey) {
        JList list = new JList();
        list.setName(uiKey);
        this.setAccessibleInfo(list, uiKey);
        return list;
    }

    public JList createList(String uiKey, ListModel model) {
        JList list = new JList(model);
        list.setName(uiKey);
        this.setAccessibleInfo(list, uiKey);
        return list;
    }

    public JMenuBar createMenuBar(String uiKey) {
        JMenuBar mb = new JMenuBar();
        mb.setName(uiKey);
        this.setAccessibleInfo(mb, uiKey);
        return mb;
    }

    public JMenu createMenu(String uiKey) {
        JMenu m = new JMenu();
        this.initMenu(m, uiKey);
        return m;
    }

    public void initMenu(JMenu m, String uiKey) {
        m.setName(uiKey);
        m.setText(this.getI18NString(uiKey + ".menu"));
        this.setMnemonic(m, uiKey);
        this.setAccessibleDescription(m, uiKey);
    }

    public JMenu createMenu(String uiKey, Action[] actions) {
        JMenu m = this.createMenu(uiKey);
        for (int i = 0; i < actions.length; ++i) {
            Action action = actions[i];
            if (action == null) {
                m.addSeparator();
                continue;
            }
            m.add(this.createMenuItem(action));
        }
        return m;
    }

    public JMenu createMenu(String uiKey, String[] actions, ActionListener l) {
        JMenu m = new JMenu();
        this.initMenu(m, uiKey, actions, l);
        return m;
    }

    public void initMenu(JMenu m, String uiKey, String[] actions, ActionListener l) {
        this.initMenu(m, uiKey);
        for (int i = 0; i < actions.length; ++i) {
            String action = actions[i];
            if (action == null) {
                m.addSeparator();
                continue;
            }
            m.add(this.createMenuItem(uiKey, action, l));
        }
    }

    public JPopupMenu createPopupMenu(String uiKey) {
        return new JPopupMenu();
    }

    public JPopupMenu createPopupMenu(String uiKey, String[] actions, ActionListener l) {
        JPopupMenu m = this.createPopupMenu(uiKey);
        for (int i = 0; i < actions.length; ++i) {
            String action = actions[i];
            if (action == null) {
                m.addSeparator();
                continue;
            }
            m.add(this.createMenuItem(uiKey, action, l));
        }
        return m;
    }

    public JMenuItem createMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        item.setName((String)action.getValue("Name"));
        return item;
    }

    public JMenuItem createMenuItem(String uiKey, String action, ActionListener l) {
        JMenuItem item = new JMenuItem(this.getI18NString(uiKey + "." + action + ".mit"));
        item.setActionCommand(action);
        item.addActionListener(l);
        item.setName(action);
        this.setMnemonic(item, uiKey + "." + action);
        return item;
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem(String uiKey, String name, boolean state) {
        String uiKey_name = uiKey + "." + name;
        String ckbKey = uiKey_name + ".ckb";
        JCheckBoxMenuItem b = new JCheckBoxMenuItem(this.getI18NString(ckbKey), state);
        b.setName(uiKey_name);
        this.setMnemonic(b, uiKey_name);
        this.setToolTip(b, uiKey_name);
        return b;
    }

    public JMenuItem createHelpMenuItem(String uiKey, final String helpID) {
        JMenuItem mi = new JMenuItem(this.getI18NString(uiKey + ".mit"));
        this.setMnemonic(mi, uiKey);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UIFactory.this.helpBroker != null) {
                    UIFactory.this.helpBroker.displayCurrentID(helpID);
                }
            }
        });
        return mi;
    }

    public JMenuItem createLiteralMenuItem(String literal, ActionListener l) {
        JMenuItem item = new JMenuItem(literal);
        item.addActionListener(l);
        return item;
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(String uiKey, String name) {
        String uiKey_name = uiKey + "." + name;
        String radKey = uiKey_name + ".rad";
        JRadioButtonMenuItem b = new JRadioButtonMenuItem(this.getI18NString(radKey));
        b.setName(uiKey_name);
        this.setMnemonic(b, uiKey_name);
        this.setToolTip(b, uiKey_name);
        return b;
    }

    public JScrollPane createScrollPane(JComponent c) {
        JScrollPane sp = new JScrollPane(c);
        sp.setName(c.getName() == null ? "sp" : c.getName() + ".sp");
        sp.setFocusable(false);
        return sp;
    }

    public JScrollPane createScrollPane(JComponent c, int vsp, int hsp) {
        JScrollPane sp = new JScrollPane(c, vsp, hsp);
        sp.setName(c.getName() == null ? "sp" : c.getName() + ".sp");
        sp.setFocusable(false);
        return sp;
    }

    public JSlider createSlider(String uiKey, int min, int max, int value) {
        JSlider s = new JSlider(min, max, value);
        this.setToolTip(s, uiKey);
        return s;
    }

    public JSplitPane createSplitPane(int orient) {
        JSplitPane sp = new JSplitPane(orient);
        sp.setName("split");
        this.setSplitPaneInfo(sp);
        return sp;
    }

    public JSplitPane createSplitPane(int orient, Component c1, Component c2) {
        JSplitPane sp = new JSplitPane(orient, c1, c2);
        sp.setName("split");
        this.setSplitPaneInfo(sp);
        return sp;
    }

    private void setSplitPaneInfo(JSplitPane sp) {
        AccessibleContext ac = sp.getAccessibleContext();
        if (sp.getOrientation() == 1) {
            ac.setAccessibleName(local_i18n.getString("uif.sp.hor.name"));
            ac.setAccessibleDescription(local_i18n.getString("uif.sp.hor.desc"));
        } else {
            ac.setAccessibleName(local_i18n.getString("uif.sp.vert.name"));
            ac.setAccessibleDescription(local_i18n.getString("uif.sp.vert.desc"));
        }
    }

    public JTabbedPane createTabbedPane(String uiKey) {
        JTabbedPane p = new JTabbedPane();
        p.setName(uiKey);
        this.setAccessibleName(p, uiKey);
        this.setToolTip(p, uiKey);
        return p;
    }

    public JTabbedPane createTabbedPane(String uiKey, JComponent[] children) {
        JTabbedPane p = new JTabbedPane();
        p.setName(uiKey);
        this.setAccessibleName(p, uiKey);
        for (int i = 0; i < children.length; ++i) {
            JComponent child = children[i];
            this.addTab(p, uiKey + "." + child.getName(), child);
        }
        this.setToolTip(p, uiKey);
        return p;
    }

    public void addTab(JTabbedPane tPane, String uiKey, JComponent comp) {
        String name = this.getI18NString(uiKey + ".tab");
        String tip = this.getI18NString(uiKey + ".tip");
        tPane.addTab(name, null, comp, tip);
    }

    public JTable createTable(String uiKey, TableModel model) {
        JTable tbl = new JTable(model);
        this.setAccessibleName(tbl, uiKey);
        this.setToolTip(tbl, uiKey);
        return tbl;
    }

    public JTextField createHeading(String uiKey) {
        String value = this.getI18NString(uiKey + ".txt");
        JTextField tf = new JTextField(value, value.length());
        tf.setName(uiKey);
        tf.setEditable(false);
        tf.setFont(tf.getFont().deriveFont(1));
        tf.setBorder(BorderFactory.createEmptyBorder());
        tf.setBackground(Colors.TRANSPARENT.color);
        tf.setOpaque(false);
        this.setAccessibleDescription(tf, uiKey);
        this.setAccessibleName(tf, uiKey);
        return tf;
    }

    public JTextField createInputField(String uiKey) {
        return this.createInputField(uiKey, null);
    }

    public JTextField createInputField(String uiKey, JLabel label) {
        return this.createInputField(uiKey, 10, label);
    }

    public JTextField createInputField(String uiKey, int cols) {
        return this.createInputField(uiKey, cols, null);
    }

    public JTextField createInputField(String uiKey, int cols, JLabel label) {
        JTextField tf = new JTextField("", cols){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        if (label != null) {
            label.setLabelFor(tf);
        } else {
            tf.setName(uiKey);
        }
        this.setToolTip(tf, uiKey);
        return tf;
    }

    public JTextArea createMessageArea(String uiKey) {
        return this.createLocalizedMessageArea(uiKey, this.getI18NString(uiKey + ".txt"), true);
    }

    public JTextArea createMessageArea(String uiKey, Object arg) {
        return this.createLocalizedMessageArea(uiKey, this.getI18NString(uiKey + ".txt", arg), true);
    }

    public JTextArea createMessageArea(String uiKey, Object[] args) {
        return this.createLocalizedMessageArea(uiKey, this.getI18NString(uiKey + ".txt", args), true);
    }

    private JTextArea createLiteralMessageArea(String msg) {
        JTextArea txt = new JTextArea(msg);
        txt.setName("literal");
        txt.setOpaque(false);
        txt.setEditable(false);
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setSize(new Dimension(7 * DOTS_PER_INCH, Integer.MAX_VALUE));
        txt.setFocusTraversalKeys(0, null);
        txt.setFocusTraversalKeys(1, null);
        AccessibleContext ac = txt.getAccessibleContext();
        ac.setAccessibleName(local_i18n.getString("uif.message.name"));
        ac.setAccessibleDescription(local_i18n.getString("uif.message.desc"));
        return txt;
    }

    private JTextArea createLocalizedMessageArea(String uiKey, String msg, boolean std) {
        JTextArea txt = new JTextArea(msg);
        txt.setName(uiKey);
        txt.setOpaque(false);
        txt.setBackground(Colors.TRANSPARENT.getValue());
        txt.setEditable(false);
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setSize(new Dimension(7 * DOTS_PER_INCH, Integer.MAX_VALUE));
        txt.setFocusTraversalKeys(0, null);
        txt.setFocusTraversalKeys(1, null);
        if (std) {
            AccessibleContext ac = txt.getAccessibleContext();
            ac.setAccessibleName(local_i18n.getString("uif.message.name"));
            ac.setAccessibleDescription(local_i18n.getString("uif.message.desc"));
        } else {
            this.setAccessibleInfo(txt, uiKey);
        }
        return txt;
    }

    public JTextField createOutputField(String uiKey) {
        return this.createOutputField(uiKey, "", 10, null, false);
    }

    public JTextField createOutputField(String uiKey, JLabel label) {
        return this.createOutputField(uiKey, "", 10, label, false);
    }

    public JTextField createOutputField(String uiKey, JLabel label, boolean autoSelect) {
        return this.createOutputField(uiKey, "", 10, label, autoSelect);
    }

    public JTextField createOutputField(String uiKey, int cols) {
        return this.createOutputField(uiKey, "", cols, null, false);
    }

    public JTextField createOutputField(String uiKey, int cols, JLabel label) {
        return this.createOutputField(uiKey, "", cols, label, false);
    }

    public JTextField createOutputField(String uiKey, int cols, JLabel label, boolean autoSelect) {
        return this.createOutputField(uiKey, "", cols, label, autoSelect);
    }

    public JTextField createOutputField(String uiKey, String value) {
        return this.createOutputField(uiKey, value, 10, null, false);
    }

    public JTextField createOutputField(String uiKey, String value, JLabel label) {
        return this.createOutputField(uiKey, value, 10, label, false);
    }

    public JTextField createOutputField(String uiKey, String value, int cols) {
        return this.createOutputField(uiKey, value, cols, null, false);
    }

    public JTextField createOutputField(String uiKey, String value, int cols, JLabel label) {
        return this.createOutputField(uiKey, value, cols, label, false);
    }

    public JTextField createOutputField(String uiKey, String value, int cols, JLabel label, boolean autoSelect) {
        final JTextField tf = new JTextField(value, cols);
        tf.setName(uiKey);
        tf.setEditable(false);
        tf.setBackground(Colors.TRANSPARENT.getValue());
        tf.setOpaque(false);
        if (autoSelect) {
            tf.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    tf.setSelectionStart(0);
                    tf.setSelectionEnd(tf.getText().length());
                }

                @Override
                public void focusLost(FocusEvent e) {
                    tf.setSelectionStart(0);
                    tf.setSelectionEnd(0);
                }
            });
        }
        if (label != null) {
            label.setLabelFor(tf);
        } else {
            this.setAccessibleName(tf, uiKey);
        }
        this.setToolTip(tf, uiKey);
        tf.setFocusTraversalKeys(0, null);
        tf.setFocusTraversalKeys(1, null);
        return tf;
    }

    public JTextArea createTextArea(String uiKey) {
        return this.createTextArea(uiKey, null);
    }

    public JTextArea createTextArea(String uiKey, JLabel label) {
        JTextArea t = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(100, 100);
            }
        };
        t.setName(uiKey);
        if (label != null) {
            label.setLabelFor(t);
        } else {
            this.setAccessibleName(t, uiKey);
        }
        this.setToolTip(t, uiKey);
        return t;
    }

    public JProgressBar createProgressBar(String uiKey, int orient) {
        JProgressBar pb = new JProgressBar(orient);
        this.setToolTip(pb, uiKey);
        this.setAccessibleName(pb, uiKey);
        return pb;
    }

    public JProgressBar createProgressBar(String uiKey, int orient, BoundedRangeModel model) {
        JProgressBar pb = this.createProgressBar(uiKey, orient);
        pb.setModel(model);
        return pb;
    }

    public JToolBar createToolBar(String uiKey) {
        JToolBar tb = new JToolBar();
        tb.setName(uiKey);
        this.setAccessibleInfo(tb, uiKey);
        return tb;
    }

    public JToolBar createToolBar(String uiKey, Action[] actions) {
        JToolBar tb = new JToolBar();
        tb.setName(uiKey);
        this.setAccessibleInfo(tb, uiKey);
        for (int i = 0; i < actions.length; ++i) {
            Action action = actions[i];
            if (action == null) {
                tb.addSeparator();
                continue;
            }
            JButton b = tb.add(action);
            b.setName((String)action.getValue("Name"));
            b.getAccessibleContext().setAccessibleName(b.getName());
        }
        return tb;
    }

    public JToolBar createToolBar(String uiKey, JButton[] buttons) {
        JToolBar tb = new JToolBar();
        tb.setName(uiKey);
        this.setAccessibleInfo(tb, uiKey);
        for (int i = 0; i < buttons.length; ++i) {
            JButton button = buttons[i];
            if (button == null) {
                tb.addSeparator();
                continue;
            }
            tb.add(button);
        }
        return tb;
    }

    public void addToolBarActions(JToolBar tb, Action[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            Action action = actions[i];
            if (action == null) {
                tb.addSeparator();
                continue;
            }
            JButton b = tb.add(action);
            b.setName((String)action.getValue("Name"));
            b.getAccessibleContext().setAccessibleName(b.getName());
        }
    }

    public void showInformation(String uiKey) {
        this.showLocalizedInfo(uiKey, this.getI18NString(uiKey + ".inf"));
    }

    public void showError(String uiKey) {
        this.showLocalizedError(uiKey, this.getI18NString(uiKey + ".err"));
    }

    public void showError(String uiKey, Object arg) {
        this.showLocalizedError(uiKey, this.getI18NString(uiKey + ".err", arg));
    }

    public void showError(String uiKey, Object[] args) {
        String msg = this.getI18NString(uiKey + ".err", args);
        String title = local_i18n.getString("uif.error", ProductInfo.getName());
        JButton okBtn = this.createOptionButton("uif.ok");
        JTextArea ta = this.createLocalizedMessageArea(uiKey, msg.trim(), true);
        Dimension d = ta.getMinimumSize();
        JComponent content = ta;
        if (d.width > Math.round(6.0f * (float)DOTS_PER_INCH) || d.height > Math.round(2.0f * (float)DOTS_PER_INCH)) {
            JScrollPane sp = new JScrollPane(ta);
            sp.setPreferredSize(new Dimension(Math.round(6.0f * (float)DOTS_PER_INCH), Math.round(2.0f * (float)DOTS_PER_INCH)));
            content = sp;
        }
        JOptionPane.showOptionDialog(this.parent, content, title, -1, 0, null, new Object[]{okBtn}, null);
    }

    public void showError(String uiKey, Object[] args, Object[] trace) {
        String title = local_i18n.getString("uif.error", ProductInfo.getName());
        JButton okBtn = this.createOptionButton("uif.ok");
        StringBuffer traceString = new StringBuffer(this.getI18NString(uiKey + ".err", args));
        traceString.append(":\n");
        for (int i = 0; i < trace.length; ++i) {
            traceString.append(trace[i]);
            if (i == trace.length - 1) continue;
            traceString.append("\n\tat ");
        }
        JTextArea ta = this.createLocalizedMessageArea(uiKey, traceString.toString(), true);
        ta.setLineWrap(false);
        JScrollPane sp = new JScrollPane(ta);
        sp.setPreferredSize(new Dimension(Math.round(6.0f * (float)DOTS_PER_INCH), Math.round(2.0f * (float)DOTS_PER_INCH)));
        JOptionPane.showOptionDialog(this.parent, sp, title, -1, 0, null, new Object[]{okBtn}, null);
    }

    public void showLiteralError(String title, String msg) {
        JButton okBtn = this.createOptionButton("uif.ok");
        if (title == null) {
            title = local_i18n.getString("uif.error", ProductInfo.getName());
        }
        JOptionPane.showOptionDialog(this.parent, this.createLiteralMessageArea(msg), title, -1, 0, null, new Object[]{okBtn}, null);
    }

    private void showLocalizedError(String uiKey, String text) {
        String title = local_i18n.getString("uif.error", ProductInfo.getName());
        JButton okBtn = this.createOptionButton("uif.ok");
        JOptionPane.showOptionDialog(this.parent, this.createLocalizedMessageArea(uiKey, text, true), title, -1, 0, null, new Object[]{okBtn}, null);
    }

    private void showLocalizedInfo(String uiKey, String text) {
        String title = this.i18n.getString(uiKey + ".title");
        JButton okBtn = this.createOptionButton("uif.ok");
        JOptionPane.showOptionDialog(this.parent, this.createLocalizedMessageArea(uiKey, text, true), title, -1, 1, null, new Object[]{okBtn}, null);
    }

    public int showOKCancelDialog(String uiKey) {
        return this.showLocalizedOKCancelDialog(uiKey, this.getI18NString(uiKey + ".txt"));
    }

    public int showOKCancelDialog(String uiKey, Object arg) {
        return this.showLocalizedOKCancelDialog(uiKey, this.getI18NString(uiKey + ".txt", arg));
    }

    public int showOKCancelDialog(String uiKey, Object[] args) {
        return this.showLocalizedOKCancelDialog(uiKey, this.getI18NString(uiKey + ".txt", args));
    }

    private int showLocalizedOKCancelDialog(String uiKey, String text) {
        JButton cancelBtn;
        JButton okBtn;
        String title;
        JTextArea msg = this.createLocalizedMessageArea(uiKey, text, true);
        int rc = JOptionPane.showOptionDialog(this.parent, msg, title = this.getI18NString(uiKey + ".title"), 2, 3, null, new Object[]{okBtn = this.createOptionButton("uif.ok"), cancelBtn = this.createOptionButton("uif.cancel")}, null);
        return rc == 0 ? 0 : (rc == 1 ? 2 : rc);
    }

    public int showYesNoDialog(String uiKey) {
        return this.showLocalizedYesNoDialog(uiKey, this.getI18NString(uiKey + ".txt"));
    }

    public int showYesNoDialog(String uiKey, Object arg) {
        return this.showLocalizedYesNoDialog(uiKey, this.getI18NString(uiKey + ".txt", arg));
    }

    public int showCustomYesNoDialog(String uiKey, Component msg) {
        return this.showComponentYesNoDialog(uiKey, msg);
    }

    public int showYesNoDialog(String uiKey, Object[] args) {
        return this.showLocalizedYesNoDialog(uiKey, this.getI18NString(uiKey + ".txt", args));
    }

    private int showLocalizedYesNoDialog(String uiKey, String text) {
        JTextArea msg = this.createLocalizedMessageArea(uiKey, text, true);
        return this.showComponentYesNoDialog(uiKey, msg);
    }

    int showLiteralYesNoDialog(String title, String text) {
        JTextArea msg = this.createLocalizedMessageArea("literal", text, true);
        JButton yesBtn = this.createOptionButton("uif.yes");
        JButton noBtn = this.createOptionButton("uif.no");
        return JOptionPane.showOptionDialog(this.parent, msg, title, 0, 3, null, new Object[]{yesBtn, noBtn}, null);
    }

    private int showComponentYesNoDialog(String uiKey, Component msg) {
        String title = this.getI18NString(uiKey + ".title");
        JButton yesBtn = this.createOptionButton("uif.yes");
        JButton noBtn = this.createOptionButton("uif.no");
        return JOptionPane.showOptionDialog(this.parent, msg, title, 0, 3, null, new Object[]{yesBtn, noBtn}, null);
    }

    public int showYesNoCancelDialog(String uiKey) {
        return this.showLocalizedYesNoCancelDialog(uiKey, this.getI18NString(uiKey + ".txt"));
    }

    public int showYesNoCancelDialog(String uiKey, Object arg) {
        return this.showLocalizedYesNoCancelDialog(uiKey, this.getI18NString(uiKey + ".txt", arg));
    }

    public int showYesNoCancelDialog(String uiKey, Object[] args) {
        return this.showLocalizedYesNoCancelDialog(uiKey, this.getI18NString(uiKey + ".txt", args));
    }

    private int showLocalizedYesNoCancelDialog(String uiKey, String text) {
        JTextArea msg = this.createLocalizedMessageArea(uiKey, text, true);
        String title = this.getI18NString(uiKey + ".title");
        JButton yesBtn = this.createOptionButton("uif.yes");
        JButton noBtn = this.createOptionButton("uif.no");
        JButton cancelBtn = this.createOptionButton("uif.cancel");
        return JOptionPane.showOptionDialog(this.parent, msg, title, 1, 3, null, new Object[]{yesBtn, noBtn, cancelBtn}, null);
    }

    public void showInformationDialog(String uiKey, Object[] args) {
        this.showLocalizedInformationDialog(uiKey, this.getI18NString(uiKey + ".title"), this.getI18NString(uiKey + ".txt", args), this.parent);
    }

    public void showInformationDialog(String uiKey, Object[] args, Component parent) {
        this.showLocalizedInformationDialog(uiKey, this.getI18NString(uiKey + ".title"), this.getI18NString(uiKey + ".txt", args), parent);
    }

    private void showLocalizedInformationDialog(String uiKey, String title, String text, Component localParent) {
        JTextArea msg = this.createLocalizedMessageArea(uiKey, text, true);
        Dimension d = msg.getMinimumSize();
        JComponent content = msg;
        if (d.width > Math.round(6.0f * (float)DOTS_PER_INCH) || d.height > Math.round(2.0f * (float)DOTS_PER_INCH)) {
            JScrollPane sp = new JScrollPane(msg);
            sp.setPreferredSize(new Dimension(Math.round(6.0f * (float)DOTS_PER_INCH), Math.round(2.0f * (float)DOTS_PER_INCH)));
            content = sp;
        }
        JOptionPane.showMessageDialog(localParent, content, title, 1, null);
    }

    public void showCustomInfoDialog(String uiKey, Object msg) {
        JOptionPane.showMessageDialog(this.parent, msg, this.getI18NString(uiKey + ".title"), 1, null);
    }

    public Box createHorizontalBox(String uiKey) {
        Box box = Box.createHorizontalBox();
        box.setName(uiKey);
        box.setFocusable(false);
        return box;
    }

    public JPanel createPanel(String uiKey) {
        return this.createPanel(uiKey, true);
    }

    public JPanel createPanel(String uiKey, boolean focusable) {
        JPanel p = new JPanel();
        this.initPanel(p, uiKey, focusable);
        return p;
    }

    public JPanel createPanel(String uiKey, LayoutManager layout) {
        return this.createPanel(uiKey, layout, true);
    }

    public JPanel createPanel(String uiKey, LayoutManager layout, boolean focusable) {
        JPanel p = new JPanel();
        this.initPanel(p, uiKey, layout, focusable);
        return p;
    }

    public void initPanel(JPanel p, String uiKey, boolean focusable) {
        p.setName(uiKey);
        if (focusable) {
            this.setAccessibleInfo(p, uiKey);
        } else {
            p.setFocusable(false);
        }
    }

    public void initPanel(JPanel p, String uiKey, LayoutManager layout, boolean focusable) {
        this.initPanel(p, uiKey, focusable);
        p.setLayout(layout);
    }

    public JDialog createDialog(String uiKey, Component parent) {
        JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, parent);
        return this.createDialog(uiKey, owner);
    }

    public JDialog createDialog(String uiKey, JFrame owner) {
        JDialog d = new JDialog(owner);
        this.initDialog(d, uiKey);
        return d;
    }

    public JDialog createDialog(String uiKey, JFrame owner, String title, Container content) {
        return this.createDialog(uiKey, owner, title, content, Dialog.ModalityType.MODELESS);
    }

    public JDialog createDialog(String uiKey, JFrame owner, String title, Container content, Dialog.ModalityType type) {
        JDialog d = new JDialog(owner, title, false);
        d.setModalityType(type);
        if (owner == null) {
            d.setIconImage(this.createImage("images/jticon.gif"));
        }
        this.initDialog(d, uiKey);
        d.setContentPane(content);
        return d;
    }

    public JFrame createFrame(String uiKey, String title, Container content) {
        JFrame frame = new JFrame(title);
        this.initFrame(frame, uiKey);
        frame.setContentPane(content);
        return frame;
    }

    public JDialog createWaitDialog(String uiKey, Component parent) {
        JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, parent);
        return this.createWaitDialog(uiKey, owner);
    }

    public JDialog createWaitDialog(String uiKey, JFrame owner) {
        int msgWidth = 50;
        JDialog d = new JDialog(owner);
        this.initDialog(d, uiKey);
        d.setTitle(this.getI18NString(uiKey + ".title"));
        JProgressBar pb = new JProgressBar(0);
        pb.setName(uiKey);
        pb.setIndeterminate(true);
        pb.setBorderPainted(true);
        pb.setPreferredSize(new Dimension(Math.round(2.5f * (float)DOTS_PER_INCH), 15));
        JPanel body = this.createPanel(uiKey, new GridBagLayout(), false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.insets.left = 12;
        gbc.insets.right = 12;
        gbc.insets.top = 12;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        JTextArea msg = this.createLocalizedMessageArea(uiKey, this.getI18NString(uiKey + ".txt"), false);
        msg.setSize(new Dimension(Math.round(4.0f * (float)DOTS_PER_INCH), Integer.MAX_VALUE));
        body.add((Component)msg, gbc);
        gbc.gridy = 1;
        gbc.insets.top = 11;
        gbc.insets.bottom = 12;
        body.add((Component)pb, gbc);
        d.setContentPane(body);
        d.pack();
        d.setLocationRelativeTo(owner);
        return d;
    }

    public void initDialog(JDialog d, String uiKey) {
        d.setName(uiKey);
        this.setAccessibleInfo(d, uiKey);
        d.setLocationRelativeTo(d.getParent());
        JRootPane root = d.getRootPane();
        root.setName(uiKey + ".root");
        AccessibleContext ac = d.getAccessibleContext();
        AccessibleContext r_ac = root.getAccessibleContext();
        r_ac.setAccessibleName(ac.getAccessibleName());
        r_ac.setAccessibleDescription(ac.getAccessibleDescription());
    }

    public void initFrame(JFrame d, String uiKey) {
        d.setName(uiKey);
        this.setAccessibleInfo(d, uiKey);
        d.setLocationRelativeTo(d.getParent());
        d.setIconImage(this.createImage("images/jticon.gif"));
        JRootPane root = d.getRootPane();
        root.setName(uiKey + ".root");
        AccessibleContext ac = d.getAccessibleContext();
        AccessibleContext r_ac = root.getAccessibleContext();
        r_ac.setAccessibleName(ac.getAccessibleName());
        r_ac.setAccessibleDescription(ac.getAccessibleDescription());
    }

    public void dispose() {
        this.clientClass = null;
        this.parent = null;
    }

    static /* synthetic */ I18NResourceBundle access$000() {
        return local_i18n;
    }

    public static class UIFactoryExt
    extends UIFactory {
        private I18NResourceBundle i18n_alt;
        private Class altClass;

        public UIFactoryExt(UIFactory uif, Class altClass) {
            super(uif.clientClass, uif.parent, uif.helpBroker);
            this.i18n_alt = I18NResourceBundle.getBundleForClass(altClass);
            this.altClass = altClass;
        }

        @Override
        public Color getI18NColor(String key) {
            if (!UIFactoryExt.hasKey(this.i18n_alt, key)) {
                return super.getI18NColor(key);
            }
            String value = this.i18n_alt.getString(key + ".clr");
            try {
                if (value != null) {
                    return Color.decode(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Color.BLACK;
        }

        @Override
        public String getI18NString(String key) {
            if (UIFactoryExt.hasKey(this.i18n_alt, key)) {
                return this.i18n_alt.getString(key);
            }
            return super.getI18NString(key);
        }

        @Override
        public String getI18NString(String key, Object arg) {
            if (UIFactoryExt.hasKey(this.i18n_alt, key)) {
                return this.i18n_alt.getString(key, arg);
            }
            return super.getI18NString(key, arg);
        }

        @Override
        public String getI18NString(String key, Object[] args) {
            if (UIFactoryExt.hasKey(this.i18n_alt, key)) {
                return this.i18n_alt.getString(key, args);
            }
            return super.getI18NString(key, args);
        }

        @Override
        public URL getIconURL(String uiKey) {
            String r = this.getI18NString(uiKey + ".icon");
            URL url = this.altClass.getResource(r);
            if (url == null) {
                url = super.getIconURL(uiKey);
            }
            return url;
        }

        static boolean hasKey(ResourceBundle rb, String key) {
            Enumeration<String> keys = rb.getKeys();
            if (keys == null || key == null) {
                return false;
            }
            while (keys.hasMoreElements()) {
                if (!key.equals(keys.nextElement())) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Colors {
        INPUT_INVALID(UIFactory.access$000().getString("colorprefs.colors.input.invalid.defvalue")),
        INPUT_VALID(UIFactory.access$000().getString("colorprefs.colors.input.valid.defvalue")),
        INPUT_DEFAULT(UIFactory.access$000().getString("colorprefs.colors.input.default.defvalue")),
        MENU_BACKGROUND(UIManager.getColor("Menu.background"), 255, false),
        SEPARATOR_FOREGROUND(UIManager.getColor("Separator.foreground"), 255, false),
        CONTROL_INFO(Color.RED, 255, false),
        CONTROL_SHADOW(Color.RED, 255, false),
        TEXT_HIGHLIGHT_COLOR(new JTextField().getSelectionColor(), 255, false),
        TEXT_COLOR(new JLabel().getForeground(), 255, false),
        TEXT_SELECTED_COLOR(new JTextField().getSelectedTextColor(), 255, false),
        WINDOW_BACKGROUND(UIManager.getColor("Panel.background"), 255, false),
        PRIMARY_CONTROL_HIGHLIGHT(Color.WHITE, 255, false),
        PRIMARY_CONTROL_INFO(Color.BLACK, 255, false),
        BUTTON_DISABLED_FOREGROUND(Color.WHITE, 255, false),
        PRIMARY_CONTROL_SHADOW(MetalLookAndFeel.getPrimaryControlShadow(), 255, false),
        PRIMARY_CONTROL(MetalLookAndFeel.getPrimaryControl(), 255, false),
        PRIMARY_CONTROL_DARK_SHADOW(MetalLookAndFeel.getPrimaryControlDarkShadow(), 255, false),
        BLACK(Color.BLACK, 255, false),
        TRANSPARENT(new Color(255, 255, 255, 0), false);

        private final String defaultColor;
        private Color color = null;
        private boolean configurable;

        private Colors(Color defaultColor) {
            this(defaultColor, true);
        }

        private Colors(Color defaultColor, int alpha) {
            this(new Color(defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue(), alpha), true);
        }

        private Colors(Color defaultColor, int alpha, boolean configurable) {
            this(new Color(defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue(), alpha), configurable);
        }

        private Colors(Color defaultColor, boolean configurable) {
            this.defaultColor = Colors.encodeARGB(defaultColor);
            this.configurable = configurable;
        }

        private Colors(String defaultColor) {
            this.defaultColor = defaultColor;
            this.configurable = true;
        }

        public boolean isConfigurable() {
            return this.configurable;
        }

        public String getDefaultValue() {
            return this.defaultColor;
        }

        public Color getValue() {
            if (this.color == null) {
                this.color = this.readColorFromPreferences();
            }
            return this.color;
        }

        public Color setValue(Color c) {
            Color t = this.color;
            if (this.configurable) {
                this.color = c;
            }
            return t;
        }

        public String getPreferencesName() {
            return "colors." + this.name().toLowerCase().replaceAll("_", ".");
        }

        public Color readColorFromPreferences() {
            return Colors.decodeRGBA(Preferences.access().getPreference(this.getPreferencesName(), this.getDefaultValue()));
        }

        public static Colors valueOfByPreferencesName(String prefsName) {
            return Colors.valueOf(prefsName.replaceFirst("colors.", "").toUpperCase().replaceAll("\\.", "_"));
        }

        public static Color getColorByPreferencesName(String prefsName) {
            Preferences prefs = Preferences.access();
            try {
                Colors c = Colors.valueOfByPreferencesName(prefsName);
                return c.getValue();
            }
            catch (IllegalArgumentException e) {
                String color = prefs.getPreference(prefsName);
                return color == null ? null : Colors.decodeRGBA(color);
            }
        }

        public static String[] getColorsNames() {
            Colors[] values = Colors.values();
            String[] temp = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                temp[i] = values[i].getPreferencesName();
            }
            return temp;
        }

        public static Color decodeRGBA(String color) throws NumberFormatException {
            try {
                if (color.startsWith("0x") && color.length() == 10) {
                    Long colorCode = Long.decode(color);
                    int A = (int)(colorCode & 0xFFL);
                    colorCode = colorCode >> 8;
                    int B = (int)(colorCode & 0xFFL);
                    colorCode = colorCode >> 8;
                    int G = (int)(colorCode & 0xFFL);
                    colorCode = colorCode >> 8;
                    int R = (int)(colorCode & 0xFFL);
                    colorCode = colorCode >> 8;
                    return new Color(R, G, B, A);
                }
                return Color.decode(color);
            }
            catch (Exception e) {
                return Color.red;
            }
        }

        public static String encodeARGB(Color color) {
            if (color == null) {
                return "";
            }
            return String.format("0x%02x%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
    }
}

