/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.ExchangeImpl;
import jdk.incubator.http.Http1Request;
import jdk.incubator.http.Http1Response;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.Response;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;

class Http1Exchange<T>
extends ExchangeImpl<T> {
    final HttpRequestImpl request;
    private final List<CompletableFuture<?>> operations;
    final Http1Request requestAction;
    private volatile Http1Response<T> response;
    private IOException failed;
    final HttpConnection connection;
    final HttpClientImpl client;
    final Executor executor;
    volatile ByteBuffer buffer;

    public String toString() {
        return this.request.toString();
    }

    HttpRequestImpl request() {
        return this.request;
    }

    Http1Exchange(Exchange<T> exchange, HttpConnection httpConnection) throws IOException {
        super(exchange);
        this.request = exchange.request();
        this.client = exchange.client();
        this.executor = exchange.executor();
        this.operations = new LinkedList();
        this.buffer = Utils.EMPTY_BYTEBUFFER;
        if (httpConnection != null) {
            this.connection = httpConnection;
        } else {
            InetSocketAddress inetSocketAddress = this.request.getAddress(this.client);
            this.connection = HttpConnection.getConnection(inetSocketAddress, this.client, this.request);
        }
        this.requestAction = new Http1Request(this.request, this.client, this.connection);
    }

    @Override
    HttpConnection connection() {
        return this.connection;
    }

    @Override
    T readBody(HttpResponse.BodyHandler<T> bodyHandler, boolean bl) throws IOException {
        HttpResponse.BodyProcessor<T> bodyProcessor = bodyHandler.apply(this.response.responseCode(), this.response.responseHeaders());
        CompletableFuture<T> completableFuture = this.response.readBody(bodyProcessor, bl, this::executeInline);
        try {
            return completableFuture.join();
        }
        catch (CompletionException completionException) {
            throw Utils.getIOException(completionException);
        }
    }

    private void executeInline(Runnable runnable) {
        runnable.run();
    }

    synchronized ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    CompletableFuture<T> readBodyAsync(HttpResponse.BodyHandler<T> bodyHandler, boolean bl, Executor executor) {
        HttpResponse.BodyProcessor<T> bodyProcessor = bodyHandler.apply(this.response.responseCode(), this.response.responseHeaders());
        CompletableFuture<T> completableFuture = this.response.readBody(bodyProcessor, bl, executor);
        return completableFuture;
    }

    @Override
    void sendHeadersOnly() throws IOException, InterruptedException {
        try {
            if (!this.connection.connected()) {
                this.connection.connect();
            }
            this.requestAction.sendHeadersOnly();
        }
        catch (Throwable throwable) {
            this.connection.close();
            throw throwable;
        }
    }

    @Override
    void sendBody() throws IOException {
        try {
            this.requestAction.continueRequest();
        }
        catch (Throwable throwable) {
            this.connection.close();
            throw throwable;
        }
    }

    @Override
    Response getResponse() throws IOException {
        try {
            this.response = new Http1Response(this.connection, this);
            this.response.readHeaders();
            Response response = this.response.response();
            this.buffer = this.response.getBuffer();
            return response;
        }
        catch (Throwable throwable) {
            this.connection.close();
            throw throwable;
        }
    }

    private void closeConnection() {
        this.connection.close();
    }

    @Override
    void cancel() {
        this.cancel(new IOException("Request cancelled"));
    }

    @Override
    synchronized void cancel(IOException iOException) {
        if (this.requestAction != null && this.requestAction.finished() && this.response != null && this.response.finished()) {
            return;
        }
        this.connection.close();
        int n = 0;
        if (this.operations.isEmpty()) {
            this.failed = iOException;
            Log.logTrace("Http1Exchange: request [{0}/timeout={1}ms] no pending operation.\n\tCan''t cancel yet with {2}", this.request.uri(), this.request.duration() == null ? -1L : this.request.duration().getSeconds() * 1000L + (long)(this.request.duration().getNano() / 1000000), iOException);
        } else {
            for (CompletableFuture<?> completableFuture : this.operations) {
                completableFuture.completeExceptionally(iOException);
                ++n;
            }
        }
        Log.logError("Http1Exchange.cancel: count=" + n, new Object[0]);
    }

    CompletableFuture<Response> getResponseAsyncImpl(Executor executor) {
        return MinimalFuture.supply(() -> {
            this.response = new Http1Response(this.connection, this);
            this.response.readHeaders();
            Response response = this.response.response();
            this.buffer = this.response.getBuffer();
            return response;
        }, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Response> getResponseAsync(Executor executor) {
        IOException iOException;
        CompletionStage completionStage = this.connection.whenReceivingResponse().thenCompose(void_ -> this.getResponseAsyncImpl(executor));
        Http1Exchange http1Exchange = this;
        synchronized (http1Exchange) {
            this.operations.add((CompletableFuture<?>)completionStage);
            iOException = this.failed;
            this.failed = null;
        }
        if (iOException != null) {
            Log.logTrace("Http1Exchange: request [{0}/timeout={1}ms]\n\tCompleting exceptionally with {2}\n", this.request.uri(), this.request.duration() == null ? -1L : this.request.duration().getSeconds() * 1000L + (long)(this.request.duration().getNano() / 1000000), iOException);
            ((CompletableFuture)completionStage).completeExceptionally(iOException);
        }
        return completionStage;
    }
}

