/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.function.Predicate;
import jdk.incubator.http.HttpHeaders;

final class ImmutableHeaders
implements HttpHeaders {
    private final Map<String, List<String>> map;

    public static ImmutableHeaders empty() {
        return ImmutableHeaders.of(Collections.emptyMap());
    }

    public static ImmutableHeaders of(Map<String, List<String>> map) {
        return ImmutableHeaders.of(map, string -> true);
    }

    public static ImmutableHeaders of(Map<String, List<String>> map, Predicate<? super String> predicate) {
        Objects.requireNonNull(map, "src");
        Objects.requireNonNull(predicate, "keyAllowed");
        return new ImmutableHeaders(map, predicate);
    }

    private ImmutableHeaders(Map<String, List<String>> map, Predicate<? super String> predicate) {
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        map.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).forEach(entry -> {
            ArrayList arrayList = new ArrayList((Collection)entry.getValue());
            treeMap.put(entry.getKey(), Collections.unmodifiableList(arrayList));
        });
        this.map = Collections.unmodifiableMap(treeMap);
    }

    @Override
    public Optional<String> firstValue(String string) {
        return this.allValues(string).stream().findFirst();
    }

    @Override
    public OptionalLong firstValueAsLong(String string) {
        return this.allValues(string).stream().mapToLong(Long::valueOf).findFirst();
    }

    @Override
    public List<String> allValues(String string) {
        Objects.requireNonNull(string);
        List<String> list = this.map.get(string);
        return list != null ? list : Collections.unmodifiableList(Collections.emptyList());
    }

    @Override
    public Map<String, List<String>> map() {
        return this.map;
    }
}

