/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IdentifyBackupCompatibilityProblemsExtendedResult
extends ExtendedResult {
    public static final String IDENTIFY_BACKUP_COMPATIBILITY_PROBLEMS_RESULT_OID = "1.3.6.1.4.1.30221.2.6.33";
    private static final byte TYPE_ERRORS = -96;
    private static final byte TYPE_WARNINGS = -95;
    private static final long serialVersionUID = -6492859100961846933L;
    private final List<String> errorMessages;
    private final List<String> warningMessages;

    public IdentifyBackupCompatibilityProblemsExtendedResult(ExtendedResult result) throws LDAPException {
        super(result);
        ASN1OctetString value = result.getValue();
        if (value == null) {
            this.errorMessages = Collections.emptyList();
            this.warningMessages = Collections.emptyList();
            return;
        }
        try {
            ASN1Element[] elements;
            List<Object> errors = Collections.emptyList();
            List<Object> warnings = Collections.emptyList();
            block7: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -96: {
                        ASN1Element[] errorElements = ASN1Sequence.decodeAsSequence(e).elements();
                        ArrayList<String> errorStrings = new ArrayList<String>(errorElements.length);
                        for (ASN1Element errorElement : errorElements) {
                            errorStrings.add(ASN1OctetString.decodeAsOctetString(errorElement).stringValue());
                        }
                        errors = Collections.unmodifiableList(errorStrings);
                        continue block7;
                    }
                    case -95: {
                        ASN1Element[] warningElements = ASN1Sequence.decodeAsSequence(e).elements();
                        ArrayList<String> warningStrings = new ArrayList<String>(warningElements.length);
                        for (ASN1Element warningElement : warningElements) {
                            warningStrings.add(ASN1OctetString.decodeAsOctetString(warningElement).stringValue());
                        }
                        warnings = Collections.unmodifiableList(warningStrings);
                        continue block7;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_IDENTIFY_BACKUP_COMPAT_PROBLEMS_RESULT_UNEXPECTED_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.errorMessages = errors;
            this.warningMessages = warnings;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_BACKUP_COMPAT_RESULT_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public IdentifyBackupCompatibilityProblemsExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Collection<String> errorMessages, Collection<String> warningMessages, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, resultCode == ResultCode.SUCCESS ? IDENTIFY_BACKUP_COMPATIBILITY_PROBLEMS_RESULT_OID : null, IdentifyBackupCompatibilityProblemsExtendedResult.encodeValue(resultCode, errorMessages, warningMessages), responseControls);
        this.errorMessages = errorMessages == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(errorMessages));
        this.warningMessages = warningMessages == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(warningMessages));
    }

    public static ASN1OctetString encodeValue(ResultCode resultCode, Collection<String> errorMessages, Collection<String> warningMessages) {
        ArrayList<ASN1OctetString> msgElements;
        if (resultCode != ResultCode.SUCCESS) {
            Validator.ensureTrue(!(errorMessages != null && !errorMessages.isEmpty() || warningMessages != null && !warningMessages.isEmpty()), "There must not be any warning or error messages with a non-success result.");
            return null;
        }
        ArrayList<ASN1Sequence> elements = new ArrayList<ASN1Sequence>(2);
        if (errorMessages != null && !errorMessages.isEmpty()) {
            msgElements = new ArrayList<ASN1OctetString>(errorMessages.size());
            for (String s : errorMessages) {
                msgElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-96, msgElements));
        }
        if (warningMessages != null && !warningMessages.isEmpty()) {
            msgElements = new ArrayList(warningMessages.size());
            for (String s : warningMessages) {
                msgElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-95, msgElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_IDENTIFY_BACKUP_COMPAT_PROBLEMS.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        Iterator<String> iterator;
        buffer.append("IdentifyBackupCompatibilityProblemsExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (!this.errorMessages.isEmpty()) {
            buffer.append(", errorMessages={");
            iterator = this.errorMessages.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        if (!this.warningMessages.isEmpty()) {
            buffer.append(", warningMessages={");
            iterator = this.warningMessages.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

