/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.wrappers;

import com.sun.ts.tests.jstl.common.wrappers.TckConnectionWrapper;
import jakarta.servlet.ServletContext;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TckDataSourceWrapper
implements DataSource {
    private ServletContext _context;
    private String _driverClassName;
    private String _jdbcURL;
    private String _userName;
    private String _password;

    public TckDataSourceWrapper() {
    }

    public TckDataSourceWrapper(ServletContext context) {
        this._context = context;
    }

    public void setDriverClassName(String driverClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this._driverClassName = driverClassName;
        Class.forName(this._driverClassName).newInstance();
    }

    public void setJdbcURL(String jdbcURL) {
        this._jdbcURL = jdbcURL;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = null;
        TckConnectionWrapper tckconn = null;
        if (this._userName != null) {
            conn = DriverManager.getConnection(this._jdbcURL, this._userName, this._password);
            if (this._context != null) {
                tckconn = new TckConnectionWrapper(this._context, conn);
                return tckconn;
            }
        } else {
            conn = DriverManager.getConnection(this._jdbcURL);
            if (this._context != null) {
                tckconn = new TckConnectionWrapper(this._context, conn);
                return tckconn;
            }
        }
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException();
    }

    @Override
    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLException();
    }

    public String getDSInfo() {
        return "driver=" + this._driverClassName + ", URL=" + this._jdbcURL + ", user=" + this._userName + ", password=" + this._password;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }
}

