/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.BadValue;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.ModeOptions;
import com.sun.javatest.agent.Proxy;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.io.Serializable;

class SerialPortModeOptions
extends ModeOptions {
    private Choice portChoice;
    private Proxy proxy;

    SerialPortModeOptions() {
        super("serial port");
        Serializable c;
        try {
            c = Class.forName(Proxy.class.getName() + "Impl");
            this.proxy = (Proxy)((Class)c).newInstance();
        }
        catch (Throwable c2) {
            // empty catch block
        }
        c = new GridBagConstraints();
        Label portLabel = new Label("port:");
        ((GridBagConstraints)c).weightx = 0.0;
        this.add((Component)portLabel, c);
        this.portChoice = new Choice();
        if (this.proxy != null) {
            String[] portNames = this.proxy.getPortNames();
            for (int i = 0; i < portNames.length; ++i) {
                this.portChoice.addItem(portNames[i]);
            }
        }
        if (this.portChoice.getItemCount() == 0) {
            this.portChoice.addItem("no serial ports found or accessible");
            this.portChoice.setEnabled(false);
        }
        ((GridBagConstraints)c).anchor = 17;
        ((GridBagConstraints)c).weightx = 1.0;
        this.add((Component)this.portChoice, c);
    }

    @Override
    ConnectionFactory createConnectionFactory(int concurrency) throws BadValue {
        if (this.proxy == null) {
            throw new BadValue("no serial ports found or accessible");
        }
        return this.proxy.createConnectionFactory(this.portChoice.getSelectedItem());
    }

    void setPort(String port) {
        this.portChoice.select(port);
    }
}

