/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import jdk.incubator.http.AbstractPushPublisher;
import jdk.incubator.http.BlockingPushPublisher;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.ExchangeImpl;
import jdk.incubator.http.Http2Connection;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.HttpResponseImpl;
import jdk.incubator.http.HttpTimeoutException;
import jdk.incubator.http.PushGroup;
import jdk.incubator.http.Response;
import jdk.incubator.http.WindowController;
import jdk.incubator.http.WindowUpdateSender;
import jdk.incubator.http.internal.common.AsyncDataReadQueue;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.HttpHeadersImpl;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.common.Utils8;
import jdk.incubator.http.internal.frame.DataFrame;
import jdk.incubator.http.internal.frame.ErrorFrame;
import jdk.incubator.http.internal.frame.HeaderFrame;
import jdk.incubator.http.internal.frame.Http2Frame;
import jdk.incubator.http.internal.frame.OutgoingHeaders;
import jdk.incubator.http.internal.frame.PriorityFrame;
import jdk.incubator.http.internal.frame.ResetFrame;
import jdk.incubator.http.internal.frame.WindowUpdateFrame;
import jdk.incubator.http.internal.hpack.DecodingCallback;

class Stream<T>
extends ExchangeImpl<T> {
    final AsyncDataReadQueue inputQ = new AsyncDataReadQueue();
    protected volatile int streamid;
    long responseContentLen = -1L;
    long responseBytesProcessed = 0L;
    long requestContentLen;
    final Http2Connection connection;
    HttpClientImpl client;
    final HttpRequestImpl request;
    final DecodingCallback rspHeadersConsumer;
    HttpHeadersImpl responseHeaders;
    final HttpHeadersImpl requestHeaders;
    final HttpHeadersImpl requestPseudoHeaders;
    HttpResponse.BodyProcessor<T> responseProcessor;
    final HttpRequest.BodyProcessor requestProcessor;
    volatile int responseCode;
    volatile Response response;
    volatile CompletableFuture<Response> responseCF;
    final AbstractPushPublisher<ByteBuffer> publisher;
    final CompletableFuture<Void> requestBodyCF = new MinimalFuture<Void>();
    private volatile boolean remotelyClosed;
    private volatile boolean closed;
    private volatile boolean endStreamSent;
    boolean requestSent;
    boolean responseReceived;
    boolean responseHeadersReceived;
    private final WindowController windowController;
    private final WindowUpdateSender windowUpdater;
    final List<CompletableFuture<Response>> response_cfs = new ArrayList<CompletableFuture<Response>>(5);

    @Override
    HttpConnection connection() {
        return this.connection.connection;
    }

    @Override
    CompletableFuture<T> readBodyAsync(HttpResponse.BodyHandler<T> bodyHandler, boolean bl, Executor executor) {
        Log.logTrace("Reading body on stream {0}", this.streamid);
        this.responseProcessor = bodyHandler.apply(this.responseCode, this.responseHeaders);
        this.publisher.subscribe(this.responseProcessor);
        CompletionStage<T> completionStage = this.receiveData(executor);
        PushGroup pushGroup = this.exchange.getPushGroup();
        if (pushGroup != null) {
            completionStage = completionStage.whenComplete((object, throwable) -> pushGroup.pushError((Throwable)throwable));
        }
        return completionStage;
    }

    @Override
    T readBody(HttpResponse.BodyHandler<T> bodyHandler, boolean bl) throws IOException {
        CompletableFuture<T> completableFuture = this.readBodyAsync(bodyHandler, bl, null);
        try {
            return completableFuture.join();
        }
        catch (CompletionException completionException) {
            throw Utils.getIOException(completionException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("streamid: ").append(this.streamid);
        return stringBuilder.toString();
    }

    private boolean receiveDataFrame(Http2Frame http2Frame) throws IOException, InterruptedException {
        ByteBufferReference[] byteBufferReferenceArray;
        if (http2Frame instanceof ResetFrame) {
            this.handleReset((ResetFrame)http2Frame);
            return true;
        }
        if (!(http2Frame instanceof DataFrame)) {
            assert (false);
            return true;
        }
        DataFrame dataFrame = (DataFrame)http2Frame;
        int n = dataFrame.payloadLength();
        for (ByteBufferReference byteBufferReference : byteBufferReferenceArray = dataFrame.getData()) {
            ByteBuffer byteBuffer = byteBufferReference.get();
            if (!byteBuffer.hasRemaining()) continue;
            this.publisher.acceptData(Optional.of(byteBuffer));
        }
        this.connection.windowUpdater.update(n);
        if (dataFrame.getFlag(1)) {
            this.setEndStreamReceived();
            this.publisher.acceptData(Optional.empty());
            return false;
        }
        this.windowUpdater.update(n);
        return true;
    }

    CompletableFuture<T> receiveData(Executor executor) {
        CompletableFuture<T> completableFuture = this.responseProcessor.getBody().toCompletableFuture();
        Consumer<Throwable> consumer = throwable -> {
            Log.logTrace("receiveData: {0}", throwable.toString());
            throwable.printStackTrace();
            completableFuture.completeExceptionally((Throwable)throwable);
            this.publisher.acceptError((Throwable)throwable);
        };
        if (executor == null) {
            this.inputQ.blockingReceive(this::receiveDataFrame, consumer);
        } else {
            this.inputQ.asyncReceive(executor, this::receiveDataFrame, consumer);
        }
        return completableFuture;
    }

    @Override
    void sendBody() throws IOException {
        try {
            this.sendBodyImpl().join();
        }
        catch (CompletionException completionException) {
            throw Utils.getIOException(completionException);
        }
    }

    @Override
    CompletableFuture<ExchangeImpl<T>> sendBodyAsync() {
        return this.sendBodyImpl().thenApply(void_ -> this);
    }

    Stream(HttpClientImpl httpClientImpl, Http2Connection http2Connection, Exchange<T> exchange, WindowController windowController) {
        super(exchange);
        this.client = httpClientImpl;
        this.connection = http2Connection;
        this.windowController = windowController;
        this.request = exchange.request();
        this.requestProcessor = this.request.requestProcessor;
        this.responseHeaders = new HttpHeadersImpl();
        this.requestHeaders = new HttpHeadersImpl();
        this.rspHeadersConsumer = (charSequence, charSequence2) -> {
            this.responseHeaders.addHeader(charSequence.toString(), charSequence2.toString());
            if (Log.headers() && Log.trace()) {
                Log.logTrace("RECEIVED HEADER (streamid={0}): {1}: {2}", this.streamid, charSequence, charSequence2);
            }
        };
        this.requestPseudoHeaders = new HttpHeadersImpl();
        this.publisher = new BlockingPushPublisher<ByteBuffer>();
        this.windowUpdater = new StreamWindowUpdateSender(http2Connection);
    }

    void incoming(Http2Frame http2Frame) throws IOException {
        if (http2Frame instanceof HeaderFrame) {
            HeaderFrame headerFrame = (HeaderFrame)http2Frame;
            if (headerFrame.endHeaders()) {
                Log.logTrace("handling response (streamid={0})", this.streamid);
                this.handleResponse();
                if (headerFrame.getFlag(1)) {
                    this.inputQ.put(new DataFrame(this.streamid, 1, new ByteBufferReference[0]));
                }
            }
        } else if (http2Frame instanceof DataFrame) {
            this.inputQ.put(http2Frame);
        } else {
            this.otherFrame(http2Frame);
        }
    }

    void otherFrame(Http2Frame http2Frame) throws IOException {
        switch (http2Frame.type()) {
            case 8: {
                this.incoming_windowUpdate((WindowUpdateFrame)http2Frame);
                break;
            }
            case 3: {
                this.incoming_reset((ResetFrame)http2Frame);
                break;
            }
            case 2: {
                this.incoming_priority((PriorityFrame)http2Frame);
                break;
            }
            default: {
                String string = "Unexpected frame: " + http2Frame.toString();
                throw new IOException(string);
            }
        }
    }

    DecodingCallback rspHeadersConsumer() {
        return this.rspHeadersConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResponse() throws IOException {
        Object object = this;
        synchronized (object) {
            this.responseHeadersReceived = true;
        }
        object = this.connection.connection;
        this.responseCode = (int)this.responseHeaders.firstValueAsLong(":status").orElseThrow(() -> new IOException("no statuscode in response"));
        this.response = new Response(this.request, this.exchange, this.responseHeaders, this.responseCode, HttpClient.Version.HTTP_2);
        this.responseContentLen = this.responseHeaders.firstValueAsLong("content-length").orElse(-1L);
        if (Log.headers()) {
            StringBuilder stringBuilder = new StringBuilder("RESPONSE HEADERS:\n");
            Log.dumpHeaders(stringBuilder, "    ", this.responseHeaders);
            Log.logHeaders(stringBuilder.toString(), new Object[0]);
        }
        this.completeResponse(this.response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incoming_reset(ResetFrame resetFrame) throws IOException {
        Log.logTrace("Received RST_STREAM on stream {0}", this.streamid);
        if (this.endStreamReceived()) {
            Log.logTrace("Ignoring RST_STREAM frame received on remotely closed stream {0}", this.streamid);
        } else if (this.closed) {
            Log.logTrace("Ignoring RST_STREAM frame received on closed stream {0}", this.streamid);
        } else {
            boolean bl = false;
            Stream stream = this;
            synchronized (stream) {
                bl = !this.closed && this.responseHeadersReceived && this.inputQ.tryPut(resetFrame);
            }
            if (!bl) {
                try {
                    this.handleReset(resetFrame);
                }
                catch (IOException iOException) {
                    this.completeResponseExceptionally(iOException);
                }
            } else {
                Log.logTrace("RST_STREAM pushed in queue for stream {0}", this.streamid);
            }
        }
    }

    void handleReset(ResetFrame resetFrame) throws IOException {
        Log.logTrace("Handling RST_STREAM on stream {0}", this.streamid);
        if (!this.closed) {
            this.close();
            int n = resetFrame.getErrorCode();
            throw new IOException(ErrorFrame.stringForCode(n));
        }
        Log.logTrace("Ignoring RST_STREAM frame received on closed stream {0}", this.streamid);
    }

    void incoming_priority(PriorityFrame priorityFrame) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void incoming_windowUpdate(WindowUpdateFrame windowUpdateFrame) throws IOException {
        int n = windowUpdateFrame.getUpdate();
        if (n <= 0) {
            Log.logTrace("Resetting stream: {0} %d, Window Update amount: %d\n", this.streamid, this.streamid, n);
            this.connection.resetStream(this.streamid, 3);
        } else {
            assert (this.streamid != 0);
            boolean bl = this.windowController.increaseStreamWindow(n, this.streamid);
            if (!bl) {
                this.connection.resetStream(this.streamid, 3);
            }
        }
    }

    void incoming_pushPromise(HttpRequestImpl httpRequestImpl, PushedStream<?, T> pushedStream) throws IOException {
        PushGroup pushGroup;
        if (Log.requests()) {
            Log.logRequest("PUSH_PROMISE: " + httpRequestImpl.toString(), new Object[0]);
        }
        if ((pushGroup = this.exchange.getPushGroup()) == null || pushGroup.noMorePushes()) {
            this.cancelImpl(new IllegalStateException("unexpected push promise on stream " + this.streamid));
        }
        HttpResponse.MultiProcessor multiProcessor = pushGroup.processor();
        CompletableFuture<HttpResponse<T>> completableFuture = pushedStream.responseCF();
        Optional optional = multiProcessor.onRequest(httpRequestImpl);
        if (!optional.isPresent()) {
            IOException iOException = new IOException("Stream " + this.streamid + " cancelled by user");
            if (Log.trace()) {
                Log.logTrace("No body processor for {0}: {1}", httpRequestImpl, iOException.getMessage());
            }
            pushedStream.cancelImpl(iOException);
            completableFuture.completeExceptionally(iOException);
            return;
        }
        pushGroup.addPush();
        pushedStream.requestSent();
        pushedStream.setPushHandler(optional.get());
        completableFuture.whenComplete((httpResponse, throwable) -> {
            if (Log.trace()) {
                Log.logTrace("Push completed on stream {0} for {1}{2}", pushedStream.streamid, httpResponse, throwable == null ? "" : " with exception " + throwable);
            }
            if (throwable != null) {
                pushGroup.pushError((Throwable)throwable);
                multiProcessor.onError(httpRequestImpl, (Throwable)throwable);
            } else {
                multiProcessor.onResponse(httpResponse);
            }
            pushGroup.pushCompleted();
        });
    }

    private OutgoingHeaders<Stream<T>> headerFrame(long l) {
        HttpHeadersImpl httpHeadersImpl = this.request.getSystemHeaders();
        if (l > 0L) {
            httpHeadersImpl.setHeader("content-length", Long.toString(l));
        }
        this.setPseudoHeaderFields();
        OutgoingHeaders<Stream<T>> outgoingHeaders = new OutgoingHeaders<Stream<T>>(httpHeadersImpl, this.request.getUserHeaders(), this);
        if (l == 0L) {
            outgoingHeaders.setFlag(1);
            this.endStreamSent = true;
        }
        return outgoingHeaders;
    }

    private void setPseudoHeaderFields() {
        HttpHeadersImpl httpHeadersImpl = this.requestPseudoHeaders;
        String string = this.request.method();
        httpHeadersImpl.setHeader(":method", string);
        URI uRI = this.request.uri();
        httpHeadersImpl.setHeader(":scheme", uRI.getScheme());
        httpHeadersImpl.setHeader(":authority", uRI.getAuthority());
        String string2 = uRI.getQuery();
        String string3 = uRI.getPath();
        if (string3 == null || string3.isEmpty()) {
            string3 = string.equalsIgnoreCase("OPTIONS") ? "*" : "/";
        }
        if (string2 != null) {
            string3 = string3 + "?" + string2;
        }
        httpHeadersImpl.setHeader(":path", string3);
    }

    HttpHeadersImpl getRequestPseudoHeaders() {
        return this.requestPseudoHeaders;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Response getResponse() throws IOException {
        Response response;
        block7: {
            if (this.request.duration() == null) break block7;
            Log.logTrace("Waiting for response (streamid={0}, timeout={1}ms)", this.streamid, this.request.duration().toMillis());
            Response response2 = this.getResponseAsync(null).get(this.request.duration().toMillis(), TimeUnit.MILLISECONDS);
            Log.logTrace("Got response or failed (streamid={0})", this.streamid);
            return response2;
        }
        try {
            Log.logTrace("Waiting for response (streamid={0})", this.streamid);
            response = this.getResponseAsync(null).join();
        }
        catch (TimeoutException timeoutException) {
            try {
                Log.logTrace("Response timeout (streamid={0})", this.streamid);
                throw new HttpTimeoutException("Response timed out");
                catch (InterruptedException | CompletionException | ExecutionException exception) {
                    Throwable throwable = exception.getCause();
                    Log.logTrace("Response failed (streamid={0}): {1}", this.streamid, throwable);
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw new IOException(exception);
                }
            }
            catch (Throwable throwable) {
                Log.logTrace("Got response or failed (streamid={0})", this.streamid);
                throw throwable;
            }
        }
        Log.logTrace("Got response or failed (streamid={0})", this.streamid);
        return response;
    }

    void setEndStreamReceived() {
        assert (!this.remotelyClosed) : "Unexpected endStream already set";
        this.remotelyClosed = true;
        this.responseReceived();
    }

    private boolean endStreamReceived() {
        return this.remotelyClosed;
    }

    @Override
    void sendHeadersOnly() throws IOException, InterruptedException {
        if (Log.requests() && this.request != null) {
            Log.logRequest(this.request.toString(), new Object[0]);
        }
        this.requestContentLen = this.requestProcessor.contentLength();
        OutgoingHeaders<Stream<T>> outgoingHeaders = this.headerFrame(this.requestContentLen);
        this.connection.sendFrame(outgoingHeaders);
    }

    void registerStream(int n) {
        this.streamid = n;
        this.connection.putStream(this, this.streamid);
    }

    DataFrame getDataFrame(ByteBuffer byteBuffer) throws InterruptedException {
        int n = Math.min(this.connection.getMaxSendFrameSize(), byteBuffer.remaining());
        int n2 = this.windowController.tryAcquire(n, this.streamid);
        ByteBuffer byteBuffer2 = Utils.slice(byteBuffer, n2);
        DataFrame dataFrame = new DataFrame(this.streamid, 0, ByteBufferReference.of(byteBuffer2));
        return dataFrame;
    }

    private DataFrame getEmptyEndStreamDataFrame() throws InterruptedException {
        return new DataFrame(this.streamid, 1, new ByteBufferReference[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Response> getResponseAsync(Executor executor) {
        CompletionStage<Object> completionStage = null;
        Object object = this.response_cfs;
        synchronized (object) {
            if (!this.response_cfs.isEmpty()) {
                completionStage = this.response_cfs.remove(0);
                assert (completionStage.isDone()) : "Removing uncompleted response: could cause code to hang!";
            } else {
                completionStage = new MinimalFuture();
                this.response_cfs.add((CompletableFuture<Response>)completionStage);
            }
        }
        if (executor != null && !completionStage.isDone()) {
            completionStage = completionStage.thenApplyAsync(response -> response, executor);
        }
        Log.logTrace("Response future (stream={0}) is: {1}", this.streamid, completionStage);
        object = this.exchange.getPushGroup();
        if (object != null) {
            completionStage = completionStage.whenComplete((arg_0, arg_1) -> Stream.lambda$getResponseAsync$49((PushGroup)object, arg_0, arg_1));
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeResponse(Response response) {
        List<CompletableFuture<Response>> list = this.response_cfs;
        synchronized (list) {
            CompletableFuture completableFuture;
            int n = this.response_cfs.size();
            for (int i = 0; i < n; ++i) {
                completableFuture = this.response_cfs.get(i);
                if (completableFuture.isDone()) continue;
                Log.logTrace("Completing response (streamid={0}): {1}", this.streamid, completableFuture);
                completableFuture.complete(response);
                this.response_cfs.remove(completableFuture);
                return;
            }
            completableFuture = MinimalFuture.completedFuture(response);
            Log.logTrace("Created completed future (streamid={0}): {1}", this.streamid, completableFuture);
            this.response_cfs.add(completableFuture);
        }
    }

    synchronized void requestSent() {
        this.requestSent = true;
        if (this.responseReceived) {
            this.close();
        }
    }

    final synchronized boolean isResponseReceived() {
        return this.responseReceived;
    }

    synchronized void responseReceived() {
        this.responseReceived = true;
        if (this.requestSent) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeResponseExceptionally(Throwable throwable) {
        List<CompletableFuture<Response>> list = this.response_cfs;
        synchronized (list) {
            for (int i = 0; i < this.response_cfs.size(); ++i) {
                CompletableFuture<Response> completableFuture = this.response_cfs.get(i);
                if (completableFuture.isDone()) continue;
                completableFuture.completeExceptionally(throwable);
                this.response_cfs.remove(i);
                return;
            }
            this.response_cfs.add(MinimalFuture.failedFuture(throwable));
        }
    }

    CompletableFuture<Void> sendBodyImpl() {
        RequestSubscriber requestSubscriber = new RequestSubscriber(this.requestContentLen);
        this.requestProcessor.subscribe(requestSubscriber);
        this.requestBodyCF.whenComplete((void_, throwable) -> this.requestSent());
        return this.requestBodyCF;
    }

    @Override
    void cancel() {
        this.cancel(new IOException("Stream " + this.streamid + " cancelled"));
    }

    @Override
    void cancel(IOException iOException) {
        this.cancelImpl(iOException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelImpl(Throwable throwable) {
        boolean bl;
        if (Log.trace()) {
            Log.logTrace("cancelling stream {0}: {1}\n", this.streamid, throwable);
        }
        if (bl = !this.closed) {
            Stream stream = this;
            synchronized (stream) {
                bl = !this.closed;
                if (bl) {
                    this.closed = true;
                }
            }
        }
        if (bl) {
            this.inputQ.close();
        }
        this.completeResponseExceptionally(throwable);
        try {
            if (this.streamid != 0) {
                this.connection.resetStream(this.streamid, 8);
            }
        }
        catch (IOException iOException) {
            Log.logError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.closed) {
            return;
        }
        Stream stream = this;
        synchronized (stream) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        Log.logTrace("Closing stream {0}", this.streamid);
        this.inputQ.close();
        this.connection.closeStream(this.streamid);
        Log.logTrace("Stream {0} closed", this.streamid);
    }

    private static /* synthetic */ void lambda$getResponseAsync$49(PushGroup pushGroup, Response response, Throwable throwable) {
        pushGroup.pushError(throwable);
    }

    final class StreamWindowUpdateSender
    extends WindowUpdateSender {
        StreamWindowUpdateSender(Http2Connection http2Connection) {
            super(http2Connection);
        }

        @Override
        int getStreamId() {
            return Stream.this.streamid;
        }
    }

    static class PushedStream<U, T>
    extends Stream<T> {
        final PushGroup<U, T> pushGroup;
        private final Stream<T> parent;
        final CompletableFuture<Response> pushCF;
        final CompletableFuture<HttpResponse<T>> responseCF;
        final HttpRequestImpl pushReq;
        HttpResponse.BodyHandler<T> pushHandler;

        PushedStream(PushGroup<U, T> pushGroup, HttpClientImpl httpClientImpl, Http2Connection http2Connection, Stream<T> stream, Exchange<T> exchange) {
            super(httpClientImpl, http2Connection, exchange, null);
            this.pushGroup = pushGroup;
            this.pushReq = exchange.request();
            this.pushCF = new MinimalFuture<Response>();
            this.responseCF = new MinimalFuture<HttpResponse<T>>();
            this.parent = stream;
        }

        CompletableFuture<HttpResponse<T>> responseCF() {
            return this.responseCF;
        }

        synchronized void setPushHandler(HttpResponse.BodyHandler<T> bodyHandler) {
            this.pushHandler = bodyHandler;
        }

        synchronized HttpResponse.BodyHandler<T> getPushHandler() {
            return this.pushHandler;
        }

        @Override
        CompletableFuture<ExchangeImpl<T>> sendBodyAsync() {
            return super.sendBodyAsync().whenComplete((exchangeImpl, throwable) -> this.pushGroup.pushError((Throwable)throwable));
        }

        @Override
        CompletableFuture<ExchangeImpl<T>> sendHeadersAsync() {
            return super.sendHeadersAsync().whenComplete((exchangeImpl, throwable) -> this.pushGroup.pushError((Throwable)throwable));
        }

        @Override
        CompletableFuture<Response> getResponseAsync(Executor executor) {
            CompletionStage completionStage = this.pushCF.whenComplete((response, throwable) -> this.pushGroup.pushError((Throwable)throwable));
            if (executor != null && !((CompletableFuture)completionStage).isDone()) {
                completionStage = ((CompletableFuture)completionStage).thenApplyAsync(response -> response, executor);
            }
            return completionStage;
        }

        @Override
        CompletableFuture<T> readBodyAsync(HttpResponse.BodyHandler<T> bodyHandler, boolean bl, Executor executor) {
            return super.readBodyAsync(bodyHandler, bl, executor).whenComplete((object, throwable) -> this.pushGroup.pushError((Throwable)throwable));
        }

        @Override
        void completeResponse(Response response) {
            HttpResponseImpl.logResponse(response);
            this.pushCF.complete(response);
            MinimalFuture minimalFuture = new MinimalFuture();
            ((CompletableFuture)minimalFuture.thenCompose(void_ -> this.readBodyAsync(this.getPushHandler(), false, this.getExchange().executor()))).whenComplete((object, throwable) -> {
                if (throwable != null) {
                    this.responseCF.completeExceptionally((Throwable)throwable);
                } else {
                    HttpResponseImpl<Object> httpResponseImpl = new HttpResponseImpl<Object>(response.request, response, object, this.getExchange());
                    this.responseCF.complete(httpResponseImpl);
                }
            });
            Utils8.completeAsync(minimalFuture, () -> null, this.getExchange().executor());
        }

        @Override
        void completeResponseExceptionally(Throwable throwable) {
            this.pushCF.completeExceptionally(throwable);
        }

        @Override
        synchronized void responseReceived() {
            super.responseReceived();
        }

        @Override
        protected void handleResponse() {
            HttpConnection httpConnection = this.connection.connection;
            this.responseCode = (int)this.responseHeaders.firstValueAsLong(":status").orElse(-1L);
            if (this.responseCode == -1) {
                this.completeResponseExceptionally(new IOException("No status code"));
            }
            this.response = new Response(this.pushReq, this.exchange, this.responseHeaders, this.responseCode, HttpClient.Version.HTTP_2);
            this.responseContentLen = this.responseHeaders.firstValueAsLong("content-length").orElse(-1L);
            if (Log.headers()) {
                StringBuilder stringBuilder = new StringBuilder("RESPONSE HEADERS");
                stringBuilder.append(" (streamid=").append(this.streamid).append("): ");
                Log.dumpHeaders(stringBuilder, "    ", this.responseHeaders);
                Log.logHeaders(stringBuilder.toString(), new Object[0]);
            }
            this.completeResponse(this.response);
        }
    }

    class RequestSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        private volatile long remainingContentLength;
        private volatile Flow.Subscription subscription;

        RequestSubscriber(long l) {
            this.remainingContentLength = l;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.subscription != null) {
                throw new IllegalStateException();
            }
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            if (Stream.this.requestBodyCF.isDone()) {
                throw new IllegalStateException();
            }
            try {
                while (byteBuffer.hasRemaining()) {
                    assert (!Stream.this.endStreamSent) : "internal error, send data after END_STREAM flag";
                    DataFrame dataFrame = Stream.this.getDataFrame(byteBuffer);
                    if (this.remainingContentLength > 0L) {
                        this.remainingContentLength -= (long)dataFrame.getDataLength();
                        assert (this.remainingContentLength >= 0L);
                        if (this.remainingContentLength == 0L) {
                            dataFrame.setFlag(1);
                            Stream.this.endStreamSent = true;
                        }
                    }
                    Stream.this.connection.sendDataFrame(dataFrame);
                }
                this.subscription.request(1L);
            }
            catch (InterruptedException interruptedException) {
                this.subscription.cancel();
                Stream.this.requestBodyCF.completeExceptionally(interruptedException);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (Stream.this.requestBodyCF.isDone()) {
                return;
            }
            this.subscription.cancel();
            Stream.this.requestBodyCF.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            assert (Stream.this.endStreamSent || this.remainingContentLength < 0L);
            try {
                if (!Stream.this.endStreamSent) {
                    Stream.this.endStreamSent = true;
                    Stream.this.connection.sendDataFrame(Stream.this.getEmptyEndStreamDataFrame());
                }
                Stream.this.requestBodyCF.complete(null);
            }
            catch (InterruptedException interruptedException) {
                Stream.this.requestBodyCF.completeExceptionally(interruptedException);
            }
        }
    }
}

