/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;

final class ISO_8859_1 {
    private ISO_8859_1() {
    }

    public static final class Writer {
        private CharSequence source;
        private int pos;
        private int end;

        public Writer configure(CharSequence charSequence, int n, int n2) {
            this.source = charSequence;
            this.pos = n;
            this.end = n2;
            return this;
        }

        public boolean write(ByteBuffer byteBuffer) {
            while (this.pos < this.end) {
                char c = this.source.charAt(this.pos);
                if (c > '\u00ff') {
                    throw new IllegalArgumentException("Illegal ISO-8859-1 char: " + c);
                }
                if (!byteBuffer.hasRemaining()) {
                    return false;
                }
                byteBuffer.put((byte)c);
                ++this.pos;
            }
            return true;
        }

        public Writer reset() {
            this.source = null;
            this.pos = -1;
            this.end = -1;
            return this;
        }
    }

    public static final class Reader {
        public void read(ByteBuffer byteBuffer, Appendable appendable) {
            int n = byteBuffer.remaining();
            for (int i = 0; i < n; ++i) {
                char c = (char)(byteBuffer.get() & 0xFF);
                try {
                    appendable.append(c);
                    continue;
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Error appending to the destination", iOException);
                }
            }
        }

        public Reader reset() {
            return this;
        }
    }
}

