/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.ModBase;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ModuleDescriptionLoader;
import com.sun.tdk.signaturetest.core.context.ModFeatures;
import com.sun.tdk.signaturetest.core.context.ModSetupOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.model.ModuleDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.ModWriter;
import com.sun.tdk.signaturetest.sigfile.StructWriter;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.OptionInfo;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public class ModSetup
extends ModBase {
    private final ModSetupOptions mo = AppContext.getContext().getBean(ModSetupOptions.class);
    private String copyrightStr = null;
    private EnumSet<ModFeatures> features = EnumSet.of(ModFeatures.ALL);
    private WriteMode wm = WriteMode.SIGFILE;

    public static void main(String[] args) {
        ModSetup t = new ModSetup();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    public void run(String[] args, PrintWriter pw, PrintWriter ref) {
        this.setLog(pw);
        if (this.parseParameters(args)) {
            this.create();
            this.getLog().flush();
        } else if (args.length > 0 && Option.VERSION.accept(args[0])) {
            pw.println(Version.getVersionInfo());
        } else {
            this.usage();
        }
    }

    protected boolean parseParameters(String[] args) {
        String mode;
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args == null || args.length == 0 || args.length == 1 && Option.VERSION.accept(args[0])) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption("-Verbose", OptionInfo.optionVariableParams(0, 1), "decodeOptions");
        parser.addOptions(this.mo.getOptions(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (!this.processHelpOptions()) {
            return false;
        }
        this.setupModulesAndPackages(this.mo);
        if (this.mo.getValue(Option.FILE_NAME) == null) {
            return this.error(i18n.getString("MTest.error.filename.missing"));
        }
        this.copyrightStr = this.mo.getValue(Option.COPYRIGHT);
        if (this.mo.getValue(Option.APIVERSION) != null) {
            this.apiVer = this.mo.getValue(Option.APIVERSION);
        }
        if ((mode = this.mo.getValue(Option.MODE)) != null) {
            if (WriteMode.STRUCT_CUMULATIVE.name().equalsIgnoreCase(mode)) {
                this.wm = WriteMode.STRUCT_CUMULATIVE;
            } else if (WriteMode.STRUCT_PLAIN.name().equalsIgnoreCase(mode)) {
                this.wm = WriteMode.STRUCT_PLAIN;
            }
        }
        if (!this.processFeatureList(this.mo)) {
            return false;
        }
        if (this.mo.getValue(Option.TEST_URL) != null && new File(this.mo.getValue(Option.FILE_NAME)).isAbsolute()) {
            return this.error(i18n.getString("MTest.error.testurl.absolutepath", new Object[]{Option.TEST_URL.getKey(), this.mo.getValue(Option.FILE_NAME)}));
        }
        return true;
    }

    private boolean processFeatureList(ModSetupOptions mo) {
        try {
            this.features = ModFeatures.featureSetFromCommaList(mo.getValue(Option.FEATURES));
        }
        catch (IllegalArgumentException ex) {
            this.error(i18n.getString("Setup.error.wrongfeature", ex.getMessage()));
            return false;
        }
        return true;
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        this.mo.readOptions(optionName, args);
    }

    @Override
    protected void usage() {
        String sb = this.getComponentName() + " - " + i18n.getString("MSetup.usage.version", "4.1") + i18n.getString("MSetup.usage");
        System.err.println(sb);
    }

    @Override
    protected String getComponentName() {
        return "Mod-Setup";
    }

    private boolean create() {
        ModWriter writer = null;
        ModuleDescriptionLoader mdl = ModSetup.getModuleLoader();
        HashMap<String, ModuleDescription> model = new HashMap<String, ModuleDescription>();
        Set<ModuleDescription> modules = mdl.loadBootModules();
        for (ModuleDescription md : modules) {
            md.setFeatures(this.features);
            model.put(md.getName(), md);
        }
        this.filterModuleSet(model, true, this.mo.isSet(Option.DEBUG));
        if (this.wm == WriteMode.STRUCT_PLAIN || this.wm == WriteMode.STRUCT_CUMULATIVE) {
            if (new StructWriter().createStructFile(this.wm, model, mdl.loadBootModules())) {
                return this.passed();
            }
            return this.failed("");
        }
        try {
            Writer w = this.getFileManager().getDefaultFormat().getWriter();
            Object object = null;
            try (FileOutputStream fos = new FileOutputStream(FileManager.getURL(this.mo.getValue(Option.TEST_URL), this.mo.getValue(Option.FILE_NAME)).getFile());
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                if (!(w instanceof ModWriter)) {
                    throw new IllegalStateException();
                }
                writer = (ModWriter)((Object)w);
                writer.init(new PrintWriter(osw));
                writer.addFeature(FeaturesHolder.ConstInfo);
                writer.addFeature(FeaturesHolder.TigerInfo);
                writer.addFeature(FeaturesHolder.ModuleInfo);
                if (this.apiVer != null) {
                    writer.setApiVersion(this.apiVer);
                }
                if (this.copyrightStr != null) {
                    writer.addFeature(FeaturesHolder.CopyRight);
                    FeaturesHolder.CopyRight.setText("# " + this.copyrightStr);
                }
                writer.writeHeader();
                for (ModuleDescription md : model.values()) {
                    writer.write(md);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (w != null) {
                    if (object != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (IOException e) {
            if (this.mo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            this.getLog().println(i18n.getString("Setup.error.message.cantcreatesigfile"));
            this.getLog().println(e);
            return this.error(i18n.getString("Setup.error.message.cantcreatesigfile"));
        }
        return this.passed();
    }

    public static enum WriteMode {
        SIGFILE,
        STRUCT_CUMULATIVE,
        STRUCT_PLAIN;

    }
}

