/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.AlertSeverity;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AlertEntry
extends ReadOnlyEntry {
    public static final String OC_ALERT = "ds-admin-alert";
    public static final String ATTR_ALERT_GENERATOR = "ds-alert-generator";
    public static final String ATTR_ALERT_ID = "ds-alert-id";
    public static final String ATTR_ALERT_MESSAGE = "ds-alert-message";
    public static final String ATTR_ALERT_SEVERITY = "ds-alert-severity";
    public static final String ATTR_ALERT_TIME = "ds-alert-time";
    public static final String ATTR_ALERT_TYPE = "ds-alert-type";
    public static final String ATTR_ALERT_TYPE_OID = "ds-alert-type-oid";
    private static final long serialVersionUID = -2912778595612338699L;
    private final AlertSeverity alertSeverity;
    private final Date alertTime;
    private final String alertGeneratorClass;
    private final String alertID;
    private final String alertMessage;
    private final String alertType;
    private final String alertTypeOID;

    public AlertEntry(Entry entry) {
        super(entry);
        this.alertGeneratorClass = entry.getAttributeValue(ATTR_ALERT_GENERATOR);
        this.alertID = entry.getAttributeValue(ATTR_ALERT_ID);
        this.alertMessage = entry.getAttributeValue(ATTR_ALERT_MESSAGE);
        this.alertType = entry.getAttributeValue(ATTR_ALERT_TYPE);
        this.alertTypeOID = entry.getAttributeValue(ATTR_ALERT_TYPE_OID);
        this.alertTime = entry.getAttributeValueAsDate(ATTR_ALERT_TIME);
        String severityStr = entry.getAttributeValue(ATTR_ALERT_SEVERITY);
        this.alertSeverity = severityStr == null ? null : AlertSeverity.forName(severityStr);
    }

    public String getAlertGeneratorClass() {
        return this.alertGeneratorClass;
    }

    public String getAlertID() {
        return this.alertID;
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public AlertSeverity getAlertSeverity() {
        return this.alertSeverity;
    }

    public Date getAlertTime() {
        return this.alertTime;
    }

    public String getAlertType() {
        return this.alertType;
    }

    public String getAlertTypeOID() {
        return this.alertTypeOID;
    }
}

