/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CannedResponseRequestHandler
extends LDAPListenerRequestHandler
implements Serializable {
    private static final long serialVersionUID = 6199105854736880833L;
    private final AddResponseProtocolOp addResponseProtocolOp;
    private final BindResponseProtocolOp bindResponseProtocolOp;
    private final CompareResponseProtocolOp compareResponseProtocolOp;
    private final DeleteResponseProtocolOp deleteResponseProtocolOp;
    private final ExtendedResponseProtocolOp extendedResponseProtocolOp;
    private final ModifyResponseProtocolOp modifyResponseProtocolOp;
    private final ModifyDNResponseProtocolOp modifyDNResponseProtocolOp;
    private final List<SearchResultEntryProtocolOp> searchEntryProtocolOps;
    private final List<SearchResultReferenceProtocolOp> searchReferenceProtocolOps;
    private final SearchResultDoneProtocolOp searchResultDoneProtocolOp;
    private final LDAPListenerClientConnection clientConnection;

    public CannedResponseRequestHandler() {
        this(ResultCode.SUCCESS, null, null, null);
    }

    public CannedResponseRequestHandler(ResultCode resultCode, String matchedDN, String diagnosticMessage, List<String> referralURLs) {
        this(resultCode, matchedDN, diagnosticMessage, referralURLs, null, null);
    }

    public CannedResponseRequestHandler(ResultCode resultCode, String matchedDN, String diagnosticMessage, List<String> referralURLs, Collection<? extends Entry> searchEntries, Collection<SearchResultReference> searchReferences) {
        ArrayList<ProtocolOp> l;
        Validator.ensureNotNull(resultCode);
        this.clientConnection = null;
        int rc = resultCode.intValue();
        this.addResponseProtocolOp = new AddResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.bindResponseProtocolOp = new BindResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs, null);
        this.compareResponseProtocolOp = new CompareResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.deleteResponseProtocolOp = new DeleteResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.extendedResponseProtocolOp = new ExtendedResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs, null, null);
        this.modifyResponseProtocolOp = new ModifyResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.modifyDNResponseProtocolOp = new ModifyDNResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.searchResultDoneProtocolOp = new SearchResultDoneProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        if (searchEntries == null || searchEntries.isEmpty()) {
            this.searchEntryProtocolOps = Collections.emptyList();
        } else {
            l = new ArrayList<ProtocolOp>(searchEntries.size());
            for (Entry entry : searchEntries) {
                l.add(new SearchResultEntryProtocolOp(entry));
            }
            this.searchEntryProtocolOps = Collections.unmodifiableList(l);
        }
        if (searchReferences == null || searchReferences.isEmpty()) {
            this.searchReferenceProtocolOps = Collections.emptyList();
        } else {
            l = new ArrayList(searchReferences.size());
            for (SearchResultReference searchResultReference : searchReferences) {
                l.add(new SearchResultReferenceProtocolOp(searchResultReference));
            }
            this.searchReferenceProtocolOps = Collections.unmodifiableList(l);
        }
    }

    private CannedResponseRequestHandler(CannedResponseRequestHandler h, LDAPListenerClientConnection c) {
        this.addResponseProtocolOp = h.addResponseProtocolOp;
        this.bindResponseProtocolOp = h.bindResponseProtocolOp;
        this.compareResponseProtocolOp = h.compareResponseProtocolOp;
        this.deleteResponseProtocolOp = h.deleteResponseProtocolOp;
        this.extendedResponseProtocolOp = h.extendedResponseProtocolOp;
        this.modifyResponseProtocolOp = h.modifyResponseProtocolOp;
        this.modifyDNResponseProtocolOp = h.modifyDNResponseProtocolOp;
        this.searchEntryProtocolOps = h.searchEntryProtocolOps;
        this.searchReferenceProtocolOps = h.searchReferenceProtocolOps;
        this.searchResultDoneProtocolOp = h.searchResultDoneProtocolOp;
        this.clientConnection = c;
    }

    @Override
    public CannedResponseRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return new CannedResponseRequestHandler(this, connection);
    }

    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.addResponseProtocolOp, Collections.emptyList());
    }

    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.bindResponseProtocolOp, Collections.emptyList());
    }

    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.compareResponseProtocolOp, Collections.emptyList());
    }

    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.deleteResponseProtocolOp, Collections.emptyList());
    }

    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.extendedResponseProtocolOp, Collections.emptyList());
    }

    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.modifyResponseProtocolOp, Collections.emptyList());
    }

    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.modifyDNResponseProtocolOp, Collections.emptyList());
    }

    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        for (SearchResultEntryProtocolOp e : this.searchEntryProtocolOps) {
            try {
                this.clientConnection.sendSearchResultEntry(messageID, e, new Control[0]);
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        for (SearchResultReferenceProtocolOp r : this.searchReferenceProtocolOps) {
            try {
                this.clientConnection.sendSearchResultReference(messageID, r, new Control[0]);
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        return new LDAPMessage(messageID, (ProtocolOp)this.searchResultDoneProtocolOp, Collections.emptyList());
    }
}

