/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import java.util.HashSet;
import java.util.Set;

public class FeaturesHolder {
    private Set<Feature> supportedFeatures;
    public static final Feature ConstInfo = new Feature("#NoConstInfo");
    public static final Feature TigerInfo = new Feature("#NoTigerFeaturesInfo");
    public static final Feature MergeModeSupported = new Feature("#MergeModeSupported");
    public static final Feature BuildMembers = new Feature("#BuildMembers");
    public static final Feature NonStaticConstants = new Feature("#NonStaticConstants");
    public static final Feature ListOfHiders = new Feature("#ListOfHiders");
    public static final Feature XHiders = new Feature("#XHiders");
    public static final Feature OuterClasses = new Feature("#OuterClasses");
    public static final Feature CopyRight = new Feature("#CopyRight");
    public static final Feature ModuleInfo = new Feature("#ModuleInfo");
    public static final Feature AnnDevVal = new Feature("#AnnoDefVals");

    public void addSupportedFeature(Feature feature) {
        this.ensureInitialized();
        this.supportedFeatures.add(feature);
    }

    public Set<Feature> getSupportedFeatures() {
        this.ensureInitialized();
        return this.supportedFeatures;
    }

    private void ensureInitialized() {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new HashSet<Feature>();
        }
    }

    protected void removeSupportedFeature(Feature feature) {
        this.ensureInitialized();
        this.supportedFeatures.remove(feature);
    }

    public boolean isFeatureSupported(Feature feature) {
        this.ensureInitialized();
        return this.supportedFeatures.contains(feature);
    }

    protected boolean isInitialized() {
        return this.supportedFeatures != null;
    }

    public void setFeatures(Set<Feature> features) {
        this.supportedFeatures = new HashSet<Feature>(features);
    }

    public void retainFeatures(Set<Feature> features) {
        this.supportedFeatures.retainAll(features);
    }

    public static class Feature {
        private String pragma;

        public void setText(String newText) {
            this.pragma = newText;
        }

        private Feature(String pragma) {
            this.pragma = pragma;
        }

        public String toString() {
            return this.pragma;
        }

        boolean match(String line) {
            return this.pragma.equals(line);
        }
    }
}

