/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.indexdiff.GitResourceDeltaVisitor;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDiffCacheEntry {
    private static final int RESOURCE_LIST_UPDATE_LIMIT = 1000;
    private Repository repository;
    private volatile IndexDiffData indexDiffData;
    private Job reloadJob;
    private ReentrantLock lock = new ReentrantLock(true);
    private Set<IndexDiffChangedListener> listeners = new HashSet<IndexDiffChangedListener>();
    private IResourceChangeListener resourceChangeListener;

    public IndexDiffCacheEntry(Repository repository) {
        this.repository = repository;
        repository.getListenerList().addIndexChangedListener(new IndexChangedListener(){

            public void onIndexChanged(IndexChangedEvent event) {
                IndexDiffCacheEntry.this.scheduleReloadJob("IndexChanged");
            }
        });
        repository.getListenerList().addRefsChangedListener(new RefsChangedListener(){

            public void onRefsChanged(RefsChangedEvent event) {
                IndexDiffCacheEntry.this.scheduleReloadJob("RefsChanged");
            }
        });
        this.scheduleReloadJob("IndexDiffCacheEntry construction");
        this.createResourceChangeListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexDiffChangedListener(IndexDiffChangedListener listener) {
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexDiffChangedListener(IndexDiffChangedListener listener) {
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public void refreshResourcesAndIndexDiff() {
        String repositoryName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        String jobName = MessageFormat.format(CoreText.IndexDiffCacheEntry_refreshingProjects, repositoryName);
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject[] validOpenProjects = ProjectUtil.getValidOpenProjects(IndexDiffCacheEntry.this.repository);
                    ProjectUtil.refreshResources((IResource[])validOpenProjects, monitor);
                }
                catch (CoreException e) {
                    return Activator.error(e.getMessage(), e);
                }
                IndexDiffCacheEntry.this.refresh();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    public void refresh() {
        this.scheduleReloadJob("Refresh called");
    }

    public IndexDiffData getIndexDiff() {
        return this.indexDiffData;
    }

    private void scheduleReloadJob(final String trigger) {
        if (this.reloadJob != null) {
            this.reloadJob.cancel();
        }
        if (!this.checkRepository()) {
            return;
        }
        this.reloadJob = new Job(this.getReloadJobName()){

            protected IStatus run(IProgressMonitor monitor) {
                IndexDiffCacheEntry.this.waitForWorkspaceLock(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IndexDiffCacheEntry.this.lock.lock();
                try {
                    long startTime = System.currentTimeMillis();
                    IndexDiff result = IndexDiffCacheEntry.this.calcIndexDiff(monitor, this.getName());
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffCacheEntry.this.indexDiffData = new IndexDiffData(result);
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        long time = System.currentTimeMillis() - startTime;
                        StringBuilder message = new StringBuilder(this.getTraceMessage(time));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), message.append(IndexDiffCacheEntry.this.indexDiffData.toString()).toString());
                    }
                    IndexDiffCacheEntry.this.notifyListeners();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (IOException e) {
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), "Calculating IndexDiff failed", (Throwable)e);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    IndexDiffCacheEntry.this.lock.unlock();
                }
            }

            private String getTraceMessage(long time) {
                return NLS.bind((String)"\nUpdated IndexDiffData in {0} ms\nReason: {1}\nRepository: {2}\n", (Object[])new Object[]{time, trigger, IndexDiffCacheEntry.this.repository.getWorkTree().getName()});
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.INDEX_DIFF_CACHE_UPDATE)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        this.reloadJob.schedule();
    }

    private boolean checkRepository() {
        if (Activator.getDefault() == null) {
            return false;
        }
        return this.repository.getDirectory().exists();
    }

    private void waitForWorkspaceLock(IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor innerMonitor) throws CoreException {
                }
            }, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void scheduleUpdateJob(final Collection<String> filesToUpdate, final Collection<IResource> resourcesToUpdate) {
        if (!this.checkRepository()) {
            return;
        }
        Job job = new Job(this.getReloadJobName()){

            protected IStatus run(IProgressMonitor monitor) {
                IndexDiffCacheEntry.this.waitForWorkspaceLock(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IndexDiffCacheEntry.this.lock.lock();
                try {
                    long startTime = System.currentTimeMillis();
                    IndexDiffData result = IndexDiffCacheEntry.this.calcIndexDiffData(monitor, this.getName(), filesToUpdate, resourcesToUpdate);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffCacheEntry.this.indexDiffData = result;
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        long time = System.currentTimeMillis() - startTime;
                        StringBuilder message = new StringBuilder(NLS.bind((String)"Updated IndexDiffData based on resource list (length = {0}) in {1} ms\n", (Object)resourcesToUpdate.size(), (Object)time));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), message.append(IndexDiffCacheEntry.this.indexDiffData.toString()).toString());
                    }
                    IndexDiffCacheEntry.this.notifyListeners();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (IOException e) {
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), "Calculating IndexDiff failed", (Throwable)e);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    IndexDiffCacheEntry.this.lock.unlock();
                }
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.INDEX_DIFF_CACHE_UPDATE)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.schedule();
    }

    private IndexDiffData calcIndexDiffData(IProgressMonitor monitor, String jobName, Collection<String> filesToUpdate, Collection<IResource> resourcesToUpdate) throws IOException {
        EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
        WorkingTreeIterator iterator = IteratorService.createInitialIterator(this.repository);
        IndexDiff diffForChangedResources = new IndexDiff(this.repository, "HEAD", iterator);
        diffForChangedResources.setFilter(PathFilterGroup.createFromStrings(filesToUpdate));
        diffForChangedResources.diff((ProgressMonitor)jgitMonitor, 0, 0, jobName);
        return new IndexDiffData(this.indexDiffData, filesToUpdate, resourcesToUpdate, diffForChangedResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        IndexDiffChangedListener[] tmpListeners;
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            tmpListeners = this.listeners.toArray(new IndexDiffChangedListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < tmpListeners.length) {
            try {
                tmpListeners[i].indexDiffChanged(this.repository, this.indexDiffData);
            }
            catch (RuntimeException e) {
                Activator.logError("Exception occured in an IndexDiffChangedListener", e);
            }
            ++i;
        }
    }

    private IndexDiff calcIndexDiff(IProgressMonitor monitor, String jobName) throws IOException {
        EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
        WorkingTreeIterator iterator = IteratorService.createInitialIterator(this.repository);
        IndexDiff newIndexDiff = new IndexDiff(this.repository, "HEAD", iterator);
        newIndexDiff.diff((ProgressMonitor)jgitMonitor, 0, 0, jobName);
        return newIndexDiff;
    }

    private String getReloadJobName() {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        return MessageFormat.format(CoreText.IndexDiffCacheEntry_reindexing, repoName);
    }

    private void createResourceChangeListener() {
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                GitResourceDeltaVisitor visitor = new GitResourceDeltaVisitor(IndexDiffCacheEntry.this.repository);
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    Activator.logError(e.getMessage(), e);
                    return;
                }
                Collection<String> filesToUpdate = visitor.getFilesToUpdate();
                if (visitor.getGitIgnoreChanged()) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("A .gitignore changed");
                } else if (IndexDiffCacheEntry.this.indexDiffData == null) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("Resource changed, no diff available");
                } else if (!filesToUpdate.isEmpty()) {
                    if (filesToUpdate.size() < 1000) {
                        IndexDiffCacheEntry.this.scheduleUpdateJob(filesToUpdate, visitor.getResourcesToUpdate());
                    } else {
                        IndexDiffCacheEntry.this.scheduleReloadJob("Too many resources changed");
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }
}

