/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CompareWithHeadActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1 && resources[0] instanceof IFile) {
            ITypedElement next;
            IFile baseFile = (IFile)resources[0];
            String gitPath = RepositoryMapping.getMapping((IResource)baseFile.getProject()).getRepoRelativePath((IResource)baseFile);
            ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)baseFile);
            try {
                Ref head = repository.getRef("HEAD");
                RevWalk rw = new RevWalk(repository);
                RevCommit commit = rw.parseCommit((AnyObjectId)head.getObjectId());
                rw.markStart(commit);
                rw.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)gitPath), (TreeFilter)TreeFilter.ANY_DIFF));
                RevCommit latestFileCommit = rw.next();
                if (latestFileCommit == null) {
                    latestFileCommit = commit;
                }
                next = CompareUtils.getFileRevisionTypedElement(gitPath, latestFileCommit, repository);
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                return null;
            }
            GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
            CompareUI.openCompareEditor((CompareEditorInput)in);
            return null;
        }
        try {
            CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
            try {
                view.setInput(resources, repository.resolve("HEAD").name());
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                return null;
            }
        }
        catch (PartInitException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.getRepository() != null;
    }
}

