/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithIndexActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getRepository(true, event) == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1 && resources[0] instanceof IFile) {
            ITypedElement next;
            IFile baseFile = (IFile)resources[0];
            ITypedElement base = this.getBaseTypeElement(baseFile);
            try {
                next = CompareUtils.getHeadTypedElement(baseFile);
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                return null;
            }
            GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
            IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            CompareUtils.openInCompare(workBenchPage, (CompareEditorInput)in);
        } else {
            try {
                CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                view.setInput(resources, "%%%INDEX%%%");
            }
            catch (PartInitException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.getRepository() != null;
    }

    private ITypedElement getBaseTypeElement(IFile baseFile) {
        Object base;
        if (ResourceUtil.isNonWorkspace((IResource)baseFile)) {
            String path = baseFile.getFullPath().toOSString();
            base = new LocalNonWorkspaceTypedElement(path);
        } else {
            base = SaveableCompareEditorInput.createFileElement((IFile)baseFile);
        }
        return base;
    }
}

