/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceBranchFailureDialog
extends MessageDialog {
    private Button toggleButton;
    private final String cause;

    public static void show(Shell parentShell, String cause) {
        SourceBranchFailureDialog dialog = new SourceBranchFailureDialog(parentShell, cause);
        dialog.setShellStyle(dialog.getShellStyle() | 0x10000000 | 0x10);
        dialog.open();
    }

    private SourceBranchFailureDialog(Shell parentShell, String cause) {
        super(parentShell, UIText.CloneFailureDialog_tile, null, null, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.cause = cause;
    }

    protected void buttonPressed(int buttonId) {
        if (this.toggleButton != null) {
            Activator.getDefault().getPreferenceStore().setValue("CloneWizard_ShowDetailedFailureDialog", !this.toggleButton.getSelection());
        }
        super.buttonPressed(buttonId);
    }

    protected Control createMessageArea(Composite composite) {
        Composite main = new Composite(composite, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        super.createMessageArea(main);
        StyledText text = new StyledText(main, 65600);
        text.setEnabled(false);
        text.setBackground(main.getBackground());
        String messageText = NLS.bind((String)UIText.CloneFailureDialog_checkList, (Object)this.cause);
        int newLinesCount = messageText.split("\n").length;
        Bullet bullet = this.createBullet(main);
        text.setText(messageText);
        text.setLineBullet(newLinesCount - 4, 2, bullet);
        return main;
    }

    private Bullet createBullet(Composite main) {
        StyleRange style = new StyleRange();
        style.metrics = new GlyphMetrics(0, 0, 40);
        style.foreground = main.getDisplay().getSystemColor(2);
        Bullet bullet = new Bullet(style);
        return bullet;
    }

    protected Control createCustomArea(Composite parent) {
        this.toggleButton = new Button(parent, 16416);
        this.toggleButton.setText(UIText.CloneFailureDialog_dontShowAgain);
        return null;
    }
}

