/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class CreateBranchPage
extends WizardPage {
    private final Repository myRepository;
    private final IInputValidator myValidator;
    private final String myBaseRef;
    private final RevCommit myBaseCommit;
    private Text nameText;
    private boolean nameIsSuggestion;
    private Button checkout;
    private Combo branchCombo;
    private Composite warningComposite;
    private CreateLocalBranchOperation.UpstreamConfig upstreamConfig;
    private Group upstreamConfigGroup;
    private Button buttonConfigRebase;
    private Button buttonConfigMerge;
    private Button buttonConfigNone;

    public static String getProposedTargetName(String sourceName) {
        if (sourceName == null) {
            return null;
        }
        if (sourceName.startsWith("refs/remotes/")) {
            String target = sourceName.substring("refs/remotes/".length());
            int postSlash = target.indexOf(47) + 1;
            if (postSlash > 0 && postSlash < target.length()) {
                return target.substring(postSlash);
            }
            return target;
        }
        if (sourceName.startsWith("refs/tags/")) {
            return sourceName.substring("refs/tags/".length());
        }
        return "";
    }

    public CreateBranchPage(Repository repo, Ref baseRef) {
        super(CreateBranchPage.class.getName());
        this.myRepository = repo;
        this.myBaseRef = baseRef != null ? baseRef.getName() : null;
        this.myBaseCommit = null;
        this.myValidator = ValidationUtils.getRefNameInputValidator(this.myRepository, "refs/heads/", true);
        this.upstreamConfig = baseRef != null ? this.getDefaultUpstreamConfig(repo, baseRef.getName()) : CreateLocalBranchOperation.UpstreamConfig.NONE;
        this.setTitle(UIText.CreateBranchPage_Title);
        this.setMessage(UIText.CreateBranchPage_ChooseBranchAndNameMessage);
    }

    public CreateBranchPage(Repository repo, RevCommit baseCommit) {
        super(CreateBranchPage.class.getName());
        this.myRepository = repo;
        this.myBaseRef = null;
        this.myBaseCommit = baseCommit;
        this.myValidator = ValidationUtils.getRefNameInputValidator(this.myRepository, "refs/heads/", true);
        this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.NONE;
        this.setTitle(UIText.CreateBranchPage_Title);
        this.setMessage(UIText.CreateBranchPage_ChooseNameMessage);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label sourceLabel = new Label(main, 0);
        if (this.myBaseCommit != null) {
            sourceLabel.setText(UIText.CreateBranchPage_SourceCommitLabel);
            sourceLabel.setToolTipText(UIText.CreateBranchPage_SourceCommitTooltip);
        } else {
            sourceLabel.setText(UIText.CreateBranchPage_SourceBranchLabel);
            sourceLabel.setToolTipText(UIText.CreateBranchPage_SourceBranchTooltip);
        }
        this.branchCombo = new Combo(main, 12);
        this.branchCombo.setData("org.eclipse.swtbot.widget.key", (Object)"BaseBranch");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.branchCombo);
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(UIText.CreateBranchPage_BranchNameLabel);
        Text prefix = new Text(main, 0);
        prefix.setText("refs/heads/");
        prefix.setEnabled(false);
        this.nameText = new Text(main, 2048);
        nameLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                CreateBranchPage.this.nameText.setFocus();
            }
        });
        if (this.myBaseCommit != null) {
            this.branchCombo.add(this.myBaseCommit.name());
            this.branchCombo.setText(this.myBaseCommit.name());
            try {
                Map map = this.myRepository.getRefDatabase().getRefs("refs/heads/");
                for (Map.Entry entry : map.entrySet()) {
                    if (!((Ref)entry.getValue()).getLeaf().getObjectId().equals((AnyObjectId)this.myBaseCommit)) continue;
                    this.branchCombo.add(((Ref)entry.getValue()).getName());
                }
                map = this.myRepository.getRefDatabase().getRefs("refs/remotes/");
                String firstRemote = null;
                for (Map.Entry entry : map.entrySet()) {
                    if (!((Ref)entry.getValue()).getLeaf().getObjectId().equals((AnyObjectId)this.myBaseCommit)) continue;
                    this.branchCombo.add(((Ref)entry.getValue()).getName());
                    if (firstRemote != null) continue;
                    firstRemote = ((Ref)entry.getValue()).getName();
                }
                if (firstRemote != null) {
                    this.branchCombo.setText(firstRemote);
                    this.suggestBranchName(firstRemote);
                }
            }
            catch (IOException e) {
                Activator.logError("Exception while trying to find Refs for Commit", e);
            }
            this.branchCombo.setEnabled(this.branchCombo.getItemCount() > 1);
        } else {
            ArrayList<String> refs = new ArrayList<String>();
            RefDatabase refDatabase = this.myRepository.getRefDatabase();
            try {
                for (Ref ref : refDatabase.getAdditionalRefs()) {
                    refs.add(ref.getName());
                }
                Set entrys = refDatabase.getRefs("").entrySet();
                for (Map.Entry ref : entrys) {
                    refs.add(((Ref)ref.getValue()).getName());
                }
            }
            catch (IOException iOException) {}
            Collections.sort(refs, CommonUtils.STRING_ASCENDING_COMPARATOR);
            for (String refName : refs) {
                this.branchCombo.add(refName);
            }
            if (this.myBaseRef != null) {
                this.branchCombo.setText(this.myBaseRef);
            }
        }
        this.branchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String ref = CreateBranchPage.this.branchCombo.getText();
                CreateBranchPage.this.suggestBranchName(ref);
                CreateBranchPage.this.upstreamConfig = CreateBranchPage.this.getDefaultUpstreamConfig(CreateBranchPage.this.myRepository, ref);
                CreateBranchPage.this.checkPage();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBranchPage.this.nameIsSuggestion = false;
            }
        });
        this.nameText.setData("org.eclipse.swtbot.widget.key", (Object)"BranchName");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.upstreamConfigGroup = new Group(main, 16);
        this.upstreamConfigGroup.setToolTipText(UIText.CreateBranchPage_PullStrategyTooltip);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.upstreamConfigGroup);
        this.upstreamConfigGroup.setText(UIText.CreateBranchPage_PullStrategyGroupHeader);
        this.upstreamConfigGroup.setLayout((Layout)new GridLayout(1, false));
        this.warningComposite = new Composite((Composite)this.upstreamConfigGroup, 0);
        this.warningComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.warningComposite);
        CLabel warningLabel = new CLabel(this.warningComposite, 0);
        warningLabel.setText(UIText.CreateBranchPage_LocalBranchWarningText);
        warningLabel.setToolTipText(UIText.CreateBranchPage_LocalBranchWarningTooltip);
        warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        this.buttonConfigRebase = new Button((Composite)this.upstreamConfigGroup, 16);
        this.buttonConfigRebase.setText(UIText.CreateBranchPage_RebaseRadioButton);
        this.buttonConfigRebase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateBranchPage.this.buttonConfigRebase.getSelection()) {
                    CreateBranchPage.this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.REBASE;
                }
            }
        });
        this.buttonConfigRebase.setToolTipText(UIText.CreateBranchPage_PullRebaseTooltip);
        this.buttonConfigMerge = new Button((Composite)this.upstreamConfigGroup, 16);
        this.buttonConfigMerge.setText(UIText.CreateBranchPage_MergeRadioButton);
        this.buttonConfigMerge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateBranchPage.this.buttonConfigMerge.getSelection()) {
                    CreateBranchPage.this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.MERGE;
                }
            }
        });
        this.buttonConfigMerge.setToolTipText(UIText.CreateBranchPage_PullMergeTooltip);
        this.buttonConfigNone = new Button((Composite)this.upstreamConfigGroup, 16);
        this.buttonConfigNone.setText(UIText.CreateBranchPage_NoneRadioButton);
        this.buttonConfigNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateBranchPage.this.buttonConfigNone.getSelection()) {
                    CreateBranchPage.this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.NONE;
                }
            }
        });
        this.buttonConfigNone.setToolTipText(UIText.CreateBranchPage_PullNoneTooltip);
        boolean isBare = this.myRepository.isBare();
        this.checkout = new Button(main, 32);
        this.checkout.setText(UIText.CreateBranchPage_CheckoutButton);
        this.checkout.setSelection(!isBare);
        this.checkout.setEnabled(!isBare);
        this.checkout.setVisible(!isBare);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.checkout);
        this.checkout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchPage.this.checkPage();
            }
        });
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
        this.nameText.setFocus();
        this.suggestBranchName(this.myBaseRef);
        this.checkPage();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBranchPage.this.checkPage();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPage() {
        block12: {
            this.setErrorMessage(null);
            try {
                block15: {
                    block14: {
                        block13: {
                            GridData gd = (GridData)this.warningComposite.getLayoutData();
                            gd.exclude = !this.branchCombo.getText().startsWith("refs/heads/");
                            this.warningComposite.setVisible(!gd.exclude);
                            this.warningComposite.getParent().getParent().layout(true);
                            boolean showRebase = !this.branchCombo.getText().startsWith("refs/tags/") && !ObjectId.isId((String)this.branchCombo.getText());
                            gd = (GridData)this.upstreamConfigGroup.getLayoutData();
                            gd.exclude = !showRebase;
                            this.upstreamConfigGroup.setVisible(!gd.exclude);
                            this.upstreamConfigGroup.getParent().layout(true);
                            if (!gd.exclude) {
                                this.buttonConfigMerge.setSelection(false);
                            }
                            this.buttonConfigRebase.setSelection(false);
                            this.buttonConfigNone.setSelection(false);
                            switch (this.upstreamConfig) {
                                case MERGE: {
                                    this.buttonConfigMerge.setSelection(true);
                                    break;
                                }
                                case REBASE: {
                                    this.buttonConfigRebase.setSelection(true);
                                    break;
                                }
                                case NONE: {
                                    this.buttonConfigNone.setSelection(true);
                                    break;
                                }
                            }
                            if (this.branchCombo.getText().length() != 0) break block13;
                            this.setErrorMessage(UIText.CreateBranchPage_MissingSourceMessage);
                            break block14;
                        }
                        if (this.nameText.getText().length() != 0) break block15;
                        this.setErrorMessage(UIText.CreateBranchPage_ChooseNameMessage);
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                String message = this.myValidator.isValid(this.nameText.getText());
                if (message == null) break block12;
                this.setErrorMessage(message);
            }
            catch (Throwable throwable) {
                this.setPageComplete(this.getErrorMessage() == null);
                throw throwable;
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public String getBranchName() {
        return this.nameText.getText();
    }

    public void createBranch(IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(UIText.CreateBranchPage_CreatingBranchMessage, -1);
        String newRefName = this.getBranchName();
        CreateLocalBranchOperation cbop = this.myBaseCommit != null && this.branchCombo.getText().equals(this.myBaseCommit.name()) ? new CreateLocalBranchOperation(this.myRepository, newRefName, this.myBaseCommit) : new CreateLocalBranchOperation(this.myRepository, newRefName, this.myRepository.getRef(this.branchCombo.getText()), this.upstreamConfig);
        cbop.execute(monitor);
        if (this.checkout.getSelection()) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(UIText.CreateBranchPage_CheckingOutMessage, -1);
            BranchOperationUI.checkout(this.myRepository, "refs/heads/" + newRefName).run(monitor);
        }
    }

    private CreateLocalBranchOperation.UpstreamConfig getDefaultUpstreamConfig(Repository repo, String refName) {
        boolean setupRebase;
        boolean setupMerge;
        String autosetupMerge = repo.getConfig().getString("branch", null, "autosetupmerge");
        if (autosetupMerge == null) {
            autosetupMerge = "true";
        }
        boolean isLocalBranch = refName.startsWith("refs/heads/");
        boolean isRemoteBranch = refName.startsWith("refs/remotes/");
        if (!isLocalBranch && !isRemoteBranch) {
            return CreateLocalBranchOperation.UpstreamConfig.NONE;
        }
        boolean bl = setupMerge = autosetupMerge.equals("always") || isRemoteBranch && autosetupMerge.equals("true");
        if (!setupMerge) {
            return CreateLocalBranchOperation.UpstreamConfig.NONE;
        }
        String autosetupRebase = repo.getConfig().getString("branch", null, "autosetuprebase");
        if (autosetupRebase == null) {
            autosetupRebase = "never";
        }
        boolean bl2 = setupRebase = autosetupRebase.equals("always") || autosetupRebase.equals("local") && isLocalBranch || autosetupRebase.equals("remote") && isRemoteBranch;
        if (setupRebase) {
            return CreateLocalBranchOperation.UpstreamConfig.REBASE;
        }
        return CreateLocalBranchOperation.UpstreamConfig.MERGE;
    }

    private void suggestBranchName(String ref) {
        String branchNameSuggestion;
        if ((this.nameText.getText().length() == 0 || this.nameIsSuggestion) && (branchNameSuggestion = CreateBranchPage.getProposedTargetName(ref)) != null) {
            this.nameText.setText(branchNameSuggestion);
            this.nameText.selectAll();
            this.nameIsSuggestion = true;
        }
    }
}

