/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowInHistoryCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode selectedNode;
        final ArrayList<File> fileList = new ArrayList<File>();
        Repository repo = null;
        List selectedNodes = this.getSelectedNodes(event);
        final RepositoryTreeNode nodeToShow = selectedNodes.size() == 1 ? ((selectedNode = (RepositoryTreeNode)selectedNodes.get(0)).getType() == RepositoryTreeNodeType.REPO || selectedNode.getType() == RepositoryTreeNodeType.FILE || selectedNode.getType() == RepositoryTreeNodeType.FOLDER ? selectedNode : null) : null;
        if (nodeToShow == null) {
            for (RepositoryTreeNode node : this.getSelectedNodes(event)) {
                if (repo == null) {
                    repo = node.getRepository();
                }
                if (repo != node.getRepository()) {
                    throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_NoUniqueRepository);
                }
                if (node.getType() == RepositoryTreeNodeType.FOLDER) {
                    fileList.add((File)((FolderNode)node).getObject());
                }
                if (node.getType() != RepositoryTreeNodeType.FILE) continue;
                fileList.add((File)((FileNode)node).getObject());
            }
        }
        final Repository repoToShow = repo;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IHistoryView part = (IHistoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
                    if (nodeToShow != null) {
                        part.showHistoryFor((Object)nodeToShow);
                    } else {
                        part.showHistoryFor((Object)new HistoryPageInput(repoToShow, fileList.toArray(new File[fileList.size()])));
                    }
                }
                catch (PartInitException e1) {
                    Activator.handleError(e1.getMessage(), e1, true);
                }
            }
        });
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.enableWhenRepositoryHaveHead(evaluationContext);
    }
}

