/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.jgit.lib.Repository;

public class GitModelCacheTree
extends GitModelTree {
    private final GitModelCache.FileModelFactory factory;
    private final Map<String, GitModelObject> cacheTreeMap;
    private final Repository repo;

    public GitModelCacheTree(GitModelObjectContainer parent, Repository repo, IPath fullPath, GitModelCache.FileModelFactory factory) {
        super(parent, fullPath, 11);
        this.repo = repo;
        this.factory = factory;
        this.cacheTreeMap = new HashMap<String, GitModelObject>();
    }

    public GitModelObject[] getChildren() {
        Collection<GitModelObject> values = this.cacheTreeMap.values();
        return values.toArray(new GitModelObject[values.size()]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        GitModelCacheTree objTree = (GitModelCacheTree)((Object)obj);
        return this.path.equals((Object)objTree.path) && this.factory.isWorkingTree() == objTree.factory.isWorkingTree();
    }

    public int hashCode() {
        return this.path.hashCode() + (this.factory.isWorkingTree() ? 31 : 41);
    }

    public String toString() {
        return "GitModelCacheTree[" + this.getLocation() + ", isWorkingTree:" + this.factory.isWorkingTree() + "]";
    }

    public boolean isWorkingTree() {
        return this.factory.isWorkingTree();
    }

    void addChild(GitCommitsModelCache.Change change, String nestedPath) {
        int firstSlash = nestedPath.indexOf("/");
        String pathKey = firstSlash > -1 ? nestedPath.substring(0, firstSlash) : nestedPath;
        IPath fullPath = this.getLocation().append(pathKey);
        if (nestedPath.contains("/")) {
            GitModelCacheTree cacheEntry = (GitModelCacheTree)this.cacheTreeMap.get(pathKey);
            if (cacheEntry == null) {
                cacheEntry = new GitModelCacheTree(this, this.repo, fullPath, this.factory);
                this.cacheTreeMap.put(pathKey, cacheEntry);
            }
            cacheEntry.addChild(change, nestedPath.substring(firstSlash + 1));
        } else {
            this.cacheTreeMap.put(pathKey, this.factory.createFileModel(this, this.repo, change, fullPath));
        }
    }
}

