/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.iplog.IpLogText;
import org.eclipse.jgit.iplog.SingleContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Contributor {
    static final Comparator<Contributor> COMPARATOR = new Comparator<Contributor>(){

        @Override
        public int compare(Contributor a, Contributor b) {
            return a.name.compareTo(b.name);
        }
    };
    private final String id;
    private final String name;
    private final List<SingleContribution> contributions = new ArrayList<SingleContribution>();

    Contributor(String id, String name) {
        this.id = id;
        this.name = name;
    }

    String getID() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    Collection<SingleContribution> getContributions() {
        return Collections.unmodifiableCollection(this.contributions);
    }

    void add(SingleContribution bug) {
        this.contributions.add(bug);
    }

    public String toString() {
        return MessageFormat.format(IpLogText.get().contributorString, this.getName());
    }
}

