/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class BranchTrackingStatus {
    private final String remoteTrackingBranch;
    private final int aheadCount;
    private final int behindCount;

    public static BranchTrackingStatus of(Repository repository, String branchName) throws IOException {
        BranchConfig branchConfig = new BranchConfig(repository.getConfig(), branchName);
        String remoteTrackingBranch = branchConfig.getRemoteTrackingBranch();
        if (remoteTrackingBranch == null) {
            return null;
        }
        Ref tracking = repository.getRef(remoteTrackingBranch);
        if (tracking == null) {
            return null;
        }
        Ref local = repository.getRef(branchName);
        if (local == null) {
            return null;
        }
        RevWalk walk = new RevWalk(repository);
        RevCommit localCommit = walk.parseCommit(local.getObjectId());
        RevCommit trackingCommit = walk.parseCommit(tracking.getObjectId());
        walk.setRevFilter(RevFilter.MERGE_BASE);
        walk.markStart(localCommit);
        walk.markStart(trackingCommit);
        RevCommit mergeBase = walk.next();
        walk.reset();
        walk.setRevFilter(RevFilter.ALL);
        int aheadCount = RevWalkUtils.count(walk, localCommit, mergeBase);
        int behindCount = RevWalkUtils.count(walk, trackingCommit, mergeBase);
        return new BranchTrackingStatus(remoteTrackingBranch, aheadCount, behindCount);
    }

    private BranchTrackingStatus(String remoteTrackingBranch, int aheadCount, int behindCount) {
        this.remoteTrackingBranch = remoteTrackingBranch;
        this.aheadCount = aheadCount;
        this.behindCount = behindCount;
    }

    public String getRemoteTrackingBranch() {
        return this.remoteTrackingBranch;
    }

    public int getAheadCount() {
        return this.aheadCount;
    }

    public int getBehindCount() {
        return this.behindCount;
    }
}

