/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.internal.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.core.internal.PluginUtils;
import org.eclipse.emf.facet.util.emf.catalog.CatalogFactory;
import org.eclipse.emf.facet.util.emf.catalog.CatalogSet;
import org.eclipse.emf.facet.util.emf.core.ICatalogManager;
import org.eclipse.emf.facet.util.emf.core.ICatalogSetManager;
import org.eclipse.emf.facet.util.emf.core.exceptions.InvalidFacetSetException;
import org.eclipse.emf.facet.util.emf.core.internal.Activator;
import org.osgi.framework.Bundle;

public class CatalogSetManager
implements ICatalogSetManager {
    private static final String CATALOG_MGR_EXTENSION_POINT_ID = "org.eclipse.emf.facet.util.emf.core.catalogmanager";
    private static final String MODEL_DECLARATION_EXTENSION_POINT_ID = "org.eclipse.emf.facet.util.emf.core.modeldeclaration";
    private static final String CLASS = "class";
    private static final String FILE = "file";
    private final Map<Resource, Bundle> resourceToBundleMap = new HashMap<Resource, Bundle>();
    private final ResourceSet resourceSet;
    private final List<ICatalogManager> catalogManagers = new ArrayList<ICatalogManager>();
    private final CatalogSet catalogSet;

    public CatalogSetManager() {
        this.resourceSet = new ResourceSetImpl();
        this.catalogSet = CatalogFactory.eINSTANCE.createCatalogSet();
        this.initRegisteredEntries();
    }

    private void initRegisteredEntries() {
        IExtensionPoint modelDeclarationExtPoint;
        int n;
        int n2;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPointCatalogMgr = registry.getExtensionPoint(CATALOG_MGR_EXTENSION_POINT_ID);
        if (extPointCatalogMgr != null) {
            IExtension[] iExtensionArray = extPointCatalogMgr.getExtensions();
            n2 = iExtensionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IExtension ext = iExtensionArray[n3];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                n = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IConfigurationElement configElt = iConfigurationElementArray[n4];
                    try {
                        ICatalogManager catalogMgr = (ICatalogManager)configElt.createExecutableExtension(CLASS);
                        this.catalogManagers.add(catalogMgr);
                        catalogMgr.setCatalogSet(this.catalogSet);
                    }
                    catch (CoreException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        if ((modelDeclarationExtPoint = registry.getExtensionPoint(MODEL_DECLARATION_EXTENSION_POINT_ID)) != null) {
            IExtension[] iExtensionArray = modelDeclarationExtPoint.getExtensions();
            int n5 = iExtensionArray.length;
            n2 = 0;
            while (n2 < n5) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n6 = iConfigurationElementArray.length;
                n = 0;
                while (n < n6) {
                    IConfigurationElement configElt = iConfigurationElementArray[n];
                    String filePath = configElt.getAttribute(FILE);
                    if (filePath != null) {
                        String pluginName = ext.getNamespaceIdentifier();
                        Bundle bundle = Platform.getBundle((String)pluginName);
                        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(pluginName) + "/" + filePath), (boolean)false);
                        try {
                            Resource resource = this.resourceSet.getResource(uri, true);
                            this.resourceToBundleMap.put(resource, bundle);
                            for (EObject root : resource.getContents()) {
                                for (ICatalogManager catalogMgr : this.catalogManagers) {
                                    if (!catalogMgr.canBeManaged(root)) continue;
                                    catalogMgr.manage(root);
                                }
                            }
                        }
                        catch (Exception e) {
                            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        }
                    }
                    ++n;
                }
                ++n2;
            }
        }
    }

    public CatalogSet getCatalogSet() {
        return this.catalogSet;
    }

    public Bundle getBundleByResource(Resource eResource) {
        return this.resourceToBundleMap.get(eResource);
    }

    public void registerModelDeclaration(IFile file) throws InvalidFacetSetException {
        PluginUtils.register((IFile)file, (String)MODEL_DECLARATION_EXTENSION_POINT_ID, (String)"modeldeclaration");
    }
}

