/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.config.AbstractRegistryConfiguration;
import net.sourceforge.nattable.config.DefaultNatTableStyleConfiguration;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.config.IConfiguration;
import net.sourceforge.nattable.config.IEditableRule;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.EditConfigAttributes;
import net.sourceforge.nattable.edit.event.InlineCellEditEvent;
import net.sourceforge.nattable.grid.command.AutoResizeColumnCommandHandler;
import net.sourceforge.nattable.grid.data.DefaultColumnHeaderDataProvider;
import net.sourceforge.nattable.grid.data.DefaultCornerDataProvider;
import net.sourceforge.nattable.grid.data.DefaultRowHeaderDataProvider;
import net.sourceforge.nattable.grid.layer.CornerLayer;
import net.sourceforge.nattable.grid.layer.GridLayer;
import net.sourceforge.nattable.hideshow.ColumnHideShowLayer;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.ILayerListener;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import net.sourceforge.nattable.layer.cell.IConfigLabelAccumulator;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.reorder.ColumnReorderLayer;
import net.sourceforge.nattable.reorder.event.ColumnReorderEvent;
import net.sourceforge.nattable.resize.event.ColumnResizeEvent;
import net.sourceforge.nattable.resize.event.RowResizeEvent;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.SelectAllCommand;
import net.sourceforge.nattable.selection.command.SelectRowsCommand;
import net.sourceforge.nattable.selection.config.DefaultSelectionStyleConfiguration;
import net.sourceforge.nattable.selection.event.CellSelectionEvent;
import net.sourceforge.nattable.selection.event.ColumnSelectionEvent;
import net.sourceforge.nattable.selection.event.RowSelectionEvent;
import net.sourceforge.nattable.sort.config.SingleClickSortConfiguration;
import net.sourceforge.nattable.style.BorderStyle;
import net.sourceforge.nattable.style.HorizontalAlignmentEnum;
import net.sourceforge.nattable.style.VerticalAlignmentEnum;
import net.sourceforge.nattable.util.GUIHelper;
import net.sourceforge.nattable.viewport.ViewportLayer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.uicore.ChangeListener;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.emf.facet.infra.query.runtime.RuntimeFactory;
import org.eclipse.emf.facet.infra.query.ui.dialogs.QuerySelectionDialog;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.internal.EMFUtils;
import org.eclipse.emf.facet.widgets.celleditors.ICellEditorsRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditorContainer;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditorValidator;
import org.eclipse.emf.facet.widgets.celleditors.INaryEAttributeCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.INaryEReferenceCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.INaryFeatureCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.internal.CellEditorsRegistry;
import org.eclipse.emf.facet.widgets.celleditors.internal.ModelCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.internal.core.EEnumCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor;
import org.eclipse.emf.facet.widgets.internal.CustomizableLabelProvider;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Factory;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.BodyDataProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.ColumnComparator;
import org.eclipse.emf.facet.widgets.nattable.internal.ColumnHeaderLayerStack;
import org.eclipse.emf.facet.widgets.nattable.internal.CopyToClipboardCommandHandler;
import org.eclipse.emf.facet.widgets.nattable.internal.DataValidatorAdapter;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElementWithContext;
import org.eclipse.emf.facet.widgets.nattable.internal.GridLayerConfiguration;
import org.eclipse.emf.facet.widgets.nattable.internal.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableCellEditorAdapter;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableDropListener;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableNaryEAttributeCellEditorAdapter;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableNaryEReferenceCellEditorAdapter;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableNaryReferenceCellEditorAdapter;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.nattable.internal.RowHeaderLayerStack;
import org.eclipse.emf.facet.widgets.nattable.internal.SortedColumnContentProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.StyleConfiguration;
import org.eclipse.emf.facet.widgets.nattable.internal.StyledColumnHeaderConfiguration;
import org.eclipse.emf.facet.widgets.nattable.internal.StyledRowHeaderConfiguration;
import org.eclipse.emf.facet.widgets.nattable.internal.TableInstanceCommandFactory;
import org.eclipse.emf.facet.widgets.nattable.internal.TableLabelProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.actions.LoadCustomizationsAction;
import org.eclipse.emf.facet.widgets.nattable.internal.actions.LoadFacetsAction;
import org.eclipse.emf.facet.widgets.nattable.internal.dialogs.ColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethodParameters;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableWidget
extends Composite
implements DisposeListener,
INatTableWidget,
INatTableWidget2,
INatTableWidgetInternal {
    private static final int REFRESH_JOB_DELAY = 100;
    private static final int DEFAULT_COLUMN_WIDTH = 150;
    private static final int DEFAULT_COLUMN_HEIGHT = 20;
    private static final Color BG_COLOR = GUIHelper.getColor((int)217, (int)232, (int)251);
    private static final String ENUM_CELLEDITOR_LABEL = "enum_celleditor";
    protected static final String TMP_FILE_NAME = "org.eclipse.emf.facet.widgets.nattable.tmp.table";
    private static final File DEFAULT_RESOURCE_FILE = new File(new File(System.getProperty("java.io.tmpdir")), "org.eclipse.emf.facet.widgets.nattable.tmp.table");
    private NatTable natTable;
    private final TableInstance tableInstance;
    private TableLabelProvider tableLabelProvider;
    private BodyDataProvider fBodyDataProvider;
    private BodyLayerStack fBodyLayer;
    private GridLayer gridLayer;
    private ColumnHeaderLayerStack fColumnHeaderLayer;
    private RowHeaderLayerStack fRowHeaderLayer;
    private final Collection<ISelectionChangedListener> fSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final List<Resource> listenedResources = new ArrayList<Resource>();
    private CustomizationEngine customizationEngine;
    private HashSet<EClass> metaclasses;
    private Resource resource;
    private final MenuManager menuMgr;
    private boolean dataEditable;
    private final EditingDomain editingDomain;
    private ICommandFactory commandFactory;
    private boolean listenColumn = true;
    private boolean listenReorderEvent = true;
    private Job refreshJob = null;
    private List<InstantiationMethod> launchedInstMethHistory;
    private final Adapter modelChangeAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            int eventType = msg.getEventType();
            if (eventType != 8 && eventType != 9 && NatTableWidget.this.natTable != null && !NatTableWidget.this.natTable.isDisposed()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (NatTableWidget.this.natTable != null && !NatTableWidget.this.natTable.isDisposed()) {
                            NatTableWidget.this.refreshDelayed();
                            NatTableWidget.this.natTable.redraw();
                        }
                    }
                });
            }
        }
    };
    private final Adapter tableInstanceAdapter = new AdapterImpl(){

        public synchronized void notifyChanged(Notification msg) {
            int eventType = msg.getEventType();
            if (eventType != 8 && eventType != 9 && msg.getNotifier() instanceof Resource) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (NatTableWidget.this.tableInstance instanceof TableInstance2) {
                            TableInstance2 tableInstance2 = (TableInstance2)NatTableWidget.this.tableInstance;
                            NatTableWidget.this.facetContext.addFacets((Collection)tableInstance2.getFacets2());
                        }
                        NatTableWidget.this.refreshDelayed();
                    }
                });
            }
        }
    };
    private final Adapter columnAdapter = new AdapterImpl(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification msg) {
            int eventType;
            if (NatTableWidget.this.listenColumn && (eventType = msg.getEventType()) != 8 && eventType != 9 && msg.getNotifier() instanceof Column) {
                Column column = (Column)msg.getNotifier();
                if (msg.getFeature() == TableinstancePackage.eINSTANCE.getColumn_Width()) {
                    int index = NatTableWidget.this.tableInstance.getColumns().indexOf((Object)column);
                    if (index != -1) {
                        3 var5_5 = this;
                        synchronized (var5_5) {
                            NatTableWidget.this.listenColumn = false;
                        }
                        int width = ((Column)NatTableWidget.this.tableInstance.getColumns().get(index)).getWidth();
                        if (width != -1) {
                            NatTableWidget.this.fBodyLayer.getBodyDataLayer().setColumnWidthByPosition(index, width);
                        } else {
                            NatTableWidget.this.fBodyLayer.getBodyDataLayer().setColumnWidthByPosition(index, 150);
                        }
                        3 var6_7 = this;
                        synchronized (var6_7) {
                            NatTableWidget.this.listenColumn = true;
                        }
                    }
                } else if (msg.getFeature() == TableinstancePackage.eINSTANCE.getColumn_IsHidden()) {
                    NatTableWidget.this.updateHiddenColumns();
                }
            }
        }
    };
    private final Adapter rowSizeAdapter = new AdapterImpl(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification msg) {
            int eventType;
            if (NatTableWidget.this.listenColumn && (eventType = msg.getEventType()) != 8 && eventType != 9 && msg.getNotifier() instanceof Row) {
                Row row = (Row)msg.getNotifier();
                int index = NatTableWidget.this.tableInstance.getRows().indexOf((Object)row);
                if (index != -1) {
                    4 var5_5 = this;
                    synchronized (var5_5) {
                        NatTableWidget.this.listenColumn = false;
                    }
                    int heigth = ((Row)NatTableWidget.this.tableInstance.getRows().get(index)).getHeight();
                    if (heigth != -1) {
                        NatTableWidget.this.fBodyLayer.getBodyDataLayer().setRowHeightByPosition(index, heigth);
                    } else {
                        NatTableWidget.this.fBodyLayer.getBodyDataLayer().setRowHeightByPosition(index, 20);
                    }
                    4 var6_7 = this;
                    synchronized (var6_7) {
                        NatTableWidget.this.listenColumn = true;
                    }
                }
            }
        }
    };
    private ChangeListener fCustomizationEngineChangeListener;
    private final FacetContext facetContext = new FacetContext();
    private Action loadCustomizationsAction;
    private Action loadFacetsAction;
    private final List<IActionDelegate> actionList = new ArrayList<IActionDelegate>();

    public NatTableWidget(Composite parent, IEditingDomainProvider editingDomainProvider, TableInstance tableInstanceParam, MenuManager menuMgr) {
        super(parent, 0);
        this.menuMgr = menuMgr;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        if (editingDomainProvider == null || editingDomainProvider.getEditingDomain() == null) {
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
            this.dataEditable = false;
        } else {
            this.editingDomain = editingDomainProvider.getEditingDomain();
            this.dataEditable = true;
        }
        this.commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
        CompoundCommand compoundCommand = new CompoundCommand();
        if (tableInstanceParam == null) {
            this.tableInstance = Tableinstance2Factory.eINSTANCE.createTableInstance2();
            this.resource = this.createDefaultResource();
            this.resource.getContents().add((Object)this.tableInstance);
            this.makeDirty(compoundCommand);
        } else if (tableInstanceParam.eResource() != null) {
            this.tableInstance = tableInstanceParam;
            this.resource = tableInstanceParam.eResource();
        } else {
            this.tableInstance = tableInstanceParam;
            this.resource = this.createDefaultResource();
            this.resource.getContents().add((Object)this.tableInstance);
            this.makeDirty(compoundCommand);
        }
        this.initLaunchedHistory();
        try {
            this.initFacets();
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)this.getShell(), (String)"Failed to load facets", (String)"Some facets failed to load. See error to have more details.");
        }
        this.init();
    }

    private void makeDirty(CompoundCommand compoundCommand) {
        Command setCommand = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Description(), (Object)(String.valueOf(this.tableInstance.getDescription()) + " "));
        compoundCommand.append(setCommand);
        this.editingDomain.getCommandStack().execute((Command)compoundCommand);
    }

    private Resource createDefaultResource() {
        return this.editingDomain.getResourceSet().createResource(URI.createFileURI((String)DEFAULT_RESOURCE_FILE.getPath()));
    }

    private void init() {
        this.customizationEngine = new CustomizationEngine();
        this.setInput();
        this.setLayout((Layout)new FillLayout());
        this.addDisposeListener(this);
        if (this.tableInstance != null) {
            this.tableInstance.eAdapters().add((Object)this.tableInstanceAdapter);
            this.resource.setTrackingModification(true);
            this.resource.eAdapters().add((Object)this.tableInstanceAdapter);
            this.resource = this.tableInstance.eResource();
            for (Column column : this.tableInstance.getColumns()) {
                column.eAdapters().add((Object)this.columnAdapter);
            }
            for (Row row : this.tableInstance.getRows()) {
                row.eAdapters().add((Object)this.rowSizeAdapter);
            }
        }
    }

    private void initFacets() throws CoreException {
        TableInstance2 tableInstance2;
        FacetSetCatalog.getSingleton();
        if (this.tableInstance instanceof TableInstance2 && (tableInstance2 = (TableInstance2)this.tableInstance).getFacets2() != null && !tableInstance2.getFacets2().isEmpty()) {
            this.setFacets((Collection<Facet>)tableInstance2.getFacets2());
        }
    }

    private synchronized void setInput() {
        Control[] children;
        this.checkTableIntegrity();
        boolean reset = false;
        int horizontalScrollbarPos = 0;
        int verticalScrollbarPos = 0;
        PositionCoordinate[] selectedCells = null;
        if (this.natTable != null && !this.natTable.isDisposed()) {
            horizontalScrollbarPos = this.natTable.getHorizontalBar().getSelection();
            verticalScrollbarPos = this.natTable.getVerticalBar().getSelection();
            SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
            selectedCells = selectionLayer.getSelectedCells();
            reset = true;
        }
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control childControl = controlArray[n2];
            childControl.dispose();
            ++n2;
        }
        this.updateMetaClassList();
        String[] columnNames = this.getColumnNames();
        this.tableLabelProvider = new TableLabelProvider((List<Column>)this.tableInstance.getColumns(), this.customizationEngine, this.facetContext);
        this.fBodyDataProvider = new BodyDataProvider((EList<Row>)this.tableInstance.getRows(), this.tableInstance.getColumns().size(), (List<Column>)this.tableInstance.getColumns(), this.getShell(), this.editingDomain, this.tableLabelProvider, this.facetContext);
        DefaultColumnHeaderDataProvider colHeaderDataProvider = new DefaultColumnHeaderDataProvider(columnNames);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)this.fBodyDataProvider);
        this.fBodyLayer = new BodyLayerStack(this.fBodyDataProvider);
        this.fColumnHeaderLayer = new ColumnHeaderLayerStack((IDataProvider)colHeaderDataProvider, this.fBodyLayer, this.fBodyDataProvider);
        this.fRowHeaderLayer = new RowHeaderLayerStack((IDataProvider)rowHeaderDataProvider, this.fBodyLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)colHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)this.fRowHeaderLayer, (ILayer)this.fColumnHeaderLayer);
        this.gridLayer = new GridLayer((ILayer)this.fBodyLayer, (ILayer)this.fColumnHeaderLayer, (ILayer)this.fRowHeaderLayer, (ILayer)cornerLayer, false);
        this.gridLayer.registerCommandHandler((ILayerCommandHandler)new AutoResizeColumnCommandHandler(this.gridLayer));
        this.gridLayer.addConfiguration((IConfiguration)new GridLayerConfiguration(this.gridLayer, this));
        DataLayer bodyDataLayer = this.fBodyLayer.getBodyDataLayer();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.natTable = new NatTable((Composite)this, (ILayer)this.gridLayer, false);
        this.natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.addCustomStyling(this.natTable);
        this.natTable.addConfiguration((IConfiguration)new StyleConfiguration(this.fBodyLayer, this.tableLabelProvider, this.customizationEngine, this));
        if (this.isDataEditable()) {
            this.natTable.addConfiguration((IConfiguration)this.editableGridConfiguration(columnLabelAccumulator, this.fBodyDataProvider));
        }
        this.natTable.configure();
        this.initializeColumnAndRowSize();
        this.addDragAndDropSupport();
        this.addDataLayerListener(this.fBodyLayer.getBodyDataLayer());
        this.addColumnReorderLayerListener(this.fBodyLayer.getColumnReorderLayer());
        this.reapplySettings();
        this.setupContextMenu();
        this.addSelectionListener(this.natTable);
        this.addChangeListener((List<Row>)this.tableInstance.getRows());
        this.layout();
        if (this.tableInstance.getCustomizations() != null) {
            this.loadCustomizationsInCustomEngine((List<MetamodelView>)this.tableInstance.getCustomizations());
        }
        if (reset && !this.natTable.isDisposed()) {
            this.natTable.getHorizontalBar().setSelection(horizontalScrollbarPos);
            this.natTable.getHorizontalBar().notifyListeners(13, new Event());
            this.natTable.getVerticalBar().setSelection(verticalScrollbarPos);
            this.natTable.getVerticalBar().notifyListeners(13, new Event());
            if (selectedCells != null) {
                this.fBodyLayer.getSelectionLayer().clear();
                PositionCoordinate[] positionCoordinateArray = selectedCells;
                int n3 = selectedCells.length;
                int n4 = 0;
                while (n4 < n3) {
                    PositionCoordinate coordinate = positionCoordinateArray[n4];
                    this.fBodyLayer.getSelectionLayer().selectCell(coordinate.columnPosition, coordinate.rowPosition, false, true);
                    ++n4;
                }
            }
        }
        this.natTable.setFocus();
    }

    private void updateMetaClassList() {
        this.metaclasses = new HashSet();
        for (EObject eObject : this.tableInstance.getElements()) {
            this.metaclasses.add(eObject.eClass());
        }
    }

    private void initializeColumnAndRowSize() {
        int i = 0;
        while (i < this.fBodyLayer.getBodyDataLayer().getColumnCount()) {
            if (((Column)this.tableInstance.getColumns().get(i)).getWidth() != -1) {
                this.fBodyLayer.getBodyDataLayer().setColumnWidthByPosition(i, ((Column)this.tableInstance.getColumns().get(i)).getWidth());
            } else {
                this.fBodyLayer.getBodyDataLayer().setColumnWidthByPosition(i, 150);
            }
            ++i;
        }
        i = 0;
        while (i < this.fBodyLayer.getBodyDataLayer().getRowCount()) {
            if (((Row)this.tableInstance.getRows().get(i)).getHeight() != -1) {
                this.fBodyLayer.getBodyDataLayer().setRowHeightByPosition(i, ((Row)this.tableInstance.getRows().get(i)).getHeight());
            } else {
                this.fBodyLayer.getBodyDataLayer().setRowHeightByPosition(i, 20);
            }
            ++i;
        }
    }

    private void initLaunchedHistory() {
        this.launchedInstMethHistory = new ArrayList<InstantiationMethod>();
        if (this.getTableConfiguration() != null && this.getTableConfiguration().getInstantiationMethod() != null) {
            for (InstantiationMethod meth : this.getTableConfiguration().getInstantiationMethod()) {
                this.launchedInstMethHistory.add(meth);
            }
        }
    }

    private void addDragAndDropSupport() {
        int operations = 19;
        DropTarget target = new DropTarget((Control)this.natTable, operations);
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Transfer[] types = new Transfer[]{localTransfer};
        target.setTransfer(types);
        NatTableDropListener dropListener = new NatTableDropListener(this.natTable, this);
        target.addDropListener((DropTargetListener)dropListener);
    }

    private void addColumnReorderLayerListener(ColumnReorderLayer columnReorderLayer) {
        columnReorderLayer.addLayerListener(new ILayerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleLayerEvent(ILayerEvent event) {
                5 var2_2 = this;
                synchronized (var2_2) {
                    if (NatTableWidget.this.listenReorderEvent) {
                        5 var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = false;
                        }
                        if (event instanceof ColumnReorderEvent) {
                            ColumnReorderEvent columnReorderEvent = (ColumnReorderEvent)event;
                            int start = -1;
                            int end = columnReorderEvent.getBeforeToColumnPosition();
                            Iterator iterator = columnReorderEvent.getBeforeFromColumnPositionRanges().iterator();
                            if (iterator.hasNext()) {
                                Range range = (Range)iterator.next();
                                start = range.start;
                            }
                            if (start != -1) {
                                EObject element;
                                if (start >= 0 && start < end) {
                                    --end;
                                }
                                if ((element = (EObject)NatTableWidget.this.tableInstance.getColumns().get(start)) != null) {
                                    Command command = NatTableWidget.this.commandFactory.createMoveCommand(NatTableWidget.this.editingDomain, (Object)NatTableWidget.this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)element, end);
                                    NatTableWidget.this.editingDomain.getCommandStack().execute(command);
                                }
                            }
                        }
                        var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = true;
                        }
                    }
                }
            }
        });
    }

    private void addDataLayerListener(DataLayer dataLayer) {
        dataLayer.addLayerListener(new ILayerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleLayerEvent(ILayerEvent event) {
                6 var2_2 = this;
                synchronized (var2_2) {
                    if (NatTableWidget.this.listenColumn) {
                        6 var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = false;
                        }
                        if (event instanceof ColumnResizeEvent) {
                            ColumnResizeEvent columnResizeEvent = (ColumnResizeEvent)event;
                            Collection rangeList = columnResizeEvent.getColumnPositionRanges();
                            for (Range r : rangeList) {
                                if (r.start == -1) continue;
                                int width = NatTableWidget.this.fBodyLayer.getColumnReorderLayer().getColumnWidthByPosition(r.start);
                                Column column = (Column)NatTableWidget.this.getTableInstance().getColumns().get(r.start);
                                Command cmd = NatTableWidget.this.commandFactory.createSetCommand(NatTableWidget.this.editingDomain, (Object)column, (Object)TableinstancePackage.eINSTANCE.getColumn_Width(), (Object)width);
                                NatTableWidget.this.editingDomain.getCommandStack().execute(cmd);
                            }
                        } else if (event instanceof RowResizeEvent) {
                            RowResizeEvent rowResizeEvent = (RowResizeEvent)event;
                            Collection rangeList = rowResizeEvent.getRowPositionRanges();
                            for (Range r : rangeList) {
                                if (r.start == -1) continue;
                                int height = NatTableWidget.this.getBodyLayer().getViewportLayer().getRowHeightByPosition(r.start);
                                Row row = (Row)NatTableWidget.this.getTableInstance().getRows().get(r.start);
                                Command cmd = NatTableWidget.this.commandFactory.createSetCommand(NatTableWidget.this.editingDomain, (Object)row, (Object)TableinstancePackage.eINSTANCE.getRow_Height(), (Object)height);
                                NatTableWidget.this.editingDomain.getCommandStack().execute(cmd);
                            }
                        }
                        var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = true;
                        }
                    }
                }
            }
        });
    }

    private void reapplySettings() {
        this.updateHiddenColumns();
    }

    private void addChangeListener(List<Row> elementsValue) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Row row : elementsValue) {
            EObject eObject = row.getElement();
            if (eObject == null) continue;
            resources.add(eObject.eResource());
        }
        for (Resource referedResource : resources) {
            if (referedResource == null || this.listenedResources.contains(referedResource)) continue;
            this.listenedResources.add(referedResource);
            referedResource.setTrackingModification(true);
            if (referedResource.eAdapters().contains((Object)this.modelChangeAdapter)) continue;
            referedResource.eAdapters().add((Object)this.modelChangeAdapter);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        for (Resource resourceElt : this.listenedResources) {
            resourceElt.eAdapters().remove((Object)this.modelChangeAdapter);
        }
    }

    private static Object getStructuralFeatureValue(EObject eObject, EStructuralFeature structuralFeature) {
        return eObject.eGet(structuralFeature);
    }

    private static boolean hasStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        EClass eClass = eObject.eClass();
        return eClass.getEAllStructuralFeatures().contains((Object)structuralFeature);
    }

    private void addSelectionListener(NatTable natTableValue) {
        natTableValue.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent || event instanceof RowSelectionEvent || event instanceof ColumnSelectionEvent) {
                    NatTableWidget.this.tableSelectionChanged();
                }
            }
        });
    }

    protected void tableSelectionChanged() {
        for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this.fSelectionChangedListeners)) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public ISelection getSelection() {
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        List<Integer> selectedRows = this.getSelectedRows();
        for (Integer current : selectedRows) {
            Row row = (Row)this.tableInstance.getRows().get(current.intValue());
            if (row == null) continue;
            selectedEObjects.add(row.getElement());
        }
        if (this.fBodyLayer != null) {
            PositionCoordinate[] selectedCells;
            SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
            PositionCoordinate[] positionCoordinateArray = selectedCells = selectionLayer.getSelectedCells();
            int n = selectedCells.length;
            int n2 = 0;
            while (n2 < n) {
                GridElement gridElement;
                EObject eObject;
                Object dataValue;
                LayerCell cell;
                PositionCoordinate positionCoordinate = positionCoordinateArray[n2];
                if (!selectedRows.contains(positionCoordinate.getRowPosition()) && (cell = selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition())) != null && (dataValue = cell.getDataValue()) instanceof GridElement && (eObject = NatTableWidget.getEObject(gridElement = (GridElement)dataValue)) != null) {
                    selectedEObjects.add(eObject);
                }
                ++n2;
            }
        }
        return new StructuredSelection(selectedEObjects);
    }

    private List<Integer> getSelectedRows() {
        ArrayList<Integer> rowsIndex = new ArrayList<Integer>();
        if (this.fBodyLayer != null) {
            int[] selectedRows;
            SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
            int[] nArray = selectedRows = selectionLayer.getFullySelectedRowPositions();
            int n = selectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                rowsIndex.add(index);
                ++n2;
            }
        }
        return rowsIndex;
    }

    public List<LayerCell> getSelectedCells() {
        PositionCoordinate[] selectedPositions;
        ArrayList<LayerCell> selectedCells = new ArrayList<LayerCell>();
        SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
        PositionCoordinate[] positionCoordinateArray = selectedPositions = selectionLayer.getSelectedCells();
        int n = selectedPositions.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate positionCoordinate = positionCoordinateArray[n2];
            LayerCell cell = selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition());
            if (cell != null) {
                selectedCells.add(cell);
            }
            ++n2;
        }
        return selectedCells;
    }

    public List<PositionCoordinate> getSelectedCellsPositions() {
        PositionCoordinate[] selectedCells = this.fBodyLayer.getSelectionLayer().getSelectedCells();
        return Arrays.asList(selectedCells);
    }

    public int convertColumnPositionDataToHideShow(int column) {
        int i = 0;
        while (i < this.fBodyDataProvider.getColumnCount()) {
            ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate((ILayer)this.fBodyLayer.getColumnHideShowLayer(), i), (ILayer)this.fBodyLayer.getBodyDataLayer());
            if (converted != null && converted.getColumnPosition() == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int convertColumnPositionDataToReorder(int column) {
        int i = 0;
        while (i < this.fBodyDataProvider.getColumnCount()) {
            ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate((ILayer)this.fBodyLayer.getColumnReorderLayer(), i), (ILayer)this.fBodyLayer.getBodyDataLayer());
            if (converted.getColumnPosition() == column) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("column index not found");
    }

    public int convertColumnPositionSelectionToData(int column) {
        ColumnPositionCoordinate columnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate((ILayer)this.getBodyLayer().getSelectionLayer(), column), (ILayer)this.getBodyLayer().getBodyDataLayer());
        return columnPositionCoordinate.getColumnPosition();
    }

    public int convertCellPositionToDataLayer(LayerCell cell) {
        ColumnPositionCoordinate columnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()), (ILayer)this.getBodyLayer().getBodyDataLayer());
        return columnPositionCoordinate.getColumnPosition();
    }

    public void setSelection(ISelection selection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.fSelectionChangedListeners.contains(listener)) {
            this.fSelectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove(listener);
    }

    private void addCustomStyling(NatTable natTableValue) {
        DefaultNatTableStyleConfiguration natTableConfiguration = new DefaultNatTableStyleConfiguration();
        natTableConfiguration.hAlign = HorizontalAlignmentEnum.LEFT;
        natTableConfiguration.vAlign = VerticalAlignmentEnum.TOP;
        DefaultSelectionStyleConfiguration selectionStyle = new DefaultSelectionStyleConfiguration();
        selectionStyle.selectionBgColor = BG_COLOR;
        selectionStyle.selectionFgColor = GUIHelper.COLOR_BLACK;
        selectionStyle.anchorBorderStyle = new BorderStyle(1, GUIHelper.COLOR_DARK_GRAY, BorderStyle.LineStyleEnum.SOLID);
        selectionStyle.anchorBgColor = BG_COLOR;
        selectionStyle.anchorFgColor = GUIHelper.COLOR_BLACK;
        selectionStyle.selectedHeaderFgColor = GUIHelper.COLOR_BLACK;
        natTableValue.addConfiguration((IConfiguration)natTableConfiguration);
        natTableValue.addConfiguration((IConfiguration)selectionStyle);
        natTableValue.addConfiguration((IConfiguration)new StyledRowHeaderConfiguration());
        natTableValue.addConfiguration((IConfiguration)new StyledColumnHeaderConfiguration(this.fBodyLayer, (List<Column>)this.tableInstance.getColumns(), new CustomizableLabelProvider(this.customizationEngine)));
    }

    public AbstractRegistryConfiguration editableGridConfiguration(final ColumnOverrideLabelAccumulator columnLabelAccumulator, IDataProvider dataProvider) {
        return new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                if (NatTableWidget.this.editingDomain != null) {
                    int nColumn = 0;
                    while (nColumn < NatTableWidget.this.tableInstance.getColumns().size()) {
                        Column columnDescription = (Column)NatTableWidget.this.tableInstance.getColumns().get(nColumn);
                        if (columnDescription instanceof AttributeColumn) {
                            AttributeColumn attributeColumn = (AttributeColumn)columnDescription;
                            if (attributeColumn.getAttribute().getEType() instanceof EEnum) {
                                NatTableWidget.this.registerEnumCellEditor(configRegistry, (EEnum)attributeColumn.getFeature().getEType(), columnLabelAccumulator, nColumn, columnDescription);
                            } else {
                                NatTableWidget.this.registerCellEditorForColumn(columnLabelAccumulator, nColumn, columnDescription);
                            }
                        } else {
                            NatTableWidget.this.registerCellEditorForColumn(columnLabelAccumulator, nColumn, columnDescription);
                        }
                        ++nColumn;
                    }
                    List allCellEditorContainers = ICellEditorsRegistry.INSTANCE.getAllCellEditors();
                    for (IModelCellEditorContainer modelCellEditorContainer : allCellEditorContainers) {
                        NatTableWidget.this.registerCellEditor((IModelCellEditorContainer<? extends AbstractModelCellEditor>)modelCellEditorContainer, configRegistry);
                    }
                }
            }
        };
    }

    private void registerCellEditorForColumn(ColumnOverrideLabelAccumulator columnLabelAccumulator, int nColumn, Column column) {
        if (column instanceof FeatureColumn) {
            ModelCellEditor selectedCellEditor;
            FeatureColumn featureColumn = (FeatureColumn)column;
            EStructuralFeature feature = featureColumn.getFeature();
            if (!feature.isChangeable()) {
                return;
            }
            TableConfiguration tableConfiguration = this.getTableConfiguration();
            EList forcedCellEditors = null;
            if (tableConfiguration != null) {
                forcedCellEditors = tableConfiguration.getForcedCellEditors();
            }
            if ((selectedCellEditor = ((CellEditorsRegistry)ICellEditorsRegistry.INSTANCE).getCellEditorWrapperFor(feature.getEType(), feature.isMany(), (List)forcedCellEditors)) != null) {
                columnLabelAccumulator.registerColumnOverrides(nColumn, new String[]{selectedCellEditor.getCellID()});
            } else {
                Logger.logWarning((String)("No cell editor defined for type: " + EcoreUtil.getURI((EObject)feature.getEType()) + " (column " + nColumn + ")"), (Plugin)Activator.getDefault());
            }
        }
    }

    private void registerEnumCellEditor(IConfigRegistry configRegistry, EEnum eType, ColumnOverrideLabelAccumulator columnLabelAccumulator, int nColumn, Column columnDescription) {
        columnLabelAccumulator.registerColumnOverrides(nColumn, new String[]{ENUM_CELLEDITOR_LABEL});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new NatTableCellEditorAdapter((IModelCellEditor)new EEnumCellEditor(), (List<Column>)this.tableInstance.getColumns(), this.facetContext), "NORMAL", ENUM_CELLEDITOR_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", ENUM_CELLEDITOR_LABEL);
    }

    private void registerCellEditor(IModelCellEditorContainer<? extends AbstractModelCellEditor> modelCellEditorContainer, IConfigRegistry configRegistry) {
        IModelCellEditor modelCellEditorImpl;
        ModelCellEditor cellEditor = new ModelCellEditor(modelCellEditorContainer.getBundleName(), modelCellEditorContainer.getModelCellEditor());
        Object cellEditorImplementation = cellEditor.getCellEditorImplementation();
        if (cellEditorImplementation instanceof IModelCellEditor) {
            modelCellEditorImpl = (IModelCellEditor)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new NatTableCellEditorAdapter(modelCellEditorImpl, (List<Column>)this.tableInstance.getColumns(), this.facetContext), "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
        } else if (cellEditorImplementation instanceof INaryFeatureCellEditor) {
            modelCellEditorImpl = (INaryFeatureCellEditor)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new NatTableNaryReferenceCellEditorAdapter((INaryFeatureCellEditor)modelCellEditorImpl, (List<Column>)this.tableInstance.getColumns(), this.editingDomain), "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)IDataValidator.NEVER_VALID, "EDIT", cellEditor.getCellID());
        } else if (cellEditorImplementation instanceof INaryEAttributeCellEditor) {
            modelCellEditorImpl = (INaryEAttributeCellEditor)cellEditorImplementation;
            NatTableNaryEAttributeCellEditorAdapter cellEditorAdapter = new NatTableNaryEAttributeCellEditorAdapter(modelCellEditorImpl, (List<Column>)this.tableInstance.getColumns(), this.facetContext, this.editingDomain);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, cellEditorAdapter, "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)IDataValidator.NEVER_VALID, "EDIT", cellEditor.getCellID());
        } else if (cellEditorImplementation instanceof INaryEReferenceCellEditor) {
            modelCellEditorImpl = (INaryEReferenceCellEditor)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, new NatTableNaryEReferenceCellEditorAdapter(modelCellEditorImpl, (List<Column>)this.tableInstance.getColumns(), this.facetContext, this.editingDomain), "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)IDataValidator.NEVER_VALID, "EDIT", cellEditor.getCellID());
        } else {
            Logger.logError((String)("Model cell editor implementation must be an instance of " + IModelCellEditor.class.getSimpleName() + " or " + INaryFeatureCellEditor.class.getSimpleName()), (Plugin)Activator.getDefault());
            return;
        }
        if (cellEditorImplementation instanceof IModelCellEditorValidator) {
            IModelCellEditorValidator modelCellEditorValidator = (IModelCellEditorValidator)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new DataValidatorAdapter(modelCellEditorValidator), "EDIT", cellEditor.getCellID());
        }
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.tableInstance.getColumns().size()];
        int i = 0;
        while (i < this.tableInstance.getColumns().size()) {
            String columnName;
            Column columnDescription = (Column)this.tableInstance.getColumns().get(i);
            columnNames[i] = columnName = NatTableWidgetInternalUtils.getColumnName(columnDescription);
            ++i;
        }
        return columnNames;
    }

    protected boolean isColumnAlreadyDeclared(EStructuralFeature eStructuralFeature) {
        block3: {
            block2: {
                if (!(eStructuralFeature instanceof EReference)) break block2;
                for (Column c : this.tableInstance.getColumns()) {
                    if (!(c instanceof ReferenceColumn ? ((ReferenceColumn)c).getReference() == eStructuralFeature : c instanceof FacetReferenceColumn && ((FacetReferenceColumn)c).getReference() == eStructuralFeature)) continue;
                    return true;
                }
                break block3;
            }
            if (!(eStructuralFeature instanceof EAttribute)) break block3;
            for (Column c : this.tableInstance.getColumns()) {
                if (!(c instanceof AttributeColumn ? ((AttributeColumn)c).getAttribute() == eStructuralFeature : c instanceof FacetAttributeColumn && ((FacetAttributeColumn)c).getAttribute() == eStructuralFeature)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean setFocus() {
        return this.natTable.setFocus();
    }

    @Override
    public void sortColumnsByType() {
        try {
            try {
                Column columnDescription;
                Column columnDescription2;
                this.natTable.setRedraw(false);
                this.listenReorderEvent = false;
                int[] order = new int[this.tableInstance.getColumns().size()];
                int i = 0;
                int j = 0;
                while (j < this.tableInstance.getColumns().size()) {
                    columnDescription2 = (Column)this.tableInstance.getColumns().get(j);
                    if (columnDescription2 instanceof DefaultLabelColumn) {
                        order[i++] = j;
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.tableInstance.getColumns().size()) {
                    columnDescription2 = (Column)this.tableInstance.getColumns().get(j);
                    if (columnDescription2 instanceof ContextColumn || columnDescription2 instanceof EContainerColumn || columnDescription2 instanceof MetaClassColumn) {
                        order[i++] = j;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.tableInstance.getColumns().size()) {
                    columnDescription2 = (Column)this.tableInstance.getColumns().get(j);
                    if (columnDescription2 instanceof AttributeColumn) {
                        order[i++] = j;
                    }
                    ++j;
                }
                ArrayList<Integer> links = new ArrayList<Integer>();
                int j2 = 0;
                while (j2 < this.tableInstance.getColumns().size()) {
                    columnDescription = (Column)this.tableInstance.getColumns().get(j2);
                    if (columnDescription instanceof ReferenceColumn) {
                        links.add(new Integer(j2));
                    }
                    ++j2;
                }
                for (Integer linkPos : links) {
                    order[i++] = linkPos;
                }
                j = 0;
                while (j < this.tableInstance.getColumns().size()) {
                    columnDescription = (Column)this.tableInstance.getColumns().get(j);
                    if (columnDescription instanceof QueryColumn) {
                        order[i++] = j;
                    }
                    ++j;
                }
                CompoundCommand compoundCommand = new CompoundCommand();
                int index = 0;
                while (index < order.length) {
                    int pos = order[index];
                    EObject element = (EObject)this.tableInstance.getColumns().get(pos);
                    Command command = this.commandFactory.createMoveCommand(this.editingDomain, (Object)this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)element, index);
                    compoundCommand.append(command);
                    ++index;
                }
                this.editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by type", (Plugin)Activator.getDefault());
                this.natTable.setRedraw(true);
                this.listenReorderEvent = true;
            }
        }
        finally {
            this.natTable.setRedraw(true);
            this.listenReorderEvent = true;
        }
    }

    @Override
    public void setHideEmptyColumns(boolean hideEmptyColumns) {
        this.setWithCommand(this.tableInstance, TableinstancePackage.eINSTANCE.getTableInstance_HideEmptyColumns(), hideEmptyColumns);
        this.updateHiddenColumns();
    }

    private boolean isEmptyColumn(Column column) {
        if (column instanceof AttributeColumn) {
            AttributeColumn attributeColumn = (AttributeColumn)column;
            return this.isEmpty((EStructuralFeature)attributeColumn.getAttribute());
        }
        if (column instanceof ReferenceColumn) {
            ReferenceColumn referenceColumn = (ReferenceColumn)column;
            return this.isEmpty((EStructuralFeature)referenceColumn.getReference());
        }
        return false;
    }

    private void updateHiddenColumns() {
        this.customizationEngine.loadCustomizations();
        this.fBodyLayer.getColumnHideShowLayer().showAllColumns();
        ArrayList<Integer> columnsToHide = new ArrayList<Integer>();
        EList tableContents = this.tableInstance.getElements();
        try {
            this.natTable.setRedraw(false);
            int nColumn = 0;
            for (Column column : this.tableInstance.getColumns()) {
                int converted;
                boolean isNonCommon;
                boolean isHidden = false;
                boolean isEmpty = this.getTableInstance().isHideEmptyColumns() && this.isEmptyColumn(column);
                boolean bl = isNonCommon = this.getTableInstance().isOnlyShowCommonColumns() && this.isNonCommonColumns(column);
                if (this.tableInstance instanceof TableInstance2 && column instanceof FeatureColumn && !tableContents.isEmpty()) {
                    EStructuralFeature columnFeature = ((FeatureColumn)column).getFeature();
                    if (column instanceof FacetAttributeColumn) {
                        isHidden = !this.customizationEngine.isAttributeVisibleStatic((EClass)columnFeature.eContainer(), columnFeature.getName());
                    } else if (column instanceof FacetReferenceColumn) {
                        isHidden = !this.customizationEngine.isReferenceVisibleStatic((EClass)columnFeature.eContainer(), columnFeature.getName());
                    } else {
                        Set featureOwner = EMFUtils.getAllFeatureOwner((List)tableContents, (EStructuralFeature)columnFeature);
                        isHidden = this.getHiddenColumnStatus((FeatureColumn)column, featureOwner);
                    }
                } else {
                    isHidden = column.isIsHidden();
                }
                if ((isHidden || isNonCommon || isEmpty) && (converted = this.convertColumnPositionDataToHideShow(nColumn)) != -1) {
                    columnsToHide.add(new Integer(converted));
                }
                ++nColumn;
            }
        }
        finally {
            this.natTable.setRedraw(true);
        }
        this.fBodyLayer.getColumnHideShowLayer().hideColumnPositions(columnsToHide);
    }

    private boolean getHiddenColumnStatus(FeatureColumn c, Set<EClass> featureOwners) {
        if (c instanceof AttributeColumn) {
            return this.getHiddenAttributeColumnStatus((AttributeColumn)c, featureOwners);
        }
        if (c instanceof ReferenceColumn) {
            return this.getHiddenReferenceColumnStatus((ReferenceColumn)c, featureOwners);
        }
        if (c instanceof FacetAttributeColumn) {
            return !this.customizationEngine.isAttributeVisibleStatic((EClass)c.getFeature().eContainer(), c.getFeature().getName());
        }
        if (c instanceof FacetReferenceColumn) {
            return !this.customizationEngine.isReferenceVisibleStatic((EClass)c.getFeature().eContainer(), c.getFeature().getName());
        }
        return false;
    }

    private boolean getHiddenAttributeColumnStatus(AttributeColumn c, Set<EClass> featureOwners) {
        boolean conflict = false;
        EStructuralFeature feature = c.getFeature();
        String featureName = feature.getName();
        Iterator<EClass> iter = featureOwners.iterator();
        if (iter.hasNext()) {
            boolean visibility = this.customizationEngine.isAttributeVisibleStatic(iter.next(), featureName);
            while (iter.hasNext()) {
                if (visibility == this.customizationEngine.isAttributeVisibleStatic(iter.next(), featureName)) continue;
                conflict = true;
                break;
            }
            if (conflict) {
                EClass commonSupertype = EMFUtils.computeLeastCommonSupertype(featureOwners, (EStructuralFeature)feature);
                visibility = this.customizationEngine.isAttributeVisibleStatic(commonSupertype, featureName);
            }
            return !visibility;
        }
        return false;
    }

    private boolean getHiddenReferenceColumnStatus(ReferenceColumn c, Set<EClass> featureOwner) {
        boolean conflict = false;
        EStructuralFeature feature = c.getFeature();
        String featureName = feature.getName();
        Iterator<EClass> iter = featureOwner.iterator();
        if (iter.hasNext()) {
            boolean visibility = this.customizationEngine.isReferenceVisibleStatic(iter.next(), featureName);
            while (iter.hasNext()) {
                if (visibility == this.customizationEngine.isReferenceVisibleStatic(iter.next(), featureName)) continue;
                conflict = true;
                break;
            }
            if (conflict) {
                EClass commonSupertype = EMFUtils.computeLeastCommonSupertype(featureOwner, (EStructuralFeature)feature);
                visibility = this.customizationEngine.isReferenceVisibleStatic(commonSupertype, featureName);
            }
            return !visibility;
        }
        return false;
    }

    @Override
    public void selectColumnsToHide() {
        this.openColumnsToHideDialog();
    }

    @Override
    public IColumnsToHideDialog openColumnsToHideDialog() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Column) {
                    Column column = (Column)element;
                    return NatTableWidgetInternalUtils.getColumnName(column);
                }
                return null;
            }
        };
        ColumnComparator columnComparator = new ColumnComparator();
        SortedColumnContentProvider contentProvider = new SortedColumnContentProvider();
        contentProvider.setComparator(columnComparator);
        contentProvider.setIsSorted(false);
        String mustPutOnTheTop = Activator.getDefault().getPreferenceStore().getString("answer_nattable_editor_select_column_to_hide");
        boolean localCustomizatinMustBeTheTop = mustPutOnTheTop.equals("Yes");
        boolean askToPutOnTheTopTheLocalCustomization = !Activator.getDefault().getPreferenceStore().getBoolean("nattable_editor_select_column_to_hide");
        final ColumnsToHideDialog dialog = new ColumnsToHideDialog(this.getShell(), this.getTableInstance().getColumns(), (ILabelProvider)labelProvider, contentProvider, this.isOneOfTheLocalCustomizationsNotOnTheTop() && askToPutOnTheTopTheLocalCustomization, localCustomizatinMustBeTheTop){

            protected void okPressed() {
                super.okPressed();
                if (this.getResult() != null) {
                    NatTableWidget.this.showHideColumns(this.getSelectedColumns(), this.getPutOnTheTop() && NatTableWidget.this.isOneOfTheLocalCustomizationsNotOnTheTop());
                    NatTableWidget.setMustAskThUserToPutOnTheTopTheLocalCustomizationNextTime(this.getMustAskTheUserNextTime(), this.getPutOnTheTop());
                }
            }

            @Override
            public List<Column> getVisibleColumns(boolean putOnTheTop) {
                return NatTableWidget.this.getVisibleColumns(putOnTheTop);
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog;
    }

    private static void setMustAskThUserToPutOnTheTopTheLocalCustomizationNextTime(boolean mustAskTheUserNextTime, boolean putOnTheTop) {
        Activator.getDefault().getPreferenceStore().setValue("nattable_editor_select_column_to_hide", !mustAskTheUserNextTime);
        if (!mustAskTheUserNextTime) {
            if (putOnTheTop) {
                Activator.getDefault().getPreferenceStore().setValue("answer_nattable_editor_select_column_to_hide", "Yes");
            } else {
                Activator.getDefault().getPreferenceStore().setValue("answer_nattable_editor_select_column_to_hide", "No");
            }
        }
    }

    @Override
    public void showHideColumns(List<Column> result, boolean putOnTheTop) {
        ArrayList<Column> columnsToShow = new ArrayList<Column>();
        ArrayList<Column> columnsToHide = new ArrayList<Column>();
        EList columns = this.getTableInstance().getColumns();
        for (Column c : columns) {
            boolean mustBeHidden;
            boolean bl = mustBeHidden = !result.contains(c);
            if (this.tableInstance instanceof TableInstance2) {
                if (mustBeHidden != this.getVisibleColumns(putOnTheTop).contains(c)) continue;
                if (mustBeHidden) {
                    columnsToHide.add(c);
                    continue;
                }
                columnsToShow.add(c);
                continue;
            }
            if (mustBeHidden == c.isIsHidden()) continue;
            if (mustBeHidden) {
                columnsToHide.add(c);
                continue;
            }
            columnsToShow.add(c);
        }
        this.showHideColumns(columnsToShow, columnsToHide, putOnTheTop);
    }

    @Override
    public boolean isOneOfTheLocalCustomizationsNotOnTheTop() {
        EList view = this.tableInstance.getCustomizations();
        List<MetamodelView> locals = this.getLocalCustomizations();
        if (this.tableInstance instanceof TableInstance2) {
            if (view.size() < locals.size()) {
                throw new RuntimeException("Some local customization files are not loaded");
            }
            int i = 0;
            while (i < locals.size()) {
                if (!locals.contains(view.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected List<MetamodelView> getLocalCustomizations() {
        ArrayList<MetamodelView> locals = new ArrayList<MetamodelView>();
        if (this.tableInstance.getLocalCustomization() != null) {
            locals.add(this.tableInstance.getLocalCustomization());
        }
        if (this.tableInstance instanceof TableInstance2) {
            locals.addAll((Collection<MetamodelView>)((TableInstance2)this.tableInstance).getLocalCustomizations());
        }
        return locals;
    }

    public List<Column> getNotHiddenColumns(int setAtTheTop, boolean atTheTop) {
        List<Object> notHiddenColumns = new ArrayList();
        if (this.tableInstance instanceof TableInstance2) {
            if (atTheTop) {
                notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations((TableInstance2)this.tableInstance, false);
            } else if (setAtTheTop == 3) {
                notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations((TableInstance2)this.tableInstance, false);
            } else if (setAtTheTop == 2) {
                notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations((TableInstance2)this.tableInstance, true);
            }
        } else {
            notHiddenColumns = this.getVisibleColumnsUsingTheModel();
        }
        return notHiddenColumns;
    }

    private void showHideColumns(List<Column> columnsToShow, List<Column> columnsToHide, boolean putOnTheTop) {
        Command showHideColumnsCommand = TableInstanceCommandFactory.createShowHideColumnCommand(this, columnsToShow, columnsToHide, putOnTheTop);
        if (showHideColumnsCommand.canExecute()) {
            this.editingDomain.getCommandStack().execute(showHideColumnsCommand);
        }
        this.customizationEngine.loadCustomizations();
        this.updateHiddenColumns();
    }

    @Override
    public void putLocalCustomizationOnTheTop() {
        this.editingDomain.getCommandStack().execute(TableInstanceCommandFactory.createPutLocalCustomizationOnTheTopCommand(this));
        this.loadCustomizationsInCustomEngine((List<MetamodelView>)this.tableInstance.getCustomizations());
    }

    public List<Column> getVisibleColumnsUsingCustomizationEngine(TableInstance2 table) {
        ArrayList<Column> visibleColumns = new ArrayList<Column>();
        EList columns = table.getColumns();
        int i = 0;
        while (i < columns.size()) {
            Column column = (Column)columns.get(i);
            if (column instanceof FeatureColumn) {
                Set owners = EMFUtils.getAllFeatureOwner((List)table.getElements(), (EStructuralFeature)((FeatureColumn)column).getFeature());
                if (!this.getHiddenColumnStatus((FeatureColumn)column, owners)) {
                    visibleColumns.add(column);
                }
            } else if (!column.isIsHidden()) {
                visibleColumns.add(column);
            }
            ++i;
        }
        return visibleColumns;
    }

    @Override
    public List<Column> getVisibleColumnsUsingTheLocalCustomizations(TableInstance2 table, boolean setToTheTop) {
        ArrayList<Column> notHiddenColumns = new ArrayList<Column>();
        List<MetamodelView> locals = this.getLocalCustomizations();
        CustomizationEngine localEngine = new CustomizationEngine();
        if (!setToTheTop) {
            for (MetamodelView current : locals) {
                localEngine.registerMetamodel(current.getMetamodelURI());
                localEngine.registerCustomization(current);
            }
        } else {
            for (MetamodelView current : this.tableInstance.getCustomizations()) {
                localEngine.registerCustomization(current);
                localEngine.registerMetamodel(current.getMetamodelURI());
            }
        }
        localEngine.loadCustomizations();
        EList allColumns = table.getColumns();
        int i = 0;
        while (i < allColumns.size()) {
            Column c = (Column)allColumns.get(i);
            boolean isVisible = true;
            if (c instanceof FeatureColumn) {
                EStructuralFeature feature = ((FeatureColumn)c).getFeature();
                String featureName = feature.getName();
                if (c instanceof FacetAttributeColumn) {
                    isVisible = this.customizationEngine.isAttributeVisibleStatic((EClass)feature.eContainer(), featureName);
                } else if (c instanceof FacetReferenceColumn) {
                    isVisible = this.customizationEngine.isReferenceVisibleStatic((EClass)feature.eContainer(), featureName);
                } else {
                    Set featureOwners = EMFUtils.getAllFeatureOwner((List)this.tableInstance.getElements(), (EStructuralFeature)feature);
                    EClass commonSupertype = EMFUtils.computeLeastCommonSupertype((Collection)featureOwners, (EStructuralFeature)feature);
                    if (c instanceof AttributeColumn) {
                        isVisible = localEngine.isAttributeVisibleStatic(commonSupertype, featureName);
                    } else if (c instanceof ReferenceColumn) {
                        isVisible = localEngine.isReferenceVisibleStatic(commonSupertype, featureName);
                    }
                }
            } else {
                boolean bl = isVisible = !c.isIsHidden();
            }
            if (isVisible) {
                notHiddenColumns.add(c);
            }
            ++i;
        }
        return notHiddenColumns;
    }

    private List<Column> getVisibleColumnsUsingTheModel() {
        ArrayList<Column> notHiddenColumns = new ArrayList<Column>();
        EList allColumns = this.tableInstance.getColumns();
        for (Column current : allColumns) {
            if (current.isIsHidden()) continue;
            notHiddenColumns.add(current);
        }
        return notHiddenColumns;
    }

    @Deprecated
    public void hideColumns() {
        this.selectColumnsToHide();
    }

    private boolean isEmpty(EStructuralFeature reference) {
        for (EObject eObject : this.tableInstance.getElements()) {
            List list;
            if (!NatTableWidget.hasStructuralFeature(eObject, reference)) continue;
            Object value = NatTableWidget.getStructuralFeatureValue(eObject, reference);
            if (!(reference.isMany() && value instanceof List ? !(list = (List)value).isEmpty() : value != null)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setOnlyShowCommonColumns(boolean onlyShowCommonColumns) {
        this.setWithCommand(this.tableInstance, TableinstancePackage.eINSTANCE.getTableInstance_OnlyShowCommonColumns(), onlyShowCommonColumns);
    }

    @Override
    public boolean isCellSelected() {
        return this.fBodyLayer.getSelectionLayer().getSelectedCells().length > 0;
    }

    @Override
    public boolean isColumnSelected() {
        return this.getSelectedColumns().size() > 0;
    }

    @Override
    public void removeLine() {
        Command removeLineCommand = TableInstanceCommandFactory.createRemoveLineCommand(this);
        this.editingDomain.getCommandStack().execute(removeLineCommand);
    }

    @Override
    public void deleteSelection() {
        if (this.isCellsDeletable()) {
            this.deleteSelectedElement();
        } else if (this.isSelectedColumnDeletable()) {
            this.deleteSelectedColumn();
        }
    }

    private void deleteSelectedColumn() {
        Command deleteSelectedColumnCommand = TableInstanceCommandFactory.createDeleteSelectedColumnCommand(this);
        this.editingDomain.getCommandStack().execute(deleteSelectedColumnCommand);
    }

    public List<Column> getSelectedColumns() {
        SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
        ArrayList<Column> listColumn = new ArrayList<Column>();
        List<LayerCell> selectedCells = this.getSelectedCells();
        int[] nArray = selectionLayer.getSelectedColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int colPos = nArray[n2];
            if (this.isColumnSelected(colPos, selectedCells)) {
                int pos = this.fBodyLayer.getSelectionLayer().getColumnIndexByPosition(colPos);
                if (this.tableInstance.getColumns().get(pos) != null) {
                    Column localColumn = (Column)this.tableInstance.getColumns().get(pos);
                    listColumn.add(localColumn);
                }
            } else {
                return null;
            }
            ++n2;
        }
        return listColumn;
    }

    private boolean isColumnSelected(int colPos, List<LayerCell> selectedCells) {
        int rowPos = 0;
        while (rowPos < this.fBodyLayer.getRowCount()) {
            LayerCell localCell = this.fBodyLayer.getSelectionLayer().getCellByPosition(colPos, rowPos);
            if (localCell != null && !selectedCells.contains(localCell)) {
                return false;
            }
            ++rowPos;
        }
        return true;
    }

    private void deleteSelectedElement() {
        Command deleteSelectedElementCommand = TableInstanceCommandFactory.createDeleteSelectedElementCommand(this, this.commandFactory);
        this.editingDomain.getCommandStack().execute(deleteSelectedElementCommand);
    }

    @Override
    public void addQueryColumn() {
        QuerySelectionDialog query = new QuerySelectionDialog(this.getShell(), false, null, null);
        query.open();
        if (query.getReturnCode() == 0) {
            CompoundCommand compoundCommand = new CompoundCommand();
            QueryColumn queryColumn = TableinstanceFactory.eINSTANCE.createQueryColumn();
            if (!query.getSelectedQueries().isEmpty()) {
                queryColumn.setQuery((ModelQuery)query.getSelectedQueries().get(0));
                Command command = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)queryColumn);
                compoundCommand.append(command);
                this.editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    @Override
    public List<InstantiationMethod> getInstantionMethodHistory() {
        return this.launchedInstMethHistory;
    }

    @Override
    public void selectInstantiationMethodToLaunch() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof InstantiationMethod) {
                    InstantiationMethod meth = (InstantiationMethod)element;
                    return meth.getName();
                }
                return null;
            }
        };
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            private Object[] objects;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof List) {
                    List list = (List)newInput;
                    this.objects = list.toArray();
                }
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.objects;
            }
        };
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setContentProvider(contentProvider);
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setInput(this.launchedInstMethHistory);
        dialog.setTitle(Messages.NatTableWidget_instantiationMethodSelectionTitle);
        if (dialog.open() != 1 && dialog.getResult()[0] instanceof InstantiationMethod) {
            InstantiationMethod meth = (InstantiationMethod)dialog.getResult()[0];
            this.launchedInstMethHistory.remove(meth);
            this.launchedInstMethHistory.add(0, meth);
            this.createNewElement();
        }
    }

    @Override
    public void createNewElement() {
        if (this.launchedInstMethHistory.get(0) != null) {
            this.createNewElement(this.launchedInstMethHistory.get(0));
        } else {
            this.selectInstantiationMethodToLaunch();
        }
    }

    @Override
    public void createNewElement(InstantiationMethod instantiationMethod) {
        try {
            this.createNewElement2(instantiationMethod);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createNewElement2(InstantiationMethod instantiationMethod) throws Exception {
        ModelQuery query = instantiationMethod.getInstantiationQuery();
        if (query != null) {
            ArrayList<ModelQueryParameterValue> parameters = new ArrayList<ModelQueryParameterValue>();
            ModelQueryParameterValue freeParameterValue = RuntimeFactory.eINSTANCE.createModelQueryParameterValue();
            freeParameterValue.setParameter(InstantiationMethodParameters.getFreeParemeter());
            freeParameterValue.setValue(this.getParameter());
            parameters.add(freeParameterValue);
            Object object = null;
            AbstractModelQuery queryImpl = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(query);
            if (queryImpl instanceof AbstractModelQueryWithEditingDomain) {
                AbstractModelQueryWithEditingDomain queryImplWithEditingDomain = (AbstractModelQueryWithEditingDomain)queryImpl;
                if (queryImplWithEditingDomain.getModelQuery() instanceof IJavaModelQueryWithEditingDomain) {
                    object = queryImplWithEditingDomain.basicEvaluate(this.getContext(), parameters, this.editingDomain);
                } else {
                    ModelQueryParameterValue editingDomainValue = RuntimeFactory.eINSTANCE.createModelQueryParameterValue();
                    editingDomainValue.setParameter(InstantiationMethodParameters.getEditingDomainParameter());
                    editingDomainValue.setValue((Object)this.editingDomain);
                    parameters.add(editingDomainValue);
                    object = queryImplWithEditingDomain.basicEvaluate(this.getContext(), parameters);
                }
            } else {
                throw new Exception();
            }
            if (object != null && object instanceof EObject) {
                ArrayList<EObject> list = new ArrayList<EObject>();
                list.add((EObject)object);
                this.addRows(list);
            }
            this.launchedInstMethHistory.remove(instantiationMethod);
            this.launchedInstMethHistory.add(0, instantiationMethod);
        }
    }

    private boolean isNonCommonColumns(Column columnDescription) {
        boolean common = true;
        if (columnDescription instanceof AttributeColumn) {
            AttributeColumn attributeColumn = (AttributeColumn)columnDescription;
            common = this.isCommon((EStructuralFeature)attributeColumn.getAttribute());
        } else if (columnDescription instanceof ReferenceColumn) {
            ReferenceColumn referenceColumn = (ReferenceColumn)columnDescription;
            common = this.isCommon((EStructuralFeature)referenceColumn.getReference());
        }
        return !common;
    }

    private boolean isCommon(EStructuralFeature feature) {
        for (EClass metaclass : this.metaclasses) {
            if (metaclass.getEAllStructuralFeatures().contains((Object)feature)) continue;
            return false;
        }
        return true;
    }

    private static EObject getEObject(GridElement gridElement) {
        if (gridElement == null) {
            return null;
        }
        EObject mainModelElement = gridElement.getElement() instanceof EObject ? (EObject)gridElement.getElement() : null;
        EObject targetObject = null;
        Column column = gridElement.getColumnDescription();
        if (column instanceof AttributeColumn) {
            Object value;
            AttributeColumn attributeColumn = (AttributeColumn)column;
            if (mainModelElement != null && NatTableWidget.hasStructuralFeature(mainModelElement, (EStructuralFeature)attributeColumn.getAttribute()) && (value = NatTableWidget.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)attributeColumn.getAttribute())) instanceof EObject) {
                targetObject = (EObject)value;
            }
        } else if (column instanceof ReferenceColumn) {
            ReferenceColumn referenceColumn = (ReferenceColumn)column;
            if (mainModelElement != null && NatTableWidget.hasStructuralFeature(mainModelElement, (EStructuralFeature)referenceColumn.getReference())) {
                Object value = NatTableWidget.getStructuralFeatureValue(mainModelElement, (EStructuralFeature)referenceColumn.getReference());
                if (referenceColumn.getReference().isMany()) {
                    EList list = (EList)value;
                    if (list.size() == 1) {
                        targetObject = (EObject)list.get(0);
                    }
                } else {
                    targetObject = (EObject)value;
                }
            }
        } else if (column instanceof EContainerColumn) {
            EObject value;
            if (mainModelElement != null && (value = mainModelElement.eContainer()) instanceof EObject) {
                targetObject = value;
            }
        } else if (column instanceof ContextColumn) {
            if (gridElement instanceof GridElementWithContext) {
                GridElementWithContext gridElementWithContext = (GridElementWithContext)gridElement;
                targetObject = gridElementWithContext.getContext();
            }
        } else if (column instanceof DefaultLabelColumn) {
            targetObject = mainModelElement;
        }
        if (targetObject != null) {
            return targetObject;
        }
        return null;
    }

    private void setupContextMenu() {
        if (this.menuMgr != null) {
            Menu menu = this.menuMgr.createContextMenu((Control)this.natTable);
            this.natTable.setMenu(menu);
        }
    }

    protected BodyLayerStack getBodyLayer() {
        return this.fBodyLayer;
    }

    protected GridLayer getGridLayer() {
        return this.gridLayer;
    }

    @Override
    public TableLabelProvider getTableLabelProvider() {
        return this.tableLabelProvider;
    }

    @Override
    public void copySelectionToClipboard() {
        new CopyToClipboardCommandHandler(this.fBodyLayer.getSelectionLayer(), this).doCommand(new CopyDataToClipboardCommand(new Clipboard(Display.getDefault()), "\t", "\n"));
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.tableInstance.getColumns());
    }

    public PositionCoordinate getCellPositionAt(int x, int y) {
        int column = this.natTable.getColumnPositionByX(x);
        int row = this.natTable.getRowPositionByY(y);
        PositionCoordinate convertedPosition = LayerCommandUtil.convertPositionToTargetContext((PositionCoordinate)new PositionCoordinate((ILayer)this.gridLayer, column, row), (ILayer)this.fBodyLayer.getSelectionLayer());
        return convertedPosition;
    }

    public LayerCell getCellAt(int column, int row) {
        return this.fBodyLayer.getSelectionLayer().getCellByPosition(column, row);
    }

    @Override
    public void loadCustomizations(List<MetamodelView> customizationsToLoad) {
        this.editingDomain.getCommandStack().execute(TableInstanceCommandFactory.createLoadCustomizationsCommand(customizationsToLoad, this));
        this.loadCustomizationsInCustomEngine(customizationsToLoad);
    }

    private void loadCustomizationsInCustomEngine(List<MetamodelView> customizationsToLoad) {
        List<MetamodelView> locals = this.getLocalCustomizations();
        if (this.tableInstance.getElements().size() != 0 && locals.isEmpty()) {
            Logger.logError((String)"The local customs should always be contained by customizationsToLoad", (Plugin)Activator.getDefault());
        }
        if (!locals.isEmpty() && !customizationsToLoad.containsAll(locals)) {
            Logger.logError((String)"The local customs should always be contained by customizationsToLoad", (Plugin)Activator.getDefault());
        }
        if (this.fCustomizationEngineChangeListener == null) {
            this.fCustomizationEngineChangeListener = new ChangeListener(){

                public void changed() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (!NatTableWidget.this.natTable.isDisposed()) {
                                NatTableWidget.this.natTable.redraw();
                            }
                        }
                    });
                }
            };
            this.customizationEngine.addChangeListener(this.fCustomizationEngineChangeListener);
        }
        this.customizationEngine.clear();
        for (MetamodelView customizationToLoad : customizationsToLoad) {
            this.customizationEngine.registerMetamodel(customizationToLoad.getMetamodelURI());
            this.customizationEngine.registerCustomization(customizationToLoad);
        }
        this.customizationEngine.loadCustomizations();
        this.updateHiddenColumns();
    }

    public CustomizationEngine getCustomizationEngine() {
        return this.customizationEngine;
    }

    public FacetContext getFacetContext() {
        return this.facetContext;
    }

    @Override
    public void setFacets(Collection<Facet> facets) throws CoreException {
        this.facetContext.clear();
        this.facetContext.addFacets(facets);
        if (this.tableInstance instanceof TableInstance2) {
            Command setFacetsComand = TableInstanceCommandFactory.createSetFacetsCommand(facets, this);
            this.editingDomain.getCommandStack().execute(setFacetsComand);
        }
    }

    public Collection<Facet> getLoadedFacets() {
        if (this.tableInstance instanceof TableInstance2) {
            return Collections.unmodifiableCollection(((TableInstance2)this.tableInstance).getFacets2());
        }
        ArrayList<Facet> list = new ArrayList<Facet>();
        list.add(this.tableInstance.getFacets());
        return list;
    }

    public void clearFacets() {
        try {
            this.facetContext.clear();
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)"Error clearing Facets", (Plugin)Activator.getDefault());
        }
    }

    public Collection<EPackage> getReferencedEPackages() {
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (EObject eObject : this.tableInstance.getElements()) {
            EPackage ePackage;
            EClass eClass = eObject.eClass();
            if (eClass == null || (ePackage = eClass.getEPackage()) == null) continue;
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    @Override
    public TableConfiguration getTableConfiguration() {
        return this.getTableInstance().getTableConfiguration();
    }

    @Override
    public TableInstance getTableInstance() {
        return this.tableInstance;
    }

    public EObject getContext() {
        return this.getTableInstance().getContext();
    }

    public Object getParameter() {
        return this.getTableInstance().getParameter();
    }

    @Override
    public void addRows(List<EObject> newElements) {
        Command loadCustomizationCommand;
        CompoundCommand addRowCommand = TableInstanceCommandFactory.createAddRowsCommand(newElements, this);
        if (this.tableInstance instanceof TableInstance2) {
            TableInstance2 tableInstance2 = (TableInstance2)this.tableInstance;
            try {
                this.facetContext.clear();
                this.facetContext.addFacets((Collection)tableInstance2.getFacets2());
                Command setFacetsCommand = TableInstanceCommandFactory.createSetFacetsCommand((Collection<Facet>)tableInstance2.getFacets2(), newElements, this);
                if (setFacetsCommand != null && setFacetsCommand.canExecute()) {
                    addRowCommand.append(setFacetsCommand);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        if ((loadCustomizationCommand = TableInstanceCommandFactory.createLoadCustomizationsCommand((List<MetamodelView>)this.tableInstance.getCustomizations(), this)) != null && loadCustomizationCommand.canExecute()) {
            addRowCommand.append(loadCustomizationCommand);
        }
        this.editingDomain.getCommandStack().execute((Command)addRowCommand);
    }

    @Override
    public boolean isCellsDeletable() {
        if (!this.isCellSelected()) {
            return false;
        }
        for (LayerCell cell : this.getSelectedCells()) {
            int position = cell.getOriginColumnPosition();
            int columnIndex = this.fBodyLayer.getColumnHideShowLayer().getColumnIndexByPosition(position);
            if (this.getColumns().get(columnIndex) instanceof DefaultLabelColumn) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedColumnDeletable() {
        List<Column> selectedColumn = this.getSelectedColumns();
        if (selectedColumn == null) {
            return false;
        }
        for (Column column : selectedColumn) {
            if (column instanceof QueryColumn) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openLoadCustomizationDialog() {
        if (this.loadCustomizationsAction == null) {
            this.loadCustomizationsAction = new LoadCustomizationsAction(this);
        }
        this.loadCustomizationsAction.run();
        this.updateHiddenColumns();
    }

    @Override
    public void openLoadFacetsDialog() {
        if (this.loadFacetsAction == null) {
            this.loadFacetsAction = new LoadFacetsAction(this);
        }
        this.loadFacetsAction.run();
    }

    @Override
    public void saveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        dialog.setOriginalName("My.table");
        dialog.open();
        if (dialog.getReturnCode() != 1) {
            URI uri = URI.createPlatformResourceURI((String)dialog.getResult().toString(), (boolean)true);
            if (uri != null) {
                ResourceSetImpl rSet = new ResourceSetImpl();
                this.resource = rSet.createResource(uri);
                this.resource.getContents().add((Object)this.getTableInstance());
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("USE_FILE_BUFFER", new Boolean(true));
                try {
                    this.resource.save(options);
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            if (this.editingDomain != null) {
                ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            }
        }
    }

    @Override
    public void save() {
        final HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("USE_FILE_BUFFER", new Boolean(true));
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor2) {
                if (NatTableWidget.this.resource == null || NatTableWidget.this.resource.getURI().lastSegment().equals(NatTableWidget.TMP_FILE_NAME)) {
                    NatTableWidget.this.saveAs();
                }
                for (Resource resourceElt : NatTableWidget.this.editingDomain.getResourceSet().getResources()) {
                    if (!NatTableWidget.this.isPersisted(resourceElt) || resourceElt.getContents().isEmpty() || NatTableWidget.this.editingDomain.isReadOnly(resourceElt)) continue;
                    try {
                        resourceElt.save(options);
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (InterruptedException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
    }

    private boolean isPersisted(Resource resourceParam) {
        boolean result;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resourceParam.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            } else {
                result = false;
            }
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public boolean isDataEditable() {
        return this.dataEditable;
    }

    protected void drop(StructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        CompoundCommand compoundCommand = TableInstanceCommandFactory.createDropCommand(this, (IStructuredSelection)structuredSelection, element, feature);
        if (compoundCommand != null && !compoundCommand.isEmpty()) {
            this.editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    protected boolean canBeDroped(IStructuredSelection structuredSelection, EStructuralFeature feature, Object element) {
        CompoundCommand compoundCommand = TableInstanceCommandFactory.createDropCommand(this, structuredSelection, element, feature);
        return compoundCommand != null && compoundCommand.canExecute();
    }

    private void setWithCommand(Object owner, Object feature, Object value) {
        Command cmd = this.commandFactory.createSetCommand(this.editingDomain, owner, feature, value);
        this.editingDomain.getCommandStack().execute(cmd);
    }

    @Override
    public void selectAll() {
        this.natTable.doCommand((ILayerCommand)new SelectAllCommand());
        this.natTable.redraw();
        this.tableSelectionChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void openSavedTable() {
        TableInstance tableInstanceValue = null;
        FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.table"});
        String path = fileDialog.open();
        if (path == null) return;
        Path myPath = new Path(path);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)myPath);
        if (file == null) throw new RuntimeException("Could not load this file: " + path);
        FileEditorInput fileEditorInput = new FileEditorInput(file);
        URI uri = URI.createFileURI((String)fileEditorInput.getPath().toOSString());
        if (uri == null) return;
        Resource localResource = null;
        if (this.editingDomain != null) {
            localResource = this.editingDomain.loadResource(uri.toString());
        } else {
            ResourceSetImpl rSet = new ResourceSetImpl();
            localResource = rSet.getResource(uri, true);
        }
        for (EObject eObject : localResource.getContents()) {
            if (!(eObject instanceof TableInstance)) continue;
            tableInstanceValue = (TableInstance)eObject;
            break;
        }
        if (tableInstanceValue == null) throw new RuntimeException("This file is not a valid .table ones: " + path);
        this.tableInstance.getColumns().addAll((Collection)tableInstanceValue.getColumns());
        this.tableInstance.setContext(tableInstanceValue.getContext());
        this.tableInstance.getCustomizations().addAll((Collection)tableInstanceValue.getCustomizations());
        this.tableInstance.getRows().addAll((Collection)tableInstanceValue.getRows());
        this.tableInstance.setDescription(tableInstanceValue.getDescription());
        if (this.tableInstance instanceof TableInstance2 && tableInstanceValue instanceof TableInstance2) {
            ((TableInstance2)this.tableInstance).getFacets2().addAll((Collection)((TableInstance2)tableInstanceValue).getFacets2());
        }
        try {
            this.initFacets();
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        this.setInput();
        this.notifyActions();
    }

    @Override
    public Control getComposite() {
        return this;
    }

    @Override
    public void registerActionDelegate(IActionDelegate action) {
        if (!this.actionList.contains(action)) {
            this.actionList.add(action);
        }
    }

    @Override
    public void unregisterActionDelegate(IActionDelegate action) {
        this.actionList.remove(action);
    }

    private void notifyActions() {
        for (IActionDelegate action : this.actionList) {
            action.selectionChanged(null, null);
        }
    }

    @Override
    public Collection<ISelectionChangedListener> getSelectionChangedListeners() {
        return Collections.unmodifiableCollection(this.fSelectionChangedListeners);
    }

    @Override
    public void sortColumnByNameAtoZ() {
        try {
            try {
                this.natTable.setRedraw(false);
                this.listenReorderEvent = false;
                ArrayList columns = new ArrayList(this.tableInstance.getColumns());
                Collections.sort(columns, new ColumnComparator());
                Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), columns);
                this.editingDomain.getCommandStack().execute(command);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by name From A to Z", (Plugin)Activator.getDefault());
                this.natTable.setRedraw(true);
                this.listenReorderEvent = true;
            }
        }
        finally {
            this.natTable.setRedraw(true);
            this.listenReorderEvent = true;
        }
    }

    @Override
    public void sortColumnByNameZtoA() {
        try {
            try {
                this.natTable.setRedraw(false);
                this.listenReorderEvent = false;
                ArrayList columns = new ArrayList(this.tableInstance.getColumns());
                ColumnComparator comparator = new ColumnComparator();
                comparator.setInversedOrder(true);
                Collections.sort(columns, comparator);
                Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), columns);
                this.editingDomain.getCommandStack().execute(command);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by name from Z to A", (Plugin)Activator.getDefault());
                this.natTable.setRedraw(true);
                this.listenReorderEvent = true;
            }
        }
        finally {
            this.natTable.setRedraw(true);
            this.listenReorderEvent = true;
        }
    }

    @Override
    public void selectDefaultLabelCell(EObject eObject) {
        int rowIndex = this.getRowIndexByEObject(eObject);
        if (rowIndex == -1) {
            return;
        }
        int columnIndex = -1;
        int i = 0;
        while (i < this.tableInstance.getColumns().size()) {
            if (this.tableInstance.getColumns().get(i) instanceof DefaultLabelColumn) {
                columnIndex = i;
                break;
            }
            ++i;
        }
        if (columnIndex == -1) {
            return;
        }
        SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
        selectionLayer.selectCell(columnIndex, rowIndex, false, false);
    }

    @Override
    public void selectCell(EObject eObject, EStructuralFeature eStructuralFeature) {
        int rowIndex = this.getRowIndexByEObject(eObject);
        if (rowIndex == -1) {
            return;
        }
        int columnIndex = -1;
        int i = 0;
        while (i < this.tableInstance.getColumns().size()) {
            FeatureColumn featureColumn;
            Column column = (Column)this.tableInstance.getColumns().get(i);
            if (column instanceof FeatureColumn && (featureColumn = (FeatureColumn)column).getFeature() == eStructuralFeature) {
                columnIndex = i;
                break;
            }
            ++i;
        }
        if (columnIndex == -1) {
            return;
        }
        SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
        selectionLayer.selectCell(columnIndex, rowIndex, false, false);
    }

    private int getRowIndexByEObject(EObject eObject) {
        int rowIndex = -1;
        EList rows = this.tableInstance.getRows();
        int i = 0;
        while (i < rows.size()) {
            if (((Row)rows.get(i)).getElement().equals(eObject)) {
                rowIndex = i;
                break;
            }
            ++i;
        }
        return rowIndex;
    }

    @Override
    public void editSelectedCell() {
        List<LayerCell> cells;
        if (this.isSelectedCellEditable() && (cells = this.getSelectedCells()) != null && !cells.isEmpty()) {
            LayerCell cell = cells.get(0);
            SelectionLayer selectionLayer = this.fBodyLayer.getSelectionLayer();
            selectionLayer.fireLayerEvent((ILayerEvent)new InlineCellEditEvent((ILayer)selectionLayer, new PositionCoordinate((ILayer)selectionLayer, cell.getColumnPosition(), cell.getRowPosition()), (Composite)this.natTable, this.natTable.getConfigRegistry(), null));
        }
    }

    @Override
    public List<Column> getVisibleColumns(boolean setAtTheTop) {
        List<Object> notHiddenColumns = new ArrayList();
        notHiddenColumns = this.tableInstance instanceof TableInstance2 ? this.getVisibleColumnsUsingTheLocalCustomizations((TableInstance2)this.tableInstance, setAtTheTop) : this.getVisibleColumnsUsingTheModel();
        return notHiddenColumns;
    }

    @Override
    public List<Column> getVisibleColumnsUsingTheLayer() {
        ArrayList<Column> notHiddenColumns = new ArrayList<Column>();
        ColumnHideShowLayer layer = this.fBodyLayer.getColumnHideShowLayer();
        EList allColumns = this.tableInstance.getColumns();
        int i = 0;
        while (i < allColumns.size()) {
            if (!layer.isColumnIndexHidden(i)) {
                notHiddenColumns.add((Column)allColumns.get(i));
            }
            ++i;
        }
        return notHiddenColumns;
    }

    @Override
    public void putLocalCustomizationOnTheBottom() {
        this.editingDomain.getCommandStack().execute(this.getPutLocalCustomizationOnTheBottomCommand());
        this.loadCustomizationsInCustomEngine((List<MetamodelView>)this.tableInstance.getCustomizations());
    }

    private Command getPutLocalCustomizationOnTheBottomCommand() {
        List<MetamodelView> locals = this.getLocalCustomizations();
        ArrayList<MetamodelView> views = new ArrayList<MetamodelView>();
        views.addAll((Collection<MetamodelView>)this.tableInstance.getCustomizations());
        views.removeAll(locals);
        views.addAll(views.size(), locals);
        return this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Customizations(), views);
    }

    @Override
    public Point getCellPositionRelativeToDisplay(int columnPosition, int rowPosition) {
        Rectangle rect = this.fBodyLayer.getSelectionLayer().getBoundsByPosition(columnPosition, rowPosition);
        return new Point(rect.x, rect.y);
    }

    @Override
    public void selectRows(List<EObject> elementsToSelect, boolean clearTheSelection) {
        int columnPosition = 0;
        EList allRows = this.tableInstance.getRows();
        ArrayList<Integer> rowsToSelect = new ArrayList<Integer>();
        int i = 0;
        while (i < elementsToSelect.size()) {
            Row row = this.findRow(elementsToSelect.get(i));
            if (row != null) {
                rowsToSelect.add(new Integer(allRows.indexOf(row)));
            }
            ++i;
        }
        int[] rowPositions = new int[rowsToSelect.size()];
        int i2 = 0;
        while (i2 < rowsToSelect.size()) {
            rowPositions[i2] = (Integer)rowsToSelect.get(i2);
            ++i2;
        }
        SelectionLayer layer = this.fBodyLayer.getSelectionLayer();
        if (clearTheSelection) {
            layer.clear();
        }
        if (rowPositions.length != 0) {
            this.natTable.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)this.fBodyLayer.getSelectionLayer(), columnPosition, rowPositions, false, true));
        }
        this.natTable.redraw();
        this.tableSelectionChanged();
    }

    private Row findRow(EObject eObject) {
        if (this.tableInstance.getElements().contains((Object)eObject)) {
            for (Row row : this.tableInstance.getRows()) {
                if (!row.getElement().equals(eObject)) continue;
                return row;
            }
        }
        return null;
    }

    @Override
    public boolean isSelectedCellEditable() {
        List<LayerCell> cells = this.getSelectedCells();
        if (cells.size() > 1) {
            return false;
        }
        LayerCell cell = cells.get(0);
        int columnPos = cell.getOriginColumnPosition();
        int columnIndex = this.fBodyLayer.getColumnHideShowLayer().getColumnIndexByPosition(columnPos);
        Column column = this.getColumns().get(columnIndex);
        if (!(column instanceof FeatureColumn)) {
            return false;
        }
        int rowPos = cell.getOriginRowPosition();
        int rowIndex = this.fBodyLayer.getColumnHideShowLayer().getRowIndexByPosition(rowPos);
        Row row = (Row)this.tableInstance.getRows().get(rowIndex);
        EObject eObject = row.getElement();
        if (column instanceof FacetReferenceColumn) {
            try {
                return this.facetContext.isInstance(eObject, (Facet)((FacetReferenceColumn)column).getReference().eContainer());
            }
            catch (ModelQueryException e) {
                return false;
            }
        }
        if (column instanceof FacetAttributeColumn) {
            try {
                return this.facetContext.isInstance(eObject, (Facet)((FacetAttributeColumn)column).getAttribute().eContainer());
            }
            catch (ModelQueryException e) {
                return false;
            }
        }
        EStructuralFeature feature = ((FeatureColumn)column).getFeature();
        EList eStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
        return eStructuralFeatures.contains(feature);
    }

    private void refreshDelayed() {
        if (this.refreshJob == null) {
            this.refreshJob = new Job("Refresh EMF Facet Table"){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (!NatTableWidget.this.natTable.isDisposed()) {
                                NatTableWidget.this.setInput();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        } else {
            this.refreshJob.cancel();
        }
        this.refreshJob.setPriority(50);
        this.refreshJob.schedule(100L);
    }

    protected EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected ICommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public void waitForResfreshJob() {
        boolean wait = true;
        while (wait) {
            try {
                if (this.refreshJob != null) {
                    this.refreshJob.join();
                }
                wait = false;
            }
            catch (InterruptedException e) {
                wait = true;
            }
        }
    }

    private void checkTableIntegrity() {
        for (Row row : new ArrayList(this.tableInstance.getRows())) {
            if (row.getElement() != null && row.getElement().eResource() != null) continue;
            Command removeCommand = this.commandFactory.createRemoveCommand(this.editingDomain, (Object)this.tableInstance, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Rows(), (Object)row);
            removeCommand.execute();
        }
    }

    public class BodyLayerStack
    extends AbstractLayerTransform {
        private final SelectionLayer selectionLayer;
        private final DataLayer bodyDataLayer;
        private final ViewportLayer viewportLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final ColumnReorderLayer columnReorderLayer;

        public BodyLayerStack(IDataProvider dataProvider) {
            this.bodyDataLayer = new DataLayer(dataProvider);
            this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.bodyDataLayer);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)this.viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public DataLayer getBodyDataLayer() {
            return this.bodyDataLayer;
        }

        public ViewportLayer getViewportLayer() {
            return this.viewportLayer;
        }

        public ColumnHideShowLayer getColumnHideShowLayer() {
            return this.columnHideShowLayer;
        }

        public ColumnReorderLayer getColumnReorderLayer() {
            return this.columnReorderLayer;
        }
    }

    public class ElementsDescription {
        private boolean containsEObjects;
        private boolean containsPrimitiveTypes;
        private boolean containsContexts;

        public boolean getContainsEObjects() {
            return this.containsEObjects;
        }

        public boolean getContainsPrimitiveTypes() {
            return this.containsPrimitiveTypes;
        }

        public boolean getContainsContexts() {
            return this.containsContexts;
        }

        public void setContainsContexts(boolean containsContexts) {
            this.containsContexts = containsContexts;
        }

        protected void setContainsEObjects(boolean containsEObjects) {
            this.containsEObjects = containsEObjects;
        }

        protected void setContainsPrimitiveTypes(boolean containsPrimitiveTypes) {
            this.containsPrimitiveTypes = containsPrimitiveTypes;
        }
    }
}

