/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ui.actions.AbstractLoadCustomizationsAction;
import org.eclipse.emf.facet.infra.browser.custom.ui.dialogs.LoadCustomizationsDialog;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.internal.dialogs.NatTableWidgetLoadCustomizationsDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCustomizationsAction
extends AbstractLoadCustomizationsAction {
    private final NatTableWidget natTableWidget;

    public LoadCustomizationsAction(NatTableWidget natTableWidget) {
        this.natTableWidget = natTableWidget;
    }

    protected void loadCustomizations(List<MetamodelView> selectedCustomizations) {
        this.natTableWidget.loadCustomizations(selectedCustomizations);
    }

    protected void loadFacet(Facet referencedFacet) {
    }

    protected void facetsLoaded(Set<Facet> referencedFacets) {
        try {
            ArrayList<Facet> facets = new ArrayList<Facet>();
            facets.addAll(this.natTableWidget.getLoadedFacets());
            facets.addAll(referencedFacets);
            this.natTableWidget.setFacets(facets);
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)this.getShell(), (String)"Failed to load facets", (String)"Some facets failed to load. See error to have more details.");
        }
    }

    protected Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    protected Collection<EPackage> getReferencedEPackages() {
        return this.natTableWidget.getReferencedEPackages();
    }

    protected List<MetamodelView> getRegisteredCustomizations() {
        return this.natTableWidget.getTableInstance().getCustomizations();
    }

    protected LoadCustomizationsDialog createLoadCustomizationDialog(List<MetamodelView> registeredCustomizations) {
        TableInstance tableInstance = this.natTableWidget.getTableInstance();
        ArrayList<MetamodelView> localCustoms = new ArrayList<MetamodelView>();
        if (tableInstance instanceof TableInstance2) {
            localCustoms.addAll((Collection<MetamodelView>)((TableInstance2)tableInstance).getLocalCustomizations());
        }
        return new NatTableWidgetLoadCustomizationsDialog(this.getShell(), registeredCustomizations, this.getReferencedEPackages(), localCustoms);
    }
}

