/**
 *  Copyright (c) 2011 Mia-Software.
 *  
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *  
 *  Contributors:
 * 	Gregoire Dupe (Mia-Software) - Design
 * 	Nicolas Guyomar (Mia-Software) - Implementation
 *  
 */
package org.eclipse.emf.facet.efacet;

import org.eclipse.emf.ecore.ETypedElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Typed Element Ref</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This query can result in content of another attribute, reference or operation.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.efacet.TypedElementRef#getTypedElement <em>Typed Element</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.facet.efacet.EFacetPackage#getTypedElementRef()
 * @model
 * @generated
 */
public interface TypedElementRef extends Query {
	/**
	 * Returns the value of the '<em><b>Typed Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Typed Element</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Typed Element</em>' reference.
	 * @see #setTypedElement(ETypedElement)
	 * @see org.eclipse.emf.facet.efacet.EFacetPackage#getTypedElementRef_TypedElement()
	 * @model required="true"
	 * @generated
	 */
	ETypedElement getTypedElement();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.efacet.TypedElementRef#getTypedElement <em>Typed Element</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Typed Element</em>' reference.
	 * @see #getTypedElement()
	 * @generated
	 */
	void setTypedElement(ETypedElement value);

} // TypedElementRef
