/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Table Instance</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getTableConfiguration <em>Table Configuration</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getCustomizations <em>Customizations</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getFacets <em>Facets</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getContext <em>Context</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getParameter <em>Parameter</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#isHideEmptyColumns <em>Hide Empty Columns</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#isOnlyShowCommonColumns <em>Only Show Common Columns</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getColumns <em>Columns</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getRows <em>Rows</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getElements <em>Elements</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl#getLocalCustomization <em>Local Customization</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TableInstanceImpl extends EObjectImpl implements TableInstance {
	/**
	 * The cached value of the '{@link #getTableConfiguration() <em>Table Configuration</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTableConfiguration()
	 * @generated
	 * @ordered
	 */
	protected TableConfiguration tableConfiguration;

	/**
	 * The cached value of the '{@link #getCustomizations() <em>Customizations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCustomizations()
	 * @generated
	 * @ordered
	 */
	protected EList<MetamodelView> customizations;

	/**
	 * The cached value of the '{@link #getFacets() <em>Facets</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFacets()
	 * @generated
	 * @ordered
	 */
	protected Facet facets;

	/**
	 * The cached value of the '{@link #getContext() <em>Context</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContext()
	 * @generated
	 * @ordered
	 */
	protected EObject context;

	/**
	 * The default value of the '{@link #getParameter() <em>Parameter</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameter()
	 * @generated
	 * @ordered
	 */
	protected static final Object PARAMETER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParameter() <em>Parameter</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameter()
	 * @generated
	 * @ordered
	 */
	protected Object parameter = PARAMETER_EDEFAULT;

	/**
	 * The default value of the '{@link #isHideEmptyColumns() <em>Hide Empty Columns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHideEmptyColumns()
	 * @generated
	 * @ordered
	 */
	protected static final boolean HIDE_EMPTY_COLUMNS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isHideEmptyColumns() <em>Hide Empty Columns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHideEmptyColumns()
	 * @generated
	 * @ordered
	 */
	protected boolean hideEmptyColumns = HIDE_EMPTY_COLUMNS_EDEFAULT;

	/**
	 * The default value of the '{@link #isOnlyShowCommonColumns() <em>Only Show Common Columns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOnlyShowCommonColumns()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ONLY_SHOW_COMMON_COLUMNS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isOnlyShowCommonColumns() <em>Only Show Common Columns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOnlyShowCommonColumns()
	 * @generated
	 * @ordered
	 */
	protected boolean onlyShowCommonColumns = ONLY_SHOW_COMMON_COLUMNS_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getColumns() <em>Columns</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumns()
	 * @generated
	 * @ordered
	 */
	protected EList<Column> columns;

	/**
	 * The cached value of the '{@link #getRows() <em>Rows</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRows()
	 * @generated
	 * @ordered
	 */
	protected EList<Row> rows;

	/**
	 * The cached value of the '{@link #getLocalCustomization() <em>Local Customization</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalCustomization()
	 * @generated
	 * @ordered
	 */
	protected MetamodelView localCustomization;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableInstanceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TableinstancePackage.Literals.TABLE_INSTANCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableConfiguration getTableConfiguration() {
		if (tableConfiguration != null && tableConfiguration.eIsProxy()) {
			InternalEObject oldTableConfiguration = (InternalEObject)tableConfiguration;
			tableConfiguration = (TableConfiguration)eResolveProxy(oldTableConfiguration);
			if (tableConfiguration != oldTableConfiguration) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TableinstancePackage.TABLE_INSTANCE__TABLE_CONFIGURATION, oldTableConfiguration, tableConfiguration));
			}
		}
		return tableConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableConfiguration basicGetTableConfiguration() {
		return tableConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTableConfiguration(TableConfiguration newTableConfiguration) {
		TableConfiguration oldTableConfiguration = tableConfiguration;
		tableConfiguration = newTableConfiguration;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__TABLE_CONFIGURATION, oldTableConfiguration, tableConfiguration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MetamodelView> getCustomizations() {
		if (customizations == null) {
			customizations = new EObjectResolvingEList<MetamodelView>(MetamodelView.class, this, TableinstancePackage.TABLE_INSTANCE__CUSTOMIZATIONS);
		}
		return customizations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Facet getFacets() {
		if (facets != null && facets.eIsProxy()) {
			InternalEObject oldFacets = (InternalEObject)facets;
			facets = (Facet)eResolveProxy(oldFacets);
			if (facets != oldFacets) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TableinstancePackage.TABLE_INSTANCE__FACETS, oldFacets, facets));
			}
		}
		return facets;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Facet basicGetFacets() {
		return facets;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFacets(Facet newFacets) {
		Facet oldFacets = facets;
		facets = newFacets;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__FACETS, oldFacets, facets));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getContext() {
		if (context != null && context.eIsProxy()) {
			InternalEObject oldContext = (InternalEObject)context;
			context = eResolveProxy(oldContext);
			if (context != oldContext) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TableinstancePackage.TABLE_INSTANCE__CONTEXT, oldContext, context));
			}
		}
		return context;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject basicGetContext() {
		return context;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContext(EObject newContext) {
		EObject oldContext = context;
		context = newContext;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__CONTEXT, oldContext, context));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getParameter() {
		return parameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParameter(Object newParameter) {
		Object oldParameter = parameter;
		parameter = newParameter;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__PARAMETER, oldParameter, parameter));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isHideEmptyColumns() {
		return hideEmptyColumns;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHideEmptyColumns(boolean newHideEmptyColumns) {
		boolean oldHideEmptyColumns = hideEmptyColumns;
		hideEmptyColumns = newHideEmptyColumns;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__HIDE_EMPTY_COLUMNS, oldHideEmptyColumns, hideEmptyColumns));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isOnlyShowCommonColumns() {
		return onlyShowCommonColumns;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOnlyShowCommonColumns(boolean newOnlyShowCommonColumns) {
		boolean oldOnlyShowCommonColumns = onlyShowCommonColumns;
		onlyShowCommonColumns = newOnlyShowCommonColumns;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS, oldOnlyShowCommonColumns, onlyShowCommonColumns));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Column> getColumns() {
		if (columns == null) {
			columns = new EObjectContainmentEList<Column>(Column.class, this, TableinstancePackage.TABLE_INSTANCE__COLUMNS);
		}
		return columns;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Row> getRows() {
		if (rows == null) {
			rows = new EObjectContainmentEList<Row>(Row.class, this, TableinstancePackage.TABLE_INSTANCE__ROWS);
		}
		return rows;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<EObject> getElements() {
		List<EObject> list = new BasicEList<EObject>();
		for(Row row : this.getRows()){
			list.add(row.getElement());
		}
		return new org.eclipse.emf.ecore.util.EcoreEList.UnmodifiableEList<EObject>(this, TableinstancePackage.eINSTANCE.getTableInstance_Elements(),list.size(),list.toArray());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetamodelView getLocalCustomization() {
		return localCustomization;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLocalCustomization(MetamodelView newLocalCustomization, NotificationChain msgs) {
		MetamodelView oldLocalCustomization = localCustomization;
		localCustomization = newLocalCustomization;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION, oldLocalCustomization, newLocalCustomization);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocalCustomization(MetamodelView newLocalCustomization) {
		if (newLocalCustomization != localCustomization) {
			NotificationChain msgs = null;
			if (localCustomization != null)
				msgs = ((InternalEObject)localCustomization).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION, null, msgs);
			if (newLocalCustomization != null)
				msgs = ((InternalEObject)newLocalCustomization).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION, null, msgs);
			msgs = basicSetLocalCustomization(newLocalCustomization, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION, newLocalCustomization, newLocalCustomization));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TableinstancePackage.TABLE_INSTANCE__COLUMNS:
				return ((InternalEList<?>)getColumns()).basicRemove(otherEnd, msgs);
			case TableinstancePackage.TABLE_INSTANCE__ROWS:
				return ((InternalEList<?>)getRows()).basicRemove(otherEnd, msgs);
			case TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION:
				return basicSetLocalCustomization(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TableinstancePackage.TABLE_INSTANCE__TABLE_CONFIGURATION:
				if (resolve) return getTableConfiguration();
				return basicGetTableConfiguration();
			case TableinstancePackage.TABLE_INSTANCE__CUSTOMIZATIONS:
				return getCustomizations();
			case TableinstancePackage.TABLE_INSTANCE__FACETS:
				if (resolve) return getFacets();
				return basicGetFacets();
			case TableinstancePackage.TABLE_INSTANCE__CONTEXT:
				if (resolve) return getContext();
				return basicGetContext();
			case TableinstancePackage.TABLE_INSTANCE__PARAMETER:
				return getParameter();
			case TableinstancePackage.TABLE_INSTANCE__HIDE_EMPTY_COLUMNS:
				return isHideEmptyColumns();
			case TableinstancePackage.TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS:
				return isOnlyShowCommonColumns();
			case TableinstancePackage.TABLE_INSTANCE__DESCRIPTION:
				return getDescription();
			case TableinstancePackage.TABLE_INSTANCE__COLUMNS:
				return getColumns();
			case TableinstancePackage.TABLE_INSTANCE__ROWS:
				return getRows();
			case TableinstancePackage.TABLE_INSTANCE__ELEMENTS:
				return getElements();
			case TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION:
				return getLocalCustomization();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TableinstancePackage.TABLE_INSTANCE__TABLE_CONFIGURATION:
				setTableConfiguration((TableConfiguration)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__CUSTOMIZATIONS:
				getCustomizations().clear();
				getCustomizations().addAll((Collection<? extends MetamodelView>)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__FACETS:
				setFacets((Facet)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__CONTEXT:
				setContext((EObject)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__PARAMETER:
				setParameter(newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__HIDE_EMPTY_COLUMNS:
				setHideEmptyColumns((Boolean)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS:
				setOnlyShowCommonColumns((Boolean)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__COLUMNS:
				getColumns().clear();
				getColumns().addAll((Collection<? extends Column>)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__ROWS:
				getRows().clear();
				getRows().addAll((Collection<? extends Row>)newValue);
				return;
			case TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION:
				setLocalCustomization((MetamodelView)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TableinstancePackage.TABLE_INSTANCE__TABLE_CONFIGURATION:
				setTableConfiguration((TableConfiguration)null);
				return;
			case TableinstancePackage.TABLE_INSTANCE__CUSTOMIZATIONS:
				getCustomizations().clear();
				return;
			case TableinstancePackage.TABLE_INSTANCE__FACETS:
				setFacets((Facet)null);
				return;
			case TableinstancePackage.TABLE_INSTANCE__CONTEXT:
				setContext((EObject)null);
				return;
			case TableinstancePackage.TABLE_INSTANCE__PARAMETER:
				setParameter(PARAMETER_EDEFAULT);
				return;
			case TableinstancePackage.TABLE_INSTANCE__HIDE_EMPTY_COLUMNS:
				setHideEmptyColumns(HIDE_EMPTY_COLUMNS_EDEFAULT);
				return;
			case TableinstancePackage.TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS:
				setOnlyShowCommonColumns(ONLY_SHOW_COMMON_COLUMNS_EDEFAULT);
				return;
			case TableinstancePackage.TABLE_INSTANCE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case TableinstancePackage.TABLE_INSTANCE__COLUMNS:
				getColumns().clear();
				return;
			case TableinstancePackage.TABLE_INSTANCE__ROWS:
				getRows().clear();
				return;
			case TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION:
				setLocalCustomization((MetamodelView)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TableinstancePackage.TABLE_INSTANCE__TABLE_CONFIGURATION:
				return tableConfiguration != null;
			case TableinstancePackage.TABLE_INSTANCE__CUSTOMIZATIONS:
				return customizations != null && !customizations.isEmpty();
			case TableinstancePackage.TABLE_INSTANCE__FACETS:
				return facets != null;
			case TableinstancePackage.TABLE_INSTANCE__CONTEXT:
				return context != null;
			case TableinstancePackage.TABLE_INSTANCE__PARAMETER:
				return PARAMETER_EDEFAULT == null ? parameter != null : !PARAMETER_EDEFAULT.equals(parameter);
			case TableinstancePackage.TABLE_INSTANCE__HIDE_EMPTY_COLUMNS:
				return hideEmptyColumns != HIDE_EMPTY_COLUMNS_EDEFAULT;
			case TableinstancePackage.TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS:
				return onlyShowCommonColumns != ONLY_SHOW_COMMON_COLUMNS_EDEFAULT;
			case TableinstancePackage.TABLE_INSTANCE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case TableinstancePackage.TABLE_INSTANCE__COLUMNS:
				return columns != null && !columns.isEmpty();
			case TableinstancePackage.TABLE_INSTANCE__ROWS:
				return rows != null && !rows.isEmpty();
			case TableinstancePackage.TABLE_INSTANCE__ELEMENTS:
				return !getElements().isEmpty();
			case TableinstancePackage.TABLE_INSTANCE__LOCAL_CUSTOMIZATION:
				return localCustomization != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (parameter: "); //$NON-NLS-1$
		result.append(parameter);
		result.append(", hideEmptyColumns: "); //$NON-NLS-1$
		result.append(hideEmptyColumns);
		result.append(", onlyShowCommonColumns: "); //$NON-NLS-1$
		result.append(onlyShowCommonColumns);
		result.append(", description: "); //$NON-NLS-1$
		result.append(description);
		result.append(')');
		return result.toString();
	}

} //TableInstanceImpl
