/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.action;

import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupUtils;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.reorder.action.ColumnReorderDragMode;
import org.eclipse.swt.events.MouseEvent;

public class ColumnHeaderReorderDragMode
extends ColumnReorderDragMode {
    private final ColumnGroupModel model;
    private MouseEvent event;

    public ColumnHeaderReorderDragMode(ColumnGroupModel model) {
        this.model = model;
    }

    public boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition) {
        int toColumnIndex = natLayer.getColumnIndexByPosition(toGridColumnPosition);
        int fromColumnIndex = natLayer.getColumnIndexByPosition(fromGridColumnPosition);
        if (this.model.isPartOfAnUnbreakableGroup(fromColumnIndex)) {
            return ColumnGroupUtils.isInTheSameGroup(fromColumnIndex, toColumnIndex, this.model);
        }
        boolean betweenTwoGroups = false;
        if (this.event != null) {
            int minX = this.event.x - 4;
            int maxX = this.event.x + 4;
            betweenTwoGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.model);
        }
        return !this.model.isPartOfAnUnbreakableGroup(toColumnIndex) || betweenTwoGroups;
    }

    public boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition, MouseEvent event) {
        this.event = event;
        toGridColumnPosition = natLayer.getColumnPositionByX(event.x);
        return this.isValidTargetColumnPosition(natLayer, fromGridColumnPosition, toGridColumnPosition);
    }
}

