/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.uicore.internal.customization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.browser.custom.AttributeView;
import org.eclipse.emf.facet.infra.browser.custom.CustomView;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.CustomizableFeatures;
import org.eclipse.emf.facet.infra.browser.custom.DerivedFeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.FeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.FeatureValueCase;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ReferenceView;
import org.eclipse.emf.facet.infra.browser.custom.StaticFeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.emf.facet.infra.browser.custom.util.OverlayIconInfo;
import org.eclipse.emf.facet.infra.browser.custom.util.UicustomUtil;
import org.eclipse.emf.facet.infra.browser.uicore.ChangeListener;
import org.eclipse.emf.facet.infra.browser.uicore.internal.Activator;
import org.eclipse.emf.facet.infra.browser.uicore.internal.Messages;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.OverlayIconImageInfo;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.EMFUtil;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.QueryUtil;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.PathUtils;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationEngine {
    private final Map<EClass, EngineElementView> engineTypeViews = new HashMap<EClass, EngineElementView>();
    private final Map<FeatureKey, EngineElementView> engineAttributeViews = new HashMap<FeatureKey, EngineElementView>();
    private final Map<FeatureKey, EngineElementView> engineReferenceViews = new HashMap<FeatureKey, EngineElementView>();
    private final Map<String, Color> colorsCache = new HashMap<String, Color>();
    private final Map<String, Font> fontsCache = new HashMap<String, Font>();
    private final Map<String, Image> iconsCache = new HashMap<String, Image>();
    private List<MetamodelView> fRegisteredCustomizations = new ArrayList<MetamodelView>();
    private final List<String> fRegisteredMetamodels = new ArrayList<String>();
    private AbstractEmfFacetCatalog.EmfFacetCatalogChangeListener customizationChangeListener;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public void addChangeListener(ChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    private void notifyChangeListeners() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.changed();
        }
    }

    public void clear() {
        this.fRegisteredCustomizations.clear();
        this.fRegisteredMetamodels.clear();
        this.clearInternal();
    }

    private void clearInternal() {
        this.engineTypeViews.clear();
        this.engineAttributeViews.clear();
        this.engineReferenceViews.clear();
    }

    public void registerCustomization(MetamodelView metamodelView) {
        if (metamodelView == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (!this.fRegisteredCustomizations.contains(metamodelView)) {
            this.fRegisteredCustomizations.add(metamodelView);
        }
    }

    public List<MetamodelView> getRegisteredCustomizations() {
        return this.fRegisteredCustomizations;
    }

    public void registerMetamodel(String metamodelURI) {
        if (metamodelURI == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (!this.fRegisteredMetamodels.contains(metamodelURI)) {
            this.fRegisteredMetamodels.add(metamodelURI);
        }
    }

    public List<String> getRegisteredMetamodels() {
        return this.fRegisteredMetamodels;
    }

    public void loadCustomizations() {
        this.clearInternal();
        for (MetamodelView registeredCustomization : this.fRegisteredCustomizations) {
            this.loadCustomization(registeredCustomization, false);
        }
        this.notifyChangeListeners();
        if (this.customizationChangeListener != null) {
            CustomizationsCatalog.getInstance().removeChangeListener(this.customizationChangeListener);
        }
        this.customizationChangeListener = new AbstractEmfFacetCatalog.EmfFacetCatalogChangeListener(){

            public void changed(EObject eObject, IFile file) {
                ArrayList<MetamodelView> newRegisteredCustomizations = new ArrayList<MetamodelView>();
                for (MetamodelView registeredCustomization : CustomizationEngine.this.fRegisteredCustomizations) {
                    if (registeredCustomization.eResource() == null) {
                        if (newRegisteredCustomizations.contains(eObject)) continue;
                        newRegisteredCustomizations.add((MetamodelView)eObject);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                CustomizationEngine.this.loadCustomizations();
                            }
                        });
                        continue;
                    }
                    newRegisteredCustomizations.add(registeredCustomization);
                }
                CustomizationEngine.this.fRegisteredCustomizations = newRegisteredCustomizations;
            }

            public void added(EObject eObject, IFile file) {
            }

            public void removed(IFile file) {
            }
        };
        CustomizationsCatalog.getInstance().addChangeListener(this.customizationChangeListener);
    }

    private void loadCustomization(MetamodelView metamodelView, boolean notifyListeners) {
        FacetSetCatalog.getSingleton();
        String metamodelURI = metamodelView.getMetamodelURI();
        if (metamodelURI == null) {
            Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_couldNotFindMetamodel, (Object)metamodelView.getMetamodelURI()), (Plugin)Activator.getDefault());
            return;
        }
        ArrayList<String> otherMetamodels = new ArrayList<String>(this.getRegisteredMetamodels());
        otherMetamodels.remove(metamodelURI);
        LinkedHashSet<EClass> metaclasses = new LinkedHashSet<EClass>();
        for (String registeredMetamodel : otherMetamodels) {
            List<EClass> otherMetaclasses = this.getMetaclasses(registeredMetamodel);
            if (otherMetaclasses == null) continue;
            metaclasses.addAll(otherMetaclasses);
        }
        List<EClass> mainMetaclasses = this.getMetaclasses(metamodelURI);
        if (mainMetaclasses == null) {
            return;
        }
        metaclasses.addAll(mainMetaclasses);
        ArrayList<TypeView> types = new ArrayList<TypeView>((Collection<TypeView>)metamodelView.getTypes());
        HashMap<String, TypeView> typeViewMap = new HashMap<String, TypeView>();
        for (TypeView typeView : types) {
            typeViewMap.put(typeView.getMetaclassName(), typeView);
        }
        HashMap<String, EClass> metaclassMap = new HashMap<String, EClass>();
        for (EClass eClass : metaclasses) {
            String metaclassQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
            metaclassMap.put(metaclassQualifiedName, eClass);
            if (typeViewMap.get(metaclassQualifiedName) != null) continue;
            TypeView typeView = UicustomFactory.eINSTANCE.createTypeView();
            typeView.setMetaclassName(metaclassQualifiedName);
            types.add(typeView);
            typeViewMap.put(metaclassQualifiedName, typeView);
        }
        for (TypeView type : types) {
            EClass eClass = (EClass)metaclassMap.get(type.getMetaclassName());
            this.associateEClassAndStructuralFeatures(eClass, type, types, typeViewMap);
        }
        if (notifyListeners) {
            this.notifyChangeListeners();
        }
    }

    private boolean associateEClassAndStructuralFeatures(EClass eClass, TypeView type, List<TypeView> types, Map<String, TypeView> typeViewMap) {
        if (eClass == null) {
            Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_coundNotFindEclass, (Object)type.getMetaclassName()), (Plugin)Activator.getDefault());
            return false;
        }
        this.addTypeView(eClass, type, types, typeViewMap);
        BasicEList eAllSuperTypes = new BasicEList((Collection)eClass.getEAllSuperTypes());
        Collections.reverse(eAllSuperTypes);
        this.addAttributeViews(eClass, type);
        this.addReferenceViews(eClass, type);
        for (EClass eSuperType : eAllSuperTypes) {
            TypeView superTypeView = typeViewMap.get(ModelUtils.getMetaclassQualifiedName((EClassifier)eSuperType));
            if (superTypeView == null || !superTypeView.isAppliesToSubInstances()) continue;
            this.addAttributeViews(eClass, superTypeView);
            this.addReferenceViews(eClass, superTypeView);
        }
        return true;
    }

    private void addAttributeViews(EClass eClass, TypeView type) {
        EList attributes = type.getAttributes();
        for (AttributeView attribute : attributes) {
            FeatureKey featureKey = new FeatureKey(eClass, attribute.getAttributeName());
            EngineElementView engineElementView = this.engineAttributeViews.get(featureKey);
            if (engineElementView == null) {
                engineElementView = new EngineElementView();
            }
            engineElementView.addFeatures((CustomView)attribute);
            this.engineAttributeViews.put(featureKey, engineElementView);
        }
    }

    private void addReferenceViews(EClass eClass, TypeView type) {
        EList references = type.getReferences();
        for (ReferenceView reference : references) {
            FeatureKey featureKey = new FeatureKey(eClass, reference.getReferenceName());
            EngineElementView engineElementView = this.engineReferenceViews.get(featureKey);
            if (engineElementView == null) {
                engineElementView = new EngineElementView();
            }
            engineElementView.addFeatures((CustomView)reference);
            this.engineReferenceViews.put(featureKey, engineElementView);
        }
    }

    private void addTypeView(EClass eClass, TypeView typeView, List<TypeView> types, Map<String, TypeView> typeViewMap) {
        EngineElementView engineElementView = this.engineTypeViews.get(eClass);
        if (engineElementView == null) {
            engineElementView = new EngineElementView();
        }
        engineElementView.addFeatures((CustomView)typeView);
        BasicEList eAllSuperTypes = new BasicEList((Collection)eClass.getEAllSuperTypes());
        Collections.reverse(eAllSuperTypes);
        for (EClass eSuperType : eAllSuperTypes) {
            TypeView superTypeView = typeViewMap.get(ModelUtils.getMetaclassQualifiedName((EClassifier)eSuperType));
            if (superTypeView == null || !superTypeView.isAppliesToSubInstances()) continue;
            engineElementView.addFeatures((CustomView)superTypeView);
        }
        this.engineTypeViews.put(eClass, engineElementView);
    }

    private List<EClass> getMetaclasses(String metamodelURI) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metamodelURI);
        if (ePackage == null) {
            Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_metamodelNotFound, (Object)metamodelURI), (Plugin)Activator.getDefault());
            return null;
        }
        Resource resource = ePackage.eResource();
        if (resource == null) {
            throw new RuntimeException(NLS.bind((String)Messages.CustomizationEngine_resourceMustNotBeNull, (Object)metamodelURI));
        }
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof EClass)) continue;
            EClass eClass = (EClass)eObject;
            eClasses.add(eClass);
        }
        return eClasses;
    }

    private EngineElementView getAttributeView(EClass eClass, String name) {
        FeatureKey featureKey = new FeatureKey(eClass, name);
        EngineElementView elementView = this.engineAttributeViews.get(featureKey);
        return elementView;
    }

    private EngineElementView getReferenceView(EClass eClass, String name) {
        FeatureKey featureKey = new FeatureKey(eClass, name);
        EngineElementView elementView = this.engineReferenceViews.get(featureKey);
        return elementView;
    }

    public boolean isTypeVisible(EClass eClass, EObject context) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.isVisible(elementView, context, false);
    }

    public boolean isAttributeVisible(EClass eClass, String name, EObject context) {
        return this.isVisible(this.getAttributeView(eClass, name), context, false);
    }

    public boolean isReferenceVisible(EClass eClass, String name, EObject context) {
        return this.isVisible(this.getReferenceView(eClass, name), context, false);
    }

    public boolean isTypeVisibleStatic(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.isVisible(elementView, null, true);
    }

    public boolean isAttributeVisibleStatic(EClass eClass, String name) {
        return this.isVisible(this.getAttributeView(eClass, name), null, true);
    }

    public boolean isReferenceVisibleStatic(EClass eClass, String name) {
        return this.isVisible(this.getReferenceView(eClass, name), null, true);
    }

    private boolean isVisible(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> visibleFeature;
        if (elementView != null && (visibleFeature = elementView.getVisibleFeature()) != null && (value = this.getValue(visibleFeature, context, staticOnly)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultVisibility();
    }

    private boolean getDefaultVisibility() {
        return true;
    }

    public boolean isMetaclassVisible(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.isMetaclassVisible(elementView);
    }

    private boolean isMetaclassVisible(EngineElementView elementView) {
        Object value;
        List<CustomViewFeature> visibleFeature;
        if (elementView != null && (visibleFeature = elementView.getMetaclassVisibleFeature()) != null && (value = this.getValue(visibleFeature, null, true)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultMetaclassVisibility();
    }

    private boolean getDefaultMetaclassVisibility() {
        return true;
    }

    public boolean isHideMetaclassName(EClass eClass, EObject context) {
        Object value;
        List<CustomViewFeature> feature;
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        if (elementView != null && (feature = elementView.getHideMetaclassNameFeature()) != null && (value = this.getValue(feature, context, false)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultHideMetaclassName();
    }

    public boolean isHideMetaclassNameStatic(EClass eClass) {
        Object value;
        List<CustomViewFeature> feature;
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        if (elementView != null && (feature = elementView.getHideMetaclassNameFeature()) != null && (value = this.getValue(feature, null, true)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultHideMetaclassName();
    }

    private boolean getDefaultHideMetaclassName() {
        return false;
    }

    public boolean isLinkCollapsed(EClass eClass, EReference eReference) {
        Object value;
        List<CustomViewFeature> feature;
        EngineElementView referenceView = this.getReferenceView(eClass, eReference.getName());
        if (referenceView != null && (feature = referenceView.getLinkCollapsedFeature()) != null && (value = this.getValue(feature, null, true)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultLinkCollapsed();
    }

    private boolean getDefaultLinkCollapsed() {
        return false;
    }

    public ArrayList<Object> filterVisible(List<?> childrenList) {
        ArrayList<Object> visibleElements = new ArrayList<Object>();
        for (Object object : childrenList) {
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                if (!this.isTypeVisible(eObject.eClass(), eObject)) continue;
                visibleElements.add(eObject);
                continue;
            }
            visibleElements.add(object);
        }
        return visibleElements;
    }

    public void filterVisible(Collection<EObject> elements, Collection<EObject> visibleElements) {
        for (EObject eObject : elements) {
            if (eObject == null || !this.isTypeVisible(eObject.eClass(), eObject)) continue;
            visibleElements.add(eObject);
        }
    }

    public Color getTypeColor(EObject eObject) {
        EngineElementView elementView = this.engineTypeViews.get(eObject.eClass());
        return this.getColor(elementView, eObject, false);
    }

    public Color getAttributeColor(EClass eClass, String name, EObject context) {
        return this.getColor(this.getAttributeView(eClass, name), context, false);
    }

    public Color getReferenceColor(EClass eClass, String name, EObject context) {
        return this.getColor(this.getReferenceView(eClass, name), context, false);
    }

    public Color getTypeColorStatic(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.getColor(elementView, null, true);
    }

    public Color getAttributeColorStatic(EClass eClass, String name) {
        return this.getColor(this.getAttributeView(eClass, name), null, true);
    }

    public Color getReferenceColorStatic(EClass eClass, String name) {
        return this.getColor(this.getReferenceView(eClass, name), null, true);
    }

    private Color getColor(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> colorFeature;
        if (elementView != null && (colorFeature = elementView.getColorFeature()) != null && (value = this.getValue(colorFeature, context, staticOnly)) instanceof Color) {
            Color result = (Color)value;
            return result;
        }
        return this.getDefaultColor();
    }

    private Color getDefaultColor() {
        return null;
    }

    public Color getTypeBackgroundColor(EObject eObject) {
        EngineElementView elementView = this.engineTypeViews.get(eObject.eClass());
        return this.getBackgroundColor(elementView, eObject, false);
    }

    public Color getAttributeBackgroundColor(EClass eClass, String name, EObject context) {
        return this.getBackgroundColor(this.getAttributeView(eClass, name), context, false);
    }

    public Color getReferenceBackgroundColor(EClass eClass, String name, EObject context) {
        return this.getBackgroundColor(this.getReferenceView(eClass, name), context, false);
    }

    public Color getTypeBackgroundColorStatic(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.getBackgroundColor(elementView, null, true);
    }

    public Color getAttributeBackgroundColorStatic(EClass eClass, String name) {
        return this.getBackgroundColor(this.getAttributeView(eClass, name), null, true);
    }

    public Color getReferenceBackgroundColorStatic(EClass eClass, String name) {
        return this.getBackgroundColor(this.getReferenceView(eClass, name), null, true);
    }

    private Color getBackgroundColor(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> colorFeature;
        if (elementView != null && (colorFeature = elementView.getBackgroundColorFeature()) != null && (value = this.getValue(colorFeature, context, staticOnly)) instanceof Color) {
            Color result = (Color)value;
            return result;
        }
        return this.getDefaultBackgroundColor();
    }

    private Color getDefaultBackgroundColor() {
        return null;
    }

    public String getTypeLabel(EObject eObject) {
        EngineElementView elementView = this.engineTypeViews.get(eObject.eClass());
        return this.getLabel(elementView, eObject, false);
    }

    public String getAttributeLabel(EClass eClass, String name, EObject context) {
        return this.getLabel(this.getAttributeView(eClass, name), context, false);
    }

    public String getReferenceLabel(EClass eClass, String name, EObject context) {
        return this.getLabel(this.getReferenceView(eClass, name), context, false);
    }

    public String getTypeLabelStatic(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.getLabel(elementView, null, true);
    }

    public String getAttributeLabelStatic(EClass eClass, String name) {
        return this.getLabel(this.getAttributeView(eClass, name), null, true);
    }

    public String getReferenceLabelStatic(EClass eClass, String name) {
        return this.getLabel(this.getReferenceView(eClass, name), null, true);
    }

    private String getLabel(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> feature;
        if (elementView != null && (feature = elementView.getLabelFeature()) != null && (value = this.getValue(feature, context, staticOnly)) instanceof String) {
            String result = (String)value;
            return result;
        }
        return this.getDefaultLabel();
    }

    private String getDefaultLabel() {
        return null;
    }

    public Image getTypeIcon(EObject context, EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.getIcon(elementView, context, false);
    }

    public Image getAttributeIcon(EClass eClass, String name, EObject context) {
        return this.getIcon(this.getAttributeView(eClass, name), context, false);
    }

    public Image getReferenceIcon(EClass eClass, String name, EObject context) {
        return this.getIcon(this.getReferenceView(eClass, name), context, false);
    }

    public Image getTypeIconStatic(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.getIcon(elementView, null, true);
    }

    public Image getAttributeIconStatic(EClass eClass, String name) {
        return this.getIcon(this.getAttributeView(eClass, name), null, true);
    }

    public Image getReferenceIconStatic(EClass eClass, String name) {
        return this.getIcon(this.getReferenceView(eClass, name), null, true);
    }

    private Image getIcon(EngineElementView elementView, EObject context, boolean staticOnly) {
        if (elementView != null) {
            List<CustomViewFeature> feature = elementView.getIconFeature();
            return this.getIcon(context, feature, staticOnly);
        }
        return this.getDefaultIcon();
    }

    private Image getIcon(EObject context, List<CustomViewFeature> feature, boolean staticOnly) {
        Object value;
        if (feature != null && (value = this.getValue(feature, context, staticOnly)) instanceof Image) {
            Image result = (Image)value;
            return result;
        }
        return null;
    }

    private Image getDefaultIcon() {
        return null;
    }

    public Image getFacetMainIcon(EObject eObject, EClass facet) {
        EngineElementView elementView = this.engineTypeViews.get(facet);
        if (elementView != null) {
            List<CustomViewFeature> facetMainIconFeature = elementView.getFacetMainIconFeature();
            return this.getIcon(eObject, facetMainIconFeature, false);
        }
        return null;
    }

    public OverlayIconImageInfo getFacetOverlayIcon(EObject eObject, EClass facet) {
        EngineElementView elementView = this.engineTypeViews.get(facet);
        if (elementView != null) {
            List<CustomViewFeature> facetOverlayIconFeature = elementView.getFacetOverlayIconFeature();
            return this.getOverlayIcon(eObject, facetOverlayIconFeature, false);
        }
        return null;
    }

    private OverlayIconImageInfo getOverlayIcon(EObject context, List<CustomViewFeature> facetOverlayIconFeature, boolean staticOnly) {
        Object value;
        if (facetOverlayIconFeature != null && (value = this.getValue(facetOverlayIconFeature, context, staticOnly)) instanceof OverlayIconImageInfo) {
            OverlayIconImageInfo result = (OverlayIconImageInfo)value;
            return result;
        }
        return null;
    }

    public boolean isTypeUnderlined(EClass eClass, EObject context) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.isUnderlined(elementView, context, false);
    }

    public boolean isAttributeUnderlined(EClass eClass, String name, EObject context) {
        return this.isUnderlined(this.getAttributeView(eClass, name), context, false);
    }

    public boolean isReferenceUnderlined(EClass eClass, String name, EObject context) {
        return this.isUnderlined(this.getReferenceView(eClass, name), context, false);
    }

    public boolean isTypeUnderlinedStatic(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.isUnderlined(elementView, null, true);
    }

    public boolean isAttributeUnderlinedStatic(EClass eClass, String name) {
        return this.isUnderlined(this.getAttributeView(eClass, name), null, true);
    }

    public boolean isReferenceUnderlinedStatic(EClass eClass, String name) {
        return this.isUnderlined(this.getReferenceView(eClass, name), null, true);
    }

    private boolean isUnderlined(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> feature;
        if (elementView != null && (feature = elementView.getUnderlinedFeature()) != null && (value = this.getValue(feature, context, staticOnly)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultUnderlined();
    }

    private boolean getDefaultUnderlined() {
        return false;
    }

    public boolean isTypeStruckthrough(EClass eClass, EObject context) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.isStruckthrough(elementView, context, false);
    }

    public boolean isAttributeStruckthrough(EClass eClass, String name, EObject context) {
        return this.isStruckthrough(this.getAttributeView(eClass, name), context, false);
    }

    public boolean isReferenceStruckthrough(EClass eClass, String name, EObject context) {
        return this.isStruckthrough(this.getReferenceView(eClass, name), context, false);
    }

    public boolean isTypeStruckthroughStatic(EClass eClass) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.isStruckthrough(elementView, null, true);
    }

    public boolean isAttributeStruckthroughStatic(EClass eClass, String name) {
        return this.isStruckthrough(this.getAttributeView(eClass, name), null, true);
    }

    public boolean isReferenceStruckthroughStatic(EClass eClass, String name) {
        return this.isStruckthrough(this.getReferenceView(eClass, name), null, true);
    }

    private boolean isStruckthrough(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> feature;
        if (elementView != null && (feature = elementView.getStrikethroughFeature()) != null && (value = this.getValue(feature, context, staticOnly)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultStruckthrough();
    }

    private boolean getDefaultStruckthrough() {
        return false;
    }

    private boolean isItalic(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> italicFeature;
        if (elementView != null && (italicFeature = elementView.getItalicFeature()) != null && (value = this.getValue(italicFeature, context, staticOnly)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultItalic();
    }

    private boolean getDefaultItalic() {
        return false;
    }

    private boolean isBold(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> boldFeature;
        if (elementView != null && (boldFeature = elementView.getBoldFeature()) != null && (value = this.getValue(boldFeature, context, staticOnly)) instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return this.getDefaultBold();
    }

    private boolean getDefaultBold() {
        return false;
    }

    private String getFontName(EngineElementView elementView, EObject context, boolean staticOnly) {
        Object value;
        List<CustomViewFeature> fontNameFeature;
        if (elementView != null && (fontNameFeature = elementView.getFontNameFeature()) != null && (value = this.getValue(fontNameFeature, context, staticOnly)) instanceof String) {
            String result = (String)value;
            return result;
        }
        return this.getDefaultFontName();
    }

    private String getDefaultFontName() {
        return null;
    }

    public Font getCustomizedTypeFont(EObject eObject, Font baseFont) {
        EngineElementView elementView = this.engineTypeViews.get(eObject.eClass());
        return this.getCustomizedFont(elementView, baseFont, eObject, false);
    }

    public Font getCustomizedAttributeFont(EClass eClass, String name, Font baseFont, EObject context) {
        return this.getCustomizedFont(this.getAttributeView(eClass, name), baseFont, context, false);
    }

    public Font getCustomizedReferenceFont(EClass eClass, String name, Font baseFont, EObject context) {
        return this.getCustomizedFont(this.getReferenceView(eClass, name), baseFont, context, false);
    }

    public Font getCustomizedTypeFontStatic(EClass eClass, Font baseFont) {
        EngineElementView elementView = this.engineTypeViews.get(eClass);
        return this.getCustomizedFont(elementView, baseFont, null, true);
    }

    public Font getCustomizedAttributeFontStatic(EClass eClass, String name, Font baseFont) {
        return this.getCustomizedFont(this.getAttributeView(eClass, name), baseFont, null, true);
    }

    public Font getCustomizedReferenceFontStatic(EClass eClass, String name, Font baseFont) {
        return this.getCustomizedFont(this.getReferenceView(eClass, name), baseFont, null, true);
    }

    private Font getCustomizedFont(EngineElementView elementView, Font baseFont, EObject context, boolean staticOnly) {
        boolean italic = this.isItalic(elementView, context, staticOnly);
        boolean bold = this.isBold(elementView, context, staticOnly);
        String fontName = this.getFontName(elementView, context, staticOnly);
        if (italic || bold || fontName != null) {
            FontDescriptor descriptor;
            if (fontName != null) {
                FontData fontData = baseFont.getFontData()[0];
                descriptor = FontDescriptor.createFrom((String)fontName, (int)fontData.getHeight(), (int)fontData.getStyle());
            } else {
                descriptor = FontDescriptor.createFrom((Font)baseFont);
            }
            descriptor = italic && bold ? descriptor.setStyle(3) : (italic ? descriptor.setStyle(2) : (bold ? descriptor.setStyle(1) : descriptor.setStyle(0)));
            return this.getFont(descriptor);
        }
        return null;
    }

    private Font getFont(FontDescriptor descriptor) {
        FontData fontData = descriptor.getFontData()[0];
        String key = String.valueOf(fontData.getName()) + "$" + fontData.getHeight() + "$" + fontData.getStyle();
        Font font = this.fontsCache.get(key);
        if (font == null) {
            font = descriptor.createFont((Device)Display.getDefault());
            this.fontsCache.put(key, font);
        }
        return font;
    }

    private Object getValue(List<CustomViewFeature> features, EObject context, boolean staticOnly) {
        Object result = null;
        for (CustomViewFeature feature : features) {
            result = this.getValue(feature, context, staticOnly);
            if (result != null) break;
        }
        return result;
    }

    private Object getValue(CustomViewFeature feature, EObject context, boolean staticOnly) {
        FeatureValue defaultValue;
        EList valueCases = feature.getValueCases();
        if (context != null) {
            for (FeatureValueCase featureValueCase : valueCases) {
                ModelQuery conditionQuery = featureValueCase.getCondition();
                if (EMFUtil.tryResolve((EObject)conditionQuery)) {
                    String querySetName = conditionQuery.getModelQuerySet().getName();
                    String queryName = conditionQuery.getName();
                    Object conditionResult = QueryUtil.basicEvaluate(conditionQuery, context);
                    if (conditionResult == null) continue;
                    if (conditionResult instanceof Boolean) {
                        Boolean boolResult = (Boolean)conditionResult;
                        if (!boolResult.booleanValue()) continue;
                        FeatureValue value = featureValueCase.getValue();
                        return this.evaluate(context, value, staticOnly);
                    }
                    Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_conditionQueryWrongReturnType, (Object[])new Object[]{queryName, querySetName, conditionResult.getClass().getSimpleName()}), (Plugin)Activator.getDefault());
                    continue;
                }
                Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_unresolvedConditionQuery, (Object)EMFUtil.proxyURI((EObject)conditionQuery)), (Plugin)Activator.getDefault());
            }
        }
        if ((defaultValue = feature.getDefaultValue()) != null) {
            return this.evaluate(context, defaultValue, staticOnly);
        }
        return null;
    }

    private Object evaluate(EObject context, FeatureValue featureValue, boolean staticOnly) {
        if (featureValue instanceof StaticFeatureValue) {
            StaticFeatureValue staticFeatureValue = (StaticFeatureValue)featureValue;
            String strValue = staticFeatureValue.getValue();
            if (strValue != null) {
                return this.decodeStaticValue(strValue, UicustomUtil.getCustomizedFeature((FeatureValue)staticFeatureValue));
            }
        } else if (featureValue instanceof DerivedFeatureValue && !staticOnly) {
            DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)featureValue;
            ModelQuery query = derivedFeatureValue.getValueCalculator();
            if (!EMFUtil.tryResolve((EObject)query)) {
                Logger.logError((String)NLS.bind((String)Messages.unresolvedQuery, (Object)EMFUtil.proxyURI((EObject)query)), (Plugin)Activator.getDefault());
            }
            Object modelQueryResult = QueryUtil.basicEvaluate(query, context);
            return this.decodeDerivedValue(modelQueryResult, UicustomUtil.getCustomizedFeature((FeatureValue)derivedFeatureValue), query.getName());
        }
        return null;
    }

    private Object decodeStaticValue(String strValue, CustomizableFeatures featureType) {
        switch (featureType) {
            case VISIBLE: 
            case BOLD: 
            case ITALIC: 
            case UNDERLINED: 
            case STRUCKTHROUGH: 
            case HIDE_METACLASS_NAME: 
            case METACLASS_VISIBLE: 
            case COLLAPSE_LINK: {
                return new Boolean(Boolean.parseBoolean(strValue));
            }
            case COLOR: 
            case BACKGROUND_COLOR: {
                return this.decodeColor(strValue);
            }
            case FONT_NAME: {
                return this.decodeFont(strValue);
            }
            case ICON: 
            case FACET_MAIN_ICON: {
                return this.decodeIcon(strValue);
            }
            case FACET_OVERLAY_ICON: {
                return this.decodeOverlayIcon(strValue);
            }
            case LABEL: {
                return strValue;
            }
        }
        Logger.logError((String)("unhandled feature type in CustomizationEngine:" + featureType.getName()), (Plugin)Activator.getDefault());
        return null;
    }

    private Object decodeDerivedValue(Object modelQueryResult, CustomizableFeatures featureType, String queryName) {
        switch (featureType) {
            case VISIBLE: 
            case LABEL: 
            case FONT_NAME: 
            case BOLD: 
            case ITALIC: 
            case UNDERLINED: 
            case STRUCKTHROUGH: 
            case HIDE_METACLASS_NAME: 
            case METACLASS_VISIBLE: 
            case COLLAPSE_LINK: {
                return modelQueryResult;
            }
            case COLOR: 
            case BACKGROUND_COLOR: {
                if (!(modelQueryResult instanceof String)) {
                    Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_errorColorString, (Object)queryName), (Plugin)Activator.getDefault());
                    return null;
                }
                String strColor = (String)modelQueryResult;
                return this.decodeColor(strColor);
            }
            case ICON: 
            case FACET_MAIN_ICON: {
                if (!(modelQueryResult instanceof String)) {
                    Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_errorIconString, (Object)queryName), (Plugin)Activator.getDefault());
                    return null;
                }
                String strIcon = (String)modelQueryResult;
                return this.decodeIcon(strIcon);
            }
            case FACET_OVERLAY_ICON: {
                if (!(modelQueryResult instanceof String)) {
                    Logger.logError((String)NLS.bind((String)"Customized overlay icon should be expressed as a String (\"path:position\") in query \"{0}\"", (Object)queryName), (Plugin)Activator.getDefault());
                    return null;
                }
                String strOverlayIcon = (String)modelQueryResult;
                return this.decodeOverlayIcon(strOverlayIcon);
            }
        }
        Logger.logError((String)("unhandled feature type in CustomizationEngine: " + featureType.getName()), (Plugin)Activator.getDefault());
        return null;
    }

    private Color decodeColor(String strValue) {
        Color color = this.colorsCache.get(strValue);
        if (color == null) {
            RGB decodedColor = UicustomUtil.decodeColor((String)strValue);
            color = new Color((Device)Display.getCurrent(), decodedColor);
            this.colorsCache.put(strValue, color);
        }
        return color;
    }

    private String decodeFont(String strValue) {
        return strValue;
    }

    private Image decodeIcon(String strValue) {
        Image icon = this.iconsCache.get(strValue);
        if (icon == null) {
            InputStream inputStream;
            block4: {
                try {
                    inputStream = PathUtils.getResourceStream((IPath)new Path(strValue));
                    if (inputStream != null) break block4;
                    Logger.logError((String)NLS.bind((String)Messages.CustomizationEngine_errorOpeningCustomizationResource, (Object)strValue), (Plugin)Activator.getDefault());
                    return null;
                }
                catch (Exception e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return null;
                }
            }
            icon = new Image((Device)Display.getCurrent(), inputStream);
            inputStream.close();
            this.iconsCache.put(strValue, icon);
        }
        return icon;
    }

    private OverlayIconImageInfo decodeOverlayIcon(String strValue) {
        OverlayIconInfo overlayIconInfo = UicustomUtil.decodeOverlayIcon((String)strValue);
        Image image = this.decodeIcon(overlayIconInfo.getPath());
        if (image != null) {
            return new OverlayIconImageInfo(image, overlayIconInfo.getIconPosition());
        }
        return null;
    }

    public void dispose() {
        for (Color color : this.colorsCache.values()) {
            color.dispose();
        }
        for (Font font : this.fontsCache.values()) {
            font.dispose();
        }
        for (Image image : this.iconsCache.values()) {
            image.dispose();
        }
        this.changeListeners.clear();
        if (this.customizationChangeListener != null) {
            CustomizationsCatalog.getInstance().removeChangeListener(this.customizationChangeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EngineElementView {
        private final List<CustomViewFeature> boldFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> colorFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> backgroundColorFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> fontNameFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> iconFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> facetMainIconFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> facetOverlayIconFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> italicFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> labelFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> strikethroughFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> underlinedFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> visibleFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> hideMetaclassNameFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> metaclassVisibleFeature = new ArrayList<CustomViewFeature>();
        private final List<CustomViewFeature> linkCollapsedFeature = new ArrayList<CustomViewFeature>();

        private EngineElementView() {
        }

        public void addFeatures(CustomView customView) {
            EList customizedFeatures = customView.getCustomizedFeatures();
            for (CustomViewFeature customViewFeature : customizedFeatures) {
                switch (customViewFeature.getCustomizedFeature()) {
                    case BOLD: {
                        this.boldFeature.add(customViewFeature);
                        break;
                    }
                    case COLOR: {
                        this.colorFeature.add(customViewFeature);
                        break;
                    }
                    case BACKGROUND_COLOR: {
                        this.backgroundColorFeature.add(customViewFeature);
                        break;
                    }
                    case FONT_NAME: {
                        this.fontNameFeature.add(customViewFeature);
                        break;
                    }
                    case ICON: {
                        this.iconFeature.add(customViewFeature);
                        break;
                    }
                    case FACET_MAIN_ICON: {
                        this.facetMainIconFeature.add(customViewFeature);
                        break;
                    }
                    case FACET_OVERLAY_ICON: {
                        this.facetOverlayIconFeature.add(customViewFeature);
                        break;
                    }
                    case ITALIC: {
                        this.italicFeature.add(customViewFeature);
                        break;
                    }
                    case LABEL: {
                        this.labelFeature.add(customViewFeature);
                        break;
                    }
                    case STRUCKTHROUGH: {
                        this.strikethroughFeature.add(customViewFeature);
                        break;
                    }
                    case UNDERLINED: {
                        this.underlinedFeature.add(customViewFeature);
                        break;
                    }
                    case VISIBLE: {
                        this.visibleFeature.add(customViewFeature);
                        break;
                    }
                    case HIDE_METACLASS_NAME: {
                        this.hideMetaclassNameFeature.add(customViewFeature);
                        break;
                    }
                    case METACLASS_VISIBLE: {
                        this.metaclassVisibleFeature.add(customViewFeature);
                        break;
                    }
                    case COLLAPSE_LINK: {
                        this.linkCollapsedFeature.add(customViewFeature);
                        break;
                    }
                    default: {
                        Logger.logError((String)("unhandled feature type in CustomizationEngine: " + customViewFeature), (Plugin)Activator.getDefault());
                    }
                }
            }
        }

        public List<CustomViewFeature> getBoldFeature() {
            return this.boldFeature;
        }

        public List<CustomViewFeature> getColorFeature() {
            return this.colorFeature;
        }

        public List<CustomViewFeature> getBackgroundColorFeature() {
            return this.backgroundColorFeature;
        }

        public List<CustomViewFeature> getFontNameFeature() {
            return this.fontNameFeature;
        }

        public List<CustomViewFeature> getIconFeature() {
            return this.iconFeature;
        }

        public List<CustomViewFeature> getFacetMainIconFeature() {
            return this.facetMainIconFeature;
        }

        public List<CustomViewFeature> getFacetOverlayIconFeature() {
            return this.facetOverlayIconFeature;
        }

        public List<CustomViewFeature> getItalicFeature() {
            return this.italicFeature;
        }

        public List<CustomViewFeature> getLabelFeature() {
            return this.labelFeature;
        }

        public List<CustomViewFeature> getStrikethroughFeature() {
            return this.strikethroughFeature;
        }

        public List<CustomViewFeature> getUnderlinedFeature() {
            return this.underlinedFeature;
        }

        public List<CustomViewFeature> getVisibleFeature() {
            return this.visibleFeature;
        }

        public List<CustomViewFeature> getHideMetaclassNameFeature() {
            return this.hideMetaclassNameFeature;
        }

        public List<CustomViewFeature> getMetaclassVisibleFeature() {
            return this.metaclassVisibleFeature;
        }

        public List<CustomViewFeature> getLinkCollapsedFeature() {
            return this.linkCollapsedFeature;
        }
    }

    class FeatureKey {
        private final EClass eClass;
        private final String featureName;

        public FeatureKey(EClass eClass, String featureName) {
            if (eClass == null) {
                throw new IllegalArgumentException("null eClass");
            }
            if (featureName == null) {
                throw new IllegalArgumentException("null featureName");
            }
            this.eClass = eClass;
            this.featureName = featureName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FeatureKey) {
                FeatureKey other = (FeatureKey)obj;
                return other.eClass.equals(this.eClass) && other.featureName.equals(this.featureName);
            }
            return false;
        }

        public int hashCode() {
            int hashPrime1 = 37;
            int hashPrime2 = 31;
            return this.eClass.hashCode() * 31 + this.featureName.hashCode() + 37;
        }
    }
}

