/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.emf.facet.infra.browser.custom.util.UicustomUtil;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Factory;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration2.TableConfiguration2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NatTableWidgetUtils {
    private NatTableWidgetUtils() {
    }

    public static TableInstance2 createTableInstance(List<EObject> elements, String description, TableConfiguration tableConfiguration, EObject context, Object parameter) {
        TableInstance2 tableInstance = Tableinstance2Factory.eINSTANCE.createTableInstance2();
        tableInstance.setTableConfiguration(tableConfiguration);
        tableInstance.setContext(context);
        tableInstance.setParameter(parameter);
        for (EObject eObject : elements) {
            if (tableInstance.getElements().contains((Object)eObject)) continue;
            Row row = TableinstanceFactory.eINSTANCE.createRow();
            row.setElement(eObject);
            tableInstance.getRows().add((Object)row);
        }
        if (tableConfiguration != null) {
            for (Facet facet : tableConfiguration.getDefaultFacets()) {
                try {
                    FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet(facet.getFacetSet().getName());
                    Facet registeredFacet = facetSet.getFacet(facet.getName());
                    if (registeredFacet == null || tableInstance.getFacets2().contains((Object)registeredFacet)) continue;
                    tableInstance.getFacets2().add((Object)registeredFacet);
                }
                catch (Exception e) {
                    Logger.logError((String)("The referenced facet:" + facet + " could not be loaded"), (Plugin)Activator.getDefault());
                }
            }
            for (MetamodelView custom : tableConfiguration.getDefaultCustomizations()) {
                if (tableInstance.getCustomizations().contains((Object)custom)) continue;
                tableInstance.getCustomizations().add((Object)custom);
            }
            MetamodelView defaultLocalCustomization = tableConfiguration.getDefaultLocalCustomization();
            if (defaultLocalCustomization != null && !tableInstance.getLocalCustomizations().contains((Object)defaultLocalCustomization)) {
                tableInstance.getLocalCustomizations().add((Object)tableConfiguration.getDefaultLocalCustomization());
            }
            if (tableConfiguration instanceof TableConfiguration2) {
                TableConfiguration2 tableConfiguration2 = (TableConfiguration2)tableConfiguration;
                for (MetamodelView custom : tableConfiguration2.getDefaultLocalCustomizations()) {
                    if (tableInstance.getLocalCustomizations().contains((Object)custom)) continue;
                    tableInstance.getLocalCustomizations().add((Object)custom);
                }
            }
        }
        NatTableWidgetUtils.createColumns((TableInstance)tableInstance);
        tableInstance.setDescription(description);
        HashSet<EPackage> alreadyDone = new HashSet<EPackage>();
        List<EStructuralFeature> allFeatures = NatTableWidgetUtils.getTableInstanceEStructuralFeatures((TableInstance)tableInstance);
        for (EStructuralFeature currentF : allFeatures) {
            EObject container = currentF.eContainer();
            if (container != null) {
                container = container.eContainer();
            }
            if (!(container instanceof EPackage) || alreadyDone.contains(container) || UicustomUtil.getMetamodelViewByEPackage((List)tableInstance.getLocalCustomizations(), (EPackage)((EPackage)container)) != null) continue;
            MetamodelView metamodelView = UicustomFactory.eINSTANCE.createMetamodelView();
            metamodelView.setMetamodelURI(((EPackage)container).getNsURI());
            metamodelView.setAllQuerySetsAvailable(false);
            tableInstance.getLocalCustomizations().add((Object)metamodelView);
            alreadyDone.add((EPackage)container);
        }
        for (Facet current : tableInstance.getFacets2()) {
            EObject container = current.eContainer();
            if (!(container instanceof EPackage) || alreadyDone.contains(container) || UicustomUtil.getMetamodelViewByEPackage((List)tableInstance.getLocalCustomizations(), (EPackage)((EPackage)container)) != null) continue;
            MetamodelView metamodelView = UicustomFactory.eINSTANCE.createMetamodelView();
            metamodelView.setMetamodelURI(((EPackage)container).getNsURI());
            metamodelView.setAllQuerySetsAvailable(false);
            tableInstance.getLocalCustomizations().add((Object)metamodelView);
            alreadyDone.add((EPackage)container);
        }
        if (!tableInstance.getLocalCustomizations().isEmpty()) {
            tableInstance.getCustomizations().addAll(0, (Collection)tableInstance.getLocalCustomizations());
        }
        return tableInstance;
    }

    public static QueryTableInstance createQueryTableInstance(List<ModelQueryResult> results, TableConfiguration tableConfiguration, EObject context, Object parameter) {
        QueryTableInstance2 queryTableInstance = Tableinstance2Factory.eINSTANCE.createQueryTableInstance2();
        queryTableInstance.getQueryResults2().addAll(results);
        queryTableInstance.setTableConfiguration(tableConfiguration);
        queryTableInstance.setContext(context);
        queryTableInstance.setParameter(parameter);
        for (ModelQueryResult result : results) {
            if (result.getValue() instanceof Collection) {
                Collection collection = (Collection)result.getValue();
                for (Object object : collection) {
                    NatTableWidgetUtils.createQueryRow((QueryTableInstance)queryTableInstance, result, object);
                }
                continue;
            }
            NatTableWidgetUtils.createQueryRow((QueryTableInstance)queryTableInstance, result, result.getValue());
        }
        NatTableWidgetUtils.createColumns((TableInstance)queryTableInstance);
        return queryTableInstance;
    }

    private static void createQueryRow(QueryTableInstance queryTableInstance, ModelQueryResult result, Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (!queryTableInstance.getElements().contains((Object)eObject)) {
                EObjectQueryRow row = Tableinstance2Factory.eINSTANCE.createEObjectQueryRow();
                row.setElement(eObject);
                row.setQueryResult(result);
                queryTableInstance.getRows().add((Object)row);
            }
        } else {
            PrimitiveTypeQueryRow row = Tableinstance2Factory.eINSTANCE.createPrimitiveTypeQueryRow();
            row.setElement((EObject)result);
            row.setQueryResult(result);
            row.setValue(object);
            queryTableInstance.getRows().add((Object)row);
        }
    }

    private static void createColumns(TableInstance tableInstance) {
        List<EStructuralFeature> features = NatTableWidgetUtils.getTableInstanceEStructuralFeatures(tableInstance);
        if (tableInstance instanceof QueryTableInstance) {
            tableInstance.getColumns().add((Object)TableinstanceFactory.eINSTANCE.createContextColumn());
            for (Row row : tableInstance.getRows()) {
                if (!(row instanceof PrimitiveTypeQueryRow)) continue;
                tableInstance.getColumns().add((Object)Tableinstance2Factory.eINSTANCE.createValueColumn());
                break;
            }
        } else {
            tableInstance.getColumns().add((Object)TableinstanceFactory.eINSTANCE.createDefaultLabelColumn());
            tableInstance.getColumns().add((Object)TableinstanceFactory.eINSTANCE.createMetaClassColumn());
            tableInstance.getColumns().add((Object)TableinstanceFactory.eINSTANCE.createEContainerColumn());
        }
        for (EStructuralFeature feature : features) {
            if (feature instanceof EReference) {
                ReferenceColumn referenceColumn = TableinstanceFactory.eINSTANCE.createReferenceColumn();
                referenceColumn.setReference((EReference)feature);
                tableInstance.getColumns().add((Object)referenceColumn);
                continue;
            }
            if (!(feature instanceof EAttribute)) continue;
            AttributeColumn attributeColumn = TableinstanceFactory.eINSTANCE.createAttributeColumn();
            attributeColumn.setAttribute((EAttribute)feature);
            tableInstance.getColumns().add((Object)attributeColumn);
        }
        if (tableInstance instanceof TableInstance2) {
            FacetContext facetContext = new FacetContext();
            facetContext.addFacets((Collection)((TableInstance2)tableInstance).getFacets2());
            HashSet eReferences = new HashSet();
            HashSet eAttributes = new HashSet();
            ArrayList<Status> statusList = new ArrayList<Status>();
            for (EObject eObject : tableInstance.getElements()) {
                try {
                    eAttributes.addAll(facetContext.getAttributes(eObject));
                    eReferences.addAll(facetContext.getReferences(eObject));
                }
                catch (ModelQueryException e) {
                    Status status = new Status(4, "org.eclipse.emf.facet.widgets.nattable", "An exception has occured while retrieving structural features of:" + eObject, (Throwable)e);
                    statusList.add(status);
                }
            }
            if (!statusList.isEmpty()) {
                MultiStatus globalStatus = new MultiStatus("org.eclipse.emf.facet.widgets.nattable", 0, "An exception has occured while retrieving structural features of the eObjects", (Throwable)new Exception());
                Logger.logError((Throwable)new CoreException((IStatus)globalStatus), (Plugin)Activator.getDefault());
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Failed to load facets", (String)"Some facets failed to load. See error to have more details.");
            }
            for (EAttribute eAttribute : eAttributes) {
                FacetAttributeColumn facetAttributeColumn = TableinstanceFactory.eINSTANCE.createFacetAttributeColumn();
                facetAttributeColumn.setAttribute((FacetAttribute)eAttribute);
                tableInstance.getColumns().add((Object)facetAttributeColumn);
            }
            for (EReference eReference : eReferences) {
                FacetReferenceColumn facetReferenceColumn = TableinstanceFactory.eINSTANCE.createFacetReferenceColumn();
                facetReferenceColumn.setReference((FacetReference)eReference);
                tableInstance.getColumns().add((Object)facetReferenceColumn);
            }
        }
    }

    private static List<EStructuralFeature> getTableInstanceEStructuralFeatures(TableInstance tableInstance) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        if (!tableInstance.getElements().isEmpty()) {
            for (EObject eObject : tableInstance.getElements()) {
                if (eObject == null || eObject instanceof ModelQueryResult && tableInstance instanceof QueryTableInstance) continue;
                for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                    if (features.contains(eStructuralFeature)) continue;
                    features.add(eStructuralFeature);
                }
            }
        }
        return features;
    }
}

