/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ICellEditHandler;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.style.IStyle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.celleditors.INaryFeatureCellEditor;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableNaryReferenceCellEditorAdapter
implements ICellEditor {
    private final INaryFeatureCellEditor cellEditor;
    private final List<Column> columnDescriptions;
    private Control control;
    private Composite fParent;
    private final EditingDomain editingDomain;

    public NatTableNaryReferenceCellEditorAdapter(INaryFeatureCellEditor cellEditor, List<Column> columnDescriptions, EditingDomain editingDomain) {
        this.cellEditor = cellEditor;
        this.columnDescriptions = columnDescriptions;
        this.editingDomain = editingDomain;
    }

    public Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue, IDisplayConverter displayConverter, IStyle cellStyle, IDataValidator dataValidator, ICellEditHandler editHandler, int colIndex, int rowIndex) {
        this.fParent = parent;
        Column columnDescription = this.columnDescriptions.get(colIndex);
        if (!(columnDescription instanceof FeatureColumn)) {
            this.control = new Composite(parent, 0);
            return this.control;
        }
        FeatureColumn featureColumn = (FeatureColumn)columnDescription;
        EStructuralFeature feature = featureColumn.getFeature();
        GridElement gridElement = (GridElement)originalCanonicalValue;
        Object element = gridElement.getElement();
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            this.control = this.cellEditor.activateCell(parent, feature, eObject, this.editingDomain);
            return this.control;
        }
        throw new IllegalArgumentException("not an EObject");
    }

    public void setCanonicalValue(Object canonicalValue) {
        throw new UnsupportedOperationException();
    }

    public Object getCanonicalValue() {
        throw new UnsupportedOperationException("commit should be disabled and editing domain used directly");
    }

    public void close() {
        if (this.fParent != null && !this.fParent.isDisposed()) {
            this.fParent.forceFocus();
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
    }

    public boolean isClosed() {
        return this.control == null || this.control.isDisposed();
    }
}

