/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal.painter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.TextPainter;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.CellStyleUtil;
import net.sourceforge.nattable.style.IStyle;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.uicore.internal.CustomTreePainter;
import org.eclipse.emf.facet.infra.browser.uicore.internal.FacetToPaint;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.internal.TableLabelProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.painter.Customization;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class CustomizedCellPainter
extends TextPainter {
    private final NatTableWidget.BodyLayerStack bodyLayerStack;
    private final TableLabelProvider tableLabelProvider;
    private final CustomizationEngine customizationEngine;
    private final NatTableWidget natTableWidget;
    private final Map<RGB, Color> cachedColors = new HashMap<RGB, Color>();

    public CustomizedCellPainter(NatTableWidget.BodyLayerStack bodyLayerStack, TableLabelProvider tableLabelProvider, CustomizationEngine customizationEngine, NatTableWidget natTableWidget) {
        this.bodyLayerStack = bodyLayerStack;
        this.tableLabelProvider = tableLabelProvider;
        this.customizationEngine = customizationEngine;
        this.natTableWidget = natTableWidget;
    }

    protected String convertDataType(LayerCell cell, IConfigRegistry configRegistry) {
        ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()), (ILayer)this.bodyLayerStack.getBodyDataLayer());
        return this.tableLabelProvider.getColumnText((GridElement)cell.getDataValue(), converted.getColumnPosition());
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        int convertedColumn = this.natTableWidget.convertCellPositionToDataLayer(cell);
        if (convertedColumn < this.natTableWidget.getTableInstance().getColumns().size()) {
            GridElement gridElement;
            Object element;
            Column columns = this.natTableWidget.getColumns().get(convertedColumn);
            Rectangle rectangleWithMargin = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
            Color backgroundColor = (Color)CellStyleUtil.getCellStyle((LayerCell)cell, (IConfigRegistry)configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
            Customization customization = null;
            Object dataValue = cell.getDataValue();
            if (dataValue instanceof GridElement && (element = (gridElement = (GridElement)dataValue).getElement()) instanceof EObject) {
                EObject eObject = (EObject)element;
                customization = this.getCustomization(eObject, columns, rectangleWithMargin);
            }
            if (customization != null && customization.getBackground() != null) {
                Color customizedColor = customization.getBackground();
                if (cell.getDisplayMode() == "SELECT") {
                    Color mergedColor;
                    double opacity = 0.3;
                    backgroundColor = mergedColor = this.mergeColors(customizedColor, backgroundColor, 0.3);
                } else {
                    backgroundColor = customizedColor;
                }
            }
            Color originalBackground = gc.getBackground();
            gc.setBackground(backgroundColor);
            gc.fillRectangle(rectangle);
            gc.setBackground(originalBackground);
            Rectangle originalClipping = gc.getClipping();
            gc.setClipping(rectangleWithMargin);
            IStyle cellStyle = CellStyleUtil.getCellStyle((LayerCell)cell, (IConfigRegistry)configRegistry);
            this.setupGCFromConfig(gc, cellStyle);
            String text = this.convertDataType(cell, configRegistry);
            if (customization != null) {
                if (customization.getForeground() != null) {
                    gc.setForeground(customization.getForeground());
                }
                if (customization.getLabel() != null) {
                    text = customization.getLabel();
                }
                if (customization.getFont() != null) {
                    gc.setFont(customization.getFont());
                }
            }
            gc.setClipping(rectangle);
            boolean hasIcon = false;
            if (customization != null && customization.getInstanceIcon() != null) {
                gc.drawImage(customization.getInstanceIcon(), rectangleWithMargin.x, rectangleWithMargin.y);
                hasIcon = true;
            } else {
                Image columnImage = this.tableLabelProvider.getColumnImage(cell.getDataValue(), convertedColumn);
                if (columnImage != null) {
                    gc.drawImage(columnImage, rectangleWithMargin.x, rectangleWithMargin.y);
                    hasIcon = true;
                }
            }
            boolean hasOverlay = false;
            if (customization != null) {
                int facetMinX = rectangle.width;
                List<FacetToPaint> facetsToMeasure = customization.getFacetsToPaint();
                for (FacetToPaint facetToPaint : facetsToMeasure) {
                    if (!facetToPaint.isOverlay()) {
                        facetMinX = Math.min(facetMinX, facetToPaint.getBounds().x);
                        continue;
                    }
                    hasOverlay = true;
                }
                Rectangle textClipping = new Rectangle(rectangleWithMargin.x, rectangleWithMargin.y, facetMinX - 2, rectangleWithMargin.height);
                gc.setClipping(textClipping);
            }
            if (hasIcon) {
                int offsetAfterIcon = 18;
                int overlaySize = 8;
                int totalOffsetAfterIcon = hasOverlay ? 26 : 18;
                gc.drawText(text, rectangleWithMargin.x + totalOffsetAfterIcon, rectangleWithMargin.y, true);
            } else {
                gc.drawText(text, rectangleWithMargin.x, rectangleWithMargin.y, true);
            }
            gc.setClipping(rectangle);
            if (customization != null) {
                boolean leftMargin = false;
                boolean rightMargin = false;
                if (customization.isUnderlined()) {
                    int y = rectangleWithMargin.y + rectangleWithMargin.height - 1;
                    gc.drawLine(rectangleWithMargin.x + 0, y, rectangleWithMargin.x + rectangleWithMargin.width - 0, y);
                }
                if (customization.isStruckthrough()) {
                    int y = rectangleWithMargin.y + rectangleWithMargin.height / 2 + 1;
                    gc.drawLine(rectangleWithMargin.x + 0, y, rectangleWithMargin.x + rectangleWithMargin.width - 0, y);
                }
            }
            if (customization != null) {
                List<FacetToPaint> facetsToPaint = customization.getFacetsToPaint();
                for (FacetToPaint facetToPaint : facetsToPaint) {
                    Image customizedIcon = facetToPaint.getImage();
                    if (customizedIcon == null) continue;
                    Rectangle bounds = customizedIcon.getBounds();
                    Rectangle target = facetToPaint.getBounds();
                    Rectangle stickerRectangle = new Rectangle(rectangle.x + target.x + 1, rectangle.y + target.y + 1, target.width, target.height);
                    gc.drawImage(customizedIcon, 0, 0, bounds.width, bounds.height, stickerRectangle.x, stickerRectangle.y, stickerRectangle.width, stickerRectangle.height);
                }
            }
            gc.setClipping(originalClipping);
        }
    }

    private Color mergeColors(Color color1, Color color2, double opacity) {
        double opacity2 = 1.0 - opacity;
        RGB rgb = new RGB((int)((double)color1.getRed() * opacity + (double)color2.getRed() * opacity2), (int)((double)color1.getGreen() * opacity + (double)color2.getGreen() * opacity2), (int)((double)color1.getBlue() * opacity + (double)color2.getBlue() * opacity2));
        Color color = this.cachedColors.get(rgb);
        if (color == null) {
            color = new Color(color1.getDevice(), rgb);
            this.cachedColors.put(rgb, color);
        }
        return color;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Customization getCustomization(EObject eObject, Column column, Rectangle rectangle) {
        EAttribute attribute;
        AttributeColumn attributeColumn;
        Customization customization = new Customization();
        EObject customizedEObject = null;
        if (column instanceof MetaClassColumn) {
            return customization;
        }
        if (column instanceof AttributeColumn) {
            attributeColumn = (AttributeColumn)column;
            attribute = attributeColumn.getAttribute();
            if (!eObject.eClass().getEAllAttributes().contains((Object)attribute)) {
                return customization;
            }
            customizedEObject = eObject;
        } else if (column instanceof ReferenceColumn) {
            ReferenceColumn referenceColumn = (ReferenceColumn)column;
            EReference reference = referenceColumn.getReference();
            if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                return customization;
            }
            if (reference.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)reference);
                if (list.size() != 1) return customization;
                customizedEObject = (EObject)list.get(0);
            } else {
                Object value = eObject.eGet((EStructuralFeature)reference);
                if (!(value instanceof EObject)) return customization;
                customizedEObject = (EObject)value;
            }
        } else {
            if (column instanceof ContextColumn) {
                return customization;
            }
            if (column instanceof DefaultLabelColumn) {
                customizedEObject = eObject;
            } else if (column instanceof EContainerColumn) {
                customizedEObject = eObject.eContainer();
            } else {
                if (column instanceof QueryColumn) {
                    return null;
                }
                if (column instanceof FacetAttributeColumn) {
                    return null;
                }
                if (column instanceof FacetReferenceColumn) {
                    return null;
                }
                if (column instanceof ValueColumn) {
                    return null;
                }
                Logger.logError((String)("unhandled case: " + column.eClass().getName()), (Plugin)Activator.getDefault());
                return customization;
            }
        }
        if (customizedEObject == null) {
            return customization;
        }
        if (column instanceof AttributeColumn) {
            attributeColumn = (AttributeColumn)column;
            attribute = attributeColumn.getAttribute();
            customization.setLabel(this.customizationEngine.getAttributeLabel((EClass)attribute.eContainer(), attribute.getName(), customizedEObject));
            customization.setInstanceIcon(this.customizationEngine.getAttributeIcon((EClass)attribute.eContainer(), attribute.getName(), customizedEObject));
            customization.setBackground(this.customizationEngine.getAttributeBackgroundColor((EClass)attribute.eContainer(), attribute.getName(), customizedEObject));
            customization.setForeground(this.customizationEngine.getAttributeColor((EClass)attribute.eContainer(), attribute.getName(), customizedEObject));
            customization.setFont(this.customizationEngine.getCustomizedAttributeFont((EClass)attribute.eContainer(), attribute.getName(), Display.getDefault().getSystemFont(), customizedEObject));
            customization.setUnderlined(this.customizationEngine.isAttributeUnderlined((EClass)attribute.eContainer(), attribute.getName(), customizedEObject));
            customization.setStruckthrough(this.customizationEngine.isAttributeStruckthrough((EClass)attribute.eContainer(), attribute.getName(), customizedEObject));
            return customization;
        } else {
            customization.setLabel(this.customizationEngine.getTypeLabel(customizedEObject));
            Image facetIcon = null;
            for (Facet facet : this.natTableWidget.getFacetContext().getFacets(customizedEObject)) {
                facetIcon = this.customizationEngine.getFacetMainIcon(customizedEObject, (EClass)facet);
                if (facetIcon != null) break;
            }
            if (facetIcon != null) {
                customization.setInstanceIcon(facetIcon);
            } else {
                customization.setInstanceIcon(this.customizationEngine.getTypeIcon(customizedEObject, customizedEObject.eClass()));
            }
            customization.setBackground(this.customizationEngine.getTypeBackgroundColor(customizedEObject));
            customization.setForeground(this.customizationEngine.getTypeColor(customizedEObject));
            customization.setFont(this.customizationEngine.getCustomizedTypeFont(customizedEObject, Display.getDefault().getSystemFont()));
            customization.setUnderlined(this.customizationEngine.isTypeUnderlined(customizedEObject.eClass(), customizedEObject));
            customization.setStruckthrough(this.customizationEngine.isTypeStruckthrough(customizedEObject.eClass(), customizedEObject));
            List facetsToPaint = CustomTreePainter.getFacetsToPaintFor((EObject)customizedEObject, (int)0, (int)rectangle.width, (int)0, (int)rectangle.height, (int)rectangle.width, (CustomizationEngine)this.customizationEngine, (FacetContext)this.natTableWidget.getFacetContext());
            customization.setFacetsToPaint(facetsToPaint);
        }
        return customization;
    }

    protected void finalize() throws Throwable {
        for (Color color : this.cachedColors.values()) {
            color.dispose();
        }
        super.finalize();
    }
}

