/**
 * Copyright (c) 2010 CEA LIST
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - design and implementation
 *     Gregoire DUPE (Mia-Software) - design and implementation
 * 
 */
package org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Enum1</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.SamplemmPackage#getEnum1()
 * @model
 * @generated
 */
public enum Enum1 implements Enumerator {
	/**
	 * The '<em><b>Lit1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIT1_VALUE
	 * @generated
	 * @ordered
	 */
	LIT1(0, "Lit1", "Lit1"),

	/**
	 * The '<em><b>Lit2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIT2_VALUE
	 * @generated
	 * @ordered
	 */
	LIT2(1, "Lit2", "Lit2"),

	/**
	 * The '<em><b>Lit3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIT3_VALUE
	 * @generated
	 * @ordered
	 */
	LIT3(3, "Lit3", "Lit3");

	/**
	 * The '<em><b>Lit1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Lit1</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIT1
	 * @model name="Lit1"
	 * @generated
	 * @ordered
	 */
	public static final int LIT1_VALUE = 0;

	/**
	 * The '<em><b>Lit2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Lit2</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIT2
	 * @model name="Lit2"
	 * @generated
	 * @ordered
	 */
	public static final int LIT2_VALUE = 1;

	/**
	 * The '<em><b>Lit3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Lit3</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIT3
	 * @model name="Lit3"
	 * @generated
	 * @ordered
	 */
	public static final int LIT3_VALUE = 3;

	/**
	 * An array of all the '<em><b>Enum1</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final Enum1[] VALUES_ARRAY =
		new Enum1[] {
			LIT1,
			LIT2,
			LIT3,
		};

	/**
	 * A public read-only list of all the '<em><b>Enum1</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<Enum1> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Enum1</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Enum1 get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Enum1 result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Enum1</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Enum1 getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Enum1 result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Enum1</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Enum1 get(int value) {
		switch (value) {
			case LIT1_VALUE: return LIT1;
			case LIT2_VALUE: return LIT2;
			case LIT3_VALUE: return LIT3;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private Enum1(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //Enum1
