/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.facet.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.common.core.internal.adapters.instances.MetaclassInstances;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.infra.facet.Shortcut;
import org.eclipse.emf.facet.infra.facet.core.FacetContextListener;
import org.eclipse.emf.facet.infra.facet.core.adapters.instances.MetaclassInstancesAdapterFactoryWithFacet;
import org.eclipse.emf.facet.infra.facet.core.exception.EmfFacetFacetException;
import org.eclipse.emf.facet.infra.facet.core.exception.StructuralConstraintViolationException;
import org.eclipse.emf.facet.infra.facet.core.internal.Activator;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQueryParameter;
import org.eclipse.emf.facet.infra.query.QueryFactory;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.emf.facet.infra.query.runtime.RuntimeFactory;
import org.eclipse.emf.facet.util.core.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetContext {
    public static final String NEW_VALUE = "newValue";
    private final Set<Facet> appliedFacets = new HashSet<Facet>();
    private final List<EStructuralFeature> appliedFeatures = new ArrayList<EStructuralFeature>();
    private final Set<Resource> resources = new HashSet<Resource>();
    private final List<FacetContextListener> listeners = new ArrayList<FacetContextListener>();

    public void setResources(Collection<Resource> resources) {
        this.resources.clear();
        for (Resource resource : resources) {
            this.addComposedResource(resource);
        }
    }

    private void addComposedResource(Resource resource) {
        this.resources.add(resource);
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
        while (allContents.hasNext()) {
            EObject element = (EObject)allContents.next();
            if (element.eResource() == resource) continue;
            this.resources.add(element.eResource());
        }
    }

    public void addFacetSet(FacetSet facetSet) {
        for (Facet facet : facetSet.getFacets()) {
            this.addFacet(facet);
        }
    }

    public void addFacet(Facet facet) {
        if (!this.appliedFacets.contains(facet)) {
            this.appliedFacets.add(facet);
            this.notifyFacetAdded(facet);
            for (EStructuralFeature feature : facet.getEStructuralFeatures()) {
                if (!(feature instanceof FacetStructuralFeature) && !(feature instanceof Shortcut)) continue;
                this.appliedFeatures.add(feature);
            }
        }
    }

    public void addFacets(Collection<Facet> facets) {
        for (Facet facet : facets) {
            this.addFacet(facet);
        }
    }

    public boolean isInstance(EObject eObject, Facet facet) throws ModelQueryException {
        ModelQuery modelQuery = facet.getConditionQuery();
        boolean result = false;
        boolean isSuperType = false;
        for (EClass superType : facet.getESuperTypes()) {
            if (!superType.isSuperTypeOf(eObject.eClass())) continue;
            isSuperType = true;
            break;
        }
        if (isSuperType) {
            if (modelQuery == null) {
                result = true;
            } else {
                AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
                try {
                    Object queryResult = abstractModelQuery.basicEvaluate(eObject);
                    if (queryResult instanceof Boolean) {
                        result = (Boolean)queryResult;
                    } else {
                        String message = "Query " + abstractModelQuery.toString() + " didn't return a boolean result as expected.";
                        Logger.logError((String)message, (Plugin)Activator.getDefault());
                    }
                }
                catch (ModelQueryException e) {
                    result = false;
                    throw e;
                }
                catch (Exception e) {
                    result = false;
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    throw new ModelQueryException("FacetContext failed to execute a query", (Throwable)e);
                }
            }
        }
        return result;
    }

    public void set(EObject eObject, FacetStructuralFeature facetStructuralFeature, Object value) throws ModelQueryException, EmfFacetFacetException {
        this.set(eObject, facetStructuralFeature, value, null);
    }

    public void set(EObject eObject, FacetStructuralFeature facetStructuralFeature, Object value, EditingDomain editingDomain) throws ModelQueryException, EmfFacetFacetException {
        ModelQuery setQuery = facetStructuralFeature.getSetQuery();
        if (setQuery != null) {
            ArrayList<ModelQueryParameterValue> parameters = new ArrayList<ModelQueryParameterValue>();
            ModelQueryParameterValue parameterValue = RuntimeFactory.eINSTANCE.createModelQueryParameterValue();
            ModelQueryParameter parameter = QueryFactory.eINSTANCE.createModelQueryParameter();
            parameter.setName(NEW_VALUE);
            parameter.setType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
            parameterValue.setParameter(parameter);
            parameterValue.setValue(value);
            parameters.add(parameterValue);
            AbstractModelQuery queryImpl = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(setQuery);
            if (queryImpl instanceof AbstractModelQueryWithEditingDomain) {
                AbstractModelQueryWithEditingDomain queryImplWithEditingDomain = (AbstractModelQueryWithEditingDomain)queryImpl;
                queryImplWithEditingDomain.basicEvaluate(eObject, parameters, editingDomain);
            } else {
                queryImpl.basicEvaluate(eObject, parameters);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(EObject eObject, EStructuralFeature structuralFeature) throws ModelQueryException, EmfFacetFacetException {
        if (structuralFeature == null) {
            throw new EmfFacetFacetException("The parameter named structuralFeature is null");
        }
        Object result = null;
        if (!this.appliedFeatures.contains(structuralFeature)) throw new EmfFacetFacetException("The structuralFeature must be registered into the context, please use the " + FacetContext.class.getSimpleName() + ".add(FacetSet) method.");
        Facet facet = (Facet)structuralFeature.eContainer();
        if (!this.isInstance(eObject, facet)) throw new EmfFacetFacetException("The eObject parameter must be an instance of : " + facet.getName());
        if (structuralFeature instanceof FacetStructuralFeature) {
            FacetStructuralFeature facetStructuralFeature = (FacetStructuralFeature)structuralFeature;
            ModelQuery modelQuery = facetStructuralFeature.getValueQuery();
            AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
            result = abstractModelQuery.basicEvaluate(eObject);
        } else {
            if (!(structuralFeature instanceof Shortcut)) throw new EmfFacetFacetException("The structuralFeature parameter must be a FacetStructuralFeature: " + structuralFeature.toString());
            Shortcut shortcut = (Shortcut)structuralFeature;
            BasicEList resultList = new BasicEList();
            EReference oppositeRef = shortcut.getOppositeReference();
            EClass eClass = oppositeRef.getEContainingClass();
            List<EObject> list = this.allInstances(eClass);
            for (EObject modelElement : list) {
                EObject referedByModelElement = (EObject)modelElement.eGet((EStructuralFeature)oppositeRef);
                if (referedByModelElement != eObject) continue;
                EObject element = modelElement;
                for (EReference eReference : shortcut.getPath()) {
                    element = (EObject)element.eGet((EStructuralFeature)eReference);
                }
                resultList.add(element);
            }
            if (shortcut.getUpperBound() > 1) {
                result = resultList;
            } else {
                if (resultList.size() > 1) {
                    throw new StructuralConstraintViolationException();
                }
                if (resultList.size() == 1) {
                    result = resultList.get(0);
                }
            }
        }
        if (!(result instanceof Collection)) return result;
        if (result instanceof BasicEList) return result;
        Collection list = (Collection)result;
        BasicEList basicEList = new BasicEList(list);
        return basicEList;
    }

    protected List<EObject> allInstances(EClass eClass) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(this);
        for (Resource resource : this.resources) {
            MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
            result.addAll(instances.getInstances(eClass, true));
        }
        return result;
    }

    public List<EStructuralFeature> getFacetFeatures(EObject eObject) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (Facet facet : this.appliedFacets) {
            try {
                if (!this.isInstance(eObject, facet)) continue;
                result.addAll((Collection<EStructuralFeature>)facet.getEStructuralFeatures());
            }
            catch (ModelQueryException e) {
                Status status = new Status(4, "org.eclipse.emf.facet.infra.facet.core", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    public void addAll(Collection<FacetSet> allFacetSets) {
        for (FacetSet facetSet : allFacetSets) {
            this.addFacetSet(facetSet);
        }
    }

    public EList<EAttribute> getAttributes(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Facet facet : this.appliedFacets) {
            if (!this.isInstance(eObject, facet)) continue;
            for (EStructuralFeature structuralFeature : facet.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof FacetAttribute)) continue;
                FacetAttribute facetAttribute = (FacetAttribute)structuralFeature;
                result.add((Object)facetAttribute);
            }
        }
        return result;
    }

    public EList<EReference> getReferences(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Facet facet : this.appliedFacets) {
            if (!this.isInstance(eObject, facet)) continue;
            for (EStructuralFeature structuralFeature : facet.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof FacetReference) && !(structuralFeature instanceof Shortcut)) continue;
                EReference facetAttribute = (EReference)structuralFeature;
                result.add((Object)facetAttribute);
            }
        }
        return result;
    }

    public List<EClass> getMetaClasses() {
        ArrayList<EClass> metaClasses = new ArrayList<EClass>();
        metaClasses.addAll(this.appliedFacets);
        return metaClasses;
    }

    public List<Facet> getFacets(EObject eObject) {
        ArrayList<Facet> result = new ArrayList<Facet>();
        for (Facet facet : this.appliedFacets) {
            try {
                if (!this.isInstance(eObject, facet)) continue;
                result.add(facet);
            }
            catch (ModelQueryException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public Set<Facet> getAppliedFacets() {
        return this.appliedFacets;
    }

    public void clear() {
        this.appliedFeatures.clear();
        this.appliedFacets.clear();
        this.notifyFacetsCleared();
    }

    public List<EStructuralFeature> getAppliedFeatures() {
        return this.appliedFeatures;
    }

    public void addListener(FacetContextListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(FacetContextListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyFacetAdded(Facet facet) {
        for (FacetContextListener listener : this.listeners) {
            listener.facetAdded(facet);
        }
    }

    public void notifyFacetsCleared() {
        for (FacetContextListener listener : this.listeners) {
            listener.facetsCleared();
        }
    }
}

