/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.core.internal;

import com.ibm.icu.lang.UCharacter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.core.internal.Activator;
import org.eclipse.emf.facet.util.core.internal.BuildPropertiesUtils;
import org.eclipse.emf.facet.util.core.internal.FileUtils;
import org.eclipse.emf.facet.util.core.internal.FolderUtils;
import org.eclipse.emf.facet.util.core.internal.IFilter;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginUtils {
    private static final String JAVA_VERSION = "J2SE-1.5";
    private static final String ACTIVATOR_NAME = "Activator";
    private static final String MANIFEST_MF_TEMPLATE = "resources/MANIFEST.MF.template";
    private static final String ACTIVATOR_TEMPLATE = "resources/Activator.java.template";
    private static final String PDE_CLASSPATH_ID = "org.eclipse.pde.core.requiredPlugins";
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    private PluginUtils() {
    }

    public static boolean isRegistered(IFile elementFile, String extensionPoint) {
        IProject project = elementFile.getProject();
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
        if (pluginModel != null) {
            IPluginExtension[] extensions;
            IPluginExtension[] iPluginExtensionArray = extensions = pluginModel.getExtensions().getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension pluginExtension = iPluginExtensionArray[n2];
                if (extensionPoint.equals(pluginExtension.getPoint())) {
                    IPluginObject[] children;
                    IPluginObject[] iPluginObjectArray = children = pluginExtension.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginObject child = iPluginObjectArray[n4];
                        if (child instanceof IPluginElement) {
                            IPluginAttribute[] attributes;
                            IPluginElement pluginElement = (IPluginElement)child;
                            IPluginAttribute[] iPluginAttributeArray = attributes = pluginElement.getAttributes();
                            int n5 = attributes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IFile file;
                                String strFile;
                                IPluginAttribute pluginAttribute = iPluginAttributeArray[n6];
                                if ("file".equalsIgnoreCase(pluginAttribute.getName()) && (strFile = pluginAttribute.getValue()) != null && strFile.length() > 0 && (file = project.getFile(strFile)).exists() && elementFile.equals((Object)file)) {
                                    return true;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static void register(IFile file, String extensionPointId, String elementName) {
        if (PluginUtils.isRegistered(file, extensionPointId)) {
            return;
        }
        IPath filePath = file.getFullPath().removeFirstSegments(1);
        IProject project = file.getProject();
        IFile pluginXML = project.getFile("plugin.xml");
        if (pluginXML.exists()) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(pluginXML.getLocation().toOSString());
                Element root = doc.getDocumentElement();
                Text whitespace = doc.createTextNode("   ");
                root.appendChild(whitespace);
                Element extensionNode = doc.createElement("extension");
                Attr pointAttr = doc.createAttribute("point");
                pointAttr.setValue(extensionPointId);
                extensionNode.getAttributes().setNamedItem(pointAttr);
                root.appendChild(extensionNode);
                Element elementNode = doc.createElement(elementName);
                Attr fileAttr = doc.createAttribute("file");
                fileAttr.setValue(filePath.toString());
                elementNode.getAttributes().setNamedItem(fileAttr);
                extensionNode.appendChild(elementNode);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                int indent = 3;
                transformerFactory.setAttribute("indent-number", new Integer(3));
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                String xmlString = result.getWriter().toString();
                byte[] byteArray = xmlString.getBytes("UTF-8");
                pluginXML.setContents((InputStream)new ByteArrayInputStream(byteArray), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Logger.logError(e, Activator.getDefault());
            }
        } else {
            try {
                String template = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n   <extension point=\"{0}\">\n      <{1} file=\"{2}\"/>\n   </extension>\n</plugin>\n";
                String content = NLS.bind((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n   <extension point=\"{0}\">\n      <{1} file=\"{2}\"/>\n   </extension>\n</plugin>\n", (Object[])new Object[]{extensionPointId, elementName, filePath.toString()});
                byte[] byteArray = content.getBytes("UTF-8");
                pluginXML.create((InputStream)new ByteArrayInputStream(byteArray), true, (IProgressMonitor)new NullProgressMonitor());
                try {
                    BuildPropertiesUtils.addToBuild(pluginXML);
                }
                catch (Exception e) {
                    Logger.logError(e, "Error adding file " + pluginXML.getFullPath() + " to the build.properties", null);
                }
            }
            catch (Exception e) {
                Logger.logError(e, Activator.getDefault());
            }
        }
    }

    private static void addPdeClassPath(IProject project) throws JavaModelException {
        IClasspathEntry[] oldClassPath;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] iClasspathEntryArray = oldClassPath = javaProject.getRawClasspath();
        int n = oldClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getPath().equals((Object)new Path(PDE_CLASSPATH_ID))) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[oldClassPath.length + 1];
        System.arraycopy(oldClassPath, 0, newClassPath, 0, oldClassPath.length);
        newClassPath[oldClassPath.length] = JavaCore.newContainerEntry((IPath)new Path(PDE_CLASSPATH_ID));
        javaProject.setRawClasspath(newClassPath, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void createManifest(IProject project) throws CoreException, IOException {
        IFile manifestFile;
        IFolder folder = project.getFolder("META-INF");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(manifestFile = folder.getFile("MANIFEST.MF")).exists()) {
            String template = FileUtils.getFileContents(Activator.getDefault().getBundle(), MANIFEST_MF_TEMPLATE);
            template = template.replace("{projectName}", project.getName());
            String packageName = PluginUtils.stringToValidPackageName(project.getName());
            template = template.replace("{packageName}", packageName);
            String activator = PluginUtils.bundleActivatorQualifiedName(packageName);
            template = template.replace("{activator}", activator);
            template = template.replace("{javaVersion}", JAVA_VERSION);
            ByteArrayInputStream source = new ByteArrayInputStream(template.getBytes());
            manifestFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static String bundleActivatorQualifiedName(String packageName) {
        return String.valueOf(packageName) + '.' + ACTIVATOR_NAME;
    }

    private static void createActivator(IProject project) throws CoreException, IOException {
        String packageName = PluginUtils.stringToValidPackageName(project.getName());
        String qualifiedName = PluginUtils.bundleActivatorQualifiedName(packageName);
        String path = qualifiedName.replaceAll("\\.", "/");
        IFile activatorFile = project.getFile(new Path("src").append(path).addFileExtension("java"));
        FolderUtils.createFolder((IFolder)activatorFile.getParent());
        if (!activatorFile.exists()) {
            String template = FileUtils.getFileContents(Activator.getDefault().getBundle(), ACTIVATOR_TEMPLATE);
            String activatorContents = template.replace("{0}", packageName);
            ByteArrayInputStream source = new ByteArrayInputStream(activatorContents.getBytes());
            activatorFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static String stringToValidPackageName(String name) {
        IStatus status;
        StringBuilder builder = new StringBuilder();
        int prev = 32;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                builder.append(c);
                prev = c;
            } else if (c >= '0' && c <= '9') {
                if (builder.length() == 0 || prev == 46) {
                    builder.append("_");
                }
                builder.append(c);
                prev = c;
            } else if (c == '.') {
                if (prev != 46) {
                    if (builder.length() == 0 || prev >= 48 && prev <= 57) {
                        builder.append("_");
                    }
                    builder.append(c);
                    prev = c;
                }
            } else {
                builder.append("_");
            }
            ++i;
        }
        String result = builder.toString();
        if (result.length() > 0 && UCharacter.isUpperCase((int)result.charAt(0))) {
            result = String.valueOf(UCharacter.toLowerCase((int)result.charAt(0))) + result.substring(1);
        }
        if (!(status = JavaConventions.validatePackageName((String)result, (String)"1.5", (String)"1.5")).isOK()) {
            Logger.logWarning("Couldn't make valid package name from project name: " + status.getMessage(), Activator.getDefault());
            return name;
        }
        return result;
    }

    private static void addPdeNature(IProject project) throws CoreException {
        String pluginNature = PLUGIN_NATURE;
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(pluginNature)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = pluginNature;
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void configureAsPluginProject(IProject project) throws CoreException, IOException {
        PluginUtils.addPdeNature(project);
        PluginUtils.addPdeClassPath(project);
        PluginUtils.createManifest(project);
        PluginUtils.createActivator(project);
    }

    public static boolean isPluginProject(IProject project) throws CoreException {
        if (!project.isAccessible()) {
            return false;
        }
        return project.getNature(PLUGIN_NATURE) != null;
    }

    public static boolean isInPluginProject(IPath path) throws CoreException {
        IProject project;
        if (path.segmentCount() == 1) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        } else {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            project = folder.getProject();
        }
        return PluginUtils.isPluginProject(project);
    }

    public static IProject importPlugin(Bundle bundle) throws CoreException, IOException {
        return PluginUtils.importPlugin(bundle, new IFilter<String>(){

            @Override
            public boolean filter(String fileName) {
                return true;
            }
        });
    }

    public static IProject importPlugin(Bundle bundle, IFilter<String> filter) throws CoreException, IOException {
        String bundleName = bundle.getSymbolicName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
        if (project.exists()) {
            int n = 1;
            int maxIter = 100;
            while (project.exists() && n < 100) {
                String uniqueName = String.valueOf(bundleName) + " (" + n + ')';
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(uniqueName);
                ++n;
            }
        }
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        ZipFile zip = null;
        try {
            String bundlePath = bundle.getLocation();
            String filePath = bundlePath.replaceFirst("^reference:file:", "");
            File bundleFile = new File(filePath);
            if (bundleFile.isDirectory()) {
                FolderUtils.copyDirectory(bundleFile, project.getLocation().toFile(), filter);
            } else {
                Location installLocation = Platform.getInstallLocation();
                String installPath = installLocation.getURL().getFile();
                File file = new File(installPath, filePath);
                zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                ArrayList<Status> errors = new ArrayList<Status>();
                while (entries.hasMoreElements()) {
                    try {
                        ZipEntry zipEntry = entries.nextElement();
                        if (!filter.filter(zipEntry.getName())) continue;
                        if (zipEntry.isDirectory()) {
                            IFolder f = project.getFolder(zipEntry.getName());
                            if (f.exists()) continue;
                            f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                            continue;
                        }
                        InputStream is = zip.getInputStream(zipEntry);
                        IFile f = project.getFile(zipEntry.getName());
                        if (!f.getParent().exists() && f.getParent() instanceof IFolder) {
                            IFolder folder = (IFolder)f.getParent();
                            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (f.exists()) {
                            f.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        f.create(is, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        errors.add(new Status(4, "org.eclipse.emf.facet.util.core", e.getMessage(), (Throwable)e));
                    }
                }
                if (errors.size() > 0) {
                    IStatus[] statusArray = errors.toArray(new IStatus[0]);
                    MultiStatus status = new MultiStatus("org.eclipse.emf.facet.util.core", 4, statusArray, "Errors happened", (Throwable)new Exception());
                    CoreException exception = new CoreException((IStatus)status);
                    throw exception;
                }
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
        return project;
    }
}

