/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.facet.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.facet.ui.Activator;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFacetsDialog
extends CheckedTreeSelectionDialog {
    private static final String LOAD_FACETS_DIALOG = "LoadFacetsDialog";
    private static final String EXPANDED_ELEMENTS = "expandedElements";

    public LoadFacetsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Collection<EPackage> ePackages) {
        super(parent, labelProvider, contentProvider);
        final HashSet<EPackage> allReferencedPackages = new HashSet<EPackage>();
        for (EPackage ePackage : ePackages) {
            allReferencedPackages.add(ePackage);
            Set referencedPackages = ModelUtils.computeReferencedPackages((EPackage)ePackage);
            allReferencedPackages.addAll(referencedPackages);
        }
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)element;
                    if (facetSet.getExtendedPackage() == null) {
                        return true;
                    }
                    EPackage extendedPackage = facetSet.getExtendedPackage();
                    return allReferencedPackages.contains(extendedPackage);
                }
                return true;
            }
        });
    }

    public int open() {
        this.restoreExpandedElements();
        return super.open();
    }

    public boolean close() {
        this.saveExpandedElements();
        return super.close();
    }

    public void saveExpandedElements() {
        try {
            Object[] expandedElements;
            String filename = this.getSettingsFilename();
            DialogSettings settings = new DialogSettings(LOAD_FACETS_DIALOG);
            ArrayList<String> expandedFacetSets = new ArrayList<String>();
            Object[] objectArray = expandedElements = this.getTreeViewer().getExpandedElements();
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object expandedElement = objectArray[n2];
                if (expandedElement instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)expandedElement;
                    expandedFacetSets.add(facetSet.getName());
                }
                ++n2;
            }
            String[] array = expandedFacetSets.toArray(new String[expandedFacetSets.size()]);
            settings.put(EXPANDED_ELEMENTS, array);
            settings.save(filename);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private String getSettingsFilename() {
        IPath stateLocation = Activator.getDefault().getStateLocation();
        String filename = stateLocation.append(LOAD_FACETS_DIALOG).toOSString();
        return filename;
    }

    public void restoreExpandedElements() {
        try {
            String filename = this.getSettingsFilename();
            DialogSettings settings = new DialogSettings(LOAD_FACETS_DIALOG);
            if (new File(filename).isFile()) {
                settings.load(filename);
                String[] array = settings.getArray(EXPANDED_ELEMENTS);
                Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                ArrayList<FacetSet> expandedFacetSets = new ArrayList<FacetSet>();
                String[] stringArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    String expandedFacetSetName = stringArray[n2];
                    for (FacetSet facetSet : facetSets) {
                        if (facetSet.getName() == null || !facetSet.getName().equals(expandedFacetSetName)) continue;
                        expandedFacetSets.add(facetSet);
                    }
                    ++n2;
                }
                this.setExpandedElements(expandedFacetSets.toArray());
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }
}

