/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.layer.cell;

import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.cell.DataCell;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.swt.graphics.Rectangle;

public class LayerCell {
    private ILayer layer;
    private int columnPosition;
    private int rowPosition;
    private ILayer sourceLayer;
    private int originColumnPosition;
    private int originRowPosition;
    private int columnSpan;
    private int rowSpan;
    private boolean isDisplayModeCached = false;
    private String displayMode = null;
    private boolean isConfigLabelsCached = false;
    private LabelStack configLabels = null;
    private boolean isDataValueCached = false;
    private Object dataValue = null;
    private boolean isBoundsCached = false;
    private Rectangle bounds = null;

    public LayerCell(ILayer layer, int columnPosition, int rowPosition, DataCell cell) {
        this(layer, cell.columnPosition, cell.rowPosition, columnPosition, rowPosition, cell.columnSpan, cell.rowSpan);
    }

    public LayerCell(ILayer layer, int columnPosition, int rowPosition) {
        this(layer, columnPosition, rowPosition, columnPosition, rowPosition, 1, 1);
    }

    public LayerCell(ILayer layer, int originColumnPosition, int originRowPosition, int columnPosition, int rowPosition, int columnSpan, int rowSpan) {
        this.sourceLayer = layer;
        this.originColumnPosition = originColumnPosition;
        this.originRowPosition = originRowPosition;
        this.layer = layer;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
        this.columnSpan = columnSpan;
        this.rowSpan = rowSpan;
    }

    private boolean isReadMode() {
        return this.isDisplayModeCached || this.isConfigLabelsCached || this.isDataValueCached || this.isBoundsCached;
    }

    public void updateLayer(ILayer layer) {
        if (this.isReadMode()) {
            throw new IllegalStateException("Cannot update cell once displayMode, configLabels, dataValue, or bounds have been read");
        }
        this.layer = layer;
    }

    public void updatePosition(ILayer layer, int originColumnPosition, int originRowPosition, int columnPosition, int rowPosition) {
        if (this.isReadMode()) {
            throw new IllegalStateException("Cannot update cell once displayMode, configLabels, dataValue, or bounds have been read");
        }
        this.layer = layer;
        this.originColumnPosition = originColumnPosition;
        this.originRowPosition = originRowPosition;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
    }

    public void updateColumnSpan(int columnSpan) {
        if (this.isReadMode()) {
            throw new IllegalStateException("Cannot update cell once displayMode, configLabels, dataValue, or bounds have been read");
        }
        this.columnSpan = columnSpan;
    }

    public void updateRowSpan(int rowSpan) {
        if (this.isReadMode()) {
            throw new IllegalStateException("Cannot update cell once displayMode, configLabels, dataValue, or bounds have been read");
        }
        this.rowSpan = rowSpan;
    }

    public ILayer getSourceLayer() {
        return this.sourceLayer;
    }

    public int getOriginColumnPosition() {
        return this.originColumnPosition;
    }

    public int getOriginRowPosition() {
        return this.originRowPosition;
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public int getRowPosition() {
        return this.rowPosition;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean isSpannedCell() {
        return this.columnSpan > 1 || this.rowSpan > 1;
    }

    public String getDisplayMode() {
        if (!this.isDisplayModeCached) {
            this.isDisplayModeCached = true;
            this.displayMode = this.layer.getDisplayModeByPosition(this.columnPosition, this.rowPosition);
        }
        return this.displayMode;
    }

    public LabelStack getConfigLabels() {
        if (!this.isConfigLabelsCached) {
            this.isConfigLabelsCached = true;
            this.configLabels = this.layer.getConfigLabelsByPosition(this.columnPosition, this.rowPosition);
        }
        return this.configLabels;
    }

    public Object getDataValue() {
        if (!this.isDataValueCached) {
            this.isDataValueCached = true;
            this.dataValue = this.layer.getDataValueByPosition(this.columnPosition, this.rowPosition);
        }
        return this.dataValue;
    }

    public Rectangle getBounds() {
        if (!this.isBoundsCached) {
            this.isBoundsCached = true;
            this.bounds = this.layer.getBoundsByPosition(this.columnPosition, this.rowPosition);
        }
        return this.bounds;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LayerCell)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LayerCell rhs = (LayerCell)obj;
        return new EqualsBuilder().append((Object)this.sourceLayer, (Object)rhs.sourceLayer).append(this.originColumnPosition, rhs.originColumnPosition).append(this.originRowPosition, rhs.originRowPosition).append(this.columnSpan, rhs.columnSpan).append(this.rowSpan, rhs.rowSpan).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(771, 855).append((Object)this.sourceLayer).append(this.originColumnPosition).append(this.originRowPosition).append(this.columnSpan).append(this.rowSpan).toHashCode();
    }

    public String toString() {
        return "LayerCell: [Data: " + this.dataValue + ", sourceLayer: " + this.sourceLayer.getClass().getSimpleName() + ", originColumnPosition: " + this.originColumnPosition + ", originRowPosition: " + this.originRowPosition + ", columnSpan: " + this.columnSpan + ", rowSpan: " + this.rowSpan + "]";
    }
}

