/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.ui.binding;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.ui.action.IDragMode;
import net.sourceforge.nattable.ui.action.IKeyAction;
import net.sourceforge.nattable.ui.action.IMouseAction;
import net.sourceforge.nattable.ui.binding.DragBinding;
import net.sourceforge.nattable.ui.binding.IUiBindingRegistry;
import net.sourceforge.nattable.ui.binding.KeyBinding;
import net.sourceforge.nattable.ui.binding.MouseBinding;
import net.sourceforge.nattable.ui.matcher.IKeyEventMatcher;
import net.sourceforge.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class UiBindingRegistry
implements IUiBindingRegistry {
    private NatTable natTable;
    private LinkedList<KeyBinding> keyBindings = new LinkedList();
    private Map<MouseEventTypeEnum, LinkedList<MouseBinding>> mouseBindingsMap = new HashMap<MouseEventTypeEnum, LinkedList<MouseBinding>>();
    private LinkedList<DragBinding> dragBindings = new LinkedList();

    public UiBindingRegistry(NatTable natTable) {
        this.natTable = natTable;
    }

    public IKeyAction getKeyEventAction(KeyEvent event) {
        for (KeyBinding keyBinding : this.keyBindings) {
            if (!keyBinding.getKeyEventMatcher().matches(event)) continue;
            return keyBinding.getAction();
        }
        return null;
    }

    public IDragMode getDragMode(MouseEvent event) {
        LabelStack regionLabels = this.natTable.getRegionLabelsByXY(event.x, event.y);
        for (DragBinding dragBinding : this.dragBindings) {
            if (!dragBinding.getMouseEventMatcher().matches(this.natTable, event, regionLabels)) continue;
            return dragBinding.getDragMode();
        }
        return null;
    }

    public IMouseAction getMouseMoveAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_MOVE, event);
    }

    public IMouseAction getMouseDownAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_DOWN, event);
    }

    public IMouseAction getSingleClickAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_SINGLE_CLICK, event);
    }

    public IMouseAction getDoubleClickAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, event);
    }

    private IMouseAction getMouseEventAction(MouseEventTypeEnum mouseEventType, MouseEvent event) {
        try {
            LinkedList<MouseBinding> mouseEventBindings = this.mouseBindingsMap.get((Object)mouseEventType);
            if (mouseEventBindings != null) {
                LabelStack regionLabels = this.natTable.getRegionLabelsByXY(event.x, event.y);
                for (MouseBinding mouseBinding : mouseEventBindings) {
                    if (!mouseBinding.getMouseEventMatcher().matches(this.natTable, event, regionLabels)) continue;
                    return mouseBinding.getAction();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void registerFirstKeyBinding(IKeyEventMatcher keyMatcher, IKeyAction action) {
        this.keyBindings.addFirst(new KeyBinding(keyMatcher, action));
    }

    public void registerKeyBinding(IKeyEventMatcher keyMatcher, IKeyAction action) {
        this.keyBindings.addLast(new KeyBinding(keyMatcher, action));
    }

    public void unregisterKeyBinding(IKeyEventMatcher keyMatcher) {
        for (KeyBinding keyBinding : this.keyBindings) {
            if (!keyBinding.getKeyEventMatcher().equals(keyMatcher)) continue;
            this.keyBindings.remove(keyBinding);
            return;
        }
    }

    public void registerFirstMouseDragMode(IMouseEventMatcher mouseEventMatcher, IDragMode dragMode) {
        this.dragBindings.addFirst(new DragBinding(mouseEventMatcher, dragMode));
    }

    public void registerMouseDragMode(IMouseEventMatcher mouseEventMatcher, IDragMode dragMode) {
        this.dragBindings.addLast(new DragBinding(mouseEventMatcher, dragMode));
    }

    public void unregisterMouseDragMode(IMouseEventMatcher mouseEventMatcher) {
        for (DragBinding dragBinding : this.dragBindings) {
            if (!dragBinding.getMouseEventMatcher().equals(mouseEventMatcher)) continue;
            this.dragBindings.remove(dragBinding);
            return;
        }
    }

    public void registerFirstMouseMoveBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_MOVE, mouseEventMatcher, action);
    }

    public void registerMouseMoveBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_MOVE, mouseEventMatcher, action);
    }

    public void unregisterMouseMoveBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_MOVE, mouseEventMatcher);
    }

    public void registerFirstMouseDownBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_DOWN, mouseEventMatcher, action);
    }

    public void registerMouseDownBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_DOWN, mouseEventMatcher, action);
    }

    public void unregisterMouseDownBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_DOWN, mouseEventMatcher);
    }

    public void registerFirstSingleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_SINGLE_CLICK, mouseEventMatcher, action);
    }

    public void registerSingleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_SINGLE_CLICK, mouseEventMatcher, action);
    }

    public void unregisterSingleClickBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_SINGLE_CLICK, mouseEventMatcher);
    }

    public void registerFirstDoubleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, mouseEventMatcher, action);
    }

    public void registerDoubleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, mouseEventMatcher, action);
    }

    public void unregisterDoubleClickBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, mouseEventMatcher);
    }

    private void registerMouseBinding(boolean first, MouseEventTypeEnum mouseEventType, IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        LinkedList<MouseBinding> mouseEventBindings = this.mouseBindingsMap.get((Object)mouseEventType);
        if (mouseEventBindings == null) {
            mouseEventBindings = new LinkedList();
            this.mouseBindingsMap.put(mouseEventType, mouseEventBindings);
        }
        if (first) {
            mouseEventBindings.addFirst(new MouseBinding(mouseEventMatcher, action));
        } else {
            mouseEventBindings.addLast(new MouseBinding(mouseEventMatcher, action));
        }
    }

    private void unregisterMouseBinding(MouseEventTypeEnum mouseEventType, IMouseEventMatcher mouseEventMatcher) {
        LinkedList<MouseBinding> mouseBindings = this.mouseBindingsMap.get((Object)mouseEventType);
        for (MouseBinding mouseBinding : mouseBindings) {
            if (!mouseBinding.getMouseEventMatcher().equals(mouseEventMatcher)) continue;
            mouseBindings.remove(mouseBinding);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MouseEventTypeEnum {
        MOUSE_DOWN,
        MOUSE_MOVE,
        MOUSE_SINGLE_CLICK,
        MOUSE_DOUBLE_CLICK;

    }
}

