/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.painter;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.TextPainter;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.CellStyleUtil;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class CustomizedCellPainter
extends TextPainter {
    private static final String ERROR_MSG = Messages.CustomizedCellPainter_error_msg;
    private static final int LEFT_MARIN = 0;
    private static final int RIGHT_MARGIN = 0;
    private static final int OFFSET_AFTER_ICON = 18;
    private static final int OVERLAY_SIZE = 8;
    private static final int PREFERRED_WIDTH_MARGIN = 8;
    private final ICustomizedLabelProvider tableLabelProvider;
    private final NatTableWidget natTableWidget;
    private final Map<RGB, Color> cachedColors = new HashMap<RGB, Color>();

    public CustomizedCellPainter(ICustomizedLabelProvider tableLabelProvider, NatTableWidget natTableWidget) {
        this.tableLabelProvider = tableLabelProvider;
        this.natTableWidget = natTableWidget;
    }

    protected String convertDataType(LayerCell cell, IConfigRegistry configRegistry) {
        String result = ERROR_MSG;
        Object dataValue = cell.getDataValue();
        if (dataValue instanceof IGridElement) {
            IGridElement gridElement = (IGridElement)dataValue;
            Column column = gridElement.getColumn();
            if (column instanceof FeatureColumn) {
                Object value = null;
                try {
                    value = this.getValueOf(gridElement);
                }
                catch (FacetManagerException e) {
                    Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
                    value = "";
                }
                try {
                    result = this.tableLabelProvider.getText(value);
                }
                catch (Exception e) {
                    Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
                }
            } else if (column != null) {
                Logger.logWarning((String)("unhandled column type: " + column.getClass().getSimpleName()), (Plugin)Activator.getDefault());
            }
        } else if (dataValue instanceof FeatureColumn) {
            FeatureColumn featureColumn = (FeatureColumn)dataValue;
            result = this.tableLabelProvider.getText((Object)featureColumn.getFeature());
        } else if (dataValue != null) {
            Logger.logWarning((String)("Unhandled cell data type in painter: " + dataValue), (Plugin)Activator.getDefault());
            result = dataValue.toString();
        } else {
            result = "null";
        }
        return result;
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        int convertedColumn = this.natTableWidget.convertCellPositionToDataLayer(cell);
        if (convertedColumn < this.natTableWidget.getController().getTable().getColumns().size()) {
            Rectangle rectangleWithMargin = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
            Object dataValue = cell.getDataValue();
            if (dataValue instanceof IGridElement) {
                IGridElement gridElement = (IGridElement)dataValue;
                this.paintGridElement(gridElement, rectangleWithMargin, cell, gc, rectangle, configRegistry);
            } else if (dataValue instanceof FeatureColumn) {
                FeatureColumn column = (FeatureColumn)dataValue;
                ETypedElement typedElement = column.getFeature();
                String text = this.tableLabelProvider.getText((Object)typedElement);
                if (text == null) {
                    text = "";
                }
                gc.drawText(text, rectangle.x, rectangleWithMargin.y, true);
            } else {
                Logger.logWarning((String)("Unhandled cell data type in painter: " + dataValue), (Plugin)Activator.getDefault());
            }
        }
    }

    private void paintGridElement(IGridElement gridElement, Rectangle rectangleWithMargin, LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        this.drawBackground(cell, gc, rectangle, configRegistry, gridElement);
        Rectangle originalClipping = gc.getClipping();
        gc.setClipping(rectangleWithMargin);
        this.setupGCFromCustomization(gc, gridElement, cell, configRegistry);
        Image icon = this.drawIcon(gc, rectangle, rectangleWithMargin, gridElement);
        this.drawText(gc, rectangleWithMargin, gridElement, icon);
        this.drawUnderline(gc, rectangleWithMargin, gridElement, rectangle);
        this.drawStruckthrough(gc, rectangleWithMargin, gridElement, rectangle);
        this.drawOverlay(gc, rectangle, gridElement);
        gc.setClipping(originalClipping);
    }

    private void drawOverlay(GC gc, Rectangle rectangle, IGridElement gridElement) {
        try {
            Object value = this.getValueOf(gridElement);
            if (value instanceof EObject) {
                Image[] topImages = new Image[]{this.tableLabelProvider.getTopLeftOverlay(value, null), this.tableLabelProvider.getTopMiddleOverlay(value, null), this.tableLabelProvider.getTopRightOverlay(value, null)};
                Image[] bottomImages = new Image[]{this.tableLabelProvider.getBottomLeftOverlay(value, null), this.tableLabelProvider.getBottomMiddleOverlay(value, null), this.tableLabelProvider.getBottomRightOverlay(value, null)};
                Image[][] imageMatrix = new Image[][]{topImages, bottomImages};
                int row = 0;
                while (row < imageMatrix.length) {
                    Image[] rowContent = imageMatrix[row];
                    int column = 0;
                    while (column < rowContent.length) {
                        Rectangle iconRectangle = new Rectangle(rectangle.x + column * 8, rectangle.y + row * 8, 8, 8);
                        gc.setClipping(iconRectangle);
                        if (rowContent[column] != null) {
                            gc.drawImage(rowContent[column], iconRectangle.x, iconRectangle.y);
                        }
                        ++column;
                    }
                    ++row;
                }
            }
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private Image drawIcon(GC gc, Rectangle rectangle, Rectangle rectangleWithMargin, IGridElement gridElement) {
        gc.setClipping(rectangle);
        Image icon = this.getIcon(gridElement);
        if (icon != null) {
            gc.drawImage(icon, rectangleWithMargin.x, rectangleWithMargin.y);
        }
        return icon;
    }

    protected Image getIcon(IGridElement gridElement) {
        Image icon = null;
        try {
            Object value = this.getValueOf(gridElement);
            if (value instanceof EObject) {
                icon = this.tableLabelProvider.getImage(value, null);
            }
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return icon;
    }

    private Object getValueOf(IGridElement gridElement) throws FacetManagerException {
        return TableWidgetUtils.getValueOf((IGridElement)gridElement, (IFacetManager)this.natTableWidget.getController().getFacetContext());
    }

    private void drawText(GC gc, Rectangle rectangleWithMargin, IGridElement gridElement, Image icon) {
        String text;
        gc.setClipping(rectangleWithMargin);
        try {
            text = this.tableLabelProvider.getText(this.getValueOf(gridElement));
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            text = ERROR_MSG;
        }
        text = CustomizedCellPainter.truncate(gc, rectangleWithMargin.width, text, icon);
        int x = rectangleWithMargin.x;
        if (icon != null) {
            int totalOffsetAfterIcon;
            if (this.hasOverlay(gridElement)) {
                this.hasOverlay(gridElement);
                totalOffsetAfterIcon = 26;
            } else {
                totalOffsetAfterIcon = 18;
            }
            x = rectangleWithMargin.x + totalOffsetAfterIcon;
        }
        gc.drawText(text, x, rectangleWithMargin.y, true);
    }

    protected boolean hasOverlay(IGridElement gridElement) {
        boolean result = false;
        Object value = null;
        try {
            value = this.getValueOf(gridElement);
        }
        catch (FacetManagerException e) {
            Logger.logWarning((String)"Error computing grid element value", (Plugin)Activator.getDefault());
        }
        if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            result = this.tableLabelProvider.getTopLeftOverlay((Object)eObject, null) != null || this.tableLabelProvider.getTopMiddleOverlay((Object)eObject, null) != null || this.tableLabelProvider.getTopRightOverlay((Object)eObject, null) != null || this.tableLabelProvider.getBottomLeftOverlay((Object)eObject, null) != null || this.tableLabelProvider.getBottomMiddleOverlay((Object)eObject, null) != null || this.tableLabelProvider.getBottomRightOverlay((Object)eObject, null) != null;
        }
        return result;
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        int preferredWidth = -1;
        Object dataValue = cell.getDataValue();
        if (dataValue instanceof IGridElement) {
            IGridElement gridElement = (IGridElement)dataValue;
            this.setupGCFromCustomization(gc, gridElement, cell, configRegistry);
        }
        String text = this.convertDataType(cell, configRegistry).split("\\r?\\n")[0];
        preferredWidth = gc.textExtent((String)text).x;
        if (dataValue instanceof IGridElement) {
            IGridElement gridElement = (IGridElement)dataValue;
            if (this.getIcon(gridElement) != null) {
                preferredWidth += 18;
                if (this.hasOverlay(gridElement)) {
                    preferredWidth += 8;
                }
            }
            preferredWidth += 8;
        }
        return preferredWidth;
    }

    protected void setupGCFromCustomization(GC gc, IGridElement gridElement, LayerCell cell, IConfigRegistry configRegistry) {
        Object value = null;
        try {
            value = this.getValueOf(gridElement);
        }
        catch (FacetManagerException e) {
            Logger.logWarning((String)"Error computing grid element value", (Plugin)Activator.getDefault());
        }
        if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            Color background = this.tableLabelProvider.getBackground((Object)eObject);
            Color foreground = this.tableLabelProvider.getForeground((Object)eObject);
            Font font = this.tableLabelProvider.getFont((Object)eObject);
            gc.setFont(font);
            gc.setForeground(foreground);
            gc.setBackground(background);
        } else {
            this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((LayerCell)cell, (IConfigRegistry)configRegistry));
            EObject element = gridElement.getRow().getElement();
            if (element != null) {
                Font font;
                Color foreground = this.tableLabelProvider.getForeground((Object)element);
                if (foreground != null) {
                    gc.setForeground(foreground);
                }
                if ((font = this.tableLabelProvider.getFont((Object)element)) != null) {
                    gc.setFont(font);
                }
            }
        }
    }

    private void drawStruckthrough(GC gc, Rectangle rectangleWithMargin, IGridElement gridElement, Rectangle rectangle) {
        EObject element = gridElement.getRow().getElement();
        if (element != null && this.tableLabelProvider.isStruckthrough((Object)gridElement.getRow().getElement(), ((FeatureColumn)gridElement.getColumn()).getFeature())) {
            gc.setClipping(rectangle);
            int y = rectangleWithMargin.y + rectangleWithMargin.height / 2 + 1;
            gc.drawLine(rectangleWithMargin.x + 0, y, rectangleWithMargin.x + rectangleWithMargin.width - 0, y);
        }
    }

    private void drawUnderline(GC gc, Rectangle rectangleWithMargin, IGridElement gridElement, Rectangle rectangle) {
        EObject element = gridElement.getRow().getElement();
        if (element != null && this.tableLabelProvider.isUnderlined((Object)element, ((FeatureColumn)gridElement.getColumn()).getFeature())) {
            gc.setClipping(rectangle);
            int y = rectangleWithMargin.y + rectangleWithMargin.height - 1;
            gc.drawLine(rectangleWithMargin.x + 0, y, rectangleWithMargin.x + rectangleWithMargin.width - 0, y);
        }
    }

    private void drawBackground(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry, IGridElement gridElement) {
        Color backgroundColor = this.getBackground(cell, gridElement, configRegistry);
        Color originalBackground = gc.getBackground();
        gc.setBackground(backgroundColor);
        gc.fillRectangle(rectangle);
        gc.setBackground(originalBackground);
    }

    private Color getBackground(LayerCell cell, IGridElement gridElement, IConfigRegistry configRegistry) {
        Color backgroundColor = (Color)CellStyleUtil.getCellStyle((LayerCell)cell, (IConfigRegistry)configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Object value = null;
        try {
            value = this.getValueOf(gridElement);
        }
        catch (FacetManagerException e) {
            Logger.logWarning((String)"Error computing grid element value", (Plugin)Activator.getDefault());
        }
        Color background = null;
        if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            background = this.tableLabelProvider.getBackground((Object)eObject);
        } else {
            EObject element = gridElement.getRow().getElement();
            if (element != null) {
                background = this.tableLabelProvider.getBackground((Object)element);
            }
        }
        if (background != null) {
            Color customizedColor = background;
            if (cell.getDisplayMode() == "SELECT") {
                Color mergedColor;
                double opacity = 0.3;
                backgroundColor = mergedColor = this.mergeColors(customizedColor, backgroundColor, 0.3);
            } else {
                backgroundColor = customizedColor;
            }
        }
        return backgroundColor;
    }

    private static String truncate(GC gc, int cellWidth, String text, Image icon) {
        int usableCellWidth;
        int textWidth;
        String result = text;
        int iconWidth = 0;
        if (icon != null) {
            iconWidth = icon.getImageData().width;
        }
        if ((textWidth = gc.textExtent((String)text).x) > (usableCellWidth = cellWidth - iconWidth)) {
            float ratio = (float)usableCellWidth / (float)textWidth;
            int nbCharacterMax = Math.max(Math.round((float)text.length() * ratio - (float)"...".length()), 0);
            result = String.valueOf(text.substring(0, nbCharacterMax)) + "...";
        }
        return result;
    }

    private Color mergeColors(Color color1, Color color2, double opacity) {
        double opacity2 = 1.0 - opacity;
        RGB rgb = new RGB((int)((double)color1.getRed() * opacity + (double)color2.getRed() * opacity2), (int)((double)color1.getGreen() * opacity + (double)color2.getGreen() * opacity2), (int)((double)color1.getBlue() * opacity + (double)color2.getBlue() * opacity2));
        Color color = this.cachedColors.get(rgb);
        if (color == null) {
            color = new Color(color1.getDevice(), rgb);
            this.cachedColors.put(rgb, color);
        }
        return color;
    }

    protected void finalize() throws Throwable {
        for (Color color : this.cachedColors.values()) {
            color.dispose();
        }
        super.finalize();
    }
}

