/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.dev.core.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.dev.core.internal.Activator;
import org.eclipse.emf.facet.dev.core.internal.INewPluginCreator;
import org.eclipse.emf.facet.dev.core.internal.Messages;

public class NewPluginCreator
implements INewPluginCreator {
    public void createProject(String id, String name, String version, String provider, boolean javaNatureEnabled, IProgressMonitor monitor) {
        try {
            Data data = new Data(id, name, version, provider);
            int nTasks = 20;
            monitor.beginTask(Messages.NewPluginWizard_jobName, 20);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(id);
            project.create(monitor);
            monitor.worked(1);
            project.open(monitor);
            monitor.worked(1);
            IFolder metaInf = project.getFolder("META-INF");
            metaInf.create(true, true, monitor);
            monitor.worked(1);
            if (javaNatureEnabled) {
                this.createFile(metaInf.getFile("MANIFEST.MF"), this.getExpandedFileContents("resources/MANIFEST.MF.java.template", data));
            } else {
                this.createFile(metaInf.getFile("MANIFEST.MF"), this.getExpandedFileContents("resources/MANIFEST.MF.template", data));
            }
            monitor.worked(1);
            this.createFile(project.getFile("about.html"), this.getExpandedFileContents("resources/about.html.template", data));
            monitor.worked(1);
            if (javaNatureEnabled) {
                this.createFile(project.getFile(".project"), this.getExpandedFileContents("resources/project.java.template", data));
            } else {
                this.createFile(project.getFile(".project"), this.getExpandedFileContents("resources/project.template", data));
            }
            monitor.worked(1);
            if (javaNatureEnabled) {
                this.createFile(project.getFile(".classpath"), this.getExpandedFileContents("resources/classpath.template", data));
                monitor.worked(1);
            }
            if (javaNatureEnabled) {
                this.createFile(project.getFile("build.properties"), this.getExpandedFileContents("resources/build.properties.java.template", data));
            } else {
                this.createFile(project.getFile("build.properties"), this.getExpandedFileContents("resources/build.properties.template", data));
            }
            monitor.worked(1);
            if (javaNatureEnabled) {
                this.createFile(project.getFile(".checkstyle"), this.getExpandedFileContents("resources/checkstyle.template", data));
                monitor.worked(1);
            }
            if (javaNatureEnabled) {
                IFolder src = project.getFolder("src");
                src.create(true, true, monitor);
                monitor.worked(1);
                String hierarchy = this.getHierarchy(id);
                IFolder srcInternal = this.createFolderHierarchy(src, String.valueOf(hierarchy) + "/internal", monitor);
                monitor.worked(1);
                this.createFile(srcInternal.getFile("Activator.java"), this.getExpandedFileContents("resources/Activator.java.template", data));
                monitor.worked(1);
            }
            IFolder osgiInf = project.getFolder("OSGI-INF");
            osgiInf.create(true, true, monitor);
            monitor.worked(1);
            IFolder i10n = osgiInf.getFolder("l10n");
            i10n.create(true, true, monitor);
            monitor.worked(1);
            this.createFile(i10n.getFile("bundle.properties"), this.getExpandedFileContents("resources/bundle.properties.template", data));
            monitor.worked(1);
            IFolder settings = project.getFolder(".settings");
            settings.create(true, true, monitor);
            monitor.worked(1);
            this.createFile(settings.getFile("org.eclipse.core.resources.prefs"), this.getExpandedFileContents("resources/org.eclipse.core.resources.prefs.template", data));
            monitor.worked(1);
            this.createFile(settings.getFile("org.eclipse.core.runtime.prefs"), this.getExpandedFileContents("resources/org.eclipse.core.runtime.prefs.template", data));
            monitor.worked(1);
            if (javaNatureEnabled) {
                this.createFile(settings.getFile("org.eclipse.jdt.core.prefs"), this.getExpandedFileContents("resources/org.eclipse.jdt.core.prefs.template", data));
                monitor.worked(1);
                this.createFile(settings.getFile("org.eclipse.jdt.ui.prefs"), this.getExpandedFileContents("resources/org.eclipse.jdt.ui.prefs.template", data));
                monitor.worked(1);
            }
            monitor.done();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.facet.dev.core", "Error creating new plug-in", (Throwable)e));
        }
    }

    private IFolder createFolderHierarchy(IFolder folder, String hierarchy, IProgressMonitor monitor) throws CoreException {
        String[] parts = hierarchy.split("/");
        IFolder current = folder;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.trim().length() > 0) {
                current = current.getFolder(part);
                current.create(true, true, monitor);
            }
            ++n2;
        }
        return current;
    }

    private String getHierarchy(String id) {
        return id.replaceAll("\\.", "/");
    }

    private void createFile(IFile newFile, String contents) throws CoreException {
        ByteArrayInputStream source = new ByteArrayInputStream(contents.getBytes());
        if (newFile.exists()) {
            newFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        newFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private String getExpandedFileContents(String path, Data data) throws IOException {
        URL url = this.getFileURL(path);
        if (url == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.facet.dev.core", "Template not found: " + path));
            return "";
        }
        InputStream source = url.openStream();
        String contents = NewPluginCreator.readInputStream(source);
        String expanded = contents.replaceAll("\\{id\\}", data.id).replaceAll("\\{name\\}", data.name).replaceAll("\\{version\\}", data.version).replaceAll("\\{provider\\}", data.provider);
        return expanded;
    }

    protected URL getFileURL(String path) {
        URL url = Activator.getDefault().getBundle().getResource(path);
        if (url == null) {
            return null;
        }
        return url;
    }

    private static String readInputStream(InputStream stream) throws IOException {
        return NewPluginCreator.readInputStream(stream, "UTF-8");
    }

    private static String readInputStream(InputStream stream, String charset) throws IOException {
        int read;
        int bufferSize = 65536;
        char[] buffer = new char[65536];
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(stream, charset);
        do {
            if ((read = ((Reader)reader).read(buffer, 0, buffer.length)) <= 0) continue;
            builder.append(buffer, 0, read);
        } while (read >= 0);
        ((Reader)reader).close();
        return builder.toString();
    }

    private class Data {
        private final String id;
        private final String name;
        private final String version;
        private final String provider;

        public Data(String id, String name, String version, String provider) {
            this.id = id;
            this.name = name;
            this.version = version;
            this.provider = provider;
        }
    }
}

