/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Bros (Mia-Software) - Bug 331675 - NatTable : copy cells as text - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import net.sourceforge.nattable.copy.command.CopyDataCommandHandler;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class CopyToClipboardCommandHandler extends CopyDataCommandHandler {

	private static final String NEWLINE = System.getProperty("line.separator"); //$NON-NLS-1$
	private final NatTableWidget natTableWidget;

	public CopyToClipboardCommandHandler(final SelectionLayer selectionLayer,
			final NatTableWidget natTableWidget) {
		super(selectionLayer);
		this.natTableWidget = natTableWidget;
	}

	@Override
	public boolean doCommand(final CopyDataToClipboardCommand command) {
		LayerCell[][] copiedCells = assembleCopiedDataStructure();
		serializeToClipboard(command, copiedCells);
		return true;
	}

	public void serializeToClipboard(final CopyDataToClipboardCommand command,
			final LayerCell[][] copiedCells) {
		final Clipboard clipboard = command.getClipboard();
		final String cellDelimeter = command.getCellDelimeter();
		final String rowDelimeter = CopyToClipboardCommandHandler.NEWLINE;

		final TextTransfer textTransfer = TextTransfer.getInstance();
		final StringBuilder textData = new StringBuilder();
		int currentRow = 0;
		TableLabelProvider tableLabelProvider = this.natTableWidget.getTableLabelProvider();
		String[] columnNames = this.natTableWidget.getColumnNames();
		for (LayerCell[] cells : copiedCells) {
			// first, a line with column names
			if (currentRow == 0) {
				boolean first = true;
				for (LayerCell cell : cells) {
					if (first) {
						first = false;
					} else {
						textData.append(cellDelimeter);
					}
					int originColumnPosition = cell.getOriginColumnPosition();
					int converted = this.natTableWidget
							.convertColumnPositionSelectionToData(originColumnPosition);
					textData.append(columnNames[converted]);
				}
				textData.append(rowDelimeter);
			}

			boolean first = true;
			for (LayerCell cell : cells) {
				if (first) {
					first = false;
				} else {
					textData.append(cellDelimeter);
				}
				if (cell != null) {
					Object dataValue = cell.getDataValue();
					if (dataValue instanceof GridElement) {
						GridElement gridElement = (GridElement) dataValue;
						int originColumnPosition = cell.getOriginColumnPosition();
						int converted = this.natTableWidget
								.convertColumnPositionSelectionToData(originColumnPosition);
						String text = tableLabelProvider.getColumnText(gridElement, converted);
						textData.append(text);
					}
				}
			}
			if (++currentRow < copiedCells.length) {
				textData.append(rowDelimeter);
			}
		}
		String string = textData.toString();
		if (string.length() > 0) {
			clipboard.setContents(new Object[] { textData.toString() },
					new Transfer[] { textTransfer });
		}
	}
}
