/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Bros (Mia-Software) - initial API and implementation
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.actions;

import java.util.Collection;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.ui.actions.AbstractLoadFacetsAction;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class LoadFacetsAction extends AbstractLoadFacetsAction {

	private final NatTableWidget natTableWidget;

	public LoadFacetsAction(final NatTableWidget natTableWidget) {
		super();
		this.natTableWidget = natTableWidget;
	}

	@Override
	protected void loadFacet(final Facet facetToLoad) {
		// nothing here
	}

	@Override
	protected void facetsLoaded(final Collection<Facet> facets) {
		try {
			this.natTableWidget.setFacets(facets);
		} catch (CoreException e) {
			Logger.logError(e, Activator.getDefault());
			MessageDialog.openError(Display.getCurrent().getActiveShell(), "Failed to load facets", //$NON-NLS-1$
					"Some facets failed to load. See Error Log for more details."); //$NON-NLS-1$
			//TODO Those strings have to be externalized
		}
	}

	@Override
	protected void clearFacets() {
		this.natTableWidget.clearFacets();
	}

	@Override
	protected Collection<? extends Facet> getLoadedFacets() {
		return this.natTableWidget.getLoadedFacets();
	}

	@Override
	protected Collection<EPackage> getReferencedEPackages() {
		return this.natTableWidget.getReferencedEPackages();
	}
}
