/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 337442 - [NatTableWidget] CreateNewElement action is not available
 *   Nicolas Guyomar (Mia-Software) - Bug 337442 - [NatTableWidget] CreateNewElement action is not available
 *   Vincent Lorenzo (CEA-LIST) - Copied from EditAnEcoreModelHandler -  *  Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.examples.ecore.internal.handlers;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.examples.ecore.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditorFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * Our sample handler extends AbstractHandler, an IHandler base class.
 * 
 * @see org.eclipse.core.commands.IHandler
 * @see org.eclipse.core.commands.AbstractHandler
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class EditAnEcoreModelWithFacetColumnsHiddenHandler extends AbstractHandler {
	private static final String TABLE_CONFIGURATION_FILE_PATH = "_example_EcoreWithFacetColumnHiddenTableConfiguration.tableconfiguration"; //$NON-NLS-1$

	/**
	 * The constructor.
	 */
	public EditAnEcoreModelWithFacetColumnsHiddenHandler() {
	}

	/**
	 * the command has been executed, so extract extract the needed information
	 * from the application context.
	 */
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow window = HandlerUtil
				.getActiveWorkbenchWindowChecked(event);
		ISelection selection = window.getSelectionService().getSelection();

		IEditorPart editor = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
		IEditingDomainProvider editingDomainProvider = null;
		EditingDomain editingDomain = null;
		if (editor != null) {
			if (editor instanceof IEditingDomainProvider) {
				editingDomainProvider = (IEditingDomainProvider) editor;
				editingDomain = editingDomainProvider.getEditingDomain();
			}
		}

		if (selection instanceof StructuredSelection) {
			StructuredSelection structuredSelection = (StructuredSelection) selection;
			Object fistElement = structuredSelection.getFirstElement();
			if (fistElement instanceof EPackage) {
				EPackage ePackage = (EPackage) fistElement;
				try {
					ResourceSet resourceSet = ePackage.eResource()
							.getResourceSet();
					URI uri = URI
							.createPlatformPluginURI(
									Activator.getDefault().getBundle()
											.getSymbolicName()
											+ "/" + EditAnEcoreModelWithFacetColumnsHiddenHandler.TABLE_CONFIGURATION_FILE_PATH, false); //$NON-NLS-1$
					Resource resource = resourceSet.getResource(uri, true);
					TableConfiguration tableConfiguration = (TableConfiguration) resource
							.getContents().get(0);
					List<EObject> list = new ArrayList<EObject>();
					list.addAll(ePackage.getEClassifiers());
					NatTableEditorFactory.getInstance().openOn(list, editingDomain,
							"Example of customized table editor", //$NON-NLS-1$
							tableConfiguration, ePackage, null);
				} catch (UnsatisfiedConfigurationConstraint e) {
					Logger.logError(e, Activator.getDefault());
				}
			}
		}
		return null;
	}
}
