/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	  Gregoire Dupe (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Gregoire Dupe (Mia-Software) - Bug 366804 - [Restructuring] Table widget upgrade
 *    Gregoire Dupe (Mia-Software) - Bug 367613 - Table widget refactoring
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.internal.exported;

import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableWidgetFactory;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;

/**
 * This interface allow the user to create EMF Facet AbstractTableWidget.
 */
public interface ITableWidgetFactory {

	ITableWidgetFactory INSTANCE = new TableWidgetFactory();

	/**
	 * This method instantiates a new {@link AbstractTableWidget} initialized with
	 * the given parameters.
	 * 
	 * @param parent
	 *            this composite's parent
	 * @param editingDomainProvider
	 *            an editing domain provider
	 * @param tableInstanceParam
	 *            The {@link Table} which contains all the needed
	 *            information to open a table
	 * @param menuMgr
	 *            a menu manager
	 * @return a new {@link AbstractTableWidget} instance
	 */
	ITableWidget createTableWidget(Composite parent,
			IEditingDomainProvider edProvider, Table tableInstance,
			MenuManager menuMgr);
	
}
