/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.query.core.internal.filters;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.ui.IActionFilter;

/** Filters for queries */
public class QueryFilter implements IActionFilter {

	public static final String QUERY = "isEmfFacetQuery"; //$NON-NLS-1$
	public static final String QUERY_SET = "isEmfFacetQuerySet"; //$NON-NLS-1$
	public static final String WORKSPACE_QUERY = "isWorkspaceQuery"; //$NON-NLS-1$
	public static final String WORKSPACE_QUERY_SET = "isWorkspaceQuerySet"; //$NON-NLS-1$

	public boolean testAttribute(final Object target, final String name, final String value) {
		if (QueryFilter.QUERY.equals(name)) {
			return Boolean.toString(target instanceof ModelQuery).equalsIgnoreCase(value);
		} else if (QueryFilter.QUERY_SET.equals(name)) {
			return Boolean.toString(target instanceof ModelQuerySet).equalsIgnoreCase(value);
		} else if (QueryFilter.WORKSPACE_QUERY.equals(name)) {
			if (target instanceof ModelQuery) {
				ModelQuery modelQuery = (ModelQuery) target;
				Resource resource = modelQuery.eResource();
				URI uri = resource.getURI();
				return Boolean.toString(uri.isPlatformResource()).equalsIgnoreCase(value);
			}
			return false;
		} else if (QueryFilter.WORKSPACE_QUERY_SET.equals(name)) {
			// if this is a query set, is it editable
			if (target instanceof ModelQuerySet) {
				ModelQuerySet modelQuerySet = (ModelQuerySet) target;
				Resource resource = modelQuerySet.eResource();
				URI uri = resource.getURI();
				if (uri.isPlatform()) {
					return Boolean.toString(uri.isPlatformResource()).equalsIgnoreCase(value);
				}
				URI realUri = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName());
				return Boolean.toString(realUri.isPlatformResource()).equalsIgnoreCase(value);
			}
		}

		// let another filter decide
		return true;
	}

}
