/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.dev.ui.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.dev.ui.internal.Activator;
import org.eclipse.emf.facet.dev.ui.internal.Messages;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewEmfFacetPluginPage
extends WizardPage {
    private static final String LAST_ID = "lastId";
    private static final String LAST_NAME = "lastName";
    private static final String LAST_VERSION = "lastVersion";
    private static final String LAST_PROVIDER = "lastProvider";
    private static final String LAST_JAVA_NATURE_ENABLED = "javaNatureEnabled";
    private static final String SETTINGS_FILENAME = "settings.txt";
    private static final String NEW_PLUGIN_PAGE_ID = "newPluginPage";
    private Text textID;
    private Text textName;
    private Text textVersion;
    private Text textProvider;
    private Button cbJavaNature;

    protected NewEmfFacetPluginPage() {
        super(NEW_PLUGIN_PAGE_ID);
        this.setTitle(Messages.NewPluginPage_title);
        this.setMessage(Messages.NewPluginPage_message);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/newpprj_wiz.png")));
    }

    protected String getDefaultID() {
        return "org.eclipse.emf.facet.xx";
    }

    protected String getDefaultName() {
        return "EMF Facet xx";
    }

    protected String getDefaultVersion() {
        return "0.2.0";
    }

    protected String getDefaultProvider() {
        return "Eclipse Modeling Project";
    }

    protected boolean getDefaultJavaNatureEnablement() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        int nColumns = 3;
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblID = new Label(container, 0);
        lblID.setText(Messages.NewPluginPage_id);
        this.textID = new Text(container, 2048);
        this.textID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        Label lblName = new Label(container, 0);
        lblName.setText(Messages.NewPluginPage_name);
        this.textName = new Text(container, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lbluserVisible = new Label(container, 0);
        lbluserVisible.setText(Messages.NewPluginPage_userVisible);
        Label lblVersion = new Label(container, 0);
        lblVersion.setText(Messages.NewPluginPage_version);
        this.textVersion = new Text(container, 2048);
        this.textVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDigits = new Label(container, 0);
        lblDigits.setText(Messages.NewPluginPage_threeDigits);
        Label lblProvider = new Label(container, 0);
        lblProvider.setText(Messages.NewPluginPage_provider);
        this.textProvider = new Text(container, 2048);
        this.textProvider.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        this.cbJavaNature = new Button(container, 32);
        this.cbJavaNature.setSelection(true);
        this.cbJavaNature.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.cbJavaNature.setText(Messages.NewEmfFacetPluginPage_btnCheckButton_text);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.load();
    }

    protected DialogSettings getSettings() {
        DialogSettings dialogSettings = new DialogSettings("NewPluginPage.settings");
        return dialogSettings;
    }

    public void load() {
        DialogSettings settings = this.getSettings();
        String filepath = this.getSettingsFilePath();
        String id = this.getDefaultID();
        String name = this.getDefaultName();
        String version = this.getDefaultVersion();
        String provider = this.getDefaultProvider();
        boolean javaNatureEnabled = this.getDefaultJavaNatureEnablement();
        if (new File(filepath).exists()) {
            try {
                settings.load(filepath);
                id = settings.get(LAST_ID);
                name = settings.get(LAST_NAME);
                version = settings.get(LAST_VERSION);
                provider = settings.get(LAST_PROVIDER);
                javaNatureEnabled = settings.getBoolean(LAST_JAVA_NATURE_ENABLED);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.facet.dev.ui", "Error loading dialog settings", (Throwable)e));
            }
        }
        this.textID.setText(id);
        this.textName.setText(name);
        this.textVersion.setText(version);
        this.textProvider.setText(provider);
        this.cbJavaNature.setSelection(javaNatureEnabled);
    }

    protected String getSettingsFilePath() {
        IPath path = Activator.getDefault().getStateLocation();
        return path.append(SETTINGS_FILENAME).toOSString();
    }

    public void save() {
        DialogSettings settings = this.getSettings();
        settings.put(LAST_ID, this.textID.getText());
        settings.put(LAST_NAME, this.textName.getText());
        settings.put(LAST_VERSION, this.textVersion.getText());
        settings.put(LAST_PROVIDER, this.textProvider.getText());
        settings.put(LAST_JAVA_NATURE_ENABLED, this.cbJavaNature.getSelection());
        try {
            settings.save(this.getSettingsFilePath());
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.facet.dev.ui", "Error saving dialog settings", (Throwable)e));
        }
    }

    public String getId() {
        return this.textID.getText();
    }

    public String getName() {
        return this.textName.getText();
    }

    public String getVersion() {
        return this.textVersion.getText();
    }

    public String getProvider() {
        return this.textProvider.getText();
    }

    public boolean getJavaNatureEnabled() {
        return this.cbJavaNature.getSelection();
    }
}

