/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory
 * @model kind="package"
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public interface TableinstancePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "tableinstance"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/EMF_Facet/ModelCellEditor/0.1.0/tableinstance"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "tableinstance"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	TableinstancePackage eINSTANCE = org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl <em>Table Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getTableInstance()
	 * @generated
	 */
	int TABLE_INSTANCE = 0;

	/**
	 * The feature id for the '<em><b>Table Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__TABLE_CONFIGURATION = 0;

	/**
	 * The feature id for the '<em><b>Customizations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__CUSTOMIZATIONS = 1;

	/**
	 * The feature id for the '<em><b>Facets</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__FACETS = 2;

	/**
	 * The feature id for the '<em><b>Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__CONTEXT = 3;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__PARAMETER = 4;

	/**
	 * The feature id for the '<em><b>Hide Empty Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__HIDE_EMPTY_COLUMNS = 5;

	/**
	 * The feature id for the '<em><b>Only Show Common Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS = 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__DESCRIPTION = 7;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__COLUMNS = 8;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__ROWS = 9;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__ELEMENTS = 10;

	/**
	 * The feature id for the '<em><b>Local Customization</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE__LOCAL_CUSTOMIZATION = 11;

	/**
	 * The number of structural features of the '<em>Table Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCE_FEATURE_COUNT = 12;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryTableInstanceImpl <em>Query Table Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryTableInstanceImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getQueryTableInstance()
	 * @generated
	 */
	int QUERY_TABLE_INSTANCE = 1;

	/**
	 * The feature id for the '<em><b>Table Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__TABLE_CONFIGURATION = TABLE_INSTANCE__TABLE_CONFIGURATION;

	/**
	 * The feature id for the '<em><b>Customizations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__CUSTOMIZATIONS = TABLE_INSTANCE__CUSTOMIZATIONS;

	/**
	 * The feature id for the '<em><b>Facets</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__FACETS = TABLE_INSTANCE__FACETS;

	/**
	 * The feature id for the '<em><b>Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__CONTEXT = TABLE_INSTANCE__CONTEXT;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__PARAMETER = TABLE_INSTANCE__PARAMETER;

	/**
	 * The feature id for the '<em><b>Hide Empty Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__HIDE_EMPTY_COLUMNS = TABLE_INSTANCE__HIDE_EMPTY_COLUMNS;

	/**
	 * The feature id for the '<em><b>Only Show Common Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS = TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__DESCRIPTION = TABLE_INSTANCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__COLUMNS = TABLE_INSTANCE__COLUMNS;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__ROWS = TABLE_INSTANCE__ROWS;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__ELEMENTS = TABLE_INSTANCE__ELEMENTS;

	/**
	 * The feature id for the '<em><b>Local Customization</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__LOCAL_CUSTOMIZATION = TABLE_INSTANCE__LOCAL_CUSTOMIZATION;

	/**
	 * The feature id for the '<em><b>Query Results</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE__QUERY_RESULTS = TABLE_INSTANCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Query Table Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_TABLE_INSTANCE_FEATURE_COUNT = TABLE_INSTANCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ColumnImpl <em>Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getColumn()
	 * @generated
	 */
	int COLUMN = 2;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN__IS_HIDDEN = 0;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN__WIDTH = 1;

	/**
	 * The number of structural features of the '<em>Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryColumnImpl <em>Query Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getQueryColumn()
	 * @generated
	 */
	int QUERY_COLUMN = 3;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_COLUMN__IS_HIDDEN = COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_COLUMN__WIDTH = COLUMN__WIDTH;

	/**
	 * The feature id for the '<em><b>Query</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_COLUMN__QUERY = COLUMN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Query Result</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_COLUMN__QUERY_RESULT = COLUMN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Query Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_COLUMN_FEATURE_COUNT = COLUMN_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn <em>Feature Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFeatureColumn()
	 * @generated
	 */
	int FEATURE_COLUMN = 10;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLUMN__IS_HIDDEN = COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLUMN__WIDTH = COLUMN__WIDTH;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLUMN__FEATURE = COLUMN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Feature Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLUMN_FEATURE_COUNT = COLUMN_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ReferenceColumnImpl <em>Reference Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ReferenceColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getReferenceColumn()
	 * @generated
	 */
	int REFERENCE_COLUMN = 4;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_COLUMN__IS_HIDDEN = FEATURE_COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_COLUMN__WIDTH = FEATURE_COLUMN__WIDTH;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_COLUMN__FEATURE = FEATURE_COLUMN__FEATURE;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_COLUMN__REFERENCE = FEATURE_COLUMN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reference Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_COLUMN_FEATURE_COUNT = FEATURE_COLUMN_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ContextColumnImpl <em>Context Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ContextColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getContextColumn()
	 * @generated
	 */
	int CONTEXT_COLUMN = 5;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_COLUMN__IS_HIDDEN = COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_COLUMN__WIDTH = COLUMN__WIDTH;

	/**
	 * The number of structural features of the '<em>Context Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_COLUMN_FEATURE_COUNT = COLUMN_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.MetaClassColumnImpl <em>Meta Class Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.MetaClassColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getMetaClassColumn()
	 * @generated
	 */
	int META_CLASS_COLUMN = 6;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_CLASS_COLUMN__IS_HIDDEN = COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_CLASS_COLUMN__WIDTH = COLUMN__WIDTH;

	/**
	 * The number of structural features of the '<em>Meta Class Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_CLASS_COLUMN_FEATURE_COUNT = COLUMN_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.AttributeColumnImpl <em>Attribute Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.AttributeColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getAttributeColumn()
	 * @generated
	 */
	int ATTRIBUTE_COLUMN = 7;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COLUMN__IS_HIDDEN = FEATURE_COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COLUMN__WIDTH = FEATURE_COLUMN__WIDTH;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COLUMN__FEATURE = FEATURE_COLUMN__FEATURE;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COLUMN__ATTRIBUTE = FEATURE_COLUMN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Attribute Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COLUMN_FEATURE_COUNT = FEATURE_COLUMN_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.EContainerColumnImpl <em>EContainer Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.EContainerColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getEContainerColumn()
	 * @generated
	 */
	int ECONTAINER_COLUMN = 8;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECONTAINER_COLUMN__IS_HIDDEN = COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECONTAINER_COLUMN__WIDTH = COLUMN__WIDTH;

	/**
	 * The number of structural features of the '<em>EContainer Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECONTAINER_COLUMN_FEATURE_COUNT = COLUMN_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.DefaultLabelColumnImpl <em>Default Label Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.DefaultLabelColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getDefaultLabelColumn()
	 * @generated
	 */
	int DEFAULT_LABEL_COLUMN = 9;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_LABEL_COLUMN__IS_HIDDEN = COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_LABEL_COLUMN__WIDTH = COLUMN__WIDTH;

	/**
	 * The number of structural features of the '<em>Default Label Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_LABEL_COLUMN_FEATURE_COUNT = COLUMN_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.RowImpl <em>Row</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.RowImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getRow()
	 * @generated
	 */
	int ROW = 11;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW__ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW__HEIGHT = 1;

	/**
	 * The number of structural features of the '<em>Row</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW_FEATURE_COUNT = 2;


	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetAttributeColumnImpl <em>Facet Attribute Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetAttributeColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFacetAttributeColumn()
	 * @generated
	 */
	int FACET_ATTRIBUTE_COLUMN = 12;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_ATTRIBUTE_COLUMN__IS_HIDDEN = FEATURE_COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_ATTRIBUTE_COLUMN__WIDTH = FEATURE_COLUMN__WIDTH;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_ATTRIBUTE_COLUMN__FEATURE = FEATURE_COLUMN__FEATURE;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_ATTRIBUTE_COLUMN__ATTRIBUTE = FEATURE_COLUMN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Facet Attribute Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_ATTRIBUTE_COLUMN_FEATURE_COUNT = FEATURE_COLUMN_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetReferenceColumnImpl <em>Facet Reference Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetReferenceColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFacetReferenceColumn()
	 * @generated
	 */
	int FACET_REFERENCE_COLUMN = 13;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_REFERENCE_COLUMN__IS_HIDDEN = FEATURE_COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_REFERENCE_COLUMN__WIDTH = FEATURE_COLUMN__WIDTH;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_REFERENCE_COLUMN__FEATURE = FEATURE_COLUMN__FEATURE;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_REFERENCE_COLUMN__REFERENCE = FEATURE_COLUMN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Facet Reference Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_REFERENCE_COLUMN_FEATURE_COUNT = FEATURE_COLUMN_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetFeatureColumnImpl <em>Facet Feature Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetFeatureColumnImpl
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFacetFeatureColumn()
	 * @generated
	 */
	int FACET_FEATURE_COLUMN = 14;

	/**
	 * The feature id for the '<em><b>Is Hidden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_FEATURE_COLUMN__IS_HIDDEN = FEATURE_COLUMN__IS_HIDDEN;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_FEATURE_COLUMN__WIDTH = FEATURE_COLUMN__WIDTH;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_FEATURE_COLUMN__FEATURE = FEATURE_COLUMN__FEATURE;

	/**
	 * The feature id for the '<em><b>Facet Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_FEATURE_COLUMN__FACET_FEATURE = FEATURE_COLUMN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Facet Feature Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACET_FEATURE_COLUMN_FEATURE_COUNT = FEATURE_COLUMN_FEATURE_COUNT + 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance <em>Table Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Table Instance</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance
	 * @generated
	 */
	EClass getTableInstance();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getTableConfiguration <em>Table Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Table Configuration</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getTableConfiguration()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_TableConfiguration();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getCustomizations <em>Customizations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Customizations</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getCustomizations()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_Customizations();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getFacets <em>Facets</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Facets</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getFacets()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_Facets();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getContext <em>Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Context</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getContext()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_Context();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Parameter</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getParameter()
	 * @see #getTableInstance()
	 * @generated
	 */
	EAttribute getTableInstance_Parameter();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isHideEmptyColumns <em>Hide Empty Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hide Empty Columns</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isHideEmptyColumns()
	 * @see #getTableInstance()
	 * @generated
	 */
	EAttribute getTableInstance_HideEmptyColumns();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isOnlyShowCommonColumns <em>Only Show Common Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Only Show Common Columns</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#isOnlyShowCommonColumns()
	 * @see #getTableInstance()
	 * @generated
	 */
	EAttribute getTableInstance_OnlyShowCommonColumns();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getDescription()
	 * @see #getTableInstance()
	 * @generated
	 */
	EAttribute getTableInstance_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getColumns <em>Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Columns</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getColumns()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_Columns();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getRows <em>Rows</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Rows</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getRows()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_Rows();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getElements <em>Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Elements</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getElements()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_Elements();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getLocalCustomization <em>Local Customization</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Local Customization</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance#getLocalCustomization()
	 * @see #getTableInstance()
	 * @generated
	 */
	EReference getTableInstance_LocalCustomization();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance <em>Query Table Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Table Instance</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance
	 * @generated
	 */
	EClass getQueryTableInstance();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance#getQueryResults <em>Query Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Query Results</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance#getQueryResults()
	 * @see #getQueryTableInstance()
	 * @generated
	 */
	EReference getQueryTableInstance_QueryResults();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column <em>Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column
	 * @generated
	 */
	EClass getColumn();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column#isIsHidden <em>Is Hidden</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Hidden</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column#isIsHidden()
	 * @see #getColumn()
	 * @generated
	 */
	EAttribute getColumn_IsHidden();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column#getWidth <em>Width</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Width</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column#getWidth()
	 * @see #getColumn()
	 * @generated
	 */
	EAttribute getColumn_Width();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn <em>Query Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn
	 * @generated
	 */
	EClass getQueryColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Query</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn#getQuery()
	 * @see #getQueryColumn()
	 * @generated
	 */
	EReference getQueryColumn_Query();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn#getQueryResult <em>Query Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Query Result</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn#getQueryResult()
	 * @see #getQueryColumn()
	 * @generated
	 */
	EReference getQueryColumn_QueryResult();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn <em>Reference Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn
	 * @generated
	 */
	EClass getReferenceColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn#getReference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Reference</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn#getReference()
	 * @see #getReferenceColumn()
	 * @generated
	 */
	EReference getReferenceColumn_Reference();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn <em>Context Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Context Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn
	 * @generated
	 */
	EClass getContextColumn();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn <em>Meta Class Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Meta Class Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn
	 * @generated
	 */
	EClass getMetaClassColumn();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn <em>Attribute Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn
	 * @generated
	 */
	EClass getAttributeColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn#getAttribute()
	 * @see #getAttributeColumn()
	 * @generated
	 */
	EReference getAttributeColumn_Attribute();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn <em>EContainer Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EContainer Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn
	 * @generated
	 */
	EClass getEContainerColumn();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn <em>Default Label Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Default Label Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn
	 * @generated
	 */
	EClass getDefaultLabelColumn();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn <em>Feature Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn
	 * @generated
	 */
	EClass getFeatureColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn#getFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Feature</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn#getFeature()
	 * @see #getFeatureColumn()
	 * @generated
	 */
	EReference getFeatureColumn_Feature();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row <em>Row</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Row</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row
	 * @generated
	 */
	EClass getRow();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row#getElement <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Element</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row#getElement()
	 * @see #getRow()
	 * @generated
	 */
	EReference getRow_Element();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row#getHeight <em>Height</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Height</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row#getHeight()
	 * @see #getRow()
	 * @generated
	 */
	EAttribute getRow_Height();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn <em>Facet Attribute Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Facet Attribute Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn
	 * @generated
	 */
	EClass getFacetAttributeColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn#getAttribute()
	 * @see #getFacetAttributeColumn()
	 * @generated
	 */
	EReference getFacetAttributeColumn_Attribute();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn <em>Facet Reference Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Facet Reference Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn
	 * @generated
	 */
	EClass getFacetReferenceColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn#getReference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Reference</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn#getReference()
	 * @see #getFacetReferenceColumn()
	 * @generated
	 */
	EReference getFacetReferenceColumn_Reference();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetFeatureColumn <em>Facet Feature Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Facet Feature Column</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetFeatureColumn
	 * @generated
	 */
	EClass getFacetFeatureColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetFeatureColumn#getFacetFeature <em>Facet Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Facet Feature</em>'.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetFeatureColumn#getFacetFeature()
	 * @see #getFacetFeatureColumn()
	 * @generated
	 */
	EReference getFacetFeatureColumn_FacetFeature();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TableinstanceFactory getTableinstanceFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Deprecated
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl <em>Table Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getTableInstance()
		 * @generated
		 */
		EClass TABLE_INSTANCE = eINSTANCE.getTableInstance();

		/**
		 * The meta object literal for the '<em><b>Table Configuration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__TABLE_CONFIGURATION = eINSTANCE.getTableInstance_TableConfiguration();

		/**
		 * The meta object literal for the '<em><b>Customizations</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__CUSTOMIZATIONS = eINSTANCE.getTableInstance_Customizations();

		/**
		 * The meta object literal for the '<em><b>Facets</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__FACETS = eINSTANCE.getTableInstance_Facets();

		/**
		 * The meta object literal for the '<em><b>Context</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__CONTEXT = eINSTANCE.getTableInstance_Context();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TABLE_INSTANCE__PARAMETER = eINSTANCE.getTableInstance_Parameter();

		/**
		 * The meta object literal for the '<em><b>Hide Empty Columns</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TABLE_INSTANCE__HIDE_EMPTY_COLUMNS = eINSTANCE.getTableInstance_HideEmptyColumns();

		/**
		 * The meta object literal for the '<em><b>Only Show Common Columns</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TABLE_INSTANCE__ONLY_SHOW_COMMON_COLUMNS = eINSTANCE.getTableInstance_OnlyShowCommonColumns();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TABLE_INSTANCE__DESCRIPTION = eINSTANCE.getTableInstance_Description();

		/**
		 * The meta object literal for the '<em><b>Columns</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__COLUMNS = eINSTANCE.getTableInstance_Columns();

		/**
		 * The meta object literal for the '<em><b>Rows</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__ROWS = eINSTANCE.getTableInstance_Rows();

		/**
		 * The meta object literal for the '<em><b>Elements</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__ELEMENTS = eINSTANCE.getTableInstance_Elements();

		/**
		 * The meta object literal for the '<em><b>Local Customization</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TABLE_INSTANCE__LOCAL_CUSTOMIZATION = eINSTANCE.getTableInstance_LocalCustomization();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryTableInstanceImpl <em>Query Table Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryTableInstanceImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getQueryTableInstance()
		 * @generated
		 */
		EClass QUERY_TABLE_INSTANCE = eINSTANCE.getQueryTableInstance();

		/**
		 * The meta object literal for the '<em><b>Query Results</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_TABLE_INSTANCE__QUERY_RESULTS = eINSTANCE.getQueryTableInstance_QueryResults();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ColumnImpl <em>Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getColumn()
		 * @generated
		 */
		EClass COLUMN = eINSTANCE.getColumn();

		/**
		 * The meta object literal for the '<em><b>Is Hidden</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COLUMN__IS_HIDDEN = eINSTANCE.getColumn_IsHidden();

		/**
		 * The meta object literal for the '<em><b>Width</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COLUMN__WIDTH = eINSTANCE.getColumn_Width();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryColumnImpl <em>Query Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getQueryColumn()
		 * @generated
		 */
		EClass QUERY_COLUMN = eINSTANCE.getQueryColumn();

		/**
		 * The meta object literal for the '<em><b>Query</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_COLUMN__QUERY = eINSTANCE.getQueryColumn_Query();

		/**
		 * The meta object literal for the '<em><b>Query Result</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_COLUMN__QUERY_RESULT = eINSTANCE.getQueryColumn_QueryResult();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ReferenceColumnImpl <em>Reference Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ReferenceColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getReferenceColumn()
		 * @generated
		 */
		EClass REFERENCE_COLUMN = eINSTANCE.getReferenceColumn();

		/**
		 * The meta object literal for the '<em><b>Reference</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REFERENCE_COLUMN__REFERENCE = eINSTANCE.getReferenceColumn_Reference();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ContextColumnImpl <em>Context Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.ContextColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getContextColumn()
		 * @generated
		 */
		EClass CONTEXT_COLUMN = eINSTANCE.getContextColumn();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.MetaClassColumnImpl <em>Meta Class Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.MetaClassColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getMetaClassColumn()
		 * @generated
		 */
		EClass META_CLASS_COLUMN = eINSTANCE.getMetaClassColumn();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.AttributeColumnImpl <em>Attribute Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.AttributeColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getAttributeColumn()
		 * @generated
		 */
		EClass ATTRIBUTE_COLUMN = eINSTANCE.getAttributeColumn();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_COLUMN__ATTRIBUTE = eINSTANCE.getAttributeColumn_Attribute();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.EContainerColumnImpl <em>EContainer Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.EContainerColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getEContainerColumn()
		 * @generated
		 */
		EClass ECONTAINER_COLUMN = eINSTANCE.getEContainerColumn();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.DefaultLabelColumnImpl <em>Default Label Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.DefaultLabelColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getDefaultLabelColumn()
		 * @generated
		 */
		EClass DEFAULT_LABEL_COLUMN = eINSTANCE.getDefaultLabelColumn();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn <em>Feature Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFeatureColumn()
		 * @generated
		 */
		EClass FEATURE_COLUMN = eINSTANCE.getFeatureColumn();

		/**
		 * The meta object literal for the '<em><b>Feature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_COLUMN__FEATURE = eINSTANCE.getFeatureColumn_Feature();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.RowImpl <em>Row</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.RowImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getRow()
		 * @generated
		 */
		EClass ROW = eINSTANCE.getRow();

		/**
		 * The meta object literal for the '<em><b>Element</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROW__ELEMENT = eINSTANCE.getRow_Element();

		/**
		 * The meta object literal for the '<em><b>Height</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROW__HEIGHT = eINSTANCE.getRow_Height();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetAttributeColumnImpl <em>Facet Attribute Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetAttributeColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFacetAttributeColumn()
		 * @generated
		 */
		EClass FACET_ATTRIBUTE_COLUMN = eINSTANCE.getFacetAttributeColumn();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FACET_ATTRIBUTE_COLUMN__ATTRIBUTE = eINSTANCE.getFacetAttributeColumn_Attribute();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetReferenceColumnImpl <em>Facet Reference Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetReferenceColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFacetReferenceColumn()
		 * @generated
		 */
		EClass FACET_REFERENCE_COLUMN = eINSTANCE.getFacetReferenceColumn();

		/**
		 * The meta object literal for the '<em><b>Reference</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FACET_REFERENCE_COLUMN__REFERENCE = eINSTANCE.getFacetReferenceColumn_Reference();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetFeatureColumnImpl <em>Facet Feature Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.FacetFeatureColumnImpl
		 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableinstancePackageImpl#getFacetFeatureColumn()
		 * @generated
		 */
		EClass FACET_FEATURE_COLUMN = eINSTANCE.getFacetFeatureColumn();

		/**
		 * The meta object literal for the '<em><b>Facet Feature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FACET_FEATURE_COLUMN__FACET_FEATURE = eINSTANCE.getFacetFeatureColumn_FacetFeature();

	}

} //TableinstancePackage
